/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.classify.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.classify.AttachClassifyRelCollection;
import com.kingdee.eas.hr.emp.classify.AttachClassifyRelFactory;
import com.kingdee.eas.hr.emp.classify.AttachClassifyRelInfo;
import com.kingdee.eas.hr.emp.classify.ClassifyCollection;
import com.kingdee.eas.hr.emp.classify.ClassifyInfo;
import com.kingdee.eas.hr.emp.classify.EntityClassifyRelFactory;
import com.kingdee.eas.hr.emp.classify.HrEmpAttachClassifyException;
import com.kingdee.eas.hr.emp.classify.app.AbstractClassifyControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClassifyControllerBean
extends AbstractClassifyControllerBean {
    private static final long serialVersionUID = 3966911436393890925L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.classify.app.ClassifyControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNumberDup(ctx, model);
        ClassifyInfo classifyInfo = (ClassifyInfo)model;
        if (classifyInfo.getParent() == null || classifyInfo.getParent().getId() == null) {
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION5);
        }
        String parentId = classifyInfo.getParent().getId().toString();
        ClassifyInfo parent = super.getClassifyInfo(ctx, " select longNumber, displayName where id = '" + parentId + "'");
        if (parent.getLongNumber() != null && parent.getLongNumber().contains("!" + classifyInfo.getNumber() + "!")) {
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION6);
        }
        String longNumber = parent.getLongNumber() + "!" + classifyInfo.getNumber();
        classifyInfo.setLongNumber(longNumber);
        String displayName_l1 = parent.getDisplayName(LocaleUtils.locale_L1) + "_" + classifyInfo.getName(LocaleUtils.locale_L1);
        String displayName_l2 = parent.getDisplayName(LocaleUtils.locale_L2) + "_" + classifyInfo.getName(LocaleUtils.locale_L2);
        String displayName_l3 = parent.getDisplayName(LocaleUtils.locale_L3) + "_" + classifyInfo.getName(LocaleUtils.locale_L3);
        classifyInfo.setDisplayName(displayName_l1, LocaleUtils.locale_L1);
        classifyInfo.setDisplayName(displayName_l2, LocaleUtils.locale_L2);
        classifyInfo.setDisplayName(displayName_l3, LocaleUtils.locale_L3);
        String[] level = longNumber.split("!");
        classifyInfo.setLevel(level.length);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._checkNumberDup(ctx, model);
        ClassifyInfo classifyInfo = (ClassifyInfo)model;
        if (classifyInfo.getParent() == null || classifyInfo.getParent().getId() == null) {
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION5);
        }
        ClassifyInfo oldClassifyInfo = super.getClassifyInfo(ctx, pk);
        String parentId = classifyInfo.getParent().getId().toString();
        if (parentId.equals(pk.toString()) && !parentId.equals(oldClassifyInfo.getParent().getId().toString())) {
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION6);
        }
        ClassifyInfo nowParentInfo = super.getClassifyInfo(ctx, (IObjectPK)new ObjectUuidPK(parentId));
        if (nowParentInfo.getLongNumber() != null && nowParentInfo.getLongNumber().contains("!" + classifyInfo.getNumber() + "!")) {
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION6);
        }
        String oldLongNumber = oldClassifyInfo.getLongNumber();
        String newLongNumber = parentId.equals(pk.toString()) ? classifyInfo.getNumber() : nowParentInfo.getLongNumber() + "!" + classifyInfo.getNumber();
        List lml = BOSConfigUtil.getLanguageMapingList();
        HashMap different = new HashMap();
        int total = lml.size();
        for (int i = 0; i < total; ++i) {
            Map lang = (Map)lml.get(i);
            String langUpper = ((String)lang.get("lang")).toUpperCase();
            Locale locale = LocaleUtils.getLocale((String)((String)lang.get("lang")));
            String name = classifyInfo.getName(locale);
            if (StringUtils.equals((String)classifyInfo.getName(locale), (String)oldClassifyInfo.getName(locale)) && parentId.equals(oldClassifyInfo.getParent().getId().toString())) continue;
            String oldDisplayName = oldClassifyInfo.getDisplayName(locale);
            String newDisplayName = parentId.equals(pk.toString()) ? name : nowParentInfo.getDisplayName(locale) + "_" + name;
            classifyInfo.setDisplayName(newDisplayName, locale);
            ArrayList<String> partner = new ArrayList<String>();
            partner.add(oldDisplayName);
            partner.add(newDisplayName);
            different.put(langUpper, partner);
        }
        if (!oldLongNumber.equals(newLongNumber) || different.size() > 0) {
            classifyInfo.setLongNumber(newLongNumber);
            classifyInfo.setLevel(newLongNumber.split("!").length);
            FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(oldClassifyInfo.getLongNumber() + "!%"), CompareType.LIKE);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(item);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            ClassifyCollection classifyCollection = super.getClassifyCollection(ctx, view);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            String sql = " update T_HR_Classify set FLongNumber = ?, FLevel = ?, FDISPLAYNAME_L1 = ?,FDISPLAYNAME_L2 = ?,FDISPLAYNAME_L3 = ?, FLASTUPDATEUSERID = ?,FLASTUPDATETIME = ? where FID = ? ";
            String userId = ctx.getCaller().toString();
            Timestamp updateTime = HRUtilExtend.getCurTimestamp();
            int size = classifyCollection.size();
            for (int i = 0; i < size; ++i) {
                ClassifyInfo children = classifyCollection.get(i);
                String childrenLongNumber = children.getLongNumber();
                if (!oldLongNumber.equals(newLongNumber)) {
                    childrenLongNumber = childrenLongNumber.replaceFirst(oldLongNumber, newLongNumber);
                }
                String displayName_l1 = children.getDisplayName(LocaleUtils.getLocale((String)"L1"));
                if (different.containsKey("L1")) {
                    ArrayList partner = (ArrayList)different.get("L1");
                    String oldDisplayName = (String)partner.get(0);
                    String newDisplayName = (String)partner.get(1);
                    displayName_l1 = displayName_l1.replaceFirst(oldDisplayName, newDisplayName);
                }
                String displayName_l2 = children.getDisplayName(LocaleUtils.getLocale((String)"L2"));
                if (different.containsKey("L2")) {
                    ArrayList partner = (ArrayList)different.get("L2");
                    String oldDisplayName = (String)partner.get(0);
                    String newDisplayName = (String)partner.get(1);
                    displayName_l2 = displayName_l2.replaceFirst(oldDisplayName, newDisplayName);
                }
                String displayName_l3 = children.getDisplayName(LocaleUtils.getLocale((String)"L3"));
                if (different.containsKey("L3")) {
                    ArrayList partner = (ArrayList)different.get("L3");
                    String oldDisplayName = (String)partner.get(0);
                    String newDisplayName = (String)partner.get(1);
                    displayName_l3 = displayName_l3.replaceFirst(oldDisplayName, newDisplayName);
                }
                int level = childrenLongNumber.split("!").length;
                Object[] params = new Object[]{childrenLongNumber, level, displayName_l1, displayName_l2, displayName_l3, userId, updateTime, children.getId().toString()};
                paramList.add(params);
                if (paramList.size() <= 200) continue;
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramList);
                paramList.clear();
            }
            if (paramList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramList);
                paramList.clear();
            }
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ClassifyInfo classifyInfo = super.getClassifyInfo(ctx, pk);
        AttachClassifyRelCollection attachClassifyColl = AttachClassifyRelFactory.getLocalInstance(ctx).getAttachClassifyRelCollection("where classify = '" + pk.toString() + "'");
        ArrayList<String> quoteAttachs = new ArrayList<String>();
        int size = attachClassifyColl.size();
        for (int i = 0; i < size; ++i) {
            AttachClassifyRelInfo attachClassifyInfo = attachClassifyColl.get(i);
            quoteAttachs.add(attachClassifyInfo.getName());
        }
        if (attachClassifyColl.size() > 0) {
            String separator = "l2".equalsIgnoreCase(ctx.getLocale().getDisplayName()) ? "\u3011 \u3001\u3010" : "], [";
            String msg = org.apache.commons.lang3.StringUtils.join(quoteAttachs, (String)separator);
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION3, new Object[]{classifyInfo.getName(), msg});
        }
        EntityClassifyRelFactory.getLocalInstance(ctx).delete("where classify = '" + pk.toString() + "'");
        boolean existSub = super._exists(ctx, " where parent = '" + pk.toString() + "'");
        if (existSub) {
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION4);
        }
        super._delete(ctx, pk);
    }

    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        ClassifyInfo classifyInfo = super.getClassifyInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (classifyInfo.getParent() == null || classifyInfo.getParent().getId() == null || id.equals(classifyInfo.getParent().getId().toString())) {
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION23);
        }
        boolean existSub = super._exists(ctx, " where parent = '" + id + "' and state = 1 ");
        if (existSub) {
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION0);
        }
        AttachClassifyRelCollection attachClassifyColl = AttachClassifyRelFactory.getLocalInstance(ctx).getAttachClassifyRelCollection("where classify = '" + id + "'");
        ArrayList<String> quoteAttachs = new ArrayList<String>();
        int size = attachClassifyColl.size();
        for (int i = 0; i < size; ++i) {
            AttachClassifyRelInfo attachClassifyInfo = attachClassifyColl.get(i);
            quoteAttachs.add(attachClassifyInfo.getName());
        }
        if (attachClassifyColl.size() > 0) {
            String separator = "l2".equalsIgnoreCase(ctx.getLocale().getDisplayName()) ? "\u3011 \u3001\u3010" : "], [";
            String msg = org.apache.commons.lang3.StringUtils.join(quoteAttachs, (String)separator);
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION1, new Object[]{classifyInfo.getName(), msg});
        }
        super._disable(ctx, id);
    }

    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        BaseItemStateEnum state;
        ClassifyInfo classifyInfo = super.getClassifyInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (classifyInfo.getParent() == null || classifyInfo.getParent().getId() == null || id.equals(classifyInfo.getParent().getId().toString())) {
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION23);
        }
        ClassifyCollection classifyColl = super.getClassifyCollection(ctx, " select parent.state where id = '" + id + "' ");
        if (classifyColl.size() > 0 && classifyColl.get(0).getParent() != null && (state = classifyColl.get(0).getParent().getState()) != null && state.getValue() != 1) {
            throw new HrEmpAttachClassifyException(HrEmpAttachClassifyException.EXCEPTION2);
        }
        super._enable(ctx, id);
    }
}

