/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.kt.CadreAuditBizBillEntryFactory;
import com.kingdee.eas.hr.kt.CadreAuditBizBillEntryInfo;
import com.kingdee.eas.hr.kt.CadreAuditException;
import com.kingdee.eas.hr.kt.CadreAuditFactory;
import com.kingdee.eas.hr.kt.ICadreAudit;
import com.kingdee.eas.hr.kt.ICadreAuditBizBillEntry;
import com.kingdee.eas.hr.kt.app.CadreBillBizBean;

public class CadreAuditBizBillBean
extends CadreBillBizBean {
    @Override
    protected String getSQL(String personIds, String currDate, String billID) {
        if (personIds == null) {
            return null;
        }
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType ");
        oql.append("where person.id in ");
        oql.append(this.getIdSql(personIds));
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and billID <> '");
            oql.append(billID);
            oql.append("' ");
        }
        oql.append(" and BillBOSType = 'B80AC705'");
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate >= ");
        oql.append(currDate);
        oql.append(" ))");
        return oql.toString();
    }

    @Override
    protected void _check(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        CadreAuditBizBillEntryInfo cInfo = (CadreAuditBizBillEntryInfo)entry;
        ICadreAuditBizBillEntry iCadre = CadreAuditBizBillEntryFactory.getLocalInstance(ctx);
        String number = "";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)cInfo.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)cInfo.getPerson().getId().toString(), CompareType.EQUALS));
        if (cInfo.getId() != null) {
            CadreAuditBizBillEntryInfo c = iCadre.getCadreAuditBizBillEntryInfo((IObjectPK)new ObjectUuidPK(cInfo.getId().toString()));
            number = c.getNumber();
        }
        if ((cInfo.getId() == null || !number.equals(cInfo.getNumber())) && iCadre.exists(filter)) {
            throw new CadreAuditException(CadreAuditException.AUDIT_NUMBER, new Object[]{cInfo.getNumber(), CompareType.EQUALS});
        }
        ICadreAudit iAudit = CadreAuditFactory.getLocalInstance(ctx);
        if (iAudit.exists(filter)) {
            throw new CadreAuditException(CadreAuditException.AUDIT_NUMBER_INTABLE, new Object[]{cInfo.getNumber()});
        }
    }

    @Override
    protected void isPersonInAffairBill(Context ctx, String personIds, String billId) throws BOSException, EASBizException {
    }
}

