/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.AffairBizCheckFacadeFactory;
import com.kingdee.eas.hr.affair.IAffairBizCheckFacade;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.app.HRBillBizBean;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.kt.CadreBillBizCheckFacadeFactory;
import com.kingdee.eas.hr.kt.CadreBillBizCollection;
import com.kingdee.eas.hr.kt.CadreBillBizException;
import com.kingdee.eas.hr.kt.CadreBillBizFactory;
import com.kingdee.eas.hr.kt.CadreBillBizInfo;
import com.kingdee.eas.hr.kt.ICadreBillBiz;
import com.kingdee.eas.hr.kt.ICadreBillBizCheckFacade;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class CadreBillBizBean
extends HRBillBizBean {
    public void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)model;
        this.addNewCadreBillBiz(ctx, info);
    }

    public void _check(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)model;
        String entryField = this.getEntryField();
        IObjectCollection entries = (IObjectCollection)info.get(entryField);
        HRBillBaseEntryInfo entry = null;
        if (entries != null) {
            String personField = this.getPersonField();
            PersonInfo person = null;
            String billID = null;
            if (pk != null) {
                billID = pk.toString();
            }
            BatchProcessedResult result = null;
            ICadreBillBizCheckFacade checkFacade = CadreBillBizCheckFacadeFactory.getLocalInstance(ctx);
            StringBuffer personIds = new StringBuffer();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (HRBillBaseEntryInfo)entries.getObject(i);
                if (!StringUtils.isEmpty((String)personField) && (person = (PersonInfo)entry.get(personField)) != null) {
                    String personID = person.getId().toString();
                    personIds.append(personID);
                    personIds.append(",");
                }
                this._check(ctx, entry);
            }
            String currDate = this.getCurrentDate();
            String oql = this.getSQL(personIds.toString(), currDate, billID);
            result = checkFacade.isPersonInAffairProcess(oql);
            if (result != null && result.isHasValidInfo()) {
                throw new CadreBillBizException(CadreBillBizException.BILL_CHECK_FAILED, new Object[]{result.getInvalidInfo()});
            }
            this.isPersonInAffairBill(ctx, personIds.toString(), null);
        }
    }

    protected void _check(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CadreBillBizFactory.getLocalInstance(ctx).delete("where billID = '" + pk + "'");
    }

    public void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    public void _processBeforeAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    public void _setBillState(Context ctx, BOSUuid billID, HRBillStateEnum state) throws BOSException, EASBizException {
        ICadreBillBiz cadreBiz = CadreBillBizFactory.getLocalInstance(ctx);
        CadreBillBizCollection cadreCol = cadreBiz.getCadreBillBizCollection("where billID = '" + billID + "'");
        if (cadreCol != null) {
            CadreBillBizInfo info = null;
            int size = cadreCol.size();
            for (int i = 0; i < size; ++i) {
                info = cadreCol.get(i);
                info.setBillState(state);
                cadreBiz.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
            }
        }
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ICadreBillBiz cadreBiz = CadreBillBizFactory.getLocalInstance(ctx);
        cadreBiz.delete("where billID = '" + pk + "'");
        this.addNewCadreBillBiz(ctx, (HRBillBaseInfo)model);
    }

    protected void addNewCadreBillBiz(Context ctx, HRBillBaseInfo info) throws BOSException, EASBizException {
        String entry = this.getEntryField();
        if (StringUtils.isEmpty((String)entry)) {
            return;
        }
        IObjectCollection entryCol = (IObjectCollection)info.get(entry);
        if (entryCol != null) {
            HRBillBaseEntryInfo entryInfo = null;
            CadreBillBizInfo cadreInfo = null;
            ICadreBillBiz cadreBiz = CadreBillBizFactory.getLocalInstance(ctx);
            String field = null;
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = (HRBillBaseEntryInfo)entryCol.getObject(i);
                cadreInfo = new CadreBillBizInfo();
                cadreInfo.setBillID(info.getId());
                cadreInfo.setBillBOSType(info.getBOSType().toString());
                cadreInfo.setBillState(info.getBillState());
                cadreInfo.setEntryID(entryInfo.getId());
                field = this.getEntryEffectDateField();
                if (!StringUtils.isEmpty((String)field)) {
                    cadreInfo.setEntryBizDate(entryInfo.getDate(field));
                }
                if (!StringUtils.isEmpty((String)(field = this.getPersonField()))) {
                    cadreInfo.setPerson((PersonInfo)entryInfo.get(field));
                }
                cadreBiz.addnew(cadreInfo);
            }
        }
    }

    public void _beforeEffectBeforeBackJob(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    public void _beforeEffectOnBackJob(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    public void _beforeEffectOnNoJob(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    protected String getSQL(String personIds, String currDate, String billID) {
        return null;
    }

    protected void isPersonInAffairBill(Context ctx, String personIds, String billId) throws BOSException, EASBizException {
        IAffairBizCheckFacade checkAffairBill = AffairBizCheckFacadeFactory.getLocalInstance((Context)ctx);
        BatchProcessedResult result = checkAffairBill.isPersonInAffairProcess(personIds, billId);
        if (result != null && result.isHasValidInfo()) {
            throw new CadreBillBizException(CadreBillBizException.BILL_CHECK_FAILED, new Object[]{result.getInvalidInfo()});
        }
    }

    protected String getIdSql(String personIds) {
        String[] idarrs = personIds.split(",");
        StringBuffer idsSql = new StringBuffer();
        boolean isfirst = true;
        idsSql.append("(");
        for (int i = 0; i < idarrs.length; ++i) {
            if (StringUtils.isEmpty((String)idarrs[i])) continue;
            if (!isfirst) {
                idsSql.append(",");
            }
            isfirst = false;
            idsSql.append("'");
            idsSql.append(idarrs[i]);
            idsSql.append("'");
        }
        idsSql.append(")");
        return idsSql.toString();
    }

    protected String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getBillApplyDateField() {
        return "applyDate";
    }

    protected String getBillApplieField() {
        return "applier";
    }

    protected String getPersonField() {
        return "person";
    }
}

