/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.kt.CadreBillBizCheckFacadeFactory;
import com.kingdee.eas.hr.kt.CadreBillBizException;
import com.kingdee.eas.hr.kt.CadreSelectBizBillEntryCollection;
import com.kingdee.eas.hr.kt.CadreSelectBizBillEntryFactory;
import com.kingdee.eas.hr.kt.CadreSelectBizBillEntryInfo;
import com.kingdee.eas.hr.kt.CadreSelectBizBillInfo;
import com.kingdee.eas.hr.kt.ICadreBillBizCheckFacade;
import com.kingdee.eas.hr.kt.app.CadreBillBizBean;

public class CadreSelectBizBillBean
extends CadreBillBizBean {
    @Override
    protected String getSQL(String personIds, String currDate, String billID) {
        if (StringUtils.isEmpty((String)personIds)) {
            return null;
        }
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType ");
        oql.append("where person.id in ");
        oql.append(this.getIdSql(personIds));
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and billID <> '");
            oql.append(billID);
            oql.append("' ");
        }
        oql.append(" and BillBOSType in ('8875B444')");
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate >= ");
        oql.append(currDate);
        oql.append(" ))");
        return oql.toString();
    }

    @Override
    public void _check(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CadreSelectBizBillInfo info = (CadreSelectBizBillInfo)model;
        String entryField = this.getEntryField();
        CadreSelectBizBillEntryCollection entries = (CadreSelectBizBillEntryCollection)((Object)info.get(entryField));
        CadreSelectBizBillEntryInfo entry = null;
        if (entries != null) {
            String personField = this.getPersonField();
            PersonInfo person = null;
            String billID = null;
            if (pk != null) {
                billID = pk.toString();
            }
            String personID = null;
            String personNumber = null;
            String positionID = null;
            String oql = null;
            String oqlbean = null;
            String currDate = null;
            BatchProcessedResult result = null;
            ICadreBillBizCheckFacade checkFacade = CadreBillBizCheckFacadeFactory.getLocalInstance(ctx);
            CadreSelectBizBillEntryCollection selectCol = null;
            StringBuffer personIds = new StringBuffer();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (CadreSelectBizBillEntryInfo)entries.getObject(i);
                if (StringUtils.isEmpty((String)personField) || (person = (PersonInfo)entry.get(personField)) == null) continue;
                personID = person.getId().toString();
                personIds.append(personID);
                personIds.append(",");
                personNumber = person.getNumber();
                positionID = entry.getTargetPosition().getId().toString();
                oql = this.getSQLBySelect(personID, billID, positionID);
                selectCol = CadreSelectBizBillEntryFactory.getLocalInstance(ctx).getCadreSelectBizBillEntryCollection(oql);
                if (selectCol == null || selectCol.size() <= 0) continue;
                throw new CadreBillBizException(CadreBillBizException.SELECTBILL_FAILED, new Object[]{personNumber});
            }
            currDate = this.getCurrentDate();
            oqlbean = this.getSQL(personIds.toString(), currDate, billID);
            result = checkFacade.isPersonInAffairProcess(oqlbean);
            if (result != null && result.isHasValidInfo()) {
                throw new CadreBillBizException(CadreBillBizException.BILL_CHECK_FAILED, new Object[]{result.getInvalidInfo()});
            }
            this.isPersonInAffairBill(ctx, personIds.toString(), null);
        }
    }

    private String getSQLBySelect(String personID, String billID, String positionID) {
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number ");
        oql.append("where person.id = '");
        oql.append(personID);
        oql.append("' ");
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and bill.id <> '");
            oql.append(billID);
            oql.append("' ");
        }
        oql.append(" and targetPosition.id = '");
        oql.append(positionID);
        oql.append("' ");
        oql.append(" and (");
        oql.append(" bill.billState = ");
        oql.append(0);
        oql.append(" or bill.billState = ");
        oql.append(1);
        oql.append(" or bill.billState = ");
        oql.append(2);
        oql.append(" )");
        return oql.toString();
    }
}

