/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SHRAdminActivatedFactory;
import com.kingdee.eas.hr.base.SHRAdminActivatedInfo;
import com.kingdee.eas.hr.mvdt.SynIdMappingFactory;
import com.kingdee.eas.hr.mvdt.SynIdMappingInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.handler.OrgUnitLayerTypeMoveHandler;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdminMoveDataHandler
implements ISHRMoveDataHandler {
    private String adminBossType = "6A6435BE";

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_ORG_LAYERTYPE", "moving");
        OrgUnitLayerTypeMoveHandler orgUnitLayerTypeMoveHandler = new OrgUnitLayerTypeMoveHandler();
        orgUnitLayerTypeMoveHandler.moveData(shrConn, ctx);
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_ORG_LAYERTYPE", "finished");
        this.moveBaseAdminAction(shrConn, ctx);
        this.moveAdminAction(shrConn, ctx);
        this.moveAdminHisAction(shrConn, ctx);
        this.moveHroAction(shrConn, ctx);
        this.moveOtherTableAction(shrConn, ctx);
        this.moveCtrlUnitAction(shrConn, ctx);
        this.moveOupartAdminAction(shrConn, ctx);
        this.setAdminIsStartShr(shrConn, ctx);
        this.moveAdminStateAction(shrConn, ctx);
        DbUtil.execute((Context)ctx, (String)"update t_org_oupartadmin set feffdt = (select b.feffdt from t_org_admin b where b.fid=t_org_oupartadmin.funitid )");
        return null;
    }

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        this.verifyAdminOrgMapId(shrConn, ctx);
        return null;
    }

    public String verifyAdminOrgMapId(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String easId;
        String shrNumber;
        String tableName = "T_ORG_ADMIN";
        String oql = "where bosType ='" + this.adminBossType + "'";
        SynIdMappingFactory.getRemoteInstance().delete(oql);
        int level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
        int startNumber = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
        List<Map<String, String>> shrAdminResultList = AdminMoveDataHandler.getShrAdminList(shrConn, ctx);
        List<Map<String, String>> easAdminResultList = AdminMoveDataHandler.getEasAdminList(shrConn, ctx);
        for (int i = 0; i < shrAdminResultList.size(); ++i) {
            Map<Object, Object> shrMap = new HashMap();
            shrMap = shrAdminResultList.get(i);
            String shrDisplayName = shrMap.get("shrDisplayName") == null ? "" : (String)shrMap.get("shrDisplayName");
            shrNumber = shrMap.get("shrNumber") == null ? "" : (String)shrMap.get("shrNumber");
            String shrId = (String)shrMap.get("shrId");
            for (int j = 0; j < easAdminResultList.size(); ++j) {
                String easNumber;
                String easDisplayName;
                Map<Object, Object> easMap = new HashMap();
                easMap = easAdminResultList.get(j);
                String string = easDisplayName = easMap.get("easDisplayName") == null ? "" : (String)easMap.get("easDisplayName");
                if (level != 0 && easDisplayName.length() > level) {
                    easDisplayName = easDisplayName.substring(startNumber - 1);
                }
                easId = (String)easMap.get("easId");
                String string2 = easNumber = easMap.get("easNumber") == null ? "" : (String)easMap.get("easNumber");
                if (!shrDisplayName.equals(easDisplayName) || !shrNumber.equals(easNumber)) continue;
                SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                synIdMappingInfo.setBosType(this.adminBossType);
                synIdMappingInfo.setShrId(shrId);
                synIdMappingInfo.setEasId(easId);
                synIdMappingInfo.setMapWay("normal");
                SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
            }
        }
        try {
            String rootName = SHRMoveDataHelpUtil.getFilterFname(ctx);
            String shrSql = "SELECT FID,FNUMBER,FDISPLAYNAME_L2 FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.adminBossType + "')";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)shrSql);
            while (executeQuery.next()) {
                String shrId = executeQuery.getString("FID");
                String shrNumber2 = executeQuery.getString("FNUMBER");
                String shrDisplayName = executeQuery.getString("FDISPLAYNAME_L2");
                String checkSql = "SELECT FID FROM " + tableName + " WHERE FDISPLAYNAME_L2 = '" + rootName + shrDisplayName + "' AND  FID NOT IN (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.adminBossType + "')";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (executeQuery2.next()) {
                    easId = executeQuery2.getString("FID");
                    SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                    synIdMappingInfo.setBosType(this.adminBossType);
                    synIdMappingInfo.setShrId(shrId);
                    synIdMappingInfo.setEasId(easId);
                    synIdMappingInfo.setMapWay("displayName");
                    SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
                }
            }
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        try {
            String shrSql = "SELECT FID,FNUMBER FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.adminBossType + "')";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)shrSql);
            while (executeQuery.next()) {
                String shrId = executeQuery.getString("FID");
                shrNumber = executeQuery.getString("FNUMBER");
                String checkSql = "SELECT FID FROM " + tableName + " WHERE FNUMBER = '" + shrNumber + "' AND  FID NOT IN (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.adminBossType + "')";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (executeQuery2.next()) {
                    String easId2 = executeQuery2.getString("FID");
                    SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                    synIdMappingInfo.setBosType(this.adminBossType);
                    synIdMappingInfo.setShrId(shrId);
                    synIdMappingInfo.setEasId(easId2);
                    synIdMappingInfo.setMapWay("number");
                    SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
                }
            }
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String verifyOuPartAdminMapId(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        Statement adminVerifyState = null;
        ResultSet rs = null;
        try {
            String oql = "where bosType ='BCA8D47D'";
            SynIdMappingFactory.getRemoteInstance().delete(oql);
            String shrSql = "select FID,FUNITID from T_ORG_OUPARTADMIN";
            adminVerifyState = shrConn.createStatement();
            rs = adminVerifyState.executeQuery(shrSql);
            while (rs.next()) {
                String shrID = rs.getString(1);
                String shrUnitId = rs.getString(2);
                String easID = "";
                String sql = "select FID FROM T_ORG_OUPARTADMIN WHERE FUNITID = '" + shrUnitId + "'";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                    easID = executeQuery.getString("FID");
                    synIdMappingInfo.setBosType("BCA8D47D");
                    synIdMappingInfo.setShrId(shrID);
                    synIdMappingInfo.setEasId(easID);
                    SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void moveAdminAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_ADMIN";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            if (SHRMoveDataHelpUtil.checkEasDBifEmpty()) {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName));
                UpdateTool.commonUpdate(shrConn, tableName, "", ctx, 100);
                SHRMoveDataHelpUtil.refreshFidAction(ctx, tableName, "FLayerTypeID", "OrgUnitLayerType");
            } else {
                ArrayList<String> columnList = new ArrayList();
                columnList = AdminMoveDataHandler.getColumnByUIPK(shrConn, ctx);
                SHRMoveDataHelpUtil.updateMapTableValue(shrConn, ctx, columnList, tableName + "_SHR_TEMP", tableName, this.adminBossType, 10);
                String filterRepetitionId = "'ID\u91cd\u590d\u7684'";
                HashMap<String, String> idMap = new HashMap<String, String>();
                String sql = "SELECT FID FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.adminBossType + "')";
                String checkSql = "SELECT FID FROM " + tableName + " WHERE FID IN (" + sql + ")";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (executeQuery.next()) {
                    String id = executeQuery.getString("FID");
                    BOSObjectType T = BOSObjectType.create((String)this.adminBossType);
                    String newId = BOSUuid.create((BOSObjectType)T).toString();
                    filterRepetitionId = filterRepetitionId + ",'" + id + "'";
                    idMap.put(id, newId);
                }
                String filterAddnewId = "'\u53ef\u4ee5\u76f4\u63a5\u65b0\u589e\u7684'";
                String getAddnewSql = "SELECT FID FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (" + filterRepetitionId + ") AND FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.adminBossType + "')";
                executeQuery = DbUtil.executeQuery((Context)ctx, (String)getAddnewSql);
                while (executeQuery.next()) {
                    String id = executeQuery.getString("FID");
                    filterAddnewId = filterAddnewId + ",'" + (String)id + "'";
                }
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FID IN (" + filterAddnewId + ") ", ctx, 100);
                for (String key : idMap.keySet()) {
                    String insertSql = SHRMoveDataHelpUtil.getInsertSql(shrConn, ctx, tableName, key, (String)idMap.get(key));
                    DbUtil.execute((Context)ctx, (String)insertSql);
                    SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                    synIdMappingInfo.setBosType(this.adminBossType);
                    synIdMappingInfo.setShrId(key);
                    synIdMappingInfo.setEasId((String)idMap.get(key));
                    synIdMappingInfo.setMapWay("ID\u91cd\u590d");
                    SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
                }
                this.updateFlongNumber(ctx, tableName);
                SHRMoveDataHelpUtil.refreshFidAction(ctx, tableName, "FLayerTypeID", "OrgUnitLayerType");
                ArrayList<String> sqlList = new ArrayList<String>();
                String getSealUpSql = "SELECT FSHRID,FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '" + this.adminBossType + "' AND FSHRID IN (SELECT FID FROM " + tableName + "_SHR_TEMP WHERE FIsSealUp = 1)";
                executeQuery = DbUtil.executeQuery((Context)ctx, (String)getSealUpSql);
                while (executeQuery.next()) {
                    String shrId = executeQuery.getString("FSHRID");
                    String easId = executeQuery.getString("FEASID");
                    String updateSealUpSql = "UPDATE " + tableName + " SET FIsSealUp = (SELECT FIsSealUp FROM " + tableName + "_SHR_TEMP B WHERE B.FID = '" + shrId + "') WHERE A.FID = '" + easId + "'";
                    sqlList.add(updateSealUpSql);
                }
                if (sqlList.size() > 0) {
                    SHRMoveDataHelpUtil.insertByBatch(ctx, sqlList, 10);
                }
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void moveOtherTableAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "";
        Object state = null;
        Object rs = null;
        try {
            int level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
            String filterAddNewID = SHRMoveDataHelpUtil.getNoMapSHRId(shrConn, ctx, this.adminBossType, "T_ORG_ADMIN");
            tableName = "T_ORG_STRUCTURE";
            if (!SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + " WHERE FUNITID IN (" + filterAddNewID + ")  AND FTREEID IN ('00000000-0000-0000-0000-0000000000034F2827FD','00000000-0000-0000-0000-0000000000014F2827FD')"));
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FUNITID IN (" + filterAddNewID + ")  AND FTREEID IN ('00000000-0000-0000-0000-0000000000034F2827FD','00000000-0000-0000-0000-0000000000014F2827FD')", ctx, 100);
                if (SHRMoveDataHelpUtil.checkMapTableIdRepeat(this.adminBossType, "ID\u91cd\u590d")) {
                    SHRMoveDataHelpUtil.refreshFidAction(ctx, tableName, "FUNITID", "adminOrg");
                }
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
            }
            if (!SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName = "T_ORG_OUPARTHR")) {
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + " WHERE FUNITID IN (" + filterAddNewID + ")"));
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FUNITID IN (" + filterAddNewID + ")", ctx, 100);
                if (SHRMoveDataHelpUtil.checkMapTableIdRepeat(this.adminBossType, "ID\u91cd\u590d")) {
                    SHRMoveDataHelpUtil.refreshFidAction(ctx, tableName, "FUNITID", "adminOrg");
                }
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
            }
            if (!SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName = "T_ORG_UNITRELATION")) {
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + " WHERE FFROMUNITID IN (" + filterAddNewID + ") AND FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'"));
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FFROMUNITID IN (" + filterAddNewID + ") AND FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'", ctx, 100);
                ArrayList<String> sqlList = new ArrayList<String>();
                String sql = "SELECT FID,FDelegateHRID FROM T_ORG_ADMIN WHERE FDelegateHRID IS NOT NULL  AND FDelegateHRID <> '' AND FID NOT IN (SELECT FFROMUNITID FROM T_ORG_UNITRELATION WHERE FTYPERELATIONID  = '00000000-0000-0000-0000-0000000000100FE9F8B5')";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery2.next()) {
                    String adminId = executeQuery2.getString("FID");
                    String toUnitId = executeQuery2.getString("FDelegateHRID");
                    BOSObjectType T = BOSObjectType.create((String)"3B2666DB");
                    String id = BOSUuid.create((BOSObjectType)T).toString();
                    String insertSql = "insert into t_org_unitrelation(FID, FFromUnitID, FToUnitID, FTypeRelationID, FIsDefault, FVersionNumber) ";
                    insertSql = insertSql + "values ('" + id + "','" + adminId + "','" + toUnitId + "','00000000-0000-0000-0000-0000000000100FE9F8B5',0,N'000')";
                    sqlList.add(insertSql);
                }
                if (sqlList.size() > 0) {
                    SHRMoveDataHelpUtil.insertByBatch(ctx, sqlList, 10);
                }
                SHRMoveDataHelpUtil.refreshFidAction(ctx, tableName, "FFROMUNITID", "adminOrg");
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
            }
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void moveHroAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_HRO";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String filterSql = SHRMoveDataHelpUtil.getStartSHRId(shrConn, ctx, this.adminBossType, "T_ORG_ADMIN");
            if (SHRMoveDataHelpUtil.checkEasDBifEmpty()) {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + " WHERE FID IN (" + filterSql + ")"));
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FID IN (" + filterSql + ") ", ctx, 100);
            } else {
                String filterAddNewID = SHRMoveDataHelpUtil.getNoMapSHRId(shrConn, ctx, this.adminBossType, "T_ORG_ADMIN");
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FID IN (" + filterAddNewID + ") ", ctx, 100);
                if (SHRMoveDataHelpUtil.checkMapTableIdRepeat(this.adminBossType, "ID\u91cd\u590d")) {
                    SHRMoveDataHelpUtil.refreshFidAction(ctx, tableName, "FID", "adminOrg");
                }
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void moveCtrlUnitAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_CTRLUNIT";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String filterSql = SHRMoveDataHelpUtil.getStartSHRId(shrConn, ctx, this.adminBossType, "T_ORG_ADMIN");
            if (SHRMoveDataHelpUtil.checkEasDBifEmpty()) {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + " WHERE FID IN (" + filterSql + ") "));
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FID IN (" + filterSql + ") ", ctx, 100);
            } else {
                String filterAddNewID = SHRMoveDataHelpUtil.getNoMapSHRId(shrConn, ctx, this.adminBossType, "T_ORG_ADMIN");
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FID IN (" + filterAddNewID + ") ", ctx, 100);
                ArrayList<String> columnList = new ArrayList<String>();
                columnList.add("FNAME_L2");
                columnList.add("FDESCRIPTION_L2");
                columnList.add("FSIMPLENAME");
                columnList.add("FEFFECTDATE");
                columnList.add("FINVALIDDATE");
                columnList.add("FCREATORID");
                columnList.add("FCREATETIME");
                columnList.add("FLASTUPDATEUSERID");
                columnList.add("FLASTUPDATETIME");
                columnList.add("FISSTART");
                columnList.add("FCODE");
                int level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
                if (level == 0) {
                    columnList.add("FDISPLAYNAME_L2");
                    columnList.add("FLONGNUMBER");
                }
                SHRMoveDataHelpUtil.updateMapTableValue(shrConn, ctx, columnList, tableName + "_SHR_TEMP", tableName, this.adminBossType, 10);
                String sql = "select CTRL.FID AS id,UNIT.FLONGNUMBER AS longNumber FROM " + tableName + " CTRL LEFT JOIN T_ORG_BASEUNIT UNIT ON CTRL.FID = UNIT.FID";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    if (executeQuery.getString("longNumber") == null) continue;
                    DbUtil.execute((Context)ctx, (String)("UPDATE " + tableName + " SET FLONGNUMBER = '" + executeQuery.getString("longNumber") + "' where fid = '" + executeQuery.getString("id") + "'"));
                }
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void moveOupartAdminAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_OUPARTADMIN";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            String updateSql;
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String filterAddNewID = SHRMoveDataHelpUtil.getNoMapSHRId(shrConn, ctx, "BCA8D47D", tableName);
            if (SHRMoveDataHelpUtil.checkEasDBifEmpty()) {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + " WHERE FUNITID <> '00000000-0000-0000-0000-000000000000CCE7AED4'"));
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FUNITID <> '00000000-0000-0000-0000-000000000000CCE7AED4'", ctx, 100);
                updateSql = "UPDATE " + tableName + " SET FISSTARTSHR = 1";
                DbUtil.execute((Context)ctx, (String)updateSql);
            } else {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + " WHERE FUNITID IN (" + filterAddNewID + ")"));
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FUNITID IN (" + filterAddNewID + ") ", ctx, 100);
                updateSql = "UPDATE " + tableName + " SET FISSTARTSHR = 1 WHERE FID IN (" + filterAddNewID + ")";
                DbUtil.execute((Context)ctx, (String)updateSql);
                SHRMoveDataHelpUtil.updateColumnValueByShrValue(shrConn, ctx, tableName, "BCA8D47D", 100);
            }
            String updateLayerSql = "UPDATE T_ORG_OUPARTADMIN SET FLAYERTYPEID = (SELECT FLAYERTYPEID FROM T_ORG_ADMIN WHERE T_ORG_OUPARTADMIN.FUNITID = T_ORG_ADMIN.FID)";
            DbUtil.execute((Context)ctx, (String)updateLayerSql);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void setAdminIsStartShr(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String updateSql;
            if (SHRMoveDataHelpUtil.checkEasDBifEmpty()) {
                updateSql = "UPDATE T_ORG_ADMIN SET FISSTARTSHR = 1";
                DbUtil.execute((Context)ctx, (String)updateSql);
            } else {
                updateSql = "UPDATE T_ORG_ADMIN SET FISSTARTSHR = 1 WHERE FID IN (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '" + this.adminBossType + "')";
                DbUtil.execute((Context)ctx, (String)updateSql);
                updateSql = "UPDATE T_ORG_ADMIN SET FISSTARTSHR = 1 WHERE FID IN (SELECT FID FROM T_ORG_ADMIN)";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
            ArrayList<String> sqlList = new ArrayList<String>();
            String sql = "SELECT FID FROM T_ORG_ADMIN WHERE FISSTARTSHR = 1";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                sqlList.add("UPDATE T_ORG_OUPARTADMIN SET FISSTARTSHR = 1 WHERE FUNITID = '" + executeQuery.getString("FID") + "'");
            }
            if (sqlList.size() > 0) {
                SHRMoveDataHelpUtil.insertByBatch(ctx, sqlList, 10);
            }
        }
        catch (SHRWebException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void moveBaseAdminAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_BASEUNIT";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String filterSql = SHRMoveDataHelpUtil.getStartSHRId(shrConn, ctx, this.adminBossType, "T_ORG_ADMIN");
            if (SHRMoveDataHelpUtil.checkEasDBifEmpty()) {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + " WHERE FID IN (" + filterSql + ") "));
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FID IN (" + filterSql + ") ", ctx, 100);
            } else {
                ArrayList<String> columnList = new ArrayList<String>();
                columnList.add("FNAME_L2");
                columnList.add("FDESCRIPTION_L2");
                columnList.add("FSIMPLENAME");
                columnList.add("FEFFECTDATE");
                columnList.add("FINVALIDDATE");
                columnList.add("FCREATORID");
                columnList.add("FCREATETIME");
                columnList.add("FLASTUPDATEUSERID");
                columnList.add("FLASTUPDATETIME");
                columnList.add("FPARENTID");
                columnList.add("FISSTART");
                columnList.add("FCODE");
                int level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
                if (level == 0) {
                    columnList.add("FDISPLAYNAME_L2");
                    columnList.add("FLONGNUMBER");
                }
                SHRMoveDataHelpUtil.updateMapTableValue(shrConn, ctx, columnList, tableName + "_SHR_TEMP", tableName, this.adminBossType, 10);
                String filterRepetitionId = "'ID\u91cd\u590d\u7684'";
                HashMap<String, String> idMap = new HashMap<String, String>();
                String sql = "SELECT FID FROM T_ORG_ADMIN_SHR_TEMP WHERE FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.adminBossType + "')";
                String checkSql = "SELECT FID FROM " + tableName + " WHERE FID IN (" + sql + ") AND FID NOT LIKE '%111111%'";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (executeQuery.next()) {
                    String id = executeQuery.getString("FID");
                    BOSObjectType T = BOSObjectType.create((String)this.adminBossType);
                    String newId = BOSUuid.create((BOSObjectType)T).toString();
                    filterRepetitionId = filterRepetitionId + ",'" + id + "'";
                    idMap.put(id, newId);
                }
                String filterAddnewId = "'\u53ef\u4ee5\u76f4\u63a5\u65b0\u589e\u7684'";
                String getAddnewSql = "SELECT FID FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (" + filterRepetitionId + ") AND FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.adminBossType + "') AND FID NOT LIKE '%111111%'";
                executeQuery = DbUtil.executeQuery((Context)ctx, (String)getAddnewSql);
                while (executeQuery.next()) {
                    String id = executeQuery.getString("FID");
                    filterAddnewId = filterAddnewId + ",'" + id + "'";
                }
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FID IN (" + filterAddnewId + ") ", ctx, 100);
                for (String key : idMap.keySet()) {
                    String insertSql = SHRMoveDataHelpUtil.getInsertSql(shrConn, ctx, tableName, key, (String)idMap.get(key));
                    DbUtil.execute((Context)ctx, (String)insertSql);
                }
                this.updateFlongNumber(ctx, tableName);
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void moveAdminHisAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_ADMINHIS";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String deleteSql = "DELETE FROM " + tableName;
            DbUtil.execute((Context)ctx, (String)deleteSql);
            UpdateTool.commonUpdate(shrConn, tableName, "", ctx, 100);
            this.updateFlongNumber(ctx, tableName);
            SHRMoveDataHelpUtil.refreshFidAction(ctx, tableName, "FLayerTypeID", "OrgUnitLayerType");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void moveAdminStateAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_HR_SHRADMINACTIVATED";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_HR_SHRADMINACTIVATED");
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("SELECT * WHERE id IS NOT NULL");
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                    adminOrgUnitInfo = coll.get(i);
                    SHRAdminActivatedInfo SHRAdminActivatedInfo2 = new SHRAdminActivatedInfo();
                    SHRAdminActivatedInfo2.setAdminOrgUnit(adminOrgUnitInfo);
                    SHRAdminActivatedInfo2.setIsStart(true);
                    String hisSql = "SELECT FEFFDT FROM T_ORG_ADMINHIS WHERE FhistoryRelateID = '" + adminOrgUnitInfo.getId().toString() + "' ORDER BY FEFFDT";
                    IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)hisSql);
                    if (executeQuery2.next()) {
                        Date effectDate = executeQuery2.getDate("FEFFDT");
                        SHRAdminActivatedInfo2.setEffectDate(new Timestamp(effectDate.getTime()));
                        SHRAdminActivatedFactory.getLocalInstance((Context)ctx).addnew(SHRAdminActivatedInfo2);
                        continue;
                    }
                    SHRAdminActivatedInfo2.setEffectDate(new Timestamp(adminOrgUnitInfo.getEFFDT().getTime()));
                    SHRAdminActivatedFactory.getLocalInstance((Context)ctx).addnew(SHRAdminActivatedInfo2);
                }
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateOrgIsValue(Context ctx, String tableName, String filterId) throws BOSException, EASBizException {
        if (filterId.equals("")) {
            filterId = "'1'";
        }
        String updateSql = "UPDATE " + tableName + " SET  FIsGrouping = 0, FIsFreeze = 0, FIsCompanyOrgUnit = 0, FIsAdminOrgUnit = 1, FIsSaleOrgUnit = 0, FIsPurchaseOrgUnit = 0, FIsStorageOrgUnit = 0, FIsProfitOrgUnit = 0, FIsCostOrgUnit = 0, FIsUnion = 0, FIsTransportOrgUnit = 0, FIsQualityOrgUnit = 0 WHERE FID IN (" + filterId + ")";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    public void updateFlongNumber(Context ctx, String tableName) throws BOSException, EASBizException {
        int level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
        if (level != 0) {
            try {
                String sql = "SELECT FLONGNUMBER,FNAME_L2 FROM T_ORG_ADMIN WHERE FLEVEL = 1";
                String rootLongNumber = "";
                String rootName = "";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (executeQuery.next()) {
                    rootLongNumber = executeQuery.getString("FLONGNUMBER");
                    rootName = executeQuery.getString("FNAME_L2");
                }
                if (tableName.equals("T_ORG_ADMINHIS")) {
                    rootLongNumber = "'" + rootLongNumber + "!'";
                    rootName = "'" + rootName + "_'";
                    String updateLongNumberSql = "update T_ORG_ADMINHIS set FLONGNUMBER=concat(" + rootLongNumber + ",FLONGNUMBER)";
                    String updateDisPlayNameSql = "update T_ORG_ADMINHIS set FDISPLAYNAME_L2=concat(" + rootName + ",FDISPLAYNAME_L2)";
                    DbUtil.execute((Context)ctx, (String)updateLongNumberSql);
                    DbUtil.execute((Context)ctx, (String)updateDisPlayNameSql);
                } else {
                    String idFilterSql = "SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '6A6435BE'";
                    sql = "SELECT FID,FLONGNUMBER,FDISPLAYNAME_L2 FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (" + idFilterSql + ")";
                    executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (executeQuery.next()) {
                        String id = executeQuery.getString("FID");
                        String longNumber = executeQuery.getString("FLONGNUMBER");
                        String disPlayName = executeQuery.getString("FDISPLAYNAME_L2");
                        DbUtil.execute((Context)ctx, (String)("UPDATE " + tableName + " SET FLONGNUMBER = '" + rootLongNumber + "!" + longNumber + "',FDISPLAYNAME_L2 = '" + rootName + "_" + disPlayName + "' WHERE FID = '" + id + "'"));
                    }
                    if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT FSHRID,FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '6A6435BE' AND FMapWay='ID\u91cd\u590d'"))).next()) {
                        String shrId = executeQuery.getString("FSHRID");
                        String easId = executeQuery.getString("FEASID");
                        String getValueSql = "SELECT FID,FLONGNUMBER,FDISPLAYNAME_L2 FROM " + tableName + "_SHR_TEMP WHERE FID = '" + shrId + "'";
                        IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)getValueSql);
                        if (executeQuery2.next()) {
                            String longNumber = executeQuery.getString("FLONGNUMBER");
                            String disPlayName = executeQuery.getString("FDISPLAYNAME_L2");
                            DbUtil.execute((Context)ctx, (String)("UPDATE " + tableName + " SET FLONGNUMBER = '" + rootLongNumber + "!" + longNumber + "',FDISPLAYNAME_L2 = '" + rootName + "_" + disPlayName + "' WHERE FID = '" + easId + "'"));
                        }
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateWhenEasRootMore(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        int level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
        if (level != 0) {
            try {
                String sql = "SELECT FID,FPARENTID FROM T_ORG_ADMIN_EAS_TEMP WHERE FLEVEL < 4 AND FLEVEL > 1";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    if (executeQuery.getString("FID") == null || executeQuery.getString("FPARENTID") == null) continue;
                    String adminId = executeQuery.getString("FID");
                    String parentId = executeQuery.getString("FPARENTID");
                    DbUtil.execute((Context)ctx, (String)("UPDATE T_ORG_ADMIN SET FPARENTID = '" + parentId + "' WHERE FID = '" + adminId + "'"));
                    DbUtil.execute((Context)ctx, (String)("UPDATE T_ORG_BASEUNIT SET FPARENTID = '" + parentId + "' WHERE FID = '" + adminId + "'"));
                    DbUtil.execute((Context)ctx, (String)("UPDATE T_ORG_ADMINHIS SET FPARENTID = '" + parentId + "' WHERE FHistoryRelateID = '" + adminId + "' AND FLEFFDT = {2199-12-31}"));
                    DbUtil.execute((Context)ctx, (String)("UPDATE T_ORG_HRO SET FPARENTID = '" + parentId + "' WHERE FID = '" + adminId + "'"));
                    DbUtil.execute((Context)ctx, (String)("UPDATE T_ORG_CTRLUNIT SET FPARENTID = '" + parentId + "' WHERE FID = '" + adminId + "'"));
                    String getStructSql = "SELECT struct.FID AS id,struct.FTREEID AS treeId,parentStruct.FID AS parentId FROM T_ORG_STRUCTURE struct LEFT JOIN T_ORG_STRUCTURE parentStruct ON struct.FTREEID = parentStruct.FTREEID  WHERE struct.FUNITID = '" + adminId + "' AND parentStruct.FUNITID = '" + parentId + "'";
                    IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)getStructSql);
                    while (executeQuery2.next()) {
                        if (executeQuery2.getString("parentId") == null) continue;
                        DbUtil.execute((Context)ctx, (String)("UPDATE T_ORG_STRUCTURE SET FPARENTID = '" + executeQuery2.getString("parentId") + "' WHERE FID = '" + executeQuery2.getString("id") + "'"));
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> getColumnByUIPK(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        ArrayList<String> resultList = new ArrayList<String>();
        String tableName = "T_ORG_ADMIN";
        resultList.add("FNAME_L2");
        try {
            Map<Object, Object> columnMap = new HashMap();
            columnMap = TableColumnSyncTool.getTableColumnMap(shrConn, tableName);
            UIViewInfo viewInfo = UIViewUtil.getUIViewInfoByUIPK((String)"shr.org.AdminOrgUnit_edit");
            List columnList = new ArrayList();
            columnList = viewInfo.getFields();
            for (int i = 0; i < columnList.size(); ++i) {
                FieldInfo fieldInfo = (FieldInfo)columnList.get(i);
                String cloumnNameByView = fieldInfo.getName();
                if (cloumnNameByView.equals("number") || cloumnNameByView.equals("name")) continue;
                for (String string : columnMap.keySet()) {
                    String columnName = string;
                    if (!columnName.toUpperCase().contains(cloumnNameByView.toUpperCase())) continue;
                    resultList.add(columnName);
                }
            }
        }
        catch (SHRWebException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<Map<String, String>> getShrAdminList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> shrAdminResultList = new ArrayList<Map<String, String>>();
        Statement state = null;
        ResultSet rs = null;
        String shrSql = "select FNUMBER,FNAME_L2,FLONGNUMBER,FDISPLAYNAME_L2,case when FIsSealUp = 1 then '\u662f' else '\u5426' end as FIsSealUp,FID from T_ORG_ADMIN_SHR_TEMP ORDER BY FDISPLAYNAME_L2";
        try {
            state = shrConn.createStatement();
            rs = state.executeQuery(shrSql);
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("shrNumber", rs.getString(1));
                map.put("shrName", rs.getString(2));
                map.put("shrLongNumber", rs.getString(3));
                map.put("shrDisplayName", rs.getString(4));
                map.put("shrIsSealUp", rs.getString(5));
                map.put("shrId", rs.getString(6));
                shrAdminResultList.add(map);
            }
            state.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return shrAdminResultList;
    }

    public static List<Map<String, String>> getEasAdminList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> easAdminResultList = new ArrayList<Map<String, String>>();
        try {
            int level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
            String sql = "select adminOrg.FNUMBER as adminNumber,adminOrg.FNAME_L2 as adminName,adminOrg.FLONGNUMBER as adminLongNumber,adminOrg.FDISPLAYNAME_L2 as adminDisplayName,case when adminOrg.FIsSealUp = 1 then '\u662f' else '\u5426' end as adminIsSealUp,cuAdmin.FNAME_L2 as cuAdminName,adminOrg.FID as adminId FROM T_ORG_ADMIN adminOrg left join T_ORG_ADMIN cuAdmin on adminOrg.FControlUnitId = cuAdmin.FID  ORDER BY adminOrg.FDISPLAYNAME_L2";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("easNumber", executeQuery.getString("adminNumber"));
                map.put("easName", executeQuery.getString("adminName"));
                map.put("easLongNumber", executeQuery.getString("adminLongNumber"));
                if (level != 0) {
                    if (executeQuery.getString("adminDisplayName").length() < SHRMoveDataHelpUtil.getFilterDisplayName(ctx) + 1) continue;
                    map.put("easDisplayName", executeQuery.getString("adminDisplayName").substring(level + 1));
                } else {
                    map.put("easDisplayName", executeQuery.getString("adminDisplayName"));
                }
                map.put("easIsSealUp", executeQuery.getString("adminIsSealUp"));
                map.put("easId", executeQuery.getString("adminId"));
                map.put("easCuAdminName", executeQuery.getString("cuAdminName"));
                easAdminResultList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return easAdminResultList;
    }
}

