/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.patch.CommonUtils;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;

public class ConfigSqlExecutor {
    public static String scriptFilePath = "";
    public static int executeDataBaseTag = 0;

    public void execute(Context ctx) throws Exception {
        this.executePreScript(ctx);
    }

    public static void setScriptFilePath(String path) {
        scriptFilePath = path;
    }

    public static String getScriptFilePath() {
        return scriptFilePath;
    }

    public static void setExecuteDataBaseTag(int tag) {
        executeDataBaseTag = tag;
    }

    public static int getExecuteDataBaseTag() {
        return executeDataBaseTag;
    }

    public void executePreScript(Context ctx) throws Exception {
        this.executeAction(ctx, scriptFilePath);
    }

    protected void executeAction(Context ctx, String path) throws Exception {
        String[] KSql;
        Document document = this.loadScriptsFromProperty(path);
        if (document != null && (KSql = this.getKSqlScriptFromDocument(document)) != null && KSql.length > 0) {
            ConfigSqlExecutor.executeKSQLScript(ctx, KSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadScriptsFromProperty(String path) {
        Document document = null;
        try {
            document = CommonUtils.XMLFileLoader(path);
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return document;
        }
    }

    private String[] getKSqlScriptFromDocument(Document document) {
        Element root = document.getRootElement();
        List itemList = root.getChildren("item");
        if (itemList.size() > 0) {
            String[] resScript = new String[itemList.size()];
            int i = 0;
            for (Object ele : itemList) {
                Element element = (Element)ele;
                String ksqlString = element.getChild("ksql").getText();
                resScript[i++] = ksqlString;
            }
            return resScript;
        }
        return null;
    }

    public static void executeKSQLScript(Context ctx, String[] KSql) throws InterfaceDataBaseException, BOSException, SQLException, SqlTranslateException {
        Connection connection = null;
        connection = executeDataBaseTag == 0 ? SHRDbConnectionTool.getSHRDBConnection(ctx) : EJBFactory.getConnection((Context)ctx);
        ConfigSqlExecutor.executeKSQLScript(connection, KSql);
    }

    public static void executeKSQLScript(Connection conn, String[] KSql) throws SQLException, SqlTranslateException {
        String sHRDBType = conn.getMetaData().getDatabaseProductName();
        ConfigSqlExecutor.executeKSQLScript(conn, KSql, sHRDBType);
    }

    public static void executeKSQLScript(Connection conn, String[] KSql, String DBType2) throws SqlTranslateException {
        String[] translatedSql = new String[KSql.length];
        int DBTypeValue = DbType.getValue((String)DBType2);
        int index = 0;
        for (String item : KSql) {
            translatedSql[index++] = TransUtil.Translate((String)item, (int)DBTypeValue);
        }
        ConfigSqlExecutor.doExecute(conn, translatedSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doExecute(Connection conn, String[] sql) {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            for (String item : sql) {
                statement.addBatch(item);
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

