/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SHRCodingRuleDataMoveHandler
implements ISHRMoveDataHandler {
    public void initialization() throws BOSException, EASBizException, SQLException {
        Context ctx = SHRContext.getInstance().getContext();
        Connection con = SHRDbConnectionTool.getSHRDBConnection(ctx);
        this.moveData(con, ctx);
    }

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        Map<String, Object> sqlMap = this.beforeMovingData(ctx);
        String[] tables = new String[]{"T_BAS_CODINGRULE", "T_BAS_CODINGRULEENTRY", "T_BAS_CODINGRULELOCK", "T_BAS_INTERMITNO", "T_BAS_MAXSERIAL"};
        String[] conditions = new String[]{" where fBusinessObject in ('com.kingdee.eas.basedata.org.app.FullOrgUnit','com.kingdee.eas.basedata.org.app.JobFamily','com.kingdee.eas.basedata.org.app.Position','com.kingdee.eas.basedata.person.app.Person') or fBusinessObject like '%.hr.%' or fBusinessObject like '%.shr.%'", " where FCodingRuleID in (select fid from t_bas_codingrule where fBusinessObject in ('com.kingdee.eas.basedata.org.app.FullOrgUnit','com.kingdee.eas.basedata.org.app.JobFamily','com.kingdee.eas.basedata.org.app.Position','com.kingdee.eas.basedata.person.app.Person') or fBusinessObject like '%.hr.%' or fBusinessObject like '%.shr.%')", "", " where FCodingRuleEntryID in (select fid from t_bas_codingruleentry where FCodingRuleID in (select fid from t_bas_codingrule where fBusinessObject in ('com.kingdee.eas.basedata.org.app.FullOrgUnit','com.kingdee.eas.basedata.org.app.JobFamily','com.kingdee.eas.basedata.org.app.Position','com.kingdee.eas.basedata.person.app.Person') or fBusinessObject like '%.hr.%' or fBusinessObject like '%.shr.%'))", " where FCodingRuleEntryID in (select fid from t_bas_codingruleentry where FCodingRuleID in (select fid from t_bas_codingrule where fBusinessObject in ('com.kingdee.eas.basedata.org.app.FullOrgUnit','com.kingdee.eas.basedata.org.app.JobFamily','com.kingdee.eas.basedata.org.app.Position','com.kingdee.eas.basedata.person.app.Person') or fBusinessObject like '%.hr.%' or fBusinessObject like '%.shr.%'))"};
        for (int i = 0; i < tables.length; ++i) {
            try {
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tables[i], "moving");
                UpdateTool.commonUpdate(shrConn, tables[i], conditions[i], ctx, 1000);
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tables[i], "finished");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tables[i], "failed");
                SHRMoveDataHelpUtil.logExceptionInfo(ctx, tables[i], e);
            }
        }
        this.afterMovingData(ctx, sqlMap);
        return null;
    }

    public void afterMovingData(Context ctx, Map<String, Object> sqlMap) throws EASBizException, BOSException, SQLException {
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BAS_CodingRule", "FCreatorId");
        DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_SHRMvTableList SET frefreshIdStatus = 1  WHERE UPPER(FmvTableName) = 'T_BAS_CODINGRULE'");
        if (sqlMap != null && !sqlMap.isEmpty()) {
            String sHR_Sql = sqlMap.get("sHR_Sql").toString();
            ArrayList sHR_paramList = (ArrayList)sqlMap.get("sHR_paramList");
            String EAS_Sql = sqlMap.get("EAS_Sql").toString();
            ArrayList EAS_paramList = (ArrayList)sqlMap.get("EAS_paramList");
            this.executeBatch(ctx, sHR_Sql, sHR_paramList);
            this.executeBatch(ctx, EAS_Sql, EAS_paramList);
        }
    }

    public Map<String, Object> beforeMovingData(Context ctx) throws InterfaceDataBaseException, BOSException, SQLException {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        boolean isNeedUpdateAfter = false;
        String sHRCRQuery = "SELECT FID,FNUMBER FROM T_BAS_CODINGRULE WHERE FID IS NOT NULL AND FNUMBER IS NOT NULL AND fBusinessObject in ('com.kingdee.eas.basedata.org.app.FullOrgUnit','com.kingdee.eas.basedata.org.app.JobFamily','com.kingdee.eas.basedata.org.app.Position','com.kingdee.eas.basedata.person.app.Person') or fBusinessObject like '%.hr.%' or fBusinessObject like '%.shr.%'";
        Connection shrConn = null;
        shrConn = SHRDbConnectionTool.getSHRDBConnection(ctx);
        RDRowSet rs = DBUtil.executeQuery((String)sHRCRQuery, (Connection)shrConn);
        ArrayList<String[]> sHRuniqueList = new ArrayList<String[]>();
        while (rs.next()) {
            String fidString = rs.getString(0);
            String fnumberString = rs.getString(1);
            String[] uniqueItem = new String[]{fidString, fnumberString};
            sHRuniqueList.add(uniqueItem);
        }
        if (!sHRuniqueList.isEmpty()) {
            StringBuffer easCRQuery = new StringBuffer("SELECT FID,FNUMBER FROM T_BAS_CODINGRULE WHERE ");
            for (int i = 0; i < sHRuniqueList.size(); ++i) {
                String[] item = (String[])sHRuniqueList.get(i);
                String tmpSqlString = "(FID!= '" + item[0] + "' AND FNUMBER = '" + item[1] + "')";
                easCRQuery.append(tmpSqlString).append(" OR ");
            }
            easCRQuery.delete(easCRQuery.length() - 3, easCRQuery.length());
            IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)easCRQuery.toString());
            ArrayList<String[]> easUniqueList = new ArrayList<String[]>();
            ArrayList<String> shrFnumberList = new ArrayList<String>();
            ArrayList<String> easFidList = new ArrayList<String>();
            while (irs.next()) {
                String fidString = irs.getString(1);
                String fnumberString = irs.getString(2);
                String[] uniqueItem = new String[]{fidString, fnumberString};
                easUniqueList.add(uniqueItem);
                shrFnumberList.add(fnumberString);
                easFidList.add(fidString);
            }
            if (!easUniqueList.isEmpty()) {
                StringBuffer updateEASCRbefore = new StringBuffer("UPDATE T_BAS_CODINGRULE SET FNUMBER = CONCAT(FNUMBER,'_EAS') WHERE FID =?");
                this.executeBatch(ctx, updateEASCRbefore.toString(), easFidList);
            }
            StringBuffer updateSHRCR = new StringBuffer("");
            if (!shrFnumberList.isEmpty()) {
                isNeedUpdateAfter = true;
                updateSHRCR.append("UPDATE T_BAS_CODINGRULE SET FNUMBER = CONCAT(FNUMBER,'_sHR') WHERE FNUMBER = ?");
            }
            StringBuffer updateEASCRafter = new StringBuffer("");
            if (!easFidList.isEmpty()) {
                isNeedUpdateAfter = true;
                updateEASCRafter.append("UPDATE T_BAS_CODINGRULE SET FNUMBER = SUBSTRING(FNUMBER,1,LENGTH(FNUMBER)-4) WHERE FID = ?");
            }
            if (isNeedUpdateAfter) {
                resMap.put("sHR_Sql", updateSHRCR.toString());
                resMap.put("sHR_paramList", shrFnumberList);
                resMap.put("EAS_Sql", updateEASCRafter.toString());
                resMap.put("EAS_paramList", easFidList);
                return resMap;
            }
            return null;
        }
        return null;
    }

    private void executeBatch(Context ctx, String sql, List params) {
        for (String item : params) {
            Object[] param = new Object[]{item};
            try {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }
}

