/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import java.sql.Connection;
import java.util.concurrent.Callable;

public class SHRMoveOriginalDataMultiThreads
implements Callable<String> {
    private String[][] tableArray;
    private Context ctx = null;
    private Connection shrConn = null;
    private int successNum = 0;
    private int failNum = 0;

    public SHRMoveOriginalDataMultiThreads() {
    }

    public SHRMoveOriginalDataMultiThreads(Context ctx, Connection shrConn, String[][] tableArray) {
        this.ctx = ctx;
        this.tableArray = tableArray;
        this.shrConn = shrConn;
    }

    @Override
    public String call() {
        long startTime = System.currentTimeMillis();
        this.moveOriginalDataAction();
        long endTime = System.currentTimeMillis();
        return Thread.currentThread().getName() + " succeed.successNum:" + this.successNum + ",failNum:" + this.failNum + ",runtime:" + (endTime - startTime) + "ms. ";
    }

    public void moveOriginalDataAction() {
        for (int i = 0; i < this.tableArray.length; ++i) {
            String tableName = this.tableArray[i][0];
            String fid = this.tableArray[i][1];
            String isBigTable = this.tableArray[i][2];
            try {
                SHRMoveDataHelpUtil.updateTableMoveStateById(this.ctx, fid, "moving");
                if ("1".equals(isBigTable)) {
                    UpdateTool.commonUpdate(this.shrConn, tableName, "", this.ctx, 8000);
                } else {
                    UpdateTool.commonUpdate(this.shrConn, tableName, "", this.ctx, 1000);
                }
                long endTime = System.currentTimeMillis();
                SHRMoveDataHelpUtil.updateTableMoveStateById(this.ctx, fid, "finished");
                ++this.successNum;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    SHRMoveDataHelpUtil.updateTableMoveStateById(this.ctx, fid, "failed");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                SHRMoveDataHelpUtil.logExceptionInfo(this.ctx, tableName, e);
                ++this.failNum;
            }
        }
    }
}

