/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.shr.base.syssetting.ISearchView;
import com.kingdee.shr.base.syssetting.SearchViewCollection;
import com.kingdee.shr.base.syssetting.SearchViewFactory;
import com.kingdee.shr.base.syssetting.SearchViewInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class SchemeMoveHandler
implements ISHRMoveDataHandler {
    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        SearchViewCollection shr_collection = new SearchViewCollection();
        SearchViewCollection eas_collection = new SearchViewCollection();
        shr_collection = this.getSHRData(shrConn, ctx);
        eas_collection = SearchViewFactory.getRemoteInstance().getSearchViewCollection();
        try {
            SearchViewCollection diffCollectionSHR = null;
            if (eas_collection.isEmpty()) {
                this.addSHRDataToEAS(ctx, shr_collection);
            } else {
                diffCollectionSHR = this.compareData(ctx, eas_collection, shr_collection);
                if (diffCollectionSHR.size() > 0) {
                    this.addSHRDataToEAS(ctx, diffCollectionSHR);
                }
            }
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "S_BS_SearchView".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private SearchViewCollection compareData(Context ctx, SearchViewCollection eas_collection, SearchViewCollection shr_collection) {
        SearchViewInfo infoEAS = null;
        SearchViewInfo infoSHR = null;
        SearchViewCollection diffCollectionSHR = new SearchViewCollection();
        boolean match = false;
        for (int i = 0; i < shr_collection.size(); ++i) {
            infoSHR = shr_collection.get(i);
            for (int j = 0; j < eas_collection.size(); ++j) {
                infoEAS = eas_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    private void addSHRDataToEAS(Context ctx, SearchViewCollection shr_collection) throws BOSException, EASBizException {
        SearchViewInfo info = null;
        ISearchView SearchView = SearchViewFactory.getRemoteInstance();
        for (int i = 0; i < shr_collection.size(); ++i) {
            info = shr_collection.get(i);
            SearchView.addnew(info);
        }
    }

    private SearchViewCollection getSHRData(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from S_BS_SearchView";
        SearchViewCollection shrCollection = new SearchViewCollection();
        SearchViewInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "S_BS_SearchView".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fviewname = colummnsmap.containsKey("fviewname".toUpperCase()) ? rs.getString("fviewname") : "";
                String fsearchdate = colummnsmap.containsKey("fsearchdate".toUpperCase()) ? rs.getString("fsearchdate") : "";
                String fsearchfilter = colummnsmap.containsKey("fsearchfilter".toUpperCase()) ? rs.getString("fsearchfilter") : "";
                String fpersonid = colummnsmap.containsKey("fpersonid".toUpperCase()) ? rs.getString("fpersonid") : "";
                String fmodel = colummnsmap.containsKey("fmodel".toUpperCase()) ? rs.getString("fmodel") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fisdefault = colummnsmap.containsKey("fisdefault".toUpperCase()) ? rs.getString("fisdefault") : "";
                String fquery = colummnsmap.containsKey("fquery".toUpperCase()) ? rs.getString("fquery") : "";
                String fuipk = colummnsmap.containsKey("fuipk".toUpperCase()) ? rs.getString("fuipk") : "";
                String fqueryfilter = colummnsmap.containsKey("fqueryfilter".toUpperCase()) ? rs.getString("fqueryfilter") : "";
                shrInfo = new SearchViewInfo();
                shrInfo.setViewname(fviewname);
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setSearchfilter(fsearchfilter);
                shrInfo.setPersonid(fpersonid);
                shrInfo.setModel(fmodel);
                shrInfo.setQuery(fquery);
                shrInfo.setUipk(fuipk);
                shrInfo.setQueryfilter(fqueryfilter);
                boolean isdefault = fisdefault != null && fisdefault.equals("1");
                shrInfo.setIsDefault(isdefault);
                if (fsearchdate != null && !fsearchdate.isEmpty()) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date date = sdf.parse(fsearchdate);
                        shrInfo.setSearchdate(date);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }
}

