/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.baseconfig.CompareTypeEnum;
import com.kingdee.shr.baseconfig.IStructureConfig;
import com.kingdee.shr.baseconfig.IStructureConfigColumns;
import com.kingdee.shr.baseconfig.IStructureConfigFilterColumn;
import com.kingdee.shr.baseconfig.IStructureConfigScheme;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigColumnsCollection;
import com.kingdee.shr.baseconfig.StructureConfigColumnsFactory;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnCollection;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnFactory;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnInfo;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.StructureConfigSchemeCollection;
import com.kingdee.shr.baseconfig.StructureConfigSchemeFactory;
import com.kingdee.shr.baseconfig.StructureConfigSchemeInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class StructureConfigMoveHandler
implements ISHRMoveDataHandler {
    private static Logger logger = Logger.getLogger(StructureConfigMoveHandler.class);

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    public StructureConfigCollection getSHR_configData(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_HR_StructureConfig";
        StructureConfigCollection shrCollection = new StructureConfigCollection();
        StructureConfigInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_HR_StructureConfig".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fschemeid = colummnsmap.containsKey("fschemeid".toUpperCase()) ? rs.getString("fschemeid") : "";
                String fentityname = colummnsmap.containsKey("fentityname".toUpperCase()) ? rs.getString("fentityname") : "";
                String falias = colummnsmap.containsKey("falias".toUpperCase()) ? rs.getString("falias") : "";
                String fparentid = colummnsmap.containsKey("fparentid".toUpperCase()) ? rs.getString("fparentid") : "";
                String fclientnumber = colummnsmap.containsKey("fclientnumber".toUpperCase()) ? rs.getString("fclientnumber") : "";
                String fismultirow = colummnsmap.containsKey("fismultirow".toUpperCase()) ? rs.getString("fismultirow") : "";
                String fsupportsingleview = colummnsmap.containsKey("fsupportsingleview".toUpperCase()) ? rs.getString("fsupportsingleview") : "";
                String fsinglecondition = colummnsmap.containsKey("fsinglecondition".toUpperCase()) ? rs.getString("fsinglecondition") : "";
                String fsingleconditionmasking = colummnsmap.containsKey("fsingleconditionmasking".toUpperCase()) ? rs.getString("fsingleconditionmasking") : "";
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fmoltialias = colummnsmap.containsKey("fmoltialias".toUpperCase()) ? rs.getString("fmoltialias") : "";
                String fisbasedata = colummnsmap.containsKey("fisbasedata".toUpperCase()) ? rs.getString("fisbasedata") : "";
                String fsinglefields = colummnsmap.containsKey("fsinglefields".toUpperCase()) ? rs.getString("fsinglefields") : "";
                shrInfo = new StructureConfigInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setEntityName(fentityname);
                shrInfo.setAlias(falias);
                shrInfo.setClientNumber(fclientnumber);
                shrInfo.setSingleCondition(fsinglecondition);
                shrInfo.setSingleConditionMasking(fsingleconditionmasking);
                shrInfo.setNumber(fnumber);
                shrInfo.setMoltiAlias(fmoltialias);
                shrInfo.setSingleFields(fsinglefields);
                boolean ismultirow = fismultirow != null && fismultirow.equals("1");
                shrInfo.setMultiRow(ismultirow);
                boolean supportsingleview = fsupportsingleview != null && fsupportsingleview.equals("1");
                shrInfo.setSupportSingleView(supportsingleview);
                boolean isbaseData = fisbasedata != null && fisbasedata.equals("1");
                shrInfo.setBaseData(isbaseData);
                if (fparentid != null && !fparentid.isEmpty()) {
                    StructureConfigInfo config = new StructureConfigInfo();
                    config.setId(BOSUuid.read((String)fparentid));
                    shrInfo.setParent(config);
                }
                if (fschemeid != null && !fschemeid.isEmpty()) {
                    StructureConfigSchemeInfo scheme = new StructureConfigSchemeInfo();
                    scheme.setId(BOSUuid.read((String)fschemeid));
                    shrInfo.setScheme(scheme);
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        this.moveStructureConfigScheme(shrConn, ctx);
        this.moveStructureConfig(shrConn, ctx);
        this.moveStructureConfigFilter(shrConn, ctx);
        this.moveStructureConfigColumns(shrConn, ctx);
        this.do_moveAfter(shrConn, ctx);
        return null;
    }

    private void moveStructureConfigColumns(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        boolean isMove = true;
        try {
            String tableName = "T_HR_StructureConfigColumns";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                isMove = false;
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            SHRMoveDataHelpUtil.clearHrData(shrConn, ctx, "T_HR_StructureConfigColumns", "T_HR_StructureColumns_tmp", "FNAME_L2");
            String delSql = "delete from T_HR_StructureConfigColumns";
            DbUtil.execute((Context)ctx, (String)delSql);
            StructureConfigColumnsCollection shr_columns_collection = new StructureConfigColumnsCollection();
            StructureConfigColumnsCollection eas_columns_collection = new StructureConfigColumnsCollection();
            shr_columns_collection = this.getSHR_configColumnsData(shrConn, ctx);
            eas_columns_collection = StructureConfigColumnsFactory.getRemoteInstance().getStructureConfigColumnsCollection();
            StructureConfigColumnsCollection diffColumnsCollectionSHR = null;
            if (eas_columns_collection.isEmpty()) {
                this.addSHRDataToEAS_Columns(ctx, shr_columns_collection);
            } else {
                diffColumnsCollectionSHR = this.compareData_Columns(ctx, eas_columns_collection, shr_columns_collection);
                if (diffColumnsCollectionSHR.size() > 0) {
                    this.addSHRDataToEAS_Columns(ctx, diffColumnsCollectionSHR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_HR_StructureConfigColumns".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (isMove) {
                SHRMoveDataHelpUtil.restore(shrConn, "T_HR_StructureConfigColumns", "T_HR_StructureColumns_tmp", "FNAME_L2");
            }
        }
    }

    private void moveStructureConfigFilter(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_HR_StructureCFC";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String delSql = "delete  from T_HR_StructureCFC";
            DbUtil.execute((Context)ctx, (String)delSql);
            StructureConfigFilterColumnCollection shr_filter_collection = new StructureConfigFilterColumnCollection();
            StructureConfigFilterColumnCollection eas_filter_collection = new StructureConfigFilterColumnCollection();
            shr_filter_collection = this.getSHR_configFilterData(shrConn, ctx);
            eas_filter_collection = StructureConfigFilterColumnFactory.getRemoteInstance().getStructureConfigFilterColumnCollection();
            StructureConfigFilterColumnCollection diffFilterCollectionSHR = null;
            if (eas_filter_collection.isEmpty()) {
                this.addSHRDataToEAS_Filter(ctx, shr_filter_collection);
            } else {
                diffFilterCollectionSHR = this.compareData_Filter(ctx, eas_filter_collection, shr_filter_collection);
                if (diffFilterCollectionSHR.size() > 0) {
                    this.addSHRDataToEAS_Filter(ctx, diffFilterCollectionSHR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_HR_StructureCFC".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveStructureConfig(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        boolean isMove = true;
        try {
            String tableName = "T_HR_StructureConfig";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                isMove = false;
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            SHRMoveDataHelpUtil.clearHrData(shrConn, ctx, "T_HR_StructureConfig", "T_HR_StructureConfig_tmp", "FNAME_L2");
            SHRMoveDataHelpUtil.clearHrData(shrConn, ctx, "T_HR_StructureConfig", "T_HR_StructureConfig_tmp_2", "FALIAS");
            String delSql = "delete from T_HR_StructureConfig";
            DbUtil.execute((Context)ctx, (String)delSql);
            StructureConfigCollection shr_config_collection = new StructureConfigCollection();
            StructureConfigCollection eas_config_collection = new StructureConfigCollection();
            shr_config_collection = this.getSHR_configData(shrConn, ctx);
            eas_config_collection = StructureConfigFactory.getRemoteInstance().getStructureConfigCollection();
            StructureConfigCollection diffConfigCollectionSHR = null;
            if (eas_config_collection.isEmpty()) {
                this.addSHRDataToEAS_Config(ctx, shr_config_collection);
            } else {
                diffConfigCollectionSHR = this.compareData_Config(ctx, eas_config_collection, shr_config_collection);
                if (diffConfigCollectionSHR.size() > 0) {
                    this.addSHRDataToEAS_Config(ctx, diffConfigCollectionSHR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_HR_StructureConfig".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (isMove) {
                SHRMoveDataHelpUtil.restore(shrConn, "T_HR_StructureConfig", "T_HR_StructureConfig_tmp", "FNAME_L2");
                SHRMoveDataHelpUtil.restore(shrConn, "T_HR_StructureConfig", "T_HR_StructureConfig_tmp", "FALIAS");
            }
        }
    }

    private void moveStructureConfigScheme(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_HR_StructureConfigScheme";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String delSql = "delete from T_HR_StructureConfigScheme";
            DbUtil.execute((Context)ctx, (String)delSql);
            StructureConfigSchemeCollection shr_scheme_collection = new StructureConfigSchemeCollection();
            StructureConfigSchemeCollection eas_scheme_collection = new StructureConfigSchemeCollection();
            shr_scheme_collection = this.getSHR_configSchemeData(shrConn, ctx);
            eas_scheme_collection = StructureConfigSchemeFactory.getRemoteInstance().getStructureConfigSchemeCollection();
            StructureConfigSchemeCollection diffSchemeCollectionSHR = null;
            if (eas_scheme_collection.isEmpty()) {
                this.addSHRDataToEAS_Scheme(ctx, shr_scheme_collection);
            } else {
                diffSchemeCollectionSHR = this.compareData_Scheme(ctx, eas_scheme_collection, shr_scheme_collection);
                if (diffSchemeCollectionSHR.size() > 0) {
                    this.addSHRDataToEAS_Scheme(ctx, diffSchemeCollectionSHR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_HR_StructureConfigScheme".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void do_moveAfter(Connection shrConn, Context ctx) throws EASBizException, BOSException, SQLException {
        logger.info((Object)"-------------------------------------------------------\u5237\u65b0ID\u3010\u67e5\u8be2\u7ed3\u6784\u914d\u7f6e\u3011----------------------------------------------------------------------------");
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_HR_StructureConfig", "FCREATORID");
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_HR_StructureConfigScheme", "FCREATORID");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_HR_StructureConfig".toUpperCase(), "finished");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_HR_StructureConfigScheme".toUpperCase(), "finished");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_HR_StructureCFC".toUpperCase(), "finished");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_HR_StructureConfigColumns".toUpperCase(), "finished");
    }

    public StructureConfigColumnsCollection compareData_Columns(Context ctx, StructureConfigColumnsCollection eas_columns_collection, StructureConfigColumnsCollection shr_columns_collection) {
        StructureConfigColumnsInfo infoEAS = null;
        StructureConfigColumnsInfo infoSHR = null;
        StructureConfigColumnsCollection diffCollectionSHR = new StructureConfigColumnsCollection();
        boolean match = false;
        for (int i = 0; i < shr_columns_collection.size(); ++i) {
            infoSHR = shr_columns_collection.get(i);
            for (int j = 0; j < eas_columns_collection.size(); ++j) {
                infoEAS = eas_columns_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_Columns(Context ctx, StructureConfigColumnsCollection shr_columns_collection) throws EASBizException, BOSException {
        StructureConfigColumnsInfo info = null;
        IStructureConfigColumns Columns = StructureConfigColumnsFactory.getRemoteInstance();
        for (int i = 0; i < shr_columns_collection.size(); ++i) {
            info = shr_columns_collection.get(i);
            Columns.addnew(info);
        }
    }

    public StructureConfigFilterColumnCollection compareData_Filter(Context ctx, StructureConfigFilterColumnCollection eas_filter_collection, StructureConfigFilterColumnCollection shr_filter_collection) {
        StructureConfigFilterColumnInfo infoEAS = null;
        StructureConfigFilterColumnInfo infoSHR = null;
        StructureConfigFilterColumnCollection diffCollectionSHR = new StructureConfigFilterColumnCollection();
        boolean match = false;
        for (int i = 0; i < shr_filter_collection.size(); ++i) {
            infoSHR = shr_filter_collection.get(i);
            for (int j = 0; j < eas_filter_collection.size(); ++j) {
                infoEAS = eas_filter_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_Filter(Context ctx, StructureConfigFilterColumnCollection shr_filter_collection) throws BOSException, EASBizException {
        StructureConfigFilterColumnInfo info = null;
        IStructureConfigFilterColumn Filter = StructureConfigFilterColumnFactory.getRemoteInstance();
        for (int i = 0; i < shr_filter_collection.size(); ++i) {
            info = shr_filter_collection.get(i);
            Filter.addnew(info);
        }
    }

    public StructureConfigCollection compareData_Config(Context ctx, StructureConfigCollection eas_config_collection, StructureConfigCollection shr_config_collection) {
        StructureConfigInfo infoEAS = null;
        StructureConfigInfo infoSHR = null;
        StructureConfigCollection diffCollectionSHR = new StructureConfigCollection();
        boolean match = false;
        for (int i = 0; i < shr_config_collection.size(); ++i) {
            infoSHR = shr_config_collection.get(i);
            for (int j = 0; j < eas_config_collection.size(); ++j) {
                infoEAS = eas_config_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_Config(Context ctx, StructureConfigCollection shr_config_collection) throws EASBizException, BOSException {
        StructureConfigInfo info = null;
        IStructureConfig Config = StructureConfigFactory.getRemoteInstance();
        for (int i = 0; i < shr_config_collection.size(); ++i) {
            info = shr_config_collection.get(i);
            Config.addnew((CoreBaseInfo)info);
        }
    }

    private boolean checkConfigExist(String alias) throws EASBizException, BOSException {
        if (alias == null || alias.isEmpty()) {
            return true;
        }
        return StructureConfigFactory.getRemoteInstance().exists("where alias='" + alias + "'");
    }

    public StructureConfigSchemeCollection compareData_Scheme(Context ctx, StructureConfigSchemeCollection eas_scheme_collection, StructureConfigSchemeCollection shr_scheme_collection) {
        StructureConfigSchemeInfo infoEAS = null;
        StructureConfigSchemeInfo infoSHR = null;
        StructureConfigSchemeCollection diffCollectionSHR = new StructureConfigSchemeCollection();
        boolean match = false;
        for (int i = 0; i < shr_scheme_collection.size(); ++i) {
            infoSHR = shr_scheme_collection.get(i);
            if (infoSHR.getNumber() == null) {
                match = false;
                continue;
            }
            for (int j = 0; j < eas_scheme_collection.size(); ++j) {
                infoEAS = eas_scheme_collection.get(j);
                if (infoEAS.getNumber() == null || !infoEAS.getId().toString().equals(infoSHR.getId().toString()) && !infoEAS.getNumber().equals(infoSHR.getNumber())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_Scheme(Context ctx, StructureConfigSchemeCollection shr_scheme_collection) throws BOSException, EASBizException {
        StructureConfigSchemeInfo info = null;
        IStructureConfigScheme ConfigScheme = StructureConfigSchemeFactory.getRemoteInstance();
        for (int i = 0; i < shr_scheme_collection.size(); ++i) {
            info = shr_scheme_collection.get(i);
            ConfigScheme.addnew((CoreBaseInfo)info);
        }
    }

    private boolean checkNumberExist(String number) throws EASBizException, BOSException {
        if (number == null || number.isEmpty()) {
            return true;
        }
        return StructureConfigSchemeFactory.getRemoteInstance().exists("where number='" + number + "'");
    }

    public StructureConfigColumnsCollection getSHR_configColumnsData(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_HR_StructureConfigColumns";
        StructureConfigColumnsCollection shrCollection = new StructureConfigColumnsCollection();
        StructureConfigColumnsInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_HR_StructureConfigColumns".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String findex = colummnsmap.containsKey("findex".toUpperCase()) ? rs.getString("findex") : "";
                String fdatatype = colummnsmap.containsKey("fdatatype".toUpperCase()) ? rs.getString("fdatatype") : "";
                String fenumsource = colummnsmap.containsKey("fenumsource".toUpperCase()) ? rs.getString("fenumsource") : "";
                String fstructureconfigid = colummnsmap.containsKey("fstructureconfigid".toUpperCase()) ? rs.getString("fstructureconfigid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fspecialextend = colummnsmap.containsKey("fspecialextend".toUpperCase()) ? rs.getString("fspecialextend") : "";
                String fparam = colummnsmap.containsKey("fparam".toUpperCase()) ? rs.getString("fparam") : "";
                shrInfo = new StructureConfigColumnsInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setNumber(fnumber);
                shrInfo.setDataType(fdatatype);
                shrInfo.setEnumSource(fenumsource);
                shrInfo.setSpecialExtend(fspecialextend);
                shrInfo.setParam(fparam);
                if (findex != null) {
                    shrInfo.setIndex(Integer.parseInt(findex));
                }
                if (fstructureconfigid != null && !fstructureconfigid.isEmpty()) {
                    StructureConfigInfo info = new StructureConfigInfo();
                    info.setId(BOSUuid.read((String)fstructureconfigid));
                    shrInfo.setStructureConfig(info);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public StructureConfigFilterColumnCollection getSHR_configFilterData(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_HR_StructureCFC";
        StructureConfigFilterColumnCollection shrCollection = new StructureConfigFilterColumnCollection();
        StructureConfigFilterColumnInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_HR_StructureCFC".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fseq = colummnsmap.containsKey("fseq".toUpperCase()) ? rs.getString("fseq") : "";
                String fparentid = colummnsmap.containsKey("fparentid".toUpperCase()) ? rs.getString("fparentid") : "";
                String fparentcolumn = colummnsmap.containsKey("fparentcolumn".toUpperCase()) ? rs.getString("fparentcolumn") : "";
                String fparentcolumnalias = colummnsmap.containsKey("fparentcolumnalias".toUpperCase()) ? rs.getString("fparentcolumnalias") : "";
                String fclientcolumn = colummnsmap.containsKey("fclientcolumn".toUpperCase()) ? rs.getString("fclientcolumn") : "";
                String fclientcolumnalias = colummnsmap.containsKey("fclientcolumnalias".toUpperCase()) ? rs.getString("fclientcolumnalias") : "";
                String ffixvalue = colummnsmap.containsKey("ffixvalue".toUpperCase()) ? rs.getString("ffixvalue") : "";
                String fcomparetype = colummnsmap.containsKey("fcomparetype".toUpperCase()) ? rs.getString("fcomparetype") : "";
                shrInfo = new StructureConfigFilterColumnInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setParentColumn(fparentcolumn);
                shrInfo.setParentColumnAlias(fparentcolumnalias);
                shrInfo.setClientColumn(fclientcolumn);
                shrInfo.setClientColumnAlias(fclientcolumnalias);
                shrInfo.setFixValue(ffixvalue);
                shrInfo.setCompareType(CompareTypeEnum.getEnum((String)fcomparetype));
                if (fseq != null) {
                    shrInfo.setSeq(Integer.parseInt(fseq));
                }
                if (fparentid != null && !fparentid.isEmpty()) {
                    StructureConfigInfo info = new StructureConfigInfo();
                    info.setId(BOSUuid.read((String)fparentid));
                    shrInfo.setParent1(info);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public StructureConfigSchemeCollection getSHR_configSchemeData(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_HR_StructureConfigScheme";
        StructureConfigSchemeCollection shrCollection = new StructureConfigSchemeCollection();
        StructureConfigSchemeInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_HR_StructureConfigScheme".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                shrInfo = new StructureConfigSchemeInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setNumber(fnumber);
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }
}

