/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.ISHRMvTableList;
import com.kingdee.eas.hr.mvdt.ITableColumnConfig;
import com.kingdee.eas.hr.mvdt.SHRMvTableListCollection;
import com.kingdee.eas.hr.mvdt.SHRMvTableListFactory;
import com.kingdee.eas.hr.mvdt.SHRMvTableListInfo;
import com.kingdee.eas.hr.mvdt.TableColumnConfigFactory;
import com.kingdee.eas.hr.mvdt.TableColumnConfigInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.handler.SHRImportEntityOrTableAnalyzeHandler;
import com.kingdee.eas.hr.mvdt.handler.SHRPreSQLExecutor;
import com.kingdee.eas.hr.mvdt.util.SHRDataMoveConstant;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.ws.ca.utils.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class TableColumnExtendHandler
implements ISHRMoveDataHandler {
    public void testSqlAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FMvTableName from T_HR_SHRMvTableList");
        Connection easConn = null;
        try {
            this.executePreScript(ctx);
            easConn = EJBFactory.getConnection((Context)ctx);
            while (rs.next()) {
                String sql;
                IRowSet tableRowSet;
                String mvTableName = rs.getString(1);
                if (StringUtils.isEmpty((String)mvTableName) || !(tableRowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = "select * from KSQL_USERTABLES where KSQL_TABNAME ='" + mvTableName + "'"))).next()) continue;
                TableColumnSyncTool.synSHRTableInfoToEAS(ctx, shrConn, easConn, mvTableName);
            }
            this.addDEPSHRMvTableList(shrConn, ctx);
            this.addDEPTableColumnConfig(shrConn, ctx);
            this.addPersonColumn(shrConn, ctx);
        }
        catch (Exception e) {
            SHRDbConnectionTool.releasDBResource(shrConn, null, null);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private void addDEPTableColumnConfig(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        Set<String> depExpEntitySet = this.getSHRDEPExtendEntitySet(shrConn, ctx);
        this.saveDEPExtendRelatedProp(ctx, depExpEntitySet);
    }

    private Set<String> getSHRDEPExtendEntitySet(Connection shrConn, Context ctx) throws BOSException {
        String sql = "select distinct FMetaDataPK from T_CON_DynamicMetadata where fbostype='enty' and FMetaDataPK not in (select FMetaDataPK from T_CON_EntityPKMapping)";
        Statement stmt = null;
        ResultSet shrRs = null;
        HashSet<String> shrDEPExtendTableSet = new HashSet<String>();
        try {
            stmt = shrConn.createStatement();
            shrRs = stmt.executeQuery(sql);
            while (shrRs.next()) {
                shrDEPExtendTableSet.add(shrRs.getString("FMetaDataPK"));
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SHRDbConnectionTool.releasDBResource(null, stmt, shrRs);
                throw throwable;
            }
        }
        SHRDbConnectionTool.releasDBResource(null, stmt, shrRs);
        IRowSet tableRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> depExpEntitySet = new HashSet<String>();
        try {
            while (tableRowSet.next()) {
                String entityName = tableRowSet.getString("FMetaDataPK");
                EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
                if (entityInfo == null || entityInfo.getTable() == null) continue;
                String tableName = entityInfo.getTable().getName();
                sql = "select FID from T_HR_SHRMvTableList where FMvTableName ='" + tableName.toUpperCase() + "'";
                IRowSet tableRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (!tableRs.next() || !shrDEPExtendTableSet.contains(entityName)) continue;
                depExpEntitySet.add(entityName);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return depExpEntitySet;
    }

    private void saveDEPExtendRelatedProp(Context ctx, Set<String> depExpEntitySet) throws BOSException, EASBizException {
        Iterator<String> iterator = depExpEntitySet.iterator();
        ITableColumnConfig iTableColumnConfig = TableColumnConfigFactory.getLocalInstance(ctx);
        ISHRMvTableList iSHRMvTableList = SHRMvTableListFactory.getLocalInstance(ctx);
        while (iterator.hasNext()) {
            String entityName = iterator.next();
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
            if (entityInfo == null) continue;
            String tableName = entityInfo.getTable().getName().toUpperCase();
            PropertyCollection propColl = entityInfo.getPropertiesRuntime();
            if (propColl.isEmpty()) continue;
            for (PropertyInfo currentPropertyInfo : propColl) {
                SHRMvTableListCollection shrMvTableColl;
                String oql;
                RelationshipInfo relation;
                String columnType;
                String columnName = "";
                if (currentPropertyInfo.getMappingField() == null) continue;
                columnName = currentPropertyInfo.getMappingField().getName();
                BOSObjectType currentBOSType = currentPropertyInfo.getBOSType();
                if (!currentBOSType.equals((Object)SHRDataMoveConstant.LINKED_PROPERTY) || StringUtils.isEmpty((String)(columnType = SHRImportEntityOrTableAnalyzeHandler.isSupplierObjectMatchedTargetEntity(relation = (RelationshipInfo)currentPropertyInfo.getStateManager().getStateValue("relationship")))) || iTableColumnConfig.exists(oql = "select mvTable.id where mvTableName='" + tableName + "' and columnName='" + columnName + "'") || (shrMvTableColl = iSHRMvTableList.getSHRMvTableListCollection(oql = "select id where mvTableName='" + tableName + "'")).size() <= 0) continue;
                SHRMvTableListInfo mvTableListInfo = shrMvTableColl.get(0);
                TableColumnConfigInfo tableColumnInfo = new TableColumnConfigInfo();
                tableColumnInfo.setMvTable(mvTableListInfo);
                tableColumnInfo.setMvTableName(tableName);
                tableColumnInfo.setColumnName(columnName);
                tableColumnInfo.setColumnType(columnType);
                iTableColumnConfig.save(tableColumnInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDEPSHRMvTableList(Connection shrConn, Context ctx) throws SQLException, BOSException {
        String sql = "select FMetaDataPK from T_CON_EntityPKMapping";
        Statement stmt = null;
        ResultSet shrRs = null;
        try {
            stmt = shrConn.createStatement();
            shrRs = stmt.executeQuery(sql);
            HashSet<String> dynEntitySet = new HashSet<String>();
            while (shrRs.next()) {
                dynEntitySet.add(shrRs.getString(1));
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            SHRImportEntityOrTableAnalyzeHandler tableAnalyzer = new SHRImportEntityOrTableAnalyzeHandler(ctx);
            while (rs.next()) {
                EntityObjectInfo entityInfo;
                String entityName = rs.getString("FMetaDataPK");
                if (!dynEntitySet.contains(entityName) || (entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName))) == null || entityInfo.getTable() == null) continue;
                String tableName = entityInfo.getTable().getName().toUpperCase();
                String tableAlias = entityInfo.getTable().getAlias();
                Statement tblStmt = null;
                ResultSet tblRs = null;
                try {
                    String tableSelSql = "select * from " + tableName + " where 1<>2";
                    tblStmt = shrConn.createStatement();
                    tblRs = tblStmt.executeQuery(tableSelSql);
                    if (!tblRs.next()) continue;
                    tableAnalyzer.saveEntityOfSHRMvTableList(entityInfo, "DEP", tableName, tableAlias, 2);
                }
                catch (SQLException sQLException) {}
                continue;
                finally {
                    if (tblStmt != null) {
                        tblStmt.close();
                    }
                    if (tblRs == null) continue;
                    tblRs.close();
                }
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SHRDbConnectionTool.releasDBResource(null, stmt, shrRs);
                throw throwable;
            }
        }
        SHRDbConnectionTool.releasDBResource(null, stmt, shrRs);
    }

    private void addPersonColumn(Connection shrConn, Context ctx) throws SQLException, BOSException {
        String kSQL1 = "If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsSynToCloud' and KSQL_COL_TABNAME='T_PM_User') alter table T_PM_User add FIsSynToCloud int default 0";
    }

    private void executePreScript(Context ctx) throws Exception {
        SHRPreSQLExecutor executor = new SHRPreSQLExecutor();
        SHRPreSQLExecutor.setScriptFilePath(SHRDataMoveConstant.PRE_SQL_FILEPATH);
        SHRPreSQLExecutor.setExecuteDataBaseTag(0);
        executor.execute(ctx);
    }

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }
}

