/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.IValidateCategory;
import com.kingdee.shr.base.syssetting.IValidateLevel;
import com.kingdee.shr.base.syssetting.IValidateProject;
import com.kingdee.shr.base.syssetting.IValidateSetting;
import com.kingdee.shr.base.syssetting.ValidateCategoryCollection;
import com.kingdee.shr.base.syssetting.ValidateCategoryFactory;
import com.kingdee.shr.base.syssetting.ValidateCategoryInfo;
import com.kingdee.shr.base.syssetting.ValidateLevelCollection;
import com.kingdee.shr.base.syssetting.ValidateLevelFactory;
import com.kingdee.shr.base.syssetting.ValidateLevelInfo;
import com.kingdee.shr.base.syssetting.ValidateProjectCollection;
import com.kingdee.shr.base.syssetting.ValidateProjectFactory;
import com.kingdee.shr.base.syssetting.ValidateProjectInfo;
import com.kingdee.shr.base.syssetting.ValidateSettingCollection;
import com.kingdee.shr.base.syssetting.ValidateSettingFactory;
import com.kingdee.shr.base.syssetting.ValidateSettingInfo;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class ValidateMoveHandler
implements ISHRMoveDataHandler {
    private static Logger logger = Logger.getLogger(ValidateMoveHandler.class);

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        this.moveValidateLevel(shrConn, ctx);
        this.moveValidateSetting(shrConn, ctx);
        this.moveValidateProject(shrConn, ctx);
        this.moveValidateCategory(shrConn, ctx);
        this.moveOther(shrConn, ctx);
        return null;
    }

    private void moveOther(Connection shrConn, Context ctx) throws EASBizException, BOSException {
        String tableName;
        try {
            tableName = "T_HR_VALIDATERESULT";
            if (!SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                UpdateTool.commonUpdate(SHRDbConnectionTool.getSHRDBConnection(ctx), "T_HR_VALIDATERESULT", "", ctx, 300);
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName.toUpperCase(), "finished");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_HR_VALIDATERESULT".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        try {
            tableName = "T_BD_VALIDATEPROJECTENTRY";
            if (!SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                UpdateTool.commonUpdate(SHRDbConnectionTool.getSHRDBConnection(ctx), tableName, "", ctx, 300);
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName.toUpperCase(), "finished");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_BD_VALIDATEPROJECTENTRY".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveValidateCategory(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_BD_ValidateCategory";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            ValidateCategoryCollection shr_category_collection = new ValidateCategoryCollection();
            ValidateCategoryCollection eas_category_collection = new ValidateCategoryCollection();
            shr_category_collection = this.getSHRData_ValidateCategory(shrConn, ctx);
            eas_category_collection = ValidateCategoryFactory.getRemoteInstance().getValidateCategoryCollection();
            ValidateCategoryCollection diffQCollectionSHR_category = null;
            if (eas_category_collection.isEmpty()) {
                this.addSHRDataToEAS_category(ctx, shr_category_collection);
            } else {
                diffQCollectionSHR_category = this.compareData_category(ctx, eas_category_collection, shr_category_collection);
                if (diffQCollectionSHR_category.size() > 0) {
                    this.addSHRDataToEAS_category(ctx, diffQCollectionSHR_category);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BD_ValidateCategory", "FCREATORID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_BD_ValidateCategory".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_BD_ValidateCategory".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveValidateProject(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_BD_ValidateProject";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String delSql = "delete  from T_BD_ValidateProject";
            DbUtil.execute((Context)ctx, (String)delSql);
            ValidateProjectCollection shr_project_collection = new ValidateProjectCollection();
            ValidateProjectCollection eas_project_collection = new ValidateProjectCollection();
            shr_project_collection = this.getSHRData_ValidateProject(shrConn, ctx);
            eas_project_collection = ValidateProjectFactory.getRemoteInstance().getValidateProjectCollection();
            ValidateProjectCollection diffQCollectionSHR_project = null;
            if (eas_project_collection.isEmpty()) {
                this.addSHRDataToEAS_project(ctx, shr_project_collection);
            } else {
                diffQCollectionSHR_project = this.compareData_project(ctx, eas_project_collection, shr_project_collection);
                if (diffQCollectionSHR_project.size() > 0) {
                    this.addSHRDataToEAS_project(ctx, diffQCollectionSHR_project);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BD_ValidateProject", "FCREATORID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_BD_ValidateProject".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_BD_ValidateProject".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveValidateSetting(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_BD_ValidateSetting";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            ValidateSettingCollection shr_setting_collection = new ValidateSettingCollection();
            ValidateSettingCollection eas_setting_collection = new ValidateSettingCollection();
            shr_setting_collection = this.getSHRData_ValidateSetting(shrConn, ctx);
            eas_setting_collection = ValidateSettingFactory.getRemoteInstance().getValidateSettingCollection();
            ValidateSettingCollection diffQCollectionSHR_setting = null;
            if (eas_setting_collection.isEmpty()) {
                this.addSHRDataToEAS_setting(ctx, shr_setting_collection);
            } else {
                diffQCollectionSHR_setting = this.compareData_setting(ctx, eas_setting_collection, shr_setting_collection);
                if (diffQCollectionSHR_setting.size() > 0) {
                    this.addSHRDataToEAS_setting(ctx, diffQCollectionSHR_setting);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BD_ValidateSetting", "FCREATORID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_BD_ValidateSetting".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_BD_ValidateSetting".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveValidateLevel(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_BD_ValidateLevel";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            ValidateLevelCollection shr_level_collection = new ValidateLevelCollection();
            ValidateLevelCollection eas_level_collection = new ValidateLevelCollection();
            shr_level_collection = this.getSHRData_ValidateLevel(shrConn, ctx);
            eas_level_collection = ValidateLevelFactory.getRemoteInstance().getValidateLevelCollection();
            ValidateLevelCollection diffQCollectionSHR_level = null;
            if (eas_level_collection.isEmpty()) {
                this.addSHRDataToEAS_level(ctx, shr_level_collection);
            } else {
                diffQCollectionSHR_level = this.compareData_level(ctx, eas_level_collection, shr_level_collection);
                if (diffQCollectionSHR_level.size() > 0) {
                    this.addSHRDataToEAS_level(ctx, diffQCollectionSHR_level);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BD_ValidateLevel", "FCREATORID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_BD_ValidateLevel".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_BD_ValidateLevel".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public ValidateCategoryCollection compareData_category(Context ctx, ValidateCategoryCollection eas_category_collection, ValidateCategoryCollection shr_category_collection) {
        ValidateCategoryInfo infoEAS = null;
        ValidateCategoryInfo infoSHR = null;
        ValidateCategoryCollection diffCollectionSHR = new ValidateCategoryCollection();
        boolean match = false;
        for (int i = 0; i < shr_category_collection.size(); ++i) {
            infoSHR = shr_category_collection.get(i);
            for (int j = 0; j < eas_category_collection.size(); ++j) {
                infoEAS = eas_category_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_category(Context ctx, ValidateCategoryCollection shr_category_collection) throws BOSException, EASBizException {
        ValidateCategoryInfo info = null;
        IValidateCategory Category2 = ValidateCategoryFactory.getRemoteInstance();
        for (int i = 0; i < shr_category_collection.size(); ++i) {
            info = shr_category_collection.get(i);
            Category2.addnew(info);
        }
    }

    public ValidateProjectCollection compareData_project(Context ctx, ValidateProjectCollection eas_project_collection, ValidateProjectCollection shr_project_collection) {
        ValidateProjectInfo infoEAS = null;
        ValidateProjectInfo infoSHR = null;
        ValidateProjectCollection diffCollectionSHR = new ValidateProjectCollection();
        boolean match = false;
        for (int i = 0; i < shr_project_collection.size(); ++i) {
            infoSHR = shr_project_collection.get(i);
            for (int j = 0; j < eas_project_collection.size(); ++j) {
                infoEAS = eas_project_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_project(Context ctx, ValidateProjectCollection shr_project_collection) throws EASBizException, BOSException {
        ValidateProjectInfo info = null;
        IValidateProject Project = ValidateProjectFactory.getRemoteInstance();
        for (int i = 0; i < shr_project_collection.size(); ++i) {
            info = shr_project_collection.get(i);
            Project.addnew(info);
        }
    }

    public ValidateSettingCollection compareData_setting(Context ctx, ValidateSettingCollection eas_setting_collection, ValidateSettingCollection shr_setting_collection) {
        ValidateSettingInfo infoEAS = null;
        ValidateSettingInfo infoSHR = null;
        ValidateSettingCollection diffCollectionSHR = new ValidateSettingCollection();
        boolean match = false;
        for (int i = 0; i < shr_setting_collection.size(); ++i) {
            infoSHR = shr_setting_collection.get(i);
            for (int j = 0; j < eas_setting_collection.size(); ++j) {
                infoEAS = eas_setting_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_setting(Context ctx, ValidateSettingCollection shr_setting_collection) throws BOSException, EASBizException {
        ValidateSettingInfo info = null;
        IValidateSetting LevelSetting = ValidateSettingFactory.getRemoteInstance();
        for (int i = 0; i < shr_setting_collection.size(); ++i) {
            info = shr_setting_collection.get(i);
            LevelSetting.addnew(info);
        }
    }

    public ValidateLevelCollection compareData_level(Context ctx, ValidateLevelCollection eas_level_collection, ValidateLevelCollection shr_level_collection) {
        ValidateLevelInfo infoEAS = null;
        ValidateLevelInfo infoSHR = null;
        ValidateLevelCollection diffCollectionSHR = new ValidateLevelCollection();
        boolean match = false;
        for (int i = 0; i < shr_level_collection.size(); ++i) {
            infoSHR = shr_level_collection.get(i);
            for (int j = 0; j < eas_level_collection.size(); ++j) {
                infoEAS = eas_level_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_level(Context ctx, ValidateLevelCollection shr_level_collection) throws BOSException, EASBizException {
        ValidateLevelInfo info = null;
        IValidateLevel ConfigScheme = ValidateLevelFactory.getRemoteInstance();
        for (int i = 0; i < shr_level_collection.size(); ++i) {
            info = shr_level_collection.get(i);
            boolean isExist = this.checkNumberExist(info.getNumber());
            if (isExist) continue;
            ConfigScheme.addnew(info);
        }
    }

    private boolean checkNumberExist(String number) throws EASBizException, BOSException {
        if (number == null || number.isEmpty()) {
            return true;
        }
        return ValidateLevelFactory.getRemoteInstance().exists("where number='" + number + "'");
    }

    public ValidateCategoryCollection getSHRData_ValidateCategory(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_BD_ValidateCategory";
        ValidateCategoryCollection shrCollection = new ValidateCategoryCollection();
        ValidateCategoryInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_BD_ValidateCategory".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                UserInfo user;
                String ftablename = colummnsmap.containsKey("ftablename".toUpperCase()) ? rs.getString("ftablename") : "";
                String fkeyfield = colummnsmap.containsKey("fkeyfield".toUpperCase()) ? rs.getString("fkeyfield") : "";
                String fresulttablename = colummnsmap.containsKey("fresulttablename".toUpperCase()) ? rs.getString("fresulttablename") : "";
                String fentityname = colummnsmap.containsKey("fentityname".toUpperCase()) ? rs.getString("fentityname") : "";
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                shrInfo = new ValidateCategoryInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setNumber(fnumber);
                shrInfo.setDescription(fdescription);
                shrInfo.setTableName(ftablename);
                shrInfo.setKeyField(fkeyfield);
                shrInfo.setResultTableName(fresulttablename);
                shrInfo.setEntityName(fentityname);
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (flastupdateuserid != null && !flastupdateuserid.isEmpty()) {
                    user = new UserInfo();
                    user.setId(BOSUuid.read((String)flastupdateuserid));
                    shrInfo.setLastUpdateUser(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public ValidateProjectCollection getSHRData_ValidateProject(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_BD_ValidateProject";
        ValidateProjectCollection shrCollection = new ValidateProjectCollection();
        ValidateProjectInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_BD_ValidateProject".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                UserInfo user;
                Object info;
                String fpercent = colummnsmap.containsKey("fpercent".toUpperCase()) ? rs.getString("fpercent") : "";
                String fvalidatecategoryid = colummnsmap.containsKey("fvalidatecategoryid".toUpperCase()) ? rs.getString("fvalidatecategoryid") : "";
                String fvalidatelevelid = colummnsmap.containsKey("fvalidatelevelid".toUpperCase()) ? rs.getString("fvalidatelevelid") : "";
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                shrInfo = new ValidateProjectInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setNumber(fnumber);
                shrInfo.setDescription(fdescription);
                if (fvalidatecategoryid != null && !fvalidatecategoryid.isEmpty()) {
                    info = new ValidateCategoryInfo();
                    info.setId(BOSUuid.read((String)fvalidatecategoryid));
                    shrInfo.setValidateCategory(info);
                }
                if (fvalidatelevelid != null && !fvalidatelevelid.isEmpty()) {
                    info = new ValidateLevelInfo();
                    info.setId(BOSUuid.read((String)fvalidatelevelid));
                    shrInfo.setValidateLevel((ValidateLevelInfo)info);
                }
                if (fpercent != null && !fpercent.isEmpty()) {
                    info = new BigDecimal(fpercent);
                    shrInfo.setPercent((BigDecimal)info);
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (flastupdateuserid != null && !flastupdateuserid.isEmpty()) {
                    user = new UserInfo();
                    user.setId(BOSUuid.read((String)flastupdateuserid));
                    shrInfo.setLastUpdateUser(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public ValidateSettingCollection getSHRData_ValidateSetting(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_BD_ValidateSetting";
        ValidateSettingCollection shrCollection = new ValidateSettingCollection();
        ValidateSettingInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_BD_ValidateSetting".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                UserInfo user;
                ValidateLevelInfo info;
                String ftablename = colummnsmap.containsKey("ftablename".toUpperCase()) ? rs.getString("ftablename") : "";
                String fuipk = colummnsmap.containsKey("fuipk".toUpperCase()) ? rs.getString("fuipk") : "";
                String fparam = colummnsmap.containsKey("fparam".toUpperCase()) ? rs.getString("fparam") : "";
                String ffieldname = colummnsmap.containsKey("ffieldname".toUpperCase()) ? rs.getString("ffieldname") : "";
                String fmainobjectfield = colummnsmap.containsKey("fmainobjectfield".toUpperCase()) ? rs.getString("fmainobjectfield") : "";
                String findex = colummnsmap.containsKey("findex".toUpperCase()) ? rs.getString("findex") : "";
                String fstate = colummnsmap.containsKey("fstate".toUpperCase()) ? rs.getString("fstate") : "";
                String fvaliator = colummnsmap.containsKey("fvaliator".toUpperCase()) ? rs.getString("fvaliator") : "";
                String fcategoryid = colummnsmap.containsKey("fcategoryid".toUpperCase()) ? rs.getString("fcategoryid") : "";
                String fvalidatelevelid = colummnsmap.containsKey("fvalidatelevelid".toUpperCase()) ? rs.getString("fvalidatelevelid") : "";
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String farchiveuipk = colummnsmap.containsKey("farchiveuipk".toUpperCase()) ? rs.getString("farchiveuipk") : "";
                shrInfo = new ValidateSettingInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setNumber(fnumber);
                shrInfo.setDescription(fdescription);
                shrInfo.setTableName(ftablename);
                shrInfo.setUipk(fuipk);
                shrInfo.setParam(fparam);
                shrInfo.setFieldName(ffieldname);
                shrInfo.setMainObjectField(fmainobjectfield);
                shrInfo.setState(StateEnum.getEnum((String)fstate));
                shrInfo.setValidator(fvaliator);
                shrInfo.setArchiveUipk(farchiveuipk);
                if (fvalidatelevelid != null && !fvalidatelevelid.isEmpty()) {
                    info = new ValidateLevelInfo();
                    info.setId(BOSUuid.read((String)fvalidatelevelid));
                    shrInfo.setValidateLevel(info);
                }
                if (fcategoryid != null && !fcategoryid.isEmpty()) {
                    info = new ValidateCategoryInfo();
                    info.setId(BOSUuid.read((String)fcategoryid));
                    shrInfo.setCategory((ValidateCategoryInfo)info);
                }
                if (findex != null && !findex.isEmpty()) {
                    shrInfo.setIndex(Integer.parseInt(findex));
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (flastupdateuserid != null && !flastupdateuserid.isEmpty()) {
                    user = new UserInfo();
                    user.setId(BOSUuid.read((String)flastupdateuserid));
                    shrInfo.setLastUpdateUser(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public ValidateLevelCollection getSHRData_ValidateLevel(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_BD_ValidateLevel";
        ValidateLevelCollection shrCollection = new ValidateLevelCollection();
        ValidateLevelInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_BD_ValidateLevel".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                UserInfo user;
                String findex = colummnsmap.containsKey("findex".toUpperCase()) ? rs.getString("findex") : "";
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                shrInfo = new ValidateLevelInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setNumber(fnumber);
                shrInfo.setDescription(fdescription);
                if (findex != null && !findex.isEmpty()) {
                    shrInfo.setIndex(Integer.parseInt(findex));
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (flastupdateuserid != null && !flastupdateuserid.isEmpty()) {
                    user = new UserInfo();
                    user.setId(BOSUuid.read((String)flastupdateuserid));
                    shrInfo.setLastUpdateUser(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }
}

