/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.AdditionalLog;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DirFileAccess;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DomainException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.EASSubsystemInfo;
import com.kingdee.eas.hr.mvdt.patch.executeSql.FileAccess;
import com.kingdee.eas.hr.mvdt.patch.executeSql.JarFileAccess;
import com.kingdee.eas.hr.mvdt.patch.executeSql.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public abstract class AbstractDCParser {
    private static final Logger logger = Logger.getLogger(AbstractDCParser.class);
    protected FileAccess scriptFileAccess;
    protected Map<String, EASSubsystemInfo> subSystemMap;
    protected LinkedHashSet execTableScriptOrder;
    protected LinkedHashSet execDataScriptOrder;
    protected LinkedHashSet execIndexScriptOrder;
    protected LinkedHashSet execViewScriptOrder;
    protected LinkedHashSet execPatchScriptOrder;

    public AbstractDCParser() {
    }

    public AbstractDCParser(String sqlScriptDirorJarPath) throws IOException {
        File scriptpath = new File(sqlScriptDirorJarPath);
        if (scriptpath.exists()) {
            this.scriptFileAccess = scriptpath.isDirectory() ? new DirFileAccess(sqlScriptDirorJarPath) : new JarFileAccess(sqlScriptDirorJarPath);
        } else {
            throw new DomainException("File not found, filePath=" + sqlScriptDirorJarPath);
        }
    }

    public AbstractDCParser(FileAccess fileAccess) {
        this.scriptFileAccess = fileAccess;
    }

    abstract void scan(String var1);

    protected String getControlFileDir(String controlFilePath) {
        String controlDirPath = controlFilePath.replace("\\", "/");
        return controlDirPath.substring(0, controlDirPath.lastIndexOf("/") + "/".length());
    }

    protected Map<String, EASSubsystemInfo> scanSystem(String sysName, String systemControl) {
        LinkedHashMap<String, EASSubsystemInfo> subSystemList = new LinkedHashMap<String, EASSubsystemInfo>();
        SAXBuilder builder = new SAXBuilder();
        String relativePath = this.getControlFileDir(systemControl);
        try {
            EASSubsystemInfo subSystem = new EASSubsystemInfo(sysName, systemControl, false);
            logger.info((Object)("[" + subSystem.getName() + "]"));
            InputStream subCreateXml = this.scriptFileAccess.getFileInputStream(subSystem.getSubCreateXml());
            Document subDoc = builder.build(subCreateXml);
            List tables = subDoc.getRootElement().getChildren("Table");
            for (int k = 0; k < tables.size(); ++k) {
                Element tEle = (Element)tables.get(k);
                this.checkFile(sysName, relativePath + tEle.getTextNormalize());
                tEle.setText(relativePath + tEle.getTextNormalize());
                subSystem.addTableScriptFile(tEle);
                logger.info((Object)tEle.getTextNormalize());
            }
            List datas = subDoc.getRootElement().getChildren("Data");
            for (int k = 0; k < datas.size(); ++k) {
                Element tEle = (Element)datas.get(k);
                this.checkFile(sysName, relativePath + tEle.getTextNormalize());
                tEle.setText(relativePath + tEle.getTextNormalize());
                subSystem.addDataScriptFile(tEle);
                logger.info((Object)tEle.getTextNormalize());
            }
            List indexs = subDoc.getRootElement().getChildren("Index");
            for (int k = 0; k < indexs.size(); ++k) {
                Element tEle = (Element)indexs.get(k);
                this.checkFile(sysName, relativePath + tEle.getTextNormalize());
                tEle.setText(relativePath + tEle.getTextNormalize());
                subSystem.addIndexScriptFile(tEle);
                logger.info((Object)tEle.getTextNormalize());
            }
            List fks = subDoc.getRootElement().getChildren("FK");
            for (int k = 0; k < fks.size(); ++k) {
                Element tEle = (Element)fks.get(k);
                this.checkFile(sysName, relativePath + tEle.getTextNormalize());
                subSystem.addFkScriptFile(tEle);
                logger.info((Object)tEle.getTextNormalize());
            }
            List views = subDoc.getRootElement().getChildren("View");
            for (int k = 0; k < views.size(); ++k) {
                Element tEle = (Element)views.get(k);
                this.checkFile(sysName, relativePath + tEle.getTextNormalize());
                tEle.setText(relativePath + tEle.getTextNormalize());
                subSystem.addViewScriptFile(tEle);
                logger.info((Object)tEle.getTextNormalize());
            }
            if (subSystem.getSubSystemScriptCount() > 0) {
                subSystemList.put(subSystem.getName(), subSystem);
            }
            List subSystems = subDoc.getRootElement().getChildren("subsystem");
            for (int k = 0; k < subSystems.size(); ++k) {
                Element tEle = (Element)subSystems.get(k);
                this.checkFile(sysName, relativePath + tEle.getTextNormalize());
                String subSystemName = tEle.getAttributeValue("name");
                subSystemList.putAll(this.scanSystem(sysName + "-" + subSystemName, relativePath + tEle.getTextNormalize()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception while analyze the subsystem[" + sysName + "] update.xml!"), (Throwable)e);
            AdditionalLog.getErrLogger().error((Object)("Exception while analyze the subsystem[" + sysName + "] update.xml!"), (Throwable)e);
            throw new DomainException("Exception while analyze the subsystem[" + sysName + "] update.xml!ErrMsg:" + e.getMessage(), e);
        }
        return subSystemList;
    }

    protected void checkFile(String sysName, String relativePath) {
        this.checkFile(sysName, relativePath, false);
    }

    protected void checkFile(String sysName, String relativePath, boolean toLowerCase) {
        if (toLowerCase) {
            relativePath = relativePath.toLowerCase();
        }
        String filename = StringUtils.cleanPath(relativePath);
        boolean exist = false;
        try {
            exist = filename.indexOf("*") > 0 ? true : this.scriptFileAccess.isFileExist(filename);
        }
        catch (Throwable e) {
            logger.error((Object)("Check subsystem[" + sysName + "] script file[" + filename + "] error!"), e);
            AdditionalLog.getErrLogger().error((Object)("Check subsystem[" + sysName + "] script file[" + filename + "] error!"), e);
            throw new DomainException("Check subsystem[" + sysName + "] script file[" + filename + "] error!ErrMsg:" + e.getMessage(), e);
        }
        if (!exist) {
            logger.error((Object)("Subsystem[" + sysName + "] script file[" + filename + "] not found!"));
            throw new DomainException("Subsystem[" + sysName + "] script file[" + filename + "] not found!");
        }
    }

    protected void initExecuteOrder(Element root) {
        LinkedHashSet<String> defaultOrder = new LinkedHashSet<String>(this.subSystemMap.keySet());
        Element table = root.getChild("Table");
        if (table != null && table.getAttributeValue("order") != null) {
            String tableOrder = table.getAttributeValue("order");
            List<String> orders = Arrays.asList(tableOrder.split(","));
            this.execTableScriptOrder = new LinkedHashSet<String>(orders);
        } else {
            this.execTableScriptOrder = defaultOrder;
        }
        Element data = root.getChild("Data");
        if (data != null && data.getAttributeValue("order") != null) {
            String dataOrder = data.getAttributeValue("order");
            List<String> orders = Arrays.asList(dataOrder.split(","));
            this.execDataScriptOrder = new LinkedHashSet<String>(orders);
        } else {
            this.execDataScriptOrder = defaultOrder;
        }
        Element index = root.getChild("Index");
        if (index != null && index.getAttributeValue("order") != null) {
            String indexOrder = index.getAttributeValue("order");
            List<String> orders = Arrays.asList(indexOrder.split(","));
            this.execIndexScriptOrder = new LinkedHashSet<String>(orders);
        } else {
            this.execIndexScriptOrder = defaultOrder;
        }
        Element view = root.getChild("View");
        if (view != null && view.getAttributeValue("order") != null) {
            String viewOrder = view.getAttributeValue("order");
            List<String> orders = Arrays.asList(viewOrder.split(","));
            this.execViewScriptOrder = new LinkedHashSet<String>(orders);
        } else {
            this.execViewScriptOrder = defaultOrder;
        }
        Element patch = root.getChild("Patch");
        if (patch != null && patch.getAttributeValue("order") != null) {
            String patchOrder = patch.getAttributeValue("order");
            List<String> orders = Arrays.asList(patchOrder.split(","));
            this.execPatchScriptOrder = new LinkedHashSet<String>(orders);
        } else {
            this.execPatchScriptOrder = defaultOrder;
        }
    }
}

