/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.AbstractDB;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ConnectionHolder {
    private Connection dbConnection = null;
    private String inUseThreadName = "";
    private AbstractDB dbEngine;
    private static Logger logger = Logger.getLogger(ConnectionHolder.class);

    public ConnectionHolder(AbstractDB abstractDB) {
        this.dbEngine = abstractDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        AbstractDB abstractDB = this.dbEngine;
        synchronized (abstractDB) {
            if (this.dbConnection == null) {
                this.dbConnection = this.dbEngine.getPhysicalDBConnection();
                this.inUseThreadName = Thread.currentThread().getName();
            }
            if (Thread.currentThread().getName().equals(this.inUseThreadName) || this.inUseThreadName.length() == 0) {
                this.dbConnection = this.dbEngine.detectConnection(this.dbConnection);
                return this.dbConnection;
            }
            try {
                logger.info((Object)("Wait thread[" + this.inUseThreadName + "] to release db connection ......"));
                this.dbEngine.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.info((Object)("Get db connection after thread[" + this.inUseThreadName + "] release it!"));
            this.dbConnection = this.dbEngine.detectConnection(this.dbConnection);
            return this.dbConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        AbstractDB abstractDB = this.dbEngine;
        synchronized (abstractDB) {
            this.inUseThreadName = "";
            this.dbEngine.notifyAll();
        }
    }

    public void doConnectionClean() {
        try {
            this.dbConnection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

