/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.AbstractDB;
import com.kingdee.eas.hr.mvdt.patch.executeSql.AdminException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.CreateDBInfo;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DB2VO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DBException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DBInstanceNotExistException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DBLoginException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DatabaseVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DefaultSQLProviderExecutor;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DefaultSQLQueryProviderExecutor;
import com.kingdee.eas.hr.mvdt.patch.executeSql.IDB2UDB;
import com.kingdee.eas.hr.mvdt.patch.executeSql.IDB2UDBDriver;
import com.kingdee.eas.hr.mvdt.patch.executeSql.JDBCDriverFactory;
import com.kingdee.eas.hr.mvdt.patch.executeSql.OptimizeDBParamVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.RowCallbackHandler;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SqlTable;
import com.kingdee.eas.hr.mvdt.patch.executeSql.StringUtils;
import com.kingdee.eas.hr.mvdt.patch.executeSql.TableSpaceInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DB2UDB
extends AbstractDB
implements IDB2UDB {
    private static final Logger logger = Logger.getLogger(DB2UDB.class);
    private static final String SQL_GET_TABLE_VIEW = "SELECT NAME, TYPE FROM SYSIBM.SYSTABLES WHERE TYPE ='T' OR TYPE ='V' AND UPPER(CREATOR) = ? ORDER BY NAME";
    private static final String SQL_RUN_STATISTICS = "CALL ADMIN_CMD(''RUNSTATS ON TABLE {0}.{1} AND INDEXES ALL'')";
    private static final String SQL_GET_DB_FK_LIST = "SELECT NAME FK_NAME,TBNAME TABLE_NAME FROM SYSIBM.SYSTABCONST WHERE CONSTRAINTYP = 'F' AND TBNAME LIKE 'T_%' AND TBCREATOR = ?";
    private static final String SQL_GET_INVALID_VIEW_LIST = "SELECT NAME,TEXT FROM SYSIBM.SYSVIEWS WHERE (VALID = 'N' OR VALID = 'X') AND CREATOR = ?";
    String createBufPool = "CREATE BUFFERPOOL EASBP{0} IMMEDIATE  SIZE {1} PAGESIZE {0}";
    String createAutoBufPool = "CREATE BUFFERPOOL EASBP{0} IMMEDIATE  SIZE {1} PAGESIZE {2}";
    String createTBSpaceNormal = "CREATE  REGULAR  TABLESPACE EASTS{0} PAGESIZE {0}  MANAGED BY SYSTEM  USING (''{1}'' ) EXTENTSIZE 16 OVERHEAD 10.5 PREFETCHSIZE 16 TRANSFERRATE 0.14 BUFFERPOOL  EASBP{0}  DROPPED TABLE RECOVERY OFF";
    String createAutoTBSpaceNormal = "CREATE  REGULAR  TABLESPACE EASTS{2} PAGESIZE {0}  MANAGED BY AUTOMATIC STORAGE EXTENTSIZE {1} OVERHEAD 10.67 PREFETCHSIZE {1} TRANSFERRATE 0.04 BUFFERPOOL EASBP{2} DROPPED TABLE RECOVERY OFF NO FILE SYSTEM CACHING";
    String createTBSpaceTemp = "CREATE  SYSTEM TEMPORARY  TABLESPACE EASTEMPTS{0} PAGESIZE {0}  MANAGED BY SYSTEM  USING (''{1}'' ) EXTENTSIZE 16 OVERHEAD 10.5 PREFETCHSIZE 16 TRANSFERRATE 0.14 BUFFERPOOL  EASBP{0}";
    String createAutoTBSpaceTemp = "CREATE SYSTEM  TEMPORARY  TABLESPACE EASTTS32K_{0}   PAGESIZE 32K  MANAGED BY AUTOMATIC STORAGE EXTENTSIZE 32 OVERHEAD 10.67 PREFETCHSIZE 32 TRANSFERRATE 0.04 BUFFERPOOL  EASBP32K_{0} NO FILE SYSTEM CACHING";
    String createLargeSpace = "CREATE  LARGE  TABLESPACE EASTSBLOB_{0} PAGESIZE 32 K  MANAGED BY AUTOMATIC STORAGE EXTENTSIZE 32 OVERHEAD 10.67 PREFETCHSIZE 32 TRANSFERRATE 0.04 BUFFERPOOL EASBP32K_{0}";
    String createUserTempSpace = "CREATE USER TEMPORARY TABLESPACE EASTSUT_{0}  PAGESIZE 32 K  MANAGED BY AUTOMATIC STORAGE EXTENTSIZE 32 OVERHEAD 10.67 PREFETCHSIZE 32 TRANSFERRATE 0.04 BUFFERPOOL  EASBP32K_{0} NO FILE SYSTEM CACHING";
    protected String[] dbconfig = new String[]{"drop tablespace userspace1", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING APPLHEAPSZ 40960 IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING DBHEAP AUTOMATIC IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING SHEAPTHRES_SHR  AUTOMATIC')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING SORTHEAP  AUTOMATIC')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING MAXLOCKS 30 IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING STMTHEAP 20480 IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING MINCOMMIT 5 IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING LOCKTIMEOUT 500 IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING AVG_APPLS 3 IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING LOCKLIST 50000 IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING LOGFILSIZ 25000 IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING LOGPRIMARY 15 IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING LOGSECOND 10  IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING PCKCACHESZ AUTOMATIC')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING SELF_TUNING_MEM  on IMMEDIATE')", "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING APP_CTL_HEAP_SZ 1024  IMMEDIATE')"};
    private IDB2UDBDriver db2udbDriver = null;
    private DB2VO db2;

    public DB2UDB(DB2VO dbvo) {
        this.db2 = dbvo;
        this.db2udbDriver = (IDB2UDBDriver)JDBCDriverFactory.getDBDriver(dbvo);
    }

    @Override
    public void runStatics(Connection conn, String tablename) {
        String sql = MessageFormat.format(SQL_RUN_STATISTICS, this.db2.getDbUserName(), tablename);
        this.executeSqlProvider(conn, new DefaultSQLProviderExecutor(sql, false));
    }

    @Override
    public String getJDBCDriverClassName() {
        return this.db2udbDriver.getDriverClassName();
    }

    @Override
    public String getJDBCUrl(DatabaseVO dbVO) {
        return this.db2udbDriver.getJDBCUrl(dbVO);
    }

    @Override
    protected Connection getPhysicalDBConnection() throws SQLException {
        this.testDBPort(this.db2);
        Properties props = new Properties();
        props.setProperty("user", this.db2.getDbUserName());
        props.setProperty("password", this.db2.getDbPassword());
        logger.info((Object)("Create physical db2 connection with user [" + props.getProperty("user") + "]"));
        Connection conn = null;
        try {
            conn = this.db2udbDriver.connect(this.getJDBCUrl(this.db2), props);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == -99999) {
                logger.error((Object)("Create DB2 connection error,login failed," + ex));
                throw new DBLoginException("Create DB2 connection error,login failed," + ex.getMessage(), this.db2.getDBType(), this.db2.getDbUserName(), this.db2.getDisplayAddress(), this.db2.getDbPort());
            }
            if (ex.getErrorCode() == -4499) {
                logger.error((Object)("Create DB2 connection error,get DBInstance failed," + ex));
                throw new DBInstanceNotExistException("Create DB2 connection error,get DBInstance failed\u951b?", this.db2.getDBType(), this.db2.getDisplayDBName(), this.db2.getDisplayAddress(), this.db2.getDbPort());
            }
            throw ex;
        }
        return conn;
    }

    @Override
    public SqlTable[] getDBTableAndViews() {
        final ArrayList tablesList = new ArrayList();
        try {
            String userName = this.db2.getDbUserName();
            if (this.db2 != null) {
                userName = userName.toUpperCase();
            }
            this.executeQueryWithSingleParam(SQL_GET_TABLE_VIEW, userName, new RowCallbackHandler(){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String tbName = rs.getString(1);
                    String type = rs.getString(2);
                    SqlTable table = new SqlTable(tbName, "V".equalsIgnoreCase(type.trim()));
                    tablesList.add(table);
                }
            });
            return tablesList.toArray(new SqlTable[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get db2 table and view failed!", e);
            throw new DBException("Get db2 table and view failed!", e);
        }
    }

    @Override
    public boolean isTableExist(String tableName) {
        final ArrayList tablesList = new ArrayList();
        try {
            this.executeQueryWithSingleParam("SELECT NAME FROM SYSIBM.SYSTABLES WHERE TYPE ='T' AND NAME='" + tableName + "' AND CREATOR = ?", this.db2.getDbUserName(), new RowCallbackHandler(){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String tbName = rs.getString(1);
                    tablesList.add(tbName);
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get db2 table and view failed!", e);
            throw new DBException("Get db2 table and view failed!", e);
        }
        return tablesList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            DatabaseMetaData meta = conn.getMetaData();
            logger.info((Object)("DB2 ProductVersion: " + meta.getDatabaseProductVersion()));
            String string = meta.getDatabaseProductVersion().substring(3);
            return string;
        }
        finally {
            this.connectionHolder.release();
        }
    }

    @Override
    public boolean isVersionNine() throws SQLException {
        String version = this.getVersion();
        return version != null && (version.startsWith("9") || version.startsWith("09") || Integer.parseInt(version) > 9000);
    }

    @Override
    public String[] getDatabaseUserList() {
        return null;
    }

    @Override
    public void createDatabase(DatabaseVO dbVO, CreateDBInfo info) throws SQLException {
        TableSpaceInfo spaceParam = (TableSpaceInfo)info.getTableSpaceInfo().get(0);
        this.createDatabase(dbVO, spaceParam, true);
    }

    private void getCreateTableSpaceSql(boolean isVersionNine, boolean isAutoManaged, Map bpSizes, ArrayList sqlList, String spacePath, String dbName) {
        if (isVersionNine) {
            if (isAutoManaged) {
                for (String bfSize : bpSizes.keySet()) {
                    if (bfSize == null) continue;
                    String size = "";
                    for (int i = 0; i < bfSize.length(); ++i) {
                        if (!StringUtils.isNum(new String(new char[]{bfSize.charAt(i)}))) continue;
                        size = size + bfSize.charAt(i);
                    }
                    String tbSQL = MessageFormat.format(this.createAutoTBSpaceNormal, bfSize, size, bfSize + "_" + dbName);
                    logger.info((Object)("Create db2 system normal tablespace, Execute sql: " + tbSQL));
                    sqlList.add(tbSQL);
                }
                String tmptbSQL = MessageFormat.format(this.createAutoTBSpaceTemp, dbName);
                sqlList.add(tmptbSQL);
                logger.info((Object)("Create db2 system temp tablespace, Execute sql: " + tmptbSQL));
                tmptbSQL = MessageFormat.format(this.createLargeSpace, dbName);
                sqlList.add(tmptbSQL);
                logger.info((Object)("Create db2 large object tablespace, Execute sql: " + tmptbSQL));
                tmptbSQL = MessageFormat.format(this.createUserTempSpace, dbName);
                sqlList.add(tmptbSQL);
                logger.info((Object)("Create db2 user temp tablespace, Execute sql: " + tmptbSQL));
                return;
            }
            logger.info((Object)"Not find DB_STORAGE_PATH, maybe it's not automatic storage");
        }
        for (String bfSize : bpSizes.keySet()) {
            String tbSQL = MessageFormat.format(this.createTBSpaceNormal, bfSize, spacePath + bfSize);
            logger.info((Object)("Create db2 system normal tablespace, Execute sql: " + tbSQL));
            sqlList.add(tbSQL);
            String tempTBsql = MessageFormat.format(this.createTBSpaceTemp, bfSize, spacePath + bfSize + "_temp");
            logger.info((Object)("Create db2 system temp tablespace, Execute sql: " + tempTBsql));
            sqlList.add(tempTBsql);
        }
    }

    @Override
    public void createDatabase(DatabaseVO dbVO, TableSpaceInfo spaceParam, boolean isDC) throws SQLException {
        boolean isVersion9 = this.isVersionNine();
        boolean isAutoManaged = false;
        if (isVersion9) {
            final ArrayList dbpaths = new ArrayList();
            this.execute(new DefaultSQLQueryProviderExecutor("select * from sysibmadm.dbpaths where type='DB_STORAGE_PATH'"){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    dbpaths.add(rs.getString("type"));
                }
            });
            if (dbpaths.size() > 0) {
                isAutoManaged = true;
            }
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        HashMap<String, String> bpSizes = new HashMap<String, String>();
        if (isDC) {
            bpSizes.put("8K", "40000");
            bpSizes.put("16K", "5000");
            bpSizes.put("32K", "500");
        } else {
            bpSizes.put("8K", "400");
            bpSizes.put("16K", "50");
            bpSizes.put("32K", "5");
        }
        for (String bfSize : bpSizes.keySet()) {
            String bfPageSize = (String)bpSizes.get(bfSize);
            String sqlBufferPool = "";
            if (isVersion9) {
                int index = this.createAutoBufPool.indexOf("PAGESIZE");
                String str = this.createAutoBufPool.substring(0, index) + "AUTOMATIC " + this.createAutoBufPool.substring(index);
                if (isAutoManaged) {
                    String realBFSize = bfSize + "_" + dbVO.getDisplayDBName();
                    sqlBufferPool = MessageFormat.format(str, realBFSize, bfPageSize, bfSize);
                } else {
                    sqlBufferPool = MessageFormat.format(str, bfSize, bfPageSize, bfSize);
                }
            } else {
                sqlBufferPool = MessageFormat.format(this.createBufPool, bfSize, bfPageSize);
            }
            logger.info((Object)("Create db2 bufferpool, Execute sql: " + sqlBufferPool));
            sqlList.add(sqlBufferPool);
        }
        String path = spaceParam.getSpacePath() + "/eas_" + dbVO.getDisplayDBName() + "_";
        this.getCreateTableSpaceSql(isVersion9, isAutoManaged, bpSizes, sqlList, path, dbVO.getDisplayDBName());
        if (this.dbconfig != null) {
            for (int i = 0; i < this.dbconfig.length; ++i) {
                int index2;
                int index1;
                String sql = this.dbconfig[i];
                if (isVersion9 && sql.indexOf("UPDATE DATABASE CONFIGURATION USING LOCKLIST") >= 0) {
                    index1 = sql.indexOf("LOCKLIST");
                    index2 = sql.indexOf("IMMEDIATE");
                    sql = sql.substring(0, index1 + "LOCKLIST".length()) + " AUTOMATIC " + sql.substring(index2);
                    logger.info((Object)("Create db2 database, Execute sql: " + sql));
                    this.execute(new DefaultSQLProviderExecutor(sql, true));
                    continue;
                }
                if (isVersion9 && sql.indexOf("UPDATE DATABASE CONFIGURATION USING MAXLOCKS") >= 0) {
                    index1 = sql.indexOf("MAXLOCKS");
                    index2 = sql.indexOf("IMMEDIATE");
                    sql = sql.substring(0, index1 + "MAXLOCKS".length()) + " AUTOMATIC " + sql.substring(index2);
                    logger.info((Object)("Create db2 database, Execute sql: " + sql));
                    this.execute(new DefaultSQLProviderExecutor(sql, true));
                    continue;
                }
                logger.info((Object)("Create db2 database, Execute sql: " + sql));
                sqlList.add(sql);
            }
        }
        boolean ignoreException = "true".equalsIgnoreCase(System.getProperty("ignoreException", "false"));
        this.execute(new DefaultSQLProviderExecutor(sqlList, ignoreException));
    }

    @Override
    public HashMap getDBFKList(String dbSchema, String tableName) {
        final HashMap fkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT NAME FK_NAME,TBNAME TABLE_NAME FROM SYSIBM.SYSTABCONST WHERE CONSTRAINTYP = 'F' AND TBCREATOR = '" + dbSchema.toUpperCase() + "' AND TBNAME='" + tableName + "'" : "SELECT NAME FK_NAME,TBNAME TABLE_NAME FROM SYSIBM.SYSTABCONST WHERE CONSTRAINTYP = 'F' AND TBNAME LIKE 'T_%' AND TBCREATOR = '" + dbSchema.toUpperCase() + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    fkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get DB2UDB DB FK list failed!", e);
            throw new AdminException("Get DB2UDB DB FK list failed!", e);
        }
        return fkList;
    }

    @Override
    public void rebuildDisabledView() throws Exception {
        final ArrayList viewList = new ArrayList();
        final ArrayList nameList = new ArrayList();
        this.executeQueryWithSingleParam(SQL_GET_INVALID_VIEW_LIST, this.db2.getDbUserName().toUpperCase(), new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet rs) throws SQLException {
                nameList.add(rs.getString(1));
                viewList.add(rs.getString(2));
            }
        });
        if (nameList.size() > 0) {
            logger.info((Object)("Invalid database view siz is " + nameList.size()));
            String[][] viewNamesArarry = new String[1][1];
            viewNamesArarry[0] = nameList.toArray(new String[0]);
            ArrayList<String> dropViewList = new ArrayList<String>();
            for (int i = 0; i < nameList.size(); ++i) {
                String viewName = (String)nameList.get(i);
                dropViewList.add("drop view " + viewName);
            }
            this.executeMultiSql(dropViewList);
            ArrayList validViewList = (ArrayList)viewList.clone();
            int failedCount = validViewList.size();
            validViewList = this.processCreateViewsSQL(validViewList);
            while (validViewList.size() > 0 && failedCount < validViewList.size()) {
                failedCount = validViewList.size();
                validViewList = this.processCreateViewsSQL(validViewList);
            }
        }
    }

    private ArrayList processCreateViewsSQL(ArrayList viewList) {
        ArrayList<String> failedSQLList = new ArrayList<String>();
        for (int i = 0; i < viewList.size(); ++i) {
            String viewSQL = (String)viewList.get(i);
            try {
                logger.debug((Object)("Execute sql [" + viewSQL + "] on DB2 database!"));
                this.executeSql(viewSQL);
                continue;
            }
            catch (Exception ex) {
                failedSQLList.add(viewSQL);
                logger.warn((Object)("Execute sql [" + viewSQL + "] on DB2 database error !"));
            }
        }
        return failedSQLList;
    }

    @Override
    public ArrayList getDBTableList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "SELECT NAME FROM SYSIBM.SYSTABLES WHERE TYPE ='T' AND CREATOR = '" + dbSchema.toUpperCase() + "' ORDER BY NAME";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get table list failed!", e);
            throw new DBException("Get table list form db error", e);
        }
        return tableList;
    }

    @Override
    public ArrayList getDBViewList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "SELECT NAME FROM SYSIBM.SYSTABLES WHERE TYPE ='V' AND CREATOR = '" + dbSchema.toUpperCase() + "' ORDER BY NAME";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get view list failed!", e);
            throw new DBException("Get view list form db error", e);
        }
        return tableList;
    }

    @Override
    public HashMap getDBPKList(String dbSchema, String tableName) {
        final HashMap pkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT NAME PK_NAME,TBNAME TABLE_NAME FROM SYSIBM.SYSTABCONST WHERE CONSTRAINTYP = 'P' AND TBCREATOR = '" + dbSchema.toUpperCase() + "' AND TBNAME='" + tableName + "'" : "SELECT NAME PK_NAME,TBNAME TABLE_NAME FROM SYSIBM.SYSTABCONST WHERE CONSTRAINTYP = 'P' AND TBCREATOR = '" + dbSchema.toUpperCase() + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    pkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get pk list failed!", e);
            throw new DBException("Get pk list form db error", e);
        }
        return pkList;
    }

    @Override
    public HashMap getDBIndexList(String dbSchema) {
        final HashMap indexList = new HashMap();
        try {
            String sql = "SELECT NAME,TBNAME FROM SYSIBM.SYSINDEXES WHERE TBCREATOR = '" + dbSchema.toUpperCase() + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    indexList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get index list failed!", e);
            throw new DBException("Get index list form db error", e);
        }
        return indexList;
    }

    @Override
    public String getID() {
        return "db2:" + this.db2.getID();
    }

    @Override
    public String getDetectSql() {
        return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    public OptimizeDBParamVO[] getDBParameterValue(OptimizeDBParamVO[] params) {
        ArrayList<OptimizeDBParamVO> list = new ArrayList<OptimizeDBParamVO>();
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                OptimizeDBParamVO vo = params[i];
                list.add(vo);
            }
        }
        return list.toArray(new OptimizeDBParamVO[list.size()]);
    }

    @Override
    public void setDBParameterValue(OptimizeDBParamVO[] params) {
        if (params != null && params.length > 0) {
            ArrayList<String> sqlList = new ArrayList<String>();
            for (int i = 0; i < params.length; ++i) {
                String sql;
                OptimizeDBParamVO vo = params[i];
                String name = vo.getName();
                String scope = vo.getScope();
                String vouchValue = vo.getRealOptimizeValue();
                String preSql = "";
                preSql = StringUtils.hasText(scope) ? "CALL ADMIN_CMD('UPDATE DATABASE " + scope + " CONFIGURATION USING " : "CALL ADMIN_CMD('UPDATE DATABASE CONFIGURATION USING ";
                if (StringUtils.isNum(vouchValue)) {
                    sql = preSql + name + " " + vouchValue + " IMMEDIATE')";
                    logger.info((Object)("[" + sql + "]"));
                    sqlList.add(sql);
                    continue;
                }
                sql = preSql + name + " '" + vouchValue + "' IMMEDIATE')";
                logger.info((Object)("[" + sql + "]"));
                sqlList.add(sql);
            }
            DefaultSQLProviderExecutor provider = new DefaultSQLProviderExecutor(sqlList, true);
            this.execute(provider);
            ArrayList exceptionList = provider.getExceptions();
            if (exceptionList != null && exceptionList.size() > 0) {
                logger.error((Object)"setDBParameterValue failed!", (Throwable)((Exception)exceptionList.get(0)));
                throw new AdminException("setDBParameterValue failed!", (Exception)exceptionList.get(0));
            }
        }
    }
}

