/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.DBSQLException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DatabaseVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.FileAccess;
import com.kingdee.eas.hr.mvdt.patch.executeSql.KSQLProvider;
import com.kingdee.eas.hr.mvdt.patch.executeSql.MultiSqlProvider;
import com.kingdee.eas.hr.mvdt.patch.executeSql.NoOpEntityResolver;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SqlParamterProvider;
import com.kingdee.eas.hr.mvdt.patch.executeSql.StringUtils;
import com.kingdee.eas.util.BASE64Decoder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public class XmlSqlFileExecutor
implements MultiSqlProvider,
SqlParamterProvider {
    private static final Logger logger = Logger.getLogger(XmlSqlFileExecutor.class);
    private FileAccess fileAccess;
    private String fileName;
    private Document sqlDocument;
    private ArrayList exceptions = new ArrayList();
    private List listItem = null;
    private DatabaseVO db;
    private int targetDBType;
    private KSQLProvider ksqlProvider;
    private boolean useRelativePathRule = false;
    private Element curSQLElement = null;
    private int curSQLElementIndex = -1;

    public XmlSqlFileExecutor(FileAccess access, String filename, DatabaseVO dbvo, String charSet, KSQLProvider provider) throws JDOMException, IOException {
        this.fileAccess = access;
        this.fileName = filename;
        this.ksqlProvider = provider;
        this.db = dbvo;
        InputStream inputStream = null;
        inputStream = this.fileAccess.isFileExist(this.fileName) ? this.fileAccess.getFileInputStream(this.fileName) : this.fileAccess.getFileInputStream(this.fileName.toLowerCase());
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        builder.setValidation(false);
        builder.setEntityResolver((EntityResolver)new NoOpEntityResolver());
        InputStreamReader docReader = null;
        docReader = charSet != null && charSet.length() != 0 ? new InputStreamReader(inputStream, charSet) : new InputStreamReader(inputStream, "UTF-8");
        Document sqlDocument = builder.build((Reader)docReader);
        Element eleRoot = sqlDocument.getRootElement();
        this.useRelativePathRule = Boolean.valueOf(eleRoot.getAttributeValue("useRelativePathRule"));
        this.listItem = eleRoot.getChildren();
        docReader.close();
    }

    @Override
    public String getProviderName() {
        return this.fileName;
    }

    @Override
    public boolean nextSQL() {
        ++this.curSQLElementIndex;
        if (this.curSQLElementIndex < this.listItem.size()) {
            this.curSQLElement = (Element)this.listItem.get(this.curSQLElementIndex);
            return true;
        }
        return false;
    }

    @Override
    public String getSql() throws DBSQLException {
        try {
            Element eleSql = this.curSQLElement.getChild("sql");
            String sql = eleSql.getText();
            return sql;
        }
        catch (Throwable e) {
            logger.error((Object)("Get sql from xml element[" + this.curSQLElement + "] failed!"), e);
            throw new DBSQLException("Get sql from xml element[" + this.curSQLElement + "] failed," + e.getMessage(), this.db.getDBType());
        }
    }

    @Override
    public boolean handleException(DBSQLException sqle) {
        this.exceptions.add(sqle);
        return true;
    }

    @Override
    public void setValues(PreparedStatement pre) throws SQLException {
        Element para = this.curSQLElement.getChild("para");
        List listPara = para.getChildren();
        ListIterator itPara = listPara.listIterator();
        int i = 1;
        while (itPara.hasNext()) {
            Element paraItem = (Element)itPara.next();
            Attribute attr = paraItem.getAttribute("type");
            if (attr == null) continue;
            String paraType = paraItem.getAttribute("type").getValue().toString();
            boolean dataInFile = Boolean.valueOf(paraItem.getAttributeValue("dataInFile", "true"));
            String paraFile = "";
            if (dataInFile) {
                paraFile = paraItem.getText();
                if (this.useRelativePathRule) {
                    paraFile = this.fileName.substring(0, this.fileName.lastIndexOf("/") + 1) + paraFile;
                }
            }
            try {
                String value;
                BASE64Decoder decoder;
                if (paraType.equals("7")) {
                    byte[] bo = null;
                    if (dataInFile) {
                        bo = this.readDataFile(paraFile);
                    } else {
                        decoder = new BASE64Decoder();
                        bo = decoder.decodeBuffer(paraItem.getText());
                    }
                    if (bo != null && bo.length > 0) {
                        pre.setBytes(i++, bo);
                        continue;
                    }
                    pre.setNull(i++, 2004);
                    continue;
                }
                if (paraType.equals("8")) {
                    value = null;
                    value = dataInFile ? this.readFile(paraFile, "UTF-8") : paraItem.getText();
                    pre.setString(i++, value);
                    continue;
                }
                if (paraType.equals("88")) {
                    value = null;
                    if (dataInFile) {
                        value = this.readFile(paraFile, "UTF-8");
                    } else {
                        decoder = new BASE64Decoder();
                        value = new String(decoder.decodeBuffer(paraItem.getText()));
                    }
                    pre.setString(i++, value);
                    continue;
                }
                if (!paraType.equals("9")) continue;
                value = null;
                value = dataInFile ? this.readFile(paraFile, "UTF-8") : paraItem.getText();
                pre.setString(i++, value);
            }
            catch (Exception e) {
                logger.error((Object)("Process xml[" + this.fileName + "] sql values failed!"), (Throwable)e);
                if (SQLException.class.isInstance(e)) {
                    throw (SQLException)e;
                }
                throw new SQLException("Process xml[" + this.fileName + "] sql values failed!");
            }
        }
    }

    @Override
    public boolean useParameters() {
        return true;
    }

    public byte[] readDataFile(String filename) throws Exception {
        String realFileName = this.fileAccess.getBaseFile() + "/" + this.fileName;
        if (!new File(realFileName = StringUtils.cleanPath(realFileName)).exists()) {
            filename = filename.toLowerCase();
            realFileName = this.fileAccess.getBaseFile() + "/" + this.fileName;
        }
        logger.debug((Object)("Load data from[" + realFileName + "] ....."));
        InputStream fi = this.fileAccess.getFileInputStream(filename);
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int count = 0;
            while ((count = fi.read(buffer)) > 0) {
                bo.write(buffer, 0, count);
            }
            bo.flush();
            fi.close();
            return bo.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)("Read data file[" + filename + "] error!"), (Throwable)e);
            throw new Exception("Read data file[" + filename + "] error!", e);
        }
    }

    public String readFile(String fileName, String code) throws Exception {
        InputStream stream = null;
        InputStreamReader reader = null;
        BufferedReader buffReader = null;
        String realFileName = this.fileAccess.getBaseFile() + "/" + fileName;
        if (!new File(realFileName = StringUtils.cleanPath(realFileName)).exists()) {
            fileName = fileName.toLowerCase();
            realFileName = this.fileAccess.getBaseFile() + "/" + fileName;
        }
        logger.debug((Object)("Load data from[" + realFileName + "] with code[" + code + "]....."));
        stream = this.fileAccess.getFileInputStream(fileName);
        reader = code != null && code.length() > 0 ? new InputStreamReader(stream, "UTF8") : new InputStreamReader(stream);
        buffReader = new BufferedReader(reader);
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        String s = "";
        while ((s = buffReader.readLine()) != null) {
            sqlBuffer.append(s);
            sqlBuffer.append("\n");
        }
        sql = sqlBuffer.toString();
        try {
            stream.close();
            reader.close();
            buffReader.close();
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
        return sql;
    }

    @Override
    public ArrayList getExceptions() {
        return this.exceptions;
    }
}

