/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.SHRMvDataDbConfigCollection;
import com.kingdee.eas.hr.mvdt.SHRMvDataDbConfigFactory;
import com.kingdee.eas.hr.mvdt.SHRMvDataDbConfigInfo;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DataBaseConfigTool {
    public static Connection getOuterConnection(Context ctx) throws BOSException, SQLException, InterfaceDataBaseException {
        SHRMvDataDbConfigCollection DataDbs = SHRMvDataDbConfigFactory.getLocalInstance(ctx).getSHRMvDataDbConfigCollection();
        SHRMvDataDbConfigInfo dbInfo = null;
        if (DataDbs.size() > 0) {
            dbInfo = DataDbs.get(0);
        }
        String IP = null;
        String DB = null;
        String username = null;
        String password = null;
        String DBtype = dbInfo.getType().toString();
        IP = dbInfo.getIp();
        DB = dbInfo.getInstance();
        int port = dbInfo.getPort();
        username = dbInfo.getUsername();
        password = dbInfo.getPassword();
        if (DBtype.equalsIgnoreCase("SQLserver")) {
            try {
                Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver").newInstance();
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            String url = "jdbc:microsoft:sqlserver://" + IP + ":" + port + ";databaseName=" + DB + "";
            DriverManager.setLoginTimeout(300);
            try {
                return DriverManager.getConnection(url, username, password);
            }
            catch (SQLException e1) {
                NumericExceptionSubItem src_conn_error = new NumericExceptionSubItem("001", e1.getMessage());
                throw new InterfaceDataBaseException(src_conn_error);
            }
        }
        if (DBtype.equalsIgnoreCase("oracle")) {
            try {
                Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
                String url = "jdbc:oracle:thin:@" + IP + ":" + port + ":" + DB + "";
                return DriverManager.getConnection(url, username, password);
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (SQLException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
        }
        return null;
    }
}

