/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.UserUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.ui.ModelMap;

public class MoveDataTestHelper {
    public void downloadTablesRowCountAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        File file;
        Context ctx = SHRContext.getInstance().getContext();
        Connection con_SHR = SHRDbConnectionTool.getSHRDBConnection(ctx);
        Connection con_EAS = EJBFactory.getQueryConnection((Context)ctx);
        ResultSet irs = this.getTableList(con_SHR);
        HttpSession session = request.getSession();
        String fileAbsolutePath = UserUtil.getUserTempDirAbsolutePath((HttpSession)session);
        String fileTempPath = UserUtil.getUserTempDir((HttpSession)session);
        String fileName = "SHR_EAS_\u8868\u8bb0\u5f55\u6570\u76ee\u5bf9\u6bd4\u8868.xlsx";
        String fileUrl = fileAbsolutePath + File.separator + fileName;
        String excelPath = request.getContextPath() + fileTempPath + File.separator + fileName;
        File filedir = new File(fileAbsolutePath);
        if (!filedir.exists()) {
            filedir.mkdirs();
        }
        if (!(file = new File(fileUrl)).exists()) {
            file.createNewFile();
        } else {
            file.delete();
            file.createNewFile();
        }
        XSSFWorkbook excelFile = this.generateExcelFile(irs, con_EAS, con_SHR);
        FileOutputStream out = new FileOutputStream(fileUrl);
        excelFile.write((OutputStream)out);
        HashMap<String, String> gridDataMap = new HashMap<String, String>();
        gridDataMap.put("url", excelPath);
        JSONUtils.writeJson((HttpServletResponse)response, gridDataMap);
    }

    public XSSFWorkbook generateExcelFile(ResultSet irs, Connection con_EAS, Connection con_SHR) throws SQLException, BOSException {
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        xssfWorkbook.createSheet("\u5bf9\u6bd4\u8868");
        xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").createRow(0);
        xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").getRow(0).createCell(0).setCellValue("\u8868\u540d");
        xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").getRow(0).createCell(1).setCellValue("EAS\u8bb0\u5f55\u6570\u91cf");
        xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").getRow(0).createCell(2).setCellValue("SHR\u8bb0\u5f55\u6570\u91cf");
        xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").getRow(0).createCell(3).setCellValue("\u662f\u5426\u5728\u8fc1\u79fb\u8868\u8303\u56f4\u5185");
        xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").getRow(0).createCell(4).setCellValue("\u662f\u5426\u9700\u8981\u6821\u5bf9");
        int i = 1;
        String tableName = "";
        ArrayList<String> tableArray = new ArrayList<String>();
        while (irs.next()) {
            tableName = irs.getString(1);
            xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").createRow(i);
            xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").getRow(i).createCell(0).setCellValue(tableName);
            tableArray.add(tableName.toUpperCase());
            ++i;
        }
        int piece = 0;
        StringBuffer sBuffer = new StringBuffer();
        for (int j = 0; j < tableArray.size(); ++j) {
            sBuffer.append((String)tableArray.get(j)).append(",");
            if (++piece < 50 && j != tableArray.size() - 1) continue;
            String tableNames = sBuffer.delete(sBuffer.length() - 1, sBuffer.length()).toString();
            sBuffer = new StringBuffer();
            ArrayList<Integer> easRowCount = this.getTablesRowCount(tableNames, con_EAS);
            ArrayList<Integer> shrRowCount = this.getTablesRowCount(tableNames, con_SHR);
            ArrayList<String> atMOveRange = this.getTableAtMoveRange(tableNames, con_EAS);
            int l = 0;
            for (int k = j + 2 - piece; k <= j + 1; ++k) {
                try {
                    xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").getRow(k).createCell(1).setCellValue((double)easRowCount.get(l).intValue());
                    xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").getRow(k).createCell(2).setCellValue((double)shrRowCount.get(l).intValue());
                    xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").getRow(k).createCell(3).setCellValue(atMOveRange.get(l));
                    xssfWorkbook.getSheet("\u5bf9\u6bd4\u8868").getRow(k).createCell(4).setCellValue(easRowCount.get(l) < shrRowCount.get(l) ? "\u662f" : "\u5426");
                    ++l;
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            piece = 0;
        }
        SHRDbConnectionTool.releasDBResource(con_EAS, null, null);
        SHRDbConnectionTool.releasDBResource(con_SHR, null, null);
        return xssfWorkbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getTableAtMoveRange(String tableNames, Connection con_EAS) {
        Statement state = null;
        ResultSet rs = null;
        ArrayList<String> res = new ArrayList<String>();
        String sql = tableNames.replaceAll(",", "' UNION ALL SELECT COUNT(*) FROM T_HR_SHRMvTableList WHERE FMVTABLENAME ='");
        sql = "SELECT COUNT(*) FROM T_HR_SHRMvTableList WHERE FMVTABLENAME = '" + sql + "'";
        try {
            state = con_EAS.createStatement();
            rs = state.executeQuery(sql);
            while (rs.next()) {
                if (rs.getInt(1) > 0) {
                    res.add("\u662f");
                    continue;
                }
                res.add("\u5426");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return res;
    }

    public ResultSet getTableList(Connection con_SHR) throws BOSException {
        ResultSet res_shr = null;
        try {
            Statement state = con_SHR.createStatement();
            if ("Microsoft SQL Server".equalsIgnoreCase(con_SHR.getMetaData().getDatabaseProductName())) {
                String querySQL = "select NAME from sysobjects where (name like ('T_HR%') or name like ('S_BS%') or name like ( 'T_ATS%') or name like ('T_BAS%')or name like ( 'T_BD%')or name like ( 'T_BS%')or name like ('T_FW%')or name like ( 'T_ORG%')or name like ( 'T_PF%')or name like ('T_PM%')or name like ('T_REC%')or name like ( 'T_RPTS%')or name like ( 'T_SHR%')or name like ( 'T_WFR%')) and type='U' order by NAME";
                res_shr = state.executeQuery(querySQL);
            } else if ("Oracle".equalsIgnoreCase(con_SHR.getMetaData().getDatabaseProductName())) {
                String querySQL = "select table_name from user_tables where (table_name like ('T_HR%') or table_name like ('S_BS%') or table_name like ( 'T_ATS%') or table_name like ('T_BAS%')or table_name like ( 'T_BD%')or table_name like ( 'T_BS%')or table_name like ('T_FW%')or table_name like ( 'T_ORG%')or table_name like ( 'T_PF%')or table_name like ('T_PM%')or table_name like ('T_REC%')or table_name like ( 'T_RPTS%')or table_name like ( 'T_SHR%')or table_name like ( 'T_WFR%'))order by table_name;";
                res_shr = state.executeQuery(querySQL);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return res_shr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> getTablesRowCount(String tableNames, Connection con) throws BOSException {
        Statement state = null;
        ResultSet rs = null;
        ArrayList<Integer> res = new ArrayList<Integer>();
        String sql = tableNames.replaceAll(",", " UNION ALL SELECT COUNT(*) FROM ");
        sql = "SELECT COUNT(*) FROM " + sql;
        try {
            state = con.createStatement();
            rs = state.executeQuery(sql);
            while (rs.next()) {
                res.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SHRDbConnectionTool.releasDBResource(null, state, rs);
                throw throwable;
            }
            SHRDbConnectionTool.releasDBResource(null, state, rs);
        }
        SHRDbConnectionTool.releasDBResource(null, state, rs);
        return res;
    }
}

