/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.DataCheckRecordCollection;
import com.kingdee.eas.hr.mvdt.DataCheckRecordFactory;
import com.kingdee.eas.hr.mvdt.DataCheckRecordInfo;
import com.kingdee.eas.hr.mvdt.util.ExcelExportUtil;
import com.kingdee.shr.hr.mvdt.handler.ISHRControlMoveDataHandler;
import com.kingdee.shr.hr.mvdt.service.syssetting.ISyssettingMvDataLevelUp;
import com.kingdee.shr.hr.mvdt.service.syssetting.SyssettingMvDataFactory;
import com.kingdee.shr.hr.mvdt.util.SHRControlMoveDataHelpUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ControlBaseDataMoveHandler
implements ISHRControlMoveDataHandler {
    private static Logger logger = Logger.getLogger(ControlBaseDataMoveHandler.class);
    public static final String SHR_BASE_ITEM_LEVELUP = "com.kingdee.shr.hr.mvdt.service.syssetting.SHRBaseItemSyssettingMvDataLevelUp";
    public static final String SHR_UIVIEW_FORM_LEVELUP = "com.kingdee.shr.hr.mvdt.service.syssetting.SHRUIViewFormSyssettingMvDataLevelUp";
    public static final String SHR_FILE_TEMPLATE_LEVELUP = "com.kingdee.shr.hr.mvdt.service.syssetting.SHRFileTemplateMvDataLevelUp";
    public static final String SHR_STRUCTURE_CONFIG_LEVELUP = "com.kingdee.shr.hr.mvdt.service.syssetting.StructureConfigMvDataLevelUp";
    public static final String SHR_LISTFILTER_SCHEME_LEVELUP = "com.kingdee.shr.hr.mvdt.service.syssetting.SHRListFilterAndSetSchemMvDataLevelUp";

    @Override
    public String moveData(Context ctx) throws BOSException, EASBizException, SQLException {
        ISyssettingMvDataLevelUp iSyssettingMvDataLevelUp = null;
        iSyssettingMvDataLevelUp = SyssettingMvDataFactory.getSHRBaseItemSyssettingMvDataLevelUp(ctx);
        this.doMoveData(ctx, iSyssettingMvDataLevelUp, SHR_BASE_ITEM_LEVELUP, "\u57fa\u7840\u8d44\u6599\u5347\u7ea7\u5931\u8d25\uff1a");
        iSyssettingMvDataLevelUp = SyssettingMvDataFactory.getSHRUIViewFormSyssettingMvDataLevelUp(ctx);
        this.doMoveData(ctx, iSyssettingMvDataLevelUp, SHR_UIVIEW_FORM_LEVELUP, "\u89c6\u56fe\u8868\u5355\u5347\u7ea7\u5931\u8d25\uff1a");
        iSyssettingMvDataLevelUp = SyssettingMvDataFactory.getSHRFileTemplateMvDataLevelUp(ctx);
        this.doMoveData(ctx, iSyssettingMvDataLevelUp, SHR_FILE_TEMPLATE_LEVELUP, "\u5bfc\u5165\u914d\u7f6e\u5347\u7ea7\u5931\u8d25\uff1a");
        iSyssettingMvDataLevelUp = SyssettingMvDataFactory.getStructureConfigMvDataLevelUp(ctx);
        this.doMoveData(ctx, iSyssettingMvDataLevelUp, SHR_STRUCTURE_CONFIG_LEVELUP, "\u7ed3\u6784\u914d\u7f6e\u5bf9\u5e94\u5143\u6570\u636e\u8c03\u6574\u5347\u7ea7\u5931\u8d25\uff1a");
        iSyssettingMvDataLevelUp = SyssettingMvDataFactory.getListFilterAndSetSchemMvDataLevelUp(ctx);
        this.doMoveData(ctx, iSyssettingMvDataLevelUp, SHR_LISTFILTER_SCHEME_LEVELUP, "\u5217\u8868\u8fc7\u6ee4\u65b9\u6848\u3001\u5217\u8868\u8bbe\u7f6e\u65b9\u6848\u5347\u7ea7\u5931\u8d25\uff1a");
        return null;
    }

    @Override
    public String beforeMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public ArrayList<HashMap<String, String>> exportFinishedReport(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    private String doMoveData(Context ctx, ISyssettingMvDataLevelUp iSyssettingMvDataLevelUp, String number, String preErrorMessage) throws BOSException, EASBizException, SQLException {
        try {
            if (!SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, number)) {
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, number, "moving");
                iSyssettingMvDataLevelUp.levelUp();
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, number, "finished");
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, number, preErrorMessage + e.getMessage());
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, number, preErrorMessage + e.getMessage());
            throw e;
        }
        return null;
    }

    @Override
    public void afterMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        DataCheckRecordCollection coll = DataCheckRecordFactory.getLocalInstance(ctx).getDataCheckRecordCollection("where type = 'BASECHECK'");
        if (null == coll || coll.size() <= 0) {
            SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "BASECHECK", 100, 100);
        } else {
            SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "BASECHECK", 100, 95);
        }
    }

    public SXSSFWorkbook getCheckReport(Context ctx) throws BOSException {
        JSONArray recordArray = new JSONArray();
        DataCheckRecordCollection coll = DataCheckRecordFactory.getLocalInstance(ctx).getDataCheckRecordCollection("where type = 'BASECHECK'");
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                DataCheckRecordInfo model = coll.get(i);
                HashMap<String, String> record = new HashMap<String, String>();
                record.put("number", model.getNumber());
                record.put("name", model.getName());
                record.put("checkresult", model.getCheckResult());
                record.put("guide", model.getRepairGuide());
                recordArray.add(record);
            }
        }
        ArrayList<LinkedHashMap<String, String>> titleList = new ArrayList<LinkedHashMap<String, String>>();
        LinkedHashMap<String, String> titleMap = new LinkedHashMap<String, String>();
        titleMap.put("title1", "\u57fa\u7840\u6570\u636e\u68c0\u67e5\u62a5\u544a");
        titleMap.put("title2", "");
        LinkedHashMap<String, String> headMap = new LinkedHashMap<String, String>();
        headMap.put("number", "\u7f16\u7801");
        headMap.put("name", "\u540d\u79f0");
        headMap.put("checkresult", "\u68c0\u67e5\u7ed3\u679c");
        headMap.put("guide", "\u6307\u5bfc\u610f\u89c1");
        titleList.add(titleMap);
        titleList.add(headMap);
        return ExcelExportUtil.exportExcel(titleList, recordArray, "\u544a\u77e5");
    }
}

