/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler.cmp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalFormulaCollection;
import com.kingdee.shr.compensation.CalFormulaFactory;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.ICalFormula;
import com.kingdee.shr.hr.mvdt.handler.cmp.AbstractMoveExecutor;
import com.kingdee.shr.hr.mvdt.handler.cmp.CmpMoveHelper;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class CalFormulaExecutor
extends AbstractMoveExecutor {
    private Map<String, String> expressMap;
    private Map<String, String> listItemMap;

    @Override
    public String execute(Context ctx) throws BOSException, EASBizException {
        this.expressMap = CmpMoveHelper.getCalFormulaConfigMapForExpress();
        this.listItemMap = CmpMoveHelper.getCalFormulaConfigMapForListItem();
        this.updateCalFormulaSp2ToSp5(ctx);
        this.updateCalFormula(ctx);
        return null;
    }

    @Override
    public int getExecutorIndex() {
        return 90;
    }

    private String updateCalFormulaSp2ToSp5(Context ctx) throws BOSException, EASBizException {
        String flag = "false";
        IRowSet r = DbUtil.executeQuery((Context)ctx, (String)"select flag from t_hr_sIsFixedCalformula");
        try {
            while (r.next()) {
                flag = r.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if ("true".equals(flag)) {
            return null;
        }
        LinkedHashMap<String, String> expressMapping = new LinkedHashMap<String, String>();
        expressMapping.put("T_ORG_Position_position", "T_ORG_Position_cmp_position");
        expressMapping.put("T_HR_EmpOrgRelation_empOrgRelation", "T_HR_EmpOrgRelation_cal_EPOR");
        expressMapping.put("T_HR_PersonPosition_cmp_pp", "T_HR_PersonPosition_cmp_pposition");
        expressMapping.put("T_HR_PersonPosition_pp", "T_HR_PersonPosition_cmp_pposition");
        expressMapping.put("T_HR_JobSubCategory_jobSubCategory", "T_HR_JobSubCategory_cmp_jobSubCategory");
        expressMapping.put("T_ORG_Admin_adminOrgUnit", "T_ORG_Admin_cmp_adminOrgUnit");
        expressMapping.put("T_ORG_JobCategory_jobCategory", "T_ORG_JobCategory_cmp_jobCategory");
        expressMapping.put("T_HR_AffairActionReason_affairActionReason", "T_HR_AffairActionReason_cmp_affairAR");
        expressMapping.put("T_HR_JobGrade_cmp_jobGrade", "T_HR_JobGrade_cmp_jobGre");
        expressMapping.put("T_BD_Regpermresidence_regresidence", "T_BD_Regpermresidence_cmp_regresidence");
        expressMapping.put("T_BD_HRPolitical_politicalFace", "T_BD_HRPolitical_cmp_politicalFace");
        expressMapping.put("T_HR_JobFamily_jobFamily", "T_HR_JobFamily_cmp_jobFamily");
        expressMapping.put("T_HR_BDEmployeeType_empType", "T_HR_BDEmployeeType_cmp_EmployeeType");
        expressMapping.put("T_BD_HRWed_wed", "T_BD_HRWed_cmp_wed");
        expressMapping.put("T_BD_HRFolk_folk", "T_BD_HRFolk_cmp_folk");
        LinkedHashMap<String, String> listItemMapping = new LinkedHashMap<String, String>();
        listItemMapping.put("~position", "~cmp_position");
        listItemMapping.put("~empOrgRelation", "~cal_EPOR");
        listItemMapping.put("~cmp_pp", "~cmp_pposition");
        listItemMapping.put("~pp", "~cmp_pposition");
        listItemMapping.put("~jobSubCategory", "~cmp_jobSubCategory");
        listItemMapping.put("~adminOrgUnit", "~cmp_adminOrgUnit");
        listItemMapping.put("~jobCategory", "~cmp_jobCategory");
        listItemMapping.put("~affairActionReason", "~cmp_affairAR");
        listItemMapping.put("~cmp_jobGrade", "~cmp_jobGre");
        listItemMapping.put("~regresidence", "~cmp_regresidence");
        listItemMapping.put("~politicalFace", "~cmp_politicalFace");
        listItemMapping.put("~jobFamily", "~cmp_jobFamily");
        listItemMapping.put("~empType", "~cmp_EmployeeType");
        listItemMapping.put("~wed", "~cmp_wed");
        listItemMapping.put("~folk", "~cmp_folk");
        ICalFormula iCalFormula = CalFormulaFactory.getLocalInstance((Context)ctx);
        CalFormulaCollection coll = iCalFormula.getCalFormulaCollection("select express,listItem");
        CoreBaseCollection cbc = new CoreBaseCollection();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            String value;
            String key;
            CalFormulaInfo info = coll.get(i);
            String express = info.getExpress();
            String listItem = info.getListItem();
            for (Map.Entry entry : expressMapping.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                if (StringUtils.isEmpty((String)express)) continue;
                express = express.replaceAll(key + "_", value + "_");
            }
            for (Map.Entry entry : listItemMapping.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                if (StringUtils.isEmpty((String)listItem)) continue;
                listItem = listItem.replaceAll(key + ";", value + ";");
                listItem = listItem.replaceFirst(key + "$", value);
            }
            info.setExpress(express);
            info.setListItem(listItem);
            cbc.add((CoreBaseInfo)info);
        }
        iCalFormula.updateBatchData(cbc);
        String updateSql = "update t_hr_sIsFixedCalformula set flag = 'true'";
        DbUtil.execute((Context)ctx, (String)updateSql);
        return null;
    }

    private String updateCalFormula(Context ctx) throws BOSException, EASBizException {
        CoreBaseCollection baseColl = new CoreBaseCollection();
        ICalFormula iCalFormula = CalFormulaFactory.getLocalInstance((Context)ctx);
        CalFormulaCollection coll = iCalFormula.getCalFormulaCollection("select id, express, listItem ");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            CalFormulaInfo info = coll.get(i);
            String express = info.getExpress();
            String listItem = info.getListItem();
            for (Map.Entry<String, String> entry : this.expressMap.entrySet()) {
                express = express.replaceAll(entry.getKey(), entry.getValue());
            }
            if (null != listItem && listItem.trim().length() > 0) {
                for (Map.Entry<String, String> entry : this.listItemMap.entrySet()) {
                    listItem = listItem.replaceAll(entry.getKey(), entry.getValue());
                }
                info.setListItem(listItem);
            }
            info.setExpress(express);
            baseColl.add((CoreBaseInfo)info);
        }
        iCalFormula.updateBatchData(baseColl);
        DbUtil.execute((Context)ctx, (String)"update T_HR_SCmpQueryConfig set FTableName = 'T_HR_HRJob' where FTableName = 'T_ORG_Job'");
        DbUtil.execute((Context)ctx, (String)"update T_HR_SCmpQueryConfig set FTableName = 'T_HR_HRJobCategory' where FTableName = 'T_ORG_JobCategory'");
        DbUtil.execute((Context)ctx, (String)"update T_HR_SCmpQueryConfig set FTableName = 'T_HR_HRJobSubCategory' where FTableName = 'T_HR_JobSubCategory'");
        DbUtil.execute((Context)ctx, (String)"update T_HR_SCmpQueryConfig set FTableName = 'T_HR_HRJobFamily' where FTableName = 'T_HR_JobFamily'");
        return null;
    }
}

