/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.util.StringCollUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.org.AdminOrgUnitVerCollection;
import com.kingdee.eas.hr.org.AdminOrgUnitVerFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.EnableStateEnum;
import com.kingdee.eas.hr.org.HROrgAdjSchmFactory;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.HrOrgBizException;
import com.kingdee.eas.hr.org.IAdminOrgUnitVer;
import com.kingdee.eas.hr.org.IsMoveEnum;
import com.kingdee.eas.hr.org.OrgAdjSchmVerException;
import com.kingdee.eas.hr.org.OrgPosVerAdjRecFactory;
import com.kingdee.eas.hr.org.OrgVerAdjEnum;
import com.kingdee.eas.hr.org.OrgVerAdjRecFactory;
import com.kingdee.eas.hr.org.OrgVerAdjRecInfo;
import com.kingdee.eas.hr.org.PersonVerInfo;
import com.kingdee.eas.hr.org.PositionVerAdjRecCollection;
import com.kingdee.eas.hr.org.PositionVerAdjRecFactory;
import com.kingdee.eas.hr.org.PositionVerCollection;
import com.kingdee.eas.hr.org.PositionVerFactory;
import com.kingdee.eas.hr.org.PositionVerInfo;
import com.kingdee.eas.hr.org.app.AbstractAdminOrgUnitVerControllerBean;
import com.kingdee.eas.hr.org.app.OrgPosVerAdjRecControllerBean;
import com.kingdee.eas.hr.org.app.PositionVerAdjRecControllerBean;
import com.kingdee.eas.hr.org.app.PositionVerControllerBean;
import com.kingdee.eas.hr.org.util.OrgAdjustUtil;
import com.kingdee.eas.hr.org.util.OrgVerAdjUtil;
import com.kingdee.eas.hr.org.util.SortCodeInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdminOrgUnitVerControllerBean
extends AbstractAdminOrgUnitVerControllerBean {
    private static final long serialVersionUID = 33133116910323737L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.AdminOrgUnitVerControllerBean");
    private static HashMap<String, String> moveAdminMap = new HashMap();

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdminOrgUnitVerInfo adminOrgVer = (AdminOrgUnitVerInfo)model;
        OrgAdjustUtil.orgNameRepeatCheck(ctx, adminOrgVer);
        boolean isCopayAddnew = false;
        if (adminOrgVer.getName().contains("copy")) {
            adminOrgVer.setName(adminOrgVer.getName().substring(4));
            isCopayAddnew = true;
        }
        String orgAdjSchm = adminOrgVer.getOrgAdjSchm().getId().toString();
        adminOrgVer.setIsSealUp(false);
        adminOrgVer.setIsAdminOrgUnit(true);
        AdminOrgUnitVerInfo parentOrg = adminOrgVer.getParent();
        AdminOrgUnitVerInfo maxSortCodeOrg = this._getMaxSortCode(ctx, parentOrg.getId().toString(), orgAdjSchm);
        if (maxSortCodeOrg == null) {
            adminOrgVer.setSortCode(parentOrg.getSortCode() + OrgVerAdjUtil.getOrgInitSortCode());
        } else if (maxSortCodeOrg.getSortCode() != null) {
            String preStr = maxSortCodeOrg.getSortCode().substring(0, maxSortCodeOrg.getSortCode().lastIndexOf("!"));
            String endStr = maxSortCodeOrg.getSortCode().substring(maxSortCodeOrg.getSortCode().lastIndexOf("!") + 1);
            adminOrgVer.setSortCode(preStr + "!" + OrgVerAdjUtil.getSortCodePlusIndex(endStr, 1));
        }
        if (adminOrgVer.getAdminOrgUnit() == null) {
            FullOrgUnitInfo fullOrgInfo = new FullOrgUnitInfo();
            AdminOrgUnitInfo orgUnit = new AdminOrgUnitInfo();
            orgUnit.setId(BOSUuid.create((BOSObjectType)fullOrgInfo.getBOSType()));
            adminOrgVer.setAdminOrgUnit(orgUnit);
            adminOrgVer.setOrgTypeStr(";Admin;");
        }
        if (adminOrgVer.getCU() == null) {
            HROrgAdjSchmInfo orgAdjSchem = HROrgAdjSchmFactory.getLocalInstance(ctx).getHROrgAdjSchmInfo((IObjectPK)new ObjectUuidPK(orgAdjSchm));
            adminOrgVer.setCU(orgAdjSchem.getCU());
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)adminOrgVer);
        adminOrgVer.setId(BOSUuid.read((String)pk.toString()));
        if (!isCopayAddnew) {
            OrgVerAdjRecFactory.getLocalInstance(ctx).adjRecForAddOrg(adminOrgVer);
        }
        String res_addNew = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.AddNew", (Locale)ctx.getLocale());
        String res_Org = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.AdminOrgUnit", (Locale)ctx.getLocale());
        OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptAdminRecorder(adminOrgVer, res_addNew + res_Org, OrgVerAdjEnum.ADDNEW);
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, adminOrgVer.getOrgAdjSchm().getId().toString());
        return pk;
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AdminOrgUnitVerInfo adminOrg = (AdminOrgUnitVerInfo)model;
        OrgAdjustUtil.orgNameRepeatCheck(ctx, adminOrg);
        OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeEditAdminOptRecorder(adminOrg);
        this.updateEditAdminOrgInfo(ctx, adminOrg);
        OrgVerAdjRecFactory.getLocalInstance(ctx).adjRecForEditOrg(adminOrg);
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, adminOrg.getOrgAdjSchm().getId().toString());
    }

    @Override
    protected void _move(Context ctx, Map movParam) throws BOSException, EASBizException {
        AdminOrgUnitVerInfo beforeMovOrg = (AdminOrgUnitVerInfo)movParam.get("movOrg");
        AdminOrgUnitVerInfo targetOrg = (AdminOrgUnitVerInfo)movParam.get("targetOrg");
        beforeMovOrg = this.getAdminOrgUnitVerInfo(ctx, beforeMovOrg);
        if ((targetOrg = this.getAdminOrgUnitVerInfo(ctx, targetOrg)).getLongNumber().indexOf(beforeMovOrg.getLongNumber()) >= 0 || beforeMovOrg.getId().equals((Object)targetOrg.getId())) {
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.ORG_MOVE_CIRCLE_ERROR);
        }
        if (targetOrg.isIsSealUp()) {
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.ORG_HASBEEN_SEALUP);
        }
        this.updateMoveAdminOrgVerInfo(ctx, beforeMovOrg, targetOrg);
        List orgSortList = (List)movParam.get("valList");
        if (orgSortList != null) {
            this._updateSortCode(ctx, orgSortList, true, null);
        }
        OrgVerAdjRecFactory.getLocalInstance(ctx).adjRecForMoveOrg(beforeMovOrg, targetOrg);
        OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeMoveAdminOptRecorder(beforeMovOrg, targetOrg);
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, beforeMovOrg.getOrgAdjSchm().getId().toString());
    }

    private void updateMoveAdminOrgVerInfo(Context ctx, AdminOrgUnitVerInfo beforeMovOrg, AdminOrgUnitVerInfo targetOrg) throws EASBizException, BOSException {
        PositionVerInfo positionVerInfo;
        String targetParentId;
        ObjectUuidPK pk = new ObjectUuidPK(beforeMovOrg.getId().toString());
        AdminOrgUnitVerInfo moveOrg = this.getAdminOrgUnitVerInfo(ctx, (IObjectPK)pk);
        AdminOrgUnitVerInfo oldParent = moveOrg.getParent();
        moveOrg.setParent(targetOrg);
        PositionVerAdjRecControllerBean positionVerAdjRecControllerBean = new PositionVerAdjRecControllerBean();
        OrgPosVerAdjRecControllerBean OrgPosVerAdjRecControllerBean2 = new OrgPosVerAdjRecControllerBean();
        ObjectUuidPK targetpk = new ObjectUuidPK(targetOrg.getId().toString());
        AdminOrgUnitVerInfo targetAdminOrg = this.getAdminOrgUnitVerInfo(ctx, (IObjectPK)targetpk);
        String adminId = moveOrg.getAdminOrgUnit().getId().toString();
        boolean isSysExist = AdminOrgUnitFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(adminId));
        AdminOrgUnitCollection adminColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("SELECT * WHERE ID = '" + adminId + "'");
        AdminOrgUnitInfo adminInfo = adminColl.get(0);
        String adminParentId = "";
        if (isSysExist) {
            adminParentId = adminInfo.getParent().getId().toString();
        }
        if (adminParentId.equals(targetParentId = targetAdminOrg.getAdminOrgUnit().getId().toString()) && isSysExist) {
            PositionVerAdjRecCollection PositionVerAdjRecColl;
            if (moveOrg.getResponPosition() != null && (PositionVerAdjRecColl = PositionVerAdjRecFactory.getLocalInstance(ctx).getPositionVerAdjRecCollection("SELECT * WHERE orgAdjSchm = '" + moveOrg.getOrgAdjSchm().getId().toString() + "' AND positionVer = '" + moveOrg.getResponPosition().getId().toString() + "'")).size() > 0) {
                PositionVerInfo positionVerInfo2 = positionVerAdjRecControllerBean.getPositionVerInfoById(ctx, moveOrg.getResponPosition().getId().toString());
                PositionCollection coll = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("SELECT * WHERE ID = '" + positionVerInfo2.getPosition().getId().toString() + "'");
                PositionInfo info = coll.get(0);
                PositionVerInfo verInfo = new PositionVerInfo();
                if (info.getParent() == null) {
                    positionVerInfo2.setParentPosition(null);
                } else {
                    PositionVerCollection positionVerColl = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection("SELECT * WHERE position.id = '" + info.getParent().getId().toString() + "' AND orgAdjSchm = '" + positionVerInfo2.getOrgAdjSchm().getId().toString() + "'");
                    verInfo = positionVerColl.get(0);
                    positionVerInfo2.setParentPosition(verInfo);
                }
                positionVerAdjRecControllerBean._adjRecForEditPosition(ctx, positionVerInfo2);
                OrgPosVerAdjRecControllerBean2._writeEditPosOptRecorder(ctx, positionVerInfo2);
                String updateSql = "UPDATE T_HR_PositionVer SET FParentPosition = '" + verInfo.getId().toString() + "' WHERE fOrgAdjSchm = '" + verInfo.getOrgAdjSchm().getId().toString() + "' AND FID = '" + positionVerInfo2.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        } else if (moveOrg.getResponPosition() != null && targetAdminOrg.getResponPosition() != null && (positionVerInfo = positionVerAdjRecControllerBean.getPositionVerInfoById(ctx, moveOrg.getResponPosition().getId().toString())).getParentPosition() != null && !positionVerInfo.getParentPosition().getId().toString().equals(targetAdminOrg.getResponPosition().getId().toString())) {
            PositionVerInfo targetAdminPositionVerInfo = positionVerAdjRecControllerBean.getPositionVerInfoById(ctx, targetAdminOrg.getResponPosition().getId().toString());
            positionVerInfo.setParentPosition(targetAdminPositionVerInfo);
            positionVerAdjRecControllerBean._adjRecForEditPosition(ctx, positionVerInfo);
            OrgPosVerAdjRecControllerBean2._writeEditPosOptRecorder(ctx, positionVerInfo);
            String updateSql = "UPDATE T_HR_PositionVer SET FParentPosition = '" + targetAdminPositionVerInfo.getId().toString() + "' WHERE fOrgAdjSchm = '" + targetAdminPositionVerInfo.getOrgAdjSchm().getId().toString() + "' AND FID = '" + positionVerInfo.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        super._update(ctx, (IObjectPK)pk, (IObjectValue)moveOrg);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isLeaf"));
        if (targetOrg.isIsLeaf()) {
            targetOrg.setIsLeaf(false);
            this.updatePartial(ctx, (CoreBaseInfo)targetOrg, sic);
        }
        if (!this.exists(ctx, "where parent.id='" + oldParent.getId() + "'")) {
            oldParent.setIsLeaf(true);
            this.updatePartial(ctx, (CoreBaseInfo)oldParent, sic);
        }
    }

    private void updateEditAdminOrgInfo(Context ctx, AdminOrgUnitVerInfo adminOrg) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(adminOrg.getId());
        AdminOrgUnitVerInfo oldAdminVerInfo = this.getAdminOrgUnitVerInfo(ctx, (IObjectPK)pk);
        adminOrg.setCU(oldAdminVerInfo.getCU());
        adminOrg.setParent(oldAdminVerInfo.getParent());
        adminOrg.setIsAdminOrgUnit(oldAdminVerInfo.isIsAdminOrgUnit());
        adminOrg.setAdminOrgUnit(oldAdminVerInfo.getAdminOrgUnit());
        super._update(ctx, (IObjectPK)pk, (IObjectValue)adminOrg);
    }

    @Override
    protected void _sealUp(Context ctx, AdminOrgUnitVerInfo adminOrgVerInfo, AdminOrgUnitVerInfo replaceOrgVerInfo) throws BOSException, EASBizException {
        adminOrgVerInfo = this.getAdminOrgUnitVerInfo(ctx, adminOrgVerInfo);
        this.checkCaseBeforeSealUp(ctx, adminOrgVerInfo);
        String orgAdjSchm = adminOrgVerInfo.getOrgAdjSchm().getId().toString();
        String updateSql = "update T_HR_AdminOrgUnitVer set fOrgStateType=?,FIsSealUp=? where fid=? and fOrgAdjSchm=?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{3, 1, adminOrgVerInfo.getId().toString(), orgAdjSchm});
        OrgVerAdjRecFactory.getLocalInstance(ctx).adjRecForSealUpOrg(adminOrgVerInfo);
        String Res_SealUP = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.SealUP", (Locale)ctx.getLocale());
        String Res_Org = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.AdminOrgUnit", (Locale)ctx.getLocale());
        OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptAdminRecorder(adminOrgVerInfo, Res_SealUP + Res_Org, OrgVerAdjEnum.SEALUP);
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, adminOrgVerInfo.getOrgAdjSchm().getId().toString());
    }

    @Override
    protected void _unSealUP(Context ctx, AdminOrgUnitVerInfo adminOrgVerInfo) throws BOSException, EASBizException {
        if ((adminOrgVerInfo = this.getAdminOrgUnitVerInfo(ctx, adminOrgVerInfo)).getParent() != null && adminOrgVerInfo.getParent().isIsSealUp()) {
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.PARENTORG_HAS_SEALUP);
        }
        String orgAdjSchm = adminOrgVerInfo.getOrgAdjSchm().getId().toString();
        String updateSql = "update T_HR_AdminOrgUnitVer set fOrgStateType=?,FIsSealUp=? where fid=? and fOrgAdjSchm=?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{2, 0, adminOrgVerInfo.getId().toString(), orgAdjSchm});
        OrgVerAdjRecFactory.getLocalInstance(ctx).adjRecForUnSealUpOrg(adminOrgVerInfo);
        String Res_Org = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.AdminOrgUnit", (Locale)ctx.getLocale());
        String Res_Un_SealUp = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.Un_SealUp", (Locale)ctx.getLocale());
        OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptAdminRecorder(adminOrgVerInfo, Res_Org + Res_Un_SealUp, OrgVerAdjEnum.UnSealUP);
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, adminOrgVerInfo.getOrgAdjSchm().getId().toString());
    }

    @Override
    protected void _deleteAdminOrgVerInfo(Context ctx, AdminOrgUnitVerInfo adminOrgVerInfo) throws BOSException, EASBizException {
        this.checkCaseBeforeDeleteOrg(ctx, adminOrgVerInfo);
        String Res_Removal = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.Removal", (Locale)ctx.getLocale());
        String Res_Org = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.AdminOrgUnit", (Locale)ctx.getLocale());
        String optDesc = Res_Removal + Res_Org;
        OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptAdminRecorder(adminOrgVerInfo, optDesc, OrgVerAdjEnum.Removal);
        String orgAdjSchm = adminOrgVerInfo.getOrgAdjSchm().getId().toString();
        String updateSql = "delete from T_HR_AdminOrgUnitVer where fid=? and fOrgAdjSchm=?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{adminOrgVerInfo.getId().toString(), orgAdjSchm});
        updateSql = "delete from T_HR_OrgVerAdjRec where fOrgVerId=? and fOrgAdjSchm=?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{adminOrgVerInfo.getId().toString(), orgAdjSchm});
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, adminOrgVerInfo.getOrgAdjSchm().getId().toString());
    }

    @Override
    protected AdminOrgUnitVerInfo _getAdminOrgInfo(Context ctx, AdminOrgUnitVerInfo adminOrgUnitVerInfo) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select isSealUp,name,orgAdjSchm.id,adminOrgUnit.id,adminOrgUnit.name ").append("where id='").append(adminOrgUnitVerInfo.getId()).append("'");
        AdminOrgUnitVerInfo beforeOrg = this.getAdminOrgUnitVerInfo(ctx, oql.toString());
        return beforeOrg;
    }

    private AdminOrgUnitVerInfo getAdminOrgUnitVerInfo(Context ctx, AdminOrgUnitVerInfo orgVerInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("sortCode"));
        sic.add(new SelectorItemInfo("displayName"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("isSealUp"));
        sic.add(new SelectorItemInfo("responPosition.*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.*"));
        sic.add(new SelectorItemInfo("orgAdjSchm.*"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.isSealUp"));
        sic.add(new SelectorItemInfo("parent.adminOrgUnit"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgVerInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("orgAdjSchm.id", (Object)orgVerInfo.getOrgAdjSchm().getId().toString()));
        view.setSelector(sic);
        view.setFilter(filter);
        AdminOrgUnitVerCollection col = this.getAdminOrgUnitVerCollection(ctx, view);
        return col.get(0);
    }

    @Override
    protected List _getSubNodes(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String selectNode = (String)paramMap.get("Current_SelectNode");
        String longNumber = (String)paramMap.get("longnumber");
        String orgAdjSchm = (String)paramMap.get("Current_OrgAdjSchm");
        String name = "fName_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,FSortCode,flongNumber,").append(name).append(" as fname").append(" from T_HR_AdminOrgUnitVer where fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and fLongNumber like '").append(longNumber).append("!%'").append(" and FParentID='").append(selectNode).append("' order by fSortCode asc,fLongNumber asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> valMap = null;
        ArrayList valList = new ArrayList();
        try {
            while (rs.next()) {
                valMap = new HashMap<String, String>();
                valMap.put("id", rs.getString("fid"));
                valMap.put("sortCode", rs.getString("fSortCode"));
                valMap.put("longNumber", rs.getString("flongNumber"));
                valMap.put("name", rs.getString("fname"));
                valList.add(valMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return valList;
    }

    @Override
    protected AdminOrgUnitVerInfo _getMaxSortCode(Context ctx, String orgVerId, String orgAdjSchm) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append(" select id,longNumber,sortCode where parent.id ='").append(orgVerId).append("'").append(" and orgAdjSchm='").append(orgAdjSchm).append("' order by sortCode desc");
        AdminOrgUnitVerCollection coll = this.getAdminOrgUnitVerCollection(ctx, oql.toString());
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    @Override
    protected boolean _isSystemAdminOrg(Context ctx, String adminOrgVerID) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select adminOrgUnit.id where id='").append(adminOrgVerID).append("'");
        AdminOrgUnitVerInfo adminOrgVer = this.getAdminOrgUnitVerInfo(ctx, oql.toString());
        return AdminOrgUnitFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(adminOrgVer.getAdminOrgUnit().getId().toString()));
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdminOrgUnitVerCollection coll;
        AdminOrgUnitVerInfo adminOrgVer = (AdminOrgUnitVerInfo)model;
        String orgAdjSchm = adminOrgVer.getOrgAdjSchm().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid where number='").append(adminOrgVer.getNumber()).append("' and orgAdjSchm='").append(orgAdjSchm).append("'");
        if (adminOrgVer.getId() != null) {
            sql.append(" and id<>'").append(adminOrgVer.getId()).append("'");
        }
        if ((coll = this.getAdminOrgUnitVerCollection(ctx, sql.toString())).size() > 0) {
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.EXIST_NUMBER_ERROR);
        }
    }

    @Override
    protected AdminOrgUnitVerInfo _getTopAdminVerLongNumberOfCU(Context ctx, CtrlUnitInfo cuInfo, HROrgAdjSchmInfo curOrgAdjSchm) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String number = cuInfo.getNumber();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append("select top 1  fid,fLongNumber,fnumber,fname_" + l + ",fisLeaf from T_HR_AdminOrgUnitVer ").append("where fcontrolunitid='").append(cuInfo.getId().toString()).append("'").append(" and flongNumber like '%").append(number).append("%'").append(" and FORGADJSCHM='").append(curOrgAdjSchm.getId()).append("' order by fLongNumber asc");
        if (curOrgAdjSchm.getIsMoved().equals((Object)IsMoveEnum.IS_MOVED)) {
            String tempStr = OrgVerAdjUtil.getReplaceHisTableSQL(sql.toString());
            sql = new StringBuffer(tempStr);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        AdminOrgUnitVerInfo adminInfo = null;
        try {
            if (rs.next()) {
                adminInfo = new AdminOrgUnitVerInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                adminInfo.setLongNumber(rs.getString("flongnumber"));
                adminInfo.setName(rs.getString("fname_" + l + ""));
                adminInfo.setNumber(rs.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminInfo;
    }

    @Override
    protected PersonVerInfo _getAdminJuridicalPerson(Context ctx, HROrgAdjSchmInfo orgAdjSchmInfo, String orgVerId) throws BOSException, EASBizException {
        PersonVerInfo person = new PersonVerInfo();
        String name = "fName_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select perVer.fid,perVer.").append(name).append(" from T_HR_AdminOrgUnitVerHis orgVer ").append(" left join T_HR_PersonVerHis perVer on FJuridicalPersonID=perVer.fid").append(" where orgVer.fOrgAdjSchm=? ").append(" and perVer.fOrgAdjSchm=? ").append(" and orgVer.fid=? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgAdjSchmInfo.getId().toString(), orgAdjSchmInfo.getId().toString(), orgVerId});
        try {
            if (rs.next()) {
                person.setId(BOSUuid.read((String)rs.getString("fid")));
                person.setName(rs.getString(name));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return person;
    }

    private void checkCaseBeforeSealUp(Context ctx, AdminOrgUnitVerInfo unitInfo) throws BOSException, EASBizException {
        IRowSet rs = null;
        String longNumber = unitInfo.getLongNumber();
        String orgAdjSchm = unitInfo.getOrgAdjSchm().getId().toString();
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("select fid from T_HR_AdminOrgUnitVer where flongNumber like '").append(longNumber).append("!%'").append(" and fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and fOrgStateType in (0,2)");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new OrgAdjSchmVerException(OrgAdjSchmVerException.ORG_SEALUP_ORGERROR);
            }
            sql = new StringBuffer();
            sql.append("select pos.fid from T_HR_PositionVer pos inner join T_HR_AdminOrgUnitVer org on org.fid=pos.FAdminOrgUnitID").append(" where pos.fOrgAdjSchm='").append(orgAdjSchm).append("' and org.fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and (org.fid='").append(unitInfo.getId()).append("'").append(" or org.flongNumber like '").append(longNumber).append("!%')").append(" and pos.fPosStateType in (1,3)");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new OrgAdjSchmVerException(OrgAdjSchmVerException.ORG_SEALUP_POSITIONERROR);
            }
            sql = new StringBuffer();
            sql.append("select per.fid from T_HR_PersonVer per inner join T_HR_BDEmployeeType et on per.FEmployeeTypeID=et.fid").append(" left join T_HR_AdminOrgUnitVer org on org.fid= per.fPersonDep").append(" where org.fid='").append(unitInfo.getId()).append("' and org.fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and per.fOrgAdjSchm='").append(orgAdjSchm).append("'");
            sql.append(" and et.FinService!=").append(2);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new EmployeeException(EmployeeException.ADMINHASPERSON);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, null, null);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, null, null);
    }

    private void checkCaseBeforeDeleteOrg(Context ctx, AdminOrgUnitVerInfo unitInfo) throws BOSException, EASBizException {
        IRowSet rs = null;
        unitInfo = this.getAdminOrgUnitVerInfo(ctx, unitInfo);
        String longNumber = unitInfo.getLongNumber();
        String orgAdjSchm = unitInfo.getOrgAdjSchm().getId().toString();
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("select fid from T_HR_AdminOrgUnitVer where flongNumber like '").append(longNumber).append("!%'").append(" and fOrgAdjSchm='").append(orgAdjSchm).append("'");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new OrgAdjSchmVerException(OrgAdjSchmVerException.ORG_DELETE_ORGERROR);
            }
            sql = new StringBuffer();
            sql.append("select pos.fid from T_HR_PositionVer pos inner join T_HR_AdminOrgUnitVer org on org.fid=pos.FAdminOrgUnitID").append(" where pos.fOrgAdjSchm='").append(orgAdjSchm).append("' and org.fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and (org.fid='").append(unitInfo.getId()).append("'").append(" or org.flongNumber like '").append(longNumber).append("!%')");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new OrgAdjSchmVerException(OrgAdjSchmVerException.ORG_DELETE_POSITIONERROR);
            }
            sql = new StringBuffer();
            sql.append("select per.fid from T_HR_AdminOrgUnitVer org left join T_HR_PersonVer per on org.fid= per.fPersonDep").append(" where org.fid='").append(unitInfo.getId()).append("' and org.fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and per.fOrgAdjSchm='").append(orgAdjSchm).append("'");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new OrgAdjSchmVerException(OrgAdjSchmVerException.ORG_DELETE_PERSONERROR);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, null, null);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, null, null);
    }

    @Override
    protected void _checkCaseBeforeSealUP(Context ctx, AdminOrgUnitVerInfo adminOrgVerInfo) throws BOSException {
    }

    @Override
    protected void _updateSortCode(Context ctx, List orgSortList, boolean needRecordAdjInfo, AdminOrgUnitVerInfo adminOrg) throws BOSException, EASBizException {
        String update = "UPDATE T_HR_AdminOrgUnitVer SET FSortCode = ? WHERE FID = ? and fOrgAdjSchm=?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        SortCodeInfo sortInfo2 = new SortCodeInfo();
        String orgAdjSchm = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(update);
            for (SortCodeInfo sortInfo2 : orgSortList) {
                orgAdjSchm = sortInfo2.getOrgAdjSchm();
                pstmt.setString(1, sortInfo2.getNewSortCode());
                pstmt.setString(2, sortInfo2.getId());
                pstmt.setString(3, sortInfo2.getOrgAdjSchm());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)pstmt, (Connection)conn);
        Statement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            for (SortCodeInfo sortInfo2 : orgSortList) {
                String longNumber = sortInfo2.getLongNumber();
                String oldSortCode = sortInfo2.getOldSortCode();
                String newSortCode = sortInfo2.getNewSortCode();
                int len = oldSortCode.length();
                StringBuffer updateChilds = new StringBuffer("UPDATE T_HR_AdminOrgUnitVer SET FSortCode = ");
                updateChilds.append("CONCAT('").append(newSortCode).append("', SUBSTRING(FSortCode, ").append(len + 1).append(", LEN(FSortCode)-").append(len).append(")) WHERE fOrgAdjSchm = '").append(orgAdjSchm).append("'").append(" and FLongNumber LIKE '").append(longNumber + "!%'");
                stmt.addBatch(updateChilds.toString());
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
        if (needRecordAdjInfo) {
            this.updateAdminOrgVerAdjBatch(ctx, orgSortList, orgAdjSchm, OrgVerAdjEnum.Sort);
        }
        if (adminOrg != null) {
            String Res_MoveOrgWithSameLevel = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.MoveOrgWithSameLevel", (Locale)ctx.getLocale());
            OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptAdminRecorder(adminOrg, Res_MoveOrgWithSameLevel, OrgVerAdjEnum.Sort);
        }
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, orgAdjSchm);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateAdminOrgVerAdjBatch(Context ctx, List orgSortList, String orgVerAdjSchm, OrgVerAdjEnum adjType) throws BOSException {
        Iterator iter = orgSortList.iterator();
        SortCodeInfo sortInfo = new SortCodeInfo();
        StringBuffer delAdjRecSql = new StringBuffer();
        delAdjRecSql.append("delete from T_HR_OrgVerAdjRec where fid in (").append("select rec.fid from T_HR_AdminOrgUnitVer org left join T_HR_OrgVerAdjRec rec ").append(" on org.fid=rec.fOrgVerId and rec.fOrgAdjSchm=org.fOrgAdjSchm").append(" where org.fOrgAdjSchm='").append(orgVerAdjSchm).append("'").append(" and rec.fAdjType=").append(adjType.getValue());
        StringBuffer conSql = new StringBuffer();
        conSql.append(" fOrgAdjSchm='").append(orgVerAdjSchm).append("'");
        int flag = 0;
        String id = null;
        while (iter.hasNext()) {
            sortInfo = (SortCodeInfo)iter.next();
            id = sortInfo.getId();
            if (flag == 0) {
                delAdjRecSql.append(" and (rec.fOrgVerId='").append(id).append("'");
                conSql.append(" and (fid='").append(id).append("'");
            } else {
                delAdjRecSql.append(" or rec.fOrgVerId='").append(id).append("'");
                conSql.append(" or fid='").append(id).append("'");
            }
            ++flag;
        }
        if (flag > 0) {
            delAdjRecSql.append("))");
            conSql.append(")");
        }
        Connection conn = null;
        PreparedStatement ps = null;
        Statement insertNewPs = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(delAdjRecSql.toString());
            ps.executeUpdate();
            Timestamp curTime = OrgVerAdjUtil.getTime();
            String timeStr = curTime.toString().substring(0, curTime.toString().lastIndexOf("."));
            String curUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into T_HR_OrgVerAdjRec(fid,fOrgVerId,fOrgAdjSchm,fAdjType,fEnableStatus,fCreatorID,fCreateTime,fLastUpdateTime,fLastUpdateUserID)").append(" select newbosid('27E1ED86'),fid,'").append(orgVerAdjSchm).append("',").append(adjType.getValue()).append(",0,'").append(curUser).append("',{ts'").append(timeStr).append("'},{ts'").append(timeStr).append("'},'").append(curUser).append("'").append(" from T_HR_AdminOrgUnitVer where ").append(conSql.toString());
            insertNewPs = conn.prepareStatement(insertSql.toString());
            insertNewPs.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
                catch (SQLDataException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, ps, (Connection)conn);
                if (insertNewPs == null) throw throwable;
                try {
                    insertNewPs.close();
                    throw throwable;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        if (insertNewPs == null) return;
        try {
            insertNewPs.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
    }

    private void doWithCodeRule(Context ctx, AdminOrgUnitVerInfo adminOrgVer) throws BOSException, EASBizException {
        String cuId;
        FullOrgUnitInfo tmpInfo;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo orgCu = adminOrgVer.getCU();
        if (orgCu == null) {
            orgCu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        }
        if (codingRuleManager.isExist((IObjectValue)(tmpInfo = new FullOrgUnitInfo()), cuId = orgCu.getId().toString())) {
            String rdNum = codingRuleManager.getNumber((IObjectValue)tmpInfo, cuId);
            adminOrgVer.setNumber(rdNum);
        }
    }

    @Override
    protected AdminOrgUnitVerInfo _getTopAdminVerLongNumberByAdminId(Context ctx, HROrgAdjSchmInfo curOrgAdjSchm) throws BOSException, EASBizException {
        String adminUrgUnitId = curOrgAdjSchm.getAdminOrgUnit().getId().toString();
        AdminOrgUnitVerInfo orgVerInfo = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerInfo("where orgAdjSchm.id = '" + curOrgAdjSchm.getId().toString() + "' and adminOrgUnit.id = '" + adminUrgUnitId + "'");
        String longNumber = orgVerInfo.getLongNumber();
        StringBuffer sql = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append("select top 1  fid,fLongNumber,fnumber,fname_" + l + ",fisLeaf from T_HR_AdminOrgUnitVer ").append("where FAdminOrgUnitID='").append(adminUrgUnitId).append("'").append(" and flongNumber like '%").append(longNumber).append("%'").append(" and FORGADJSCHM='").append(curOrgAdjSchm.getId()).append("' order by fLongNumber asc");
        if (curOrgAdjSchm.getIsMoved().equals((Object)IsMoveEnum.IS_MOVED)) {
            String tempStr = OrgVerAdjUtil.getReplaceHisTableSQL(sql.toString());
            sql = new StringBuffer(tempStr);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        AdminOrgUnitVerInfo adminInfo = null;
        try {
            if (rs.next()) {
                adminInfo = new AdminOrgUnitVerInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                adminInfo.setLongNumber(rs.getString("flongnumber"));
                adminInfo.setName(rs.getString("fname_" + l + ""));
                adminInfo.setNumber(rs.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminInfo;
    }

    @Override
    protected void _moveOtherCompany(Context ctx, Map movParam) throws BOSException, EASBizException {
        AdminOrgUnitVerInfo beforeMovOrg = (AdminOrgUnitVerInfo)movParam.get("movOrg");
        AdminOrgUnitVerInfo targetOrg = (AdminOrgUnitVerInfo)movParam.get("targetOrg");
        beforeMovOrg = this.getAdminOrgUnitVerInfo(ctx, beforeMovOrg);
        targetOrg = this.getAdminOrgUnitVerInfo(ctx, targetOrg);
        String schemeId = beforeMovOrg.getOrgAdjSchm().getId().toString();
        HROrgAdjSchmInfo curOrgAdjSchm = new HROrgAdjSchmInfo();
        curOrgAdjSchm.setId(BOSUuid.read((String)schemeId));
        if (targetOrg.getLongNumber().indexOf(beforeMovOrg.getLongNumber()) >= 0 || beforeMovOrg.getId().equals((Object)targetOrg.getId())) {
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.ORG_MOVE_CIRCLE_ERROR);
        }
        if (targetOrg.isIsSealUp()) {
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.ORG_HASBEEN_SEALUP);
        }
        ArrayList<String> orgList = new ArrayList<String>();
        try {
            moveAdminMap = new HashMap();
            int startLevel = beforeMovOrg.getLevel();
            String moveParentAdminVerID = targetOrg.getId().toString();
            String l = LocaleUtils.getShortCode((Context)ctx);
            String sql = "SELECT FID,FAdminOrgUnitID,FParentID,FLevel,FNAME_" + l + " FROM T_HR_AdminOrgUnitVer  WHERE FOrgAdjSchm = '" + beforeMovOrg.getOrgAdjSchm().getId().toString() + "' AND (FLongNumber like '" + beforeMovOrg.getLongNumber() + "!%' OR FLongNumber like '" + beforeMovOrg.getLongNumber() + "') AND FIsSealUp = 0 ORDER BY FLongNumber ASC";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String adminVerID = executeQuery.getString("FID");
                String parentID = executeQuery.getString("FParentID");
                String name = executeQuery.getString("FNAME_" + l + "");
                int level = executeQuery.getInt("FLevel");
                orgList.add(adminVerID);
                if (level == startLevel) {
                    this.addNewAdminOrgMove(ctx, schemeId, adminVerID, moveParentAdminVerID);
                    continue;
                }
                if (moveAdminMap.get(parentID) != null) {
                    this.addNewAdminOrgMove(ctx, schemeId, adminVerID, moveAdminMap.get(parentID));
                    continue;
                }
                throw new HrOrgBizException(HrOrgBizException.EXCEPTION7, new Object[]{name});
            }
            if (moveAdminMap.keySet().size() > 0 && "1".equals(moveAdminMap.get("revert"))) {
                moveAdminMap.remove("revert");
                String adminVerIds = StringCollUtil.convertSetToString(moveAdminMap.keySet());
                DbUtil.execute((Context)ctx, (String)("DELETE FROM T_HR_AdminOrgUnitVer WHERE FID in " + adminVerIds));
            }
            for (int i = orgList.size(); i > 0; --i) {
                String id = (String)orgList.get(i - 1);
                AdminOrgUnitVerInfo sealUpAdminOrgUnitVerInfo = new AdminOrgUnitVerInfo();
                sealUpAdminOrgUnitVerInfo.setId(BOSUuid.read((String)id));
                sealUpAdminOrgUnitVerInfo.setOrgAdjSchm(curOrgAdjSchm);
                if (!AdminOrgUnitVerFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(sealUpAdminOrgUnitVerInfo.getId().toString()))) continue;
                this._sealUp(ctx, sealUpAdminOrgUnitVerInfo, null);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addNewAdminOrgMove(Context ctx, String schemeId, String adminVerID, String targetAdminVerID) throws BOSException, EASBizException {
        AdminOrgUnitVerInfo targetAdminVerInfo = new AdminOrgUnitVerInfo();
        targetAdminVerInfo.setId(BOSUuid.read((String)targetAdminVerID));
        HROrgAdjSchmInfo curOrgAdjSchm = new HROrgAdjSchmInfo();
        curOrgAdjSchm.setId(BOSUuid.read((String)schemeId));
        String backAdminVerId = "";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT FBackAdminVerId,FORGVERID FROM T_HR_OrgVerAdjRec WHERE fOrgVerId = '" + adminVerID + "' AND FadjType = 27"));
            while (executeQuery.next()) {
                backAdminVerId = executeQuery.getString("FBackAdminVerId");
            }
            if (!backAdminVerId.equals("")) {
                IRowSet execute = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID FROM T_HR_AdminOrgUnitVer WHERE FID = '" + backAdminVerId + "' AND FParentID = '" + targetAdminVerID + "'"));
                if (execute.size() > 0) {
                    AdminOrgUnitVerInfo backAdminOrgUnitVerInfo = new AdminOrgUnitVerInfo();
                    backAdminOrgUnitVerInfo.setId(BOSUuid.read((String)backAdminVerId));
                    backAdminOrgUnitVerInfo.setOrgAdjSchm(curOrgAdjSchm);
                    this._unSealUP(ctx, backAdminOrgUnitVerInfo);
                    PositionVerControllerBean.positionAllMoveAdminToAdmin(ctx, schemeId, adminVerID, backAdminVerId);
                    moveAdminMap.put("revert", "1");
                    DbUtil.execute((Context)ctx, (String)("DELETE FROM T_HR_OrgVerAdjRec WHERE fOrgVerId = '" + adminVerID + "' AND fOrgAdjSchm = '" + schemeId + "' AND fAdjType = 27"));
                    if (moveAdminMap.get(adminVerID) == null) {
                        moveAdminMap.put(adminVerID, backAdminVerId);
                    }
                } else {
                    String updateUnitVerSql = "UPDATE T_HR_AdminOrgUnitVer SET FParentID = '" + targetAdminVerID + "' WHERE FID = '" + adminVerID + "'";
                    DbUtil.execute((Context)ctx, (String)updateUnitVerSql);
                    if (moveAdminMap.get(adminVerID) == null) {
                        moveAdminMap.put(adminVerID, adminVerID);
                    }
                }
            } else {
                String beforeMoveParentID = "";
                AdminOrgUnitVerInfo adminOrgUnitVerInfo = new AdminOrgUnitVerInfo();
                AdminOrgUnitVerCollection adminVerColl = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerCollection("select *,responPosition.* where id = '" + adminVerID + "'");
                for (int i = 0; i < adminVerColl.size(); ++i) {
                    adminOrgUnitVerInfo = adminVerColl.get(i);
                    beforeMoveParentID = adminOrgUnitVerInfo.getParent().getId().toString();
                }
                AdminOrgUnitVerInfo newAdminOrgUnitVerInfo = new AdminOrgUnitVerInfo();
                newAdminOrgUnitVerInfo = adminOrgUnitVerInfo;
                newAdminOrgUnitVerInfo.setId(BOSUuid.create((String)"F5751915"));
                newAdminOrgUnitVerInfo.setName("copy" + adminOrgUnitVerInfo.getName());
                newAdminOrgUnitVerInfo.setParent(targetAdminVerInfo);
                String autoNumber = this.getAutoAdminNumberAction(newAdminOrgUnitVerInfo, ctx);
                if (StringUtils.isEmpty((String)autoNumber)) {
                    autoNumber = "copy" + adminOrgUnitVerInfo.getNumber();
                }
                newAdminOrgUnitVerInfo.setNumber(autoNumber);
                newAdminOrgUnitVerInfo.setResponPosition(null);
                newAdminOrgUnitVerInfo.setAdminOrgUnit(null);
                IObjectPK pk = this._addnew(ctx, (IObjectValue)newAdminOrgUnitVerInfo);
                OrgVerAdjRecInfo orgVerAdjInfo = new OrgVerAdjRecInfo();
                orgVerAdjInfo.setOrgVer(newAdminOrgUnitVerInfo);
                orgVerAdjInfo.setOrgAdjSchm(newAdminOrgUnitVerInfo.getOrgAdjSchm());
                orgVerAdjInfo.setAdjType(OrgVerAdjEnum.ADMIN_COPY_ADDNEW);
                orgVerAdjInfo.setEnableStatus(EnableStateEnum.UNABLE);
                orgVerAdjInfo.setCU(newAdminOrgUnitVerInfo.getCU());
                orgVerAdjInfo.setBackAdminVerId(adminVerID);
                orgVerAdjInfo.setBeforeMovParentID(AdminOrgUnitVerControllerBean.getSysAdminIdByAdminVer(ctx, beforeMoveParentID));
                orgVerAdjInfo.setAfterMovParentID(AdminOrgUnitVerControllerBean.getSysAdminIdByAdminVer(ctx, targetAdminVerID));
                OrgVerAdjRecFactory.getLocalInstance(ctx).save((CoreBaseInfo)orgVerAdjInfo);
                PositionVerControllerBean.positionAllMoveAdminToAdmin(ctx, schemeId, adminVerID, pk.toString());
                String sql = "SELECT FPositionVer FROM T_HR_positionverAdjRec WHERE FOrgAdjSchm = '" + schemeId + "' AND FBackPositionVerId IN (SELECT FResponPositionID FROM T_HR_AdminOrgUnitVer WHERE FID = '" + adminVerID + "')";
                IRowSet resExecuteQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (resExecuteQuery.next()) {
                    String newResPositionID = resExecuteQuery.getString("FPositionVer");
                    DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_AdminOrgUnitVer SET FResponPositionID = '" + newResPositionID + "' WHERE FID = '" + pk.toString() + "'"));
                }
                if (moveAdminMap.get(adminVerID) == null) {
                    moveAdminMap.put(adminVerID, pk.toString());
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static String getSysAdminIdByAdminVer(Context ctx, String adminVerID) throws BOSException {
        String adminOrgID = "";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT FAdminOrgUnitID FROM T_HR_AdminOrgUnitVer WHERE FID = '" + adminVerID + "'"));
            while (executeQuery.next()) {
                adminOrgID = executeQuery.getString("FAdminOrgUnitID");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return adminOrgID;
    }

    protected String getAutoAdminNumberAction(AdminOrgUnitVerInfo verInfo, Context ctx) throws BOSException, EASBizException {
        String number;
        block9: {
            IFullOrgUnit iFullOrgUnit;
            IAdminOrgUnitVer iAdminOrgUnitVer;
            ICodingRuleManager iCodingRuleManager;
            AdminOrgUnitVerInfo parentVer;
            block10: {
                int count;
                String verSql;
                FullOrgUnitInfo fullOrgUnitInfo;
                String mainOrgID;
                AdminOrgUnitInfo parentAdminOrg;
                block11: {
                    number = "";
                    if (verInfo.getParent() == null || verInfo.getParent().getId() == null) break block9;
                    parentVer = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerInfo((IObjectPK)new ObjectUuidPK(verInfo.getParent().getId().toString()));
                    iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    iAdminOrgUnitVer = AdminOrgUnitVerFactory.getLocalInstance(ctx);
                    iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                    parentAdminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentVer.getAdminOrgUnit().getId()));
                    if (parentAdminOrg == null) break block10;
                    mainOrgID = parentAdminOrg.getCU().getId().toString();
                    fullOrgUnitInfo = new FullOrgUnitInfo();
                    AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
                    verSql = "select id where orgAdjSchm = '" + parentVer.getOrgAdjSchm().getId().toString() + "' and number='";
                    count = 0;
                    if (!iCodingRuleManager.isExist((IObjectValue)adminOrg, mainOrgID)) break block11;
                    adminOrg.setCompany(parentAdminOrg.getCompany());
                    adminOrg.setParent(parentAdminOrg);
                    if (verInfo.getUnitLayerType() != null && verInfo.getUnitLayerType().getId() != null) {
                        OrgUnitLayerTypeInfo unitLayerType = OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx).getOrgUnitLayerTypeInfo((IObjectPK)new ObjectUuidPK(verInfo.getUnitLayerType().getId()));
                        adminOrg.setUnitLayerType(unitLayerType);
                    }
                    number = iCodingRuleManager.getNonbreakNumber((IObjectValue)adminOrg, mainOrgID);
                    while (iFullOrgUnit.exists("select id where number='" + number + "'") || iAdminOrgUnitVer.exists(verSql + number + "'")) {
                        number = iCodingRuleManager.getNonbreakNumber((IObjectValue)adminOrg, mainOrgID);
                        if (++count <= 1000) continue;
                        throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
                    }
                    break block9;
                }
                if (!iCodingRuleManager.isExist((IObjectValue)fullOrgUnitInfo, mainOrgID)) break block9;
                FullOrgUnitInfo parentOrgInfo = new FullOrgUnitInfo();
                parentOrgInfo.setNumber(parentAdminOrg.getNumber());
                parentOrgInfo.setName(parentAdminOrg.getName());
                parentOrgInfo.setId(parentAdminOrg.getId());
                fullOrgUnitInfo.setParent(parentOrgInfo);
                number = iCodingRuleManager.getNonbreakNumber((IObjectValue)fullOrgUnitInfo, mainOrgID);
                while (iFullOrgUnit.exists(" select id where number='" + number + "'") || iAdminOrgUnitVer.exists(verSql + number + "'")) {
                    number = iCodingRuleManager.getNonbreakNumber((IObjectValue)fullOrgUnitInfo, mainOrgID);
                    if (++count <= 1000) continue;
                    throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
                }
                break block9;
            }
            String mainOrgID = parentVer.getCU().getId().toString();
            FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
            AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
            String verSql = "select id where orgAdjSchm = '" + parentVer.getOrgAdjSchm().getId().toString() + "' and number='";
            int count = 0;
            if (iCodingRuleManager.isExist((IObjectValue)adminOrg, mainOrgID)) {
                AdminOrgUnitInfo parent = new AdminOrgUnitInfo();
                parent.setName(parentVer.getName());
                parent.setNumber(parentVer.getNumber());
                adminOrg.setParent(parent);
                if (verInfo.getUnitLayerType() != null && verInfo.getUnitLayerType().getId() != null) {
                    OrgUnitLayerTypeInfo unitLayerType = OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx).getOrgUnitLayerTypeInfo((IObjectPK)new ObjectUuidPK(verInfo.getUnitLayerType().getId()));
                    adminOrg.setUnitLayerType(unitLayerType);
                }
                number = iCodingRuleManager.getNonbreakNumber((IObjectValue)adminOrg, mainOrgID);
                while (iFullOrgUnit.exists("select id where number='" + number + "'") || iAdminOrgUnitVer.exists(verSql + number + "'")) {
                    number = iCodingRuleManager.getNonbreakNumber((IObjectValue)adminOrg, mainOrgID);
                    if (++count <= 1000) continue;
                    throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
                }
            } else if (iCodingRuleManager.isExist((IObjectValue)fullOrgUnitInfo, mainOrgID)) {
                FullOrgUnitInfo parentOrgInfo = new FullOrgUnitInfo();
                parentOrgInfo.setNumber(parentVer.getNumber());
                parentOrgInfo.setName(parentVer.getName());
                fullOrgUnitInfo.setParent(parentOrgInfo);
                number = iCodingRuleManager.getNonbreakNumber((IObjectValue)fullOrgUnitInfo, mainOrgID);
                while (iFullOrgUnit.exists(" select id where number='" + number + "'") || iAdminOrgUnitVer.exists(verSql + number + "'")) {
                    number = iCodingRuleManager.getNonbreakNumber((IObjectValue)fullOrgUnitInfo, mainOrgID);
                    if (++count <= 1000) continue;
                    throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
                }
            }
        }
        return number;
    }
}

