/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.org.AdminOrgUnitVerCollection;
import com.kingdee.eas.hr.org.AdminOrgUnitVerFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.EnableStateEnum;
import com.kingdee.eas.hr.org.HROrgAdjSchmCollection;
import com.kingdee.eas.hr.org.HROrgAdjSchmFactory;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.IPositionVer;
import com.kingdee.eas.hr.org.OrgPosVerAdjRecFactory;
import com.kingdee.eas.hr.org.OrgVerAdjEnum;
import com.kingdee.eas.hr.org.PersonVerAdjRecCollection;
import com.kingdee.eas.hr.org.PersonVerAdjRecFactory;
import com.kingdee.eas.hr.org.PersonVerAdjRecInfo;
import com.kingdee.eas.hr.org.PersonVerCollection;
import com.kingdee.eas.hr.org.PersonVerFactory;
import com.kingdee.eas.hr.org.PersonVerInfo;
import com.kingdee.eas.hr.org.PositionVerCollection;
import com.kingdee.eas.hr.org.PositionVerFactory;
import com.kingdee.eas.hr.org.PositionVerInfo;
import com.kingdee.eas.hr.org.app.AbstractPersonVerControllerBean;
import com.kingdee.eas.hr.org.util.OrgVerAdjUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonVerControllerBean
extends AbstractPersonVerControllerBean {
    private static final long serialVersionUID = 281796336131383727L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.PersonVerControllerBean");

    @Override
    protected void _movePersonByPosMove(Context ctx, PositionVerInfo posVerInfo, AdminOrgUnitVerInfo orgVerInfo) throws BOSException, EASBizException {
        PersonVerCollection personVerList = new PersonVerCollection();
        PersonVerAdjRecCollection personVerAdjList = new PersonVerAdjRecCollection();
        try {
            PersonVerAdjRecInfo personVerAdj = null;
            PersonVerInfo personver = null;
            String selectSql = "select FID,FPersonDep from T_HR_PersonVer where fPrimaryPosition=? and fOrgAdjSchm=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{posVerInfo.getId().toString(), posVerInfo.getOrgAdjSchm().getId().toString()});
            String personVerId = null;
            String personDepId = null;
            while (rs.next()) {
                personVerId = rs.getString("FID");
                personDepId = rs.getString("FPersonDep");
                personver = new PersonVerInfo();
                personver.setId(BOSUuid.read((String)personVerId));
                personver.setPersonDep(orgVerInfo);
                personver.setOrgAdjSchm(posVerInfo.getOrgAdjSchm());
                personver.setPrimaryPosition(posVerInfo);
                personVerList.add(personver);
                personVerAdj = new PersonVerAdjRecInfo();
                personVerAdj.setPersonVer(personver);
                personVerAdj.setOrgAdjSchm(posVerInfo.getOrgAdjSchm());
                personVerAdj.setBeforeAdjOrg(personDepId);
                personVerAdj.setAfterAdjOrg(orgVerInfo.getId().toString());
                personVerAdj.setBeforeAdjPos(posVerInfo.getId().toString());
                personVerAdj.setAfterAdjPos(posVerInfo.getId().toString());
                personVerAdj.setIsPrimaryAdj(1);
                personVerAdj.setEnableStatus(EnableStateEnum.UNABLE);
                personVerAdj.setAdjType(OrgVerAdjEnum.MOVE);
                personVerAdjList.add(personVerAdj);
            }
        }
        catch (SQLDataException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (personVerList.size() > 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("personVerList", (Object)personVerList);
            paramMap.put("personVerAdjList", (Object)personVerAdjList);
            paramMap.put("notDisplayOpt", new Boolean(false));
            this.move(ctx, paramMap);
        }
    }

    @Override
    protected void _move(Context ctx, Map paramMap) throws BOSException, EASBizException {
        PersonVerCollection personVerCol = (PersonVerCollection)((Object)paramMap.get("personVerList"));
        PersonVerAdjRecCollection personVerAdjRecCol = (PersonVerAdjRecCollection)((Object)paramMap.get("personVerAdjList"));
        String personIdStr = OrgVerAdjUtil.convertColToString((IObjectCollection)personVerCol);
        String orgAdjSchm = personVerCol.get(0).getOrgAdjSchm().getId().toString();
        PersonVerCollection beforeMovCol = null;
        PersonVerCollection afterMovCol = null;
        beforeMovCol = personVerCol.get(0).getPrimaryPosition() != null ? this.getPosAndAdminInfo(ctx, personIdStr, orgAdjSchm) : this.getNoPosAndAdminInfo(ctx, personIdStr, orgAdjSchm);
        Connection conn = null;
        PreparedStatement updateBatchPs = null;
        try {
            PersonVerAdjRecFactory.getLocalInstance(ctx).adjRecForMove(personVerCol, personVerAdjRecCol);
            Timestamp currentTime = OrgVerAdjUtil.getTime();
            UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update T_HR_PersonVer set fPersonDep=?,fPrimaryPosition=?").append(",flastupdatetime=?,flastupdateuserID=? where fid=? and fOrgAdjSchm=?");
            updateBatchPs = conn.prepareStatement(updateSql.toString());
            PersonVerInfo personVer = null;
            int size = personVerCol.size();
            for (int i = 0; i < size; ++i) {
                personVer = personVerCol.get(i);
                updateBatchPs.setString(1, personVer.getPersonDep().getId().toString());
                if (personVer.getPrimaryPosition() != null) {
                    updateBatchPs.setString(2, personVer.getPrimaryPosition().getId().toString());
                } else {
                    updateBatchPs.setString(2, null);
                }
                updateBatchPs.setTimestamp(3, currentTime);
                updateBatchPs.setString(4, curUser.getId().toString());
                updateBatchPs.setString(5, personVer.getId().toString());
                updateBatchPs.setString(6, personVer.getOrgAdjSchm().getId().toString());
                updateBatchPs.addBatch();
            }
            updateBatchPs.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, updateBatchPs, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)updateBatchPs, (Connection)conn);
        afterMovCol = personVerCol.get(0).getPrimaryPosition() != null ? this.getPosAndAdminInfo(ctx, personIdStr, orgAdjSchm) : this.getNoPosAndAdminInfo(ctx, personIdStr, orgAdjSchm);
        Boolean notDisplayOpt = (Boolean)paramMap.get("notDisplayOpt");
        if (notDisplayOpt == null) {
            OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptPersonRecorder(beforeMovCol, afterMovCol, orgAdjSchm);
        }
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, orgAdjSchm);
    }

    protected void _moveByPosition(Context ctx, String schemeId, String personVerId, String targetPositionVerId, boolean isPrimary) throws BOSException, EASBizException {
        PersonVerInfo personver = PersonVerFactory.getLocalInstance(ctx).getPersonVerInfo((IObjectPK)new ObjectUuidPK(personVerId));
        HROrgAdjSchmInfo curOrgAdjSchm = new HROrgAdjSchmInfo();
        curOrgAdjSchm.setId(BOSUuid.read((String)schemeId));
        IPositionVer iPositionVer = PositionVerFactory.getLocalInstance(ctx);
        PositionVerInfo targetPos = iPositionVer.getPositionVerInfo("select id, adminOrgUnit.id where id ='" + targetPositionVerId + "'");
        PersonVerAdjRecCollection personVerAdjList = new PersonVerAdjRecCollection();
        PersonVerAdjRecInfo personVerAdj = new PersonVerAdjRecInfo();
        personVerAdj.setPersonVer(personver);
        personVerAdj.setOrgAdjSchm(curOrgAdjSchm);
        personVerAdj.setBeforeAdjOrg(personver.getPersonDep().getId().toString());
        personVerAdj.setBeforeAdjPos(personver.getPrimaryPosition().getId().toString());
        personVerAdj.setAfterAdjPos(targetPos.getId().toString());
        personVerAdj.setAfterAdjOrg(targetPos.getAdminOrgUnit().getId().toString());
        personVerAdj.setIsPrimaryAdj(1);
        personVerAdj.setAdjType(OrgVerAdjEnum.PERSON_TRANSFER);
        personVerAdj.setEnableStatus(EnableStateEnum.UNABLE);
        personVerAdjList.add(personVerAdj);
        PersonVerCollection personVerList = new PersonVerCollection();
        personver.setOrgAdjSchm(curOrgAdjSchm);
        personver.setPrimaryPosition(targetPos);
        personver.setPersonDep(targetPos.getAdminOrgUnit());
        personVerList.add(personver);
        HashMap<String, AbstractObjectCollection> paramMap = new HashMap<String, AbstractObjectCollection>();
        paramMap.put("personVerList", personVerList);
        paramMap.put("personVerAdjList", personVerAdjList);
        PersonVerFactory.getLocalInstance(ctx).move(paramMap);
    }

    private PersonVerCollection getPosAndAdminInfo(Context ctx, String personIdStr, String orgAdjSchm) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name,number,personDep.id,personDep.name,personDep.number,").append("primaryPosition.id,primaryPosition.name,primaryPosition.number ").append(" where id in (").append(personIdStr).append(")").append(" and orgAdjSchm='").append(orgAdjSchm).append("'").append(" and personDep.orgAdjSchm='").append(orgAdjSchm).append("'").append(" and primaryPosition.orgAdjSchm='").append(orgAdjSchm).append("'").append(" order by id asc");
        return this.getPersonVerCollection(ctx, oql.toString());
    }

    private PersonVerCollection getNoPosAndAdminInfo(Context ctx, String personIdStr, String orgAdjSchm) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name,number,personDep.id,personDep.name,personDep.number").append(" where id in (").append(personIdStr).append(")").append(" and orgAdjSchm='").append(orgAdjSchm).append("'").append(" and personDep.orgAdjSchm='").append(orgAdjSchm).append("'").append(" order by id asc");
        return this.getPersonVerCollection(ctx, oql.toString());
    }

    public void _movePersonNoPrimary(Context ctx, String schemeId, PositionVerInfo newPositionVerInfo, String positionVerId, String targetOrgVerId, boolean isNeedAddnew) throws BOSException, EASBizException {
        try {
            HROrgAdjSchmInfo curOrgAdjSchm = new HROrgAdjSchmInfo();
            curOrgAdjSchm.setId(BOSUuid.read((String)schemeId));
            String positionId = "";
            PositionVerCollection positionVerCollection = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection("SELECT * WHERE id = '" + positionVerId + "'");
            if (positionVerCollection.size() > 0) {
                positionId = positionVerCollection.get(0).getPosition().getId().toString();
            }
            String adminId = "";
            String adminName = "";
            String adminNumber = "";
            AdminOrgUnitVerCollection adminOrgUnitVerCollection = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerCollection("SELECT * WHERE id = '" + targetOrgVerId + "'");
            if (adminOrgUnitVerCollection.size() > 0) {
                adminId = adminOrgUnitVerCollection.get(0).getAdminOrgUnit().getId().toString();
                adminName = adminOrgUnitVerCollection.get(0).getAdminOrgUnit().getName();
                adminNumber = adminOrgUnitVerCollection.get(0).getAdminOrgUnit().getNumber();
            }
            String l = LocaleUtils.getShortCode((Context)ctx);
            String getNoPrimarySql = "SELECT personVer.FID AS personVerId,personVer.FPERSONID AS personId, personVer.FNAME_" + l + " as personName,personVer.FNUMBER as personNumber, beforeAdmin.FID as beforeAdminId, beforeAdmin.FNAME_" + l + " as beforeAdminName, beforeAdmin.FNUMBER as beforeAdminNumber, beforePosition.FID as beforePositionId, beforePosition.FNAME_" + l + " as beforePositionName, beforePosition.FNUMBER as beforePositionNumber, bizDefine.FBIZDEFINETYPE as bizDefineType FROM T_HR_PersonVer personVer LEFT JOIN T_HR_EmpOrgRelation EmpOrg ON personVer.FPERSONID = EmpOrg.FPERSONID  LEFT JOIN T_HR_HRBizDefine bizDefine ON EmpOrg.FACTIONID = bizdefine.FID  LEFT JOIN T_ORG_ADMIN beforeAdmin ON EmpOrg.FADMINORGID = beforeAdmin.FID  LEFT JOIN T_ORG_POSITION beforePosition ON EmpOrg.FPOSITIONID = beforePosition.FID  WHERE personVer.FORGADJSCHM = '" + schemeId + "' AND EmpOrg.FASSIGNTYPE = 0 AND EmpOrg.FLEFFDT = {ts'2199-12-31'} AND EmpOrg.FISINNER = 1 AND beforePosition.FID = '" + positionId + "'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)getNoPrimarySql);
            while (executeQuery.next()) {
                String personVerId = executeQuery.getString("personVerId");
                String personId = executeQuery.getString("personId");
                String personName = executeQuery.getString("personName");
                String personNumber = executeQuery.getString("personNumber");
                String beforeAdminId = executeQuery.getString("beforeAdminId");
                String beforeAdminName = executeQuery.getString("beforeAdminName");
                String beforeAdminNumber = executeQuery.getString("beforeAdminNumber");
                String beforePositionName = executeQuery.getString("beforePositionName");
                String beforePositionId = executeQuery.getString("beforePositionId");
                String beforePositionNumber = executeQuery.getString("beforePositionNumber");
                int bizDefineType = executeQuery.getInt("bizDefineType");
                DbUtil.execute((Context)ctx, (String)("DELETE FROM T_HR_PersonVerAdjRec WHERE FISPRIMARYADJ = 0 AND FPERSONVER = '" + personVerId + "' AND fAfterAdjPos = '" + beforePositionId + "' AND fOrgAdjSchm = '" + schemeId + "' AND fAdjType = 23"));
                DbUtil.execute((Context)ctx, (String)("DELETE FROM T_HR_PersonVerAdjRec WHERE FISPRIMARYADJ = 0 AND FPERSONVER = '" + personVerId + "' AND fAfterAdjPos = '" + newPositionVerInfo.getPosition().getId().toString() + "' AND fOrgAdjSchm = '" + schemeId + "' AND fAdjType = 24"));
                PersonVerInfo personver = PersonVerFactory.getLocalInstance(ctx).getPersonVerInfo((IObjectPK)new ObjectUuidPK(personVerId));
                PersonVerAdjRecInfo personVerAdj = new PersonVerAdjRecInfo();
                personVerAdj.setPersonVer(personver);
                personVerAdj.setOrgAdjSchm(curOrgAdjSchm);
                personVerAdj.setBeforeAdjOrg(beforeAdminId);
                personVerAdj.setBeforeAdjPos(beforePositionId);
                personVerAdj.setAfterAdjPos(beforePositionId);
                personVerAdj.setAfterAdjOrg(beforeAdminId);
                personVerAdj.setIsPrimaryAdj(0);
                if (bizDefineType == 9 || bizDefineType == 15) {
                    personVerAdj.setAdjType(OrgVerAdjEnum.PERSON_TRANSFER_END);
                } else {
                    personVerAdj.setAdjType(OrgVerAdjEnum.PERSON_OTHERJOB_END);
                }
                personVerAdj.setEnableStatus(EnableStateEnum.UNABLE);
                String description = "";
                description = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label6", (Locale)ctx.getLocale()), personName, personNumber, beforeAdminName, beforeAdminNumber, beforePositionName, beforePositionNumber);
                personVerAdj.setDescription(description);
                PersonVerAdjRecFactory.getLocalInstance(ctx).save((CoreBaseInfo)personVerAdj);
                if (!isNeedAddnew) continue;
                personVerAdj = new PersonVerAdjRecInfo();
                personVerAdj.setPersonVer(personver);
                personVerAdj.setOrgAdjSchm(curOrgAdjSchm);
                personVerAdj.setBeforeAdjOrg(beforeAdminId);
                personVerAdj.setBeforeAdjPos(beforePositionId);
                personVerAdj.setAfterAdjPos(newPositionVerInfo.getPosition().getId().toString());
                personVerAdj.setAfterAdjOrg(adminId);
                personVerAdj.setIsPrimaryAdj(0);
                if (bizDefineType == 9 || bizDefineType == 15) {
                    personVerAdj.setAdjType(OrgVerAdjEnum.PERSON_TRANSFER_ADDNEW);
                } else {
                    personVerAdj.setAdjType(OrgVerAdjEnum.PERSON_OTHERJOB_ADDNEW);
                }
                personVerAdj.setEnableStatus(EnableStateEnum.UNABLE);
                description = "";
                description = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label7", (Locale)ctx.getLocale()), personName, personNumber, adminName, adminNumber, newPositionVerInfo.getPosition().getName(), newPositionVerInfo.getPosition().getNumber());
                personVerAdj.setDescription(description);
                PersonVerAdjRecFactory.getLocalInstance(ctx).save((CoreBaseInfo)personVerAdj);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void _personNoPrimaryEnd(Context ctx, String schemeId, String personVerId, String targetPositionVerId) throws BOSException, EASBizException {
        try {
            String positionId = "";
            String personId = "";
            PositionVerCollection positionVerCollection = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection("SELECT * WHERE id = '" + targetPositionVerId + "'");
            if (positionVerCollection.size() > 0) {
                positionId = positionVerCollection.get(0).getPosition().getId().toString();
            }
            DbUtil.execute((Context)ctx, (String)("DELETE FROM T_HR_PersonVerAdjRec WHERE FISPRIMARYADJ = 0 AND FPERSONVER = '" + personVerId + "' AND FORGADJSCHM = '" + schemeId + "' AND fAfterAdjPos = '" + positionId + "'"));
            PersonVerCollection personVerCollection = PersonVerFactory.getLocalInstance(ctx).getPersonVerCollection("SELECT * WHERE id = '" + personVerId + "'");
            PersonVerInfo personVerInfo = new PersonVerInfo();
            if (personVerCollection.size() > 0) {
                personVerInfo = personVerCollection.get(0);
                personId = personVerInfo.getPerson().getId().toString();
            }
            HROrgAdjSchmCollection hROrgAdjSchmCollection = HROrgAdjSchmFactory.getLocalInstance(ctx).getHROrgAdjSchmCollection("SELECT * WHERE id = '" + schemeId + "'");
            HROrgAdjSchmInfo hROrgAdjSchmInfo = new HROrgAdjSchmInfo();
            if (hROrgAdjSchmCollection.size() > 0) {
                hROrgAdjSchmInfo = hROrgAdjSchmCollection.get(0);
            }
            String effectDate = HRUtilExtend.getDateStringWithoutMininute((Date)hROrgAdjSchmInfo.getEffectDate());
            String todayDate = HRUtilExtend.getDateStringWithoutMininute((Date)new Date());
            String l = LocaleUtils.getShortCode((Context)ctx);
            String sql = "SELECT adminOrg.FID AS adminId,adminOrg.FNAME_" + l + " AS adminName,adminOrg.FNUMBER AS adminNumber, position.FID AS positionId,position.FNAME_" + l + " AS positionName,position.FNumber AS positionNumber FROM T_HR_EmpOrgRelation empOrg LEFT JOIN T_ORG_ADMIN adminOrg ON empOrg.FAdminOrgID = adminOrg.FID  LEFT JOIN T_ORG_POSITION position ON empOrg.FPositionID = position.FID  where empOrg.FAssignType = 0 AND empOrg.FPositionID = '" + positionId + "' AND empOrg.FPersonID = '" + personId + "' AND EmpOrg.FEFFDT < {ts'" + effectDate + "'} AND EmpOrg.FLEFFDT >= {ts'" + todayDate + "'}  AND FISSYSTEM = 1";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String adminId = executeQuery.getString("adminId");
                String adminName = executeQuery.getString("adminName");
                String adminNumber = executeQuery.getString("adminNumber");
                String positionName = executeQuery.getString("positionName");
                String positionNumber = executeQuery.getString("positionNumber");
                PersonVerAdjRecInfo personVerAdj = new PersonVerAdjRecInfo();
                personVerAdj.setPersonVer(personVerInfo);
                personVerAdj.setOrgAdjSchm(hROrgAdjSchmInfo);
                personVerAdj.setBeforeAdjOrg(adminId);
                personVerAdj.setBeforeAdjPos(positionId);
                personVerAdj.setAfterAdjOrg(adminId);
                personVerAdj.setAfterAdjPos(positionId);
                personVerAdj.setIsPrimaryAdj(0);
                personVerAdj.setAdjType(OrgVerAdjEnum.PERSON_OTHERJOB_END);
                personVerAdj.setEnableStatus(EnableStateEnum.UNABLE);
                String description = "";
                description = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label6", (Locale)ctx.getLocale()), personVerInfo.getName(), personVerInfo.getNumber(), adminName, adminNumber, positionName, positionNumber);
                personVerAdj.setDescription(description);
                PersonVerAdjRecFactory.getLocalInstance(ctx).save((CoreBaseInfo)personVerAdj);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void _personNoPrimaryEndByPosition(Context ctx, String schemeId, String positionVerId, boolean isInsert) throws BOSException, EASBizException {
        try {
            String positionId = "";
            PositionVerCollection positionVerCollection = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection("SELECT * WHERE id = '" + positionVerId + "'");
            if (positionVerCollection.size() > 0) {
                positionId = positionVerCollection.get(0).getPosition().getId().toString();
            }
            HROrgAdjSchmCollection hROrgAdjSchmCollection = HROrgAdjSchmFactory.getLocalInstance(ctx).getHROrgAdjSchmCollection("SELECT * WHERE id = '" + schemeId + "'");
            HROrgAdjSchmInfo hROrgAdjSchmInfo = new HROrgAdjSchmInfo();
            if (hROrgAdjSchmCollection.size() > 0) {
                hROrgAdjSchmInfo = hROrgAdjSchmCollection.get(0);
            }
            String l = LocaleUtils.getShortCode((Context)ctx);
            String sql = "SELECT org.FID AS adminId,org.FNAME_" + l + " AS adminName,org.FNUMBER AS adminNumber, position.FID AS positionId,position.FNAME_" + l + " AS positionName,position.FNumber AS positionNumber, person.FID as personId,person.Fnumber as personNumber,person.Fname_" + l + " as personName FROM T_HR_EmpOrgRelation empOrg LEFT JOIN T_ORG_ADMIN org ON empOrg.FAdminOrgID = org.FID  LEFT JOIN T_ORG_POSITION position ON empOrg.FPositionID = position.FID  LEFT JOIN T_BD_PERSON person ON person.FID = empOrg.FPERSONID where empOrg.FAssignType = 0 AND empOrg.FPositionID = '" + positionId + "' AND empOrg.FLEFFDT = {ts'2199-12-31'}";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String adminId = executeQuery.getString("adminId");
                String adminName = executeQuery.getString("adminName");
                String adminNumber = executeQuery.getString("adminNumber");
                String positionName = executeQuery.getString("positionName");
                String positionNumber = executeQuery.getString("positionNumber");
                String personId = executeQuery.getString("personId");
                String personNumber = executeQuery.getString("personNumber");
                String personName = executeQuery.getString("personName");
                if (isInsert) {
                    PersonVerAdjRecInfo personVerAdj = new PersonVerAdjRecInfo();
                    PersonVerCollection personVerCollection = PersonVerFactory.getLocalInstance(ctx).getPersonVerCollection("SELECT * WHERE person.id = '" + personId + "' AND orgAdjSchm.id = '" + schemeId + "'");
                    PersonVerInfo personVerInfo = new PersonVerInfo();
                    if (personVerCollection.size() <= 0) continue;
                    personVerInfo = personVerCollection.get(0);
                    personVerAdj.setPersonVer(personVerInfo);
                    String deleteSql = "DELETE FROM T_HR_PersonVerAdjRec WHERE fOrgAdjSchm = '" + schemeId + "' AND fIsPrimaryAdj = 0 AND fPersonVer = '" + personVerInfo.getId().toString() + "' AND fBeforeAdjPos = '" + positionId + "' AND fAdjType = 23";
                    DbUtil.execute((Context)ctx, (String)deleteSql);
                    personVerAdj.setOrgAdjSchm(hROrgAdjSchmInfo);
                    personVerAdj.setBeforeAdjOrg(adminId);
                    personVerAdj.setBeforeAdjPos(positionId);
                    personVerAdj.setAfterAdjOrg(adminId);
                    personVerAdj.setAfterAdjPos(positionId);
                    personVerAdj.setIsPrimaryAdj(0);
                    personVerAdj.setAdjType(OrgVerAdjEnum.PERSON_OTHERJOB_END);
                    personVerAdj.setEnableStatus(EnableStateEnum.UNABLE);
                    String description = "";
                    description = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label6", (Locale)ctx.getLocale()), personVerInfo.getName(), personVerInfo.getNumber(), adminName, adminNumber, positionName, positionNumber);
                    personVerAdj.setDescription(description);
                    PersonVerAdjRecFactory.getLocalInstance(ctx).save((CoreBaseInfo)personVerAdj);
                    continue;
                }
                PersonVerCollection personVerCollection = PersonVerFactory.getLocalInstance(ctx).getPersonVerCollection("SELECT * WHERE person.id = '" + personId + "' AND orgAdjSchm.id = '" + schemeId + "'");
                PersonVerInfo personVerInfo = new PersonVerInfo();
                if (personVerCollection.size() <= 0) continue;
                personVerInfo = personVerCollection.get(0);
                String deleteSql = "DELETE FROM T_HR_PersonVerAdjRec WHERE fOrgAdjSchm = '" + schemeId + "' AND fIsPrimaryAdj = 0 AND fPersonVer = '" + personVerInfo.getId().toString() + "' AND fBeforeAdjPos = '" + positionId + "'";
                DbUtil.execute((Context)ctx, (String)deleteSql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

