/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryEntityParam;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRHistoryUtil {
    private static Logger logger = LoggerFactory.getLogger(HRHistoryUtil.class);
    public static String EARLIEST_EFFDT = "1900-01-01";
    public static final String CHANGEENDDATE = "2199-12-31";
    public static final String IS_FROM_SHR_OPTAction = "IS_FROM_SHR_OPTAction";
    public static final String IS_FROM_SHR_OPT_CURD = "IS_FROM_SHR_OPT_CURD";
    public static final String IS_FROM_EAS_OPT_CURD = "IS_FROM_EAS_OPT_CURD";

    public static java.util.Date getMaxEndDate() {
        try {
            return DateTimeUtils.parseDate((String)CHANGEENDDATE);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static java.util.Date getMinEffdtDate() {
        try {
            return DateTimeUtils.parseDate((String)EARLIEST_EFFDT);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static java.util.Date getEarliestAdminOrgEFFDT(Context ctx, String objId) throws BOSException {
        return HRHistoryUtil.getEarliestEFFDT(ctx, "t_org_adminHis", objId);
    }

    public static java.util.Date getEarliestPositionEFFDT(Context ctx, String objId) throws BOSException {
        return HRHistoryUtil.getEarliestEFFDT(ctx, "t_org_PositionHis", objId);
    }

    public static java.util.Date getEarliestEFFDT(Context ctx, String table, String objId) throws BOSException {
        Date effdt = null;
        String sql = "select top 1 FEFFDT from " + table + " where FHistoryRelateID='" + objId + "' order by FEFFDT ASC";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                effdt = rs.getDate("FEFFDT");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return effdt;
    }

    public static Object getHistoryObject(Context ctx, String objectId, java.util.Date historyDate, SelectorItemCollection selector) throws BOSException, EASBizException {
        HistoryEntityParam param;
        if (StringUtils.isEmpty((String)objectId)) {
            return null;
        }
        BOSObjectType bosObjectType = BOSUuid.getBOSObjectType((String)objectId, (boolean)false);
        if ("CCE7AED4".equals(bosObjectType.toString())) {
            bosObjectType = BOSObjectType.create((String)"6A6435BE");
        }
        if (!(param = HistoryUtil.getHistoryEntityParam((Context)ctx, (BOSObjectType)bosObjectType)).isNeedHistory()) {
            return null;
        }
        if (historyDate == null) {
            historyDate = new java.util.Date();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)historyDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)historyDate, CompareType.GREATER_EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (selector != null && !selector.isEmpty()) {
            view.setSelector(selector);
        }
        ICoreBase iCoreBase = BaseMetaDataUtil.getBizInterface((Context)ctx, (BOSObjectType)bosObjectType);
        ObjectUuidPK pk = new ObjectUuidPK(objectId);
        List historys = iCoreBase.getAllHisVersionReturnCurrentPaging((IObjectPK)pk, view, 0, 10);
        int size = historys.size();
        Object result = null;
        String name = null;
        String displayName = null;
        String viewStr = view.toString();
        if (size > 0 && (result = historys.get(0)) instanceof DataBaseInfo) {
            DataBaseInfo dataBaseInfo = result;
            name = dataBaseInfo.getName();
            displayName = dataBaseInfo.getDisplayName();
        }
        String msg = "HRHistoryUtil.getHistoryObject historys size : {0} name: {1} displayName: {2} realBosType: {3} viewStr: {4}";
        logger.error(MessageFormat.format("HRHistoryUtil.getHistoryObject historys size : {0} name: {1} displayName: {2} realBosType: {3} viewStr: {4}", size, name, displayName, bosObjectType.toString(), viewStr));
        return result;
    }
}

