/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.util.StringCollUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.AdminTreeNodeInfo;
import com.kingdee.eas.hr.org.app.AbstractHROrgUnitFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class HROrgUnitFacadeControllerBean
extends AbstractHROrgUnitFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.HROrgUnitFacadeControllerBean");

    @Override
    protected IObjectCollection _getAdminOrgUnitCollection(Context ctx, String hrOrgUnitID, boolean includeSealUp) throws BOSException, EASBizException {
        return this._getAdminOrgUnitCollection(ctx, hrOrgUnitID, includeSealUp, true);
    }

    @Override
    protected IObjectCollection _getAdminOrgUnitCollectionWithOrgRangeFilter(Context ctx, String hrOrgUnitID, boolean includeSealUp) throws BOSException, EASBizException {
        return this._getAdminOrgUnitCollectionWithOrgRangeFilter(ctx, hrOrgUnitID, includeSealUp, true);
    }

    @Override
    protected IObjectCollection _getAdminOrgUnitCollection(Context ctx, String hrOrgUnitID, boolean includeSealUp, boolean showVirtualOrg) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select \"A\".FID,\"A\".FNumber,\"A\".FName_L1,\"A\".FName_L2,").append("\"A\".FName_L3,\"A\".FLongNumber,\"A\".FLevel, \"A\".FSortCode ").append("from T_ORG_Admin \"A\" left join T_ORG_UnitRelation \"B\" ").append("on \"A\".FID=\"B\".FFromUnitID ").append("where");
        if (!includeSealUp) {
            sql.append(" \"A\".FIsSealUp = 0 and ");
        }
        if (!showVirtualOrg) {
            sql.append(" \"A\".FIsVirtual = 0 and ");
        }
        sql.append(" (\"B\".FToUnitID=? and FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5') ");
        sql.append(" order by FSortCode,FLongNumber asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{hrOrgUnitID});
        AdminOrgUnitCollection adminCol = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminInfo = null;
        Locale l = ctx.getLocale();
        String namePosition = "FName_L2";
        if (l.toString().equalsIgnoreCase("l1")) {
            namePosition = "FName_L1";
        } else if (l.toString().equalsIgnoreCase("l2")) {
            namePosition = "FName_L2";
        } else if (l.toString().equalsIgnoreCase("l3")) {
            namePosition = "FName_L3";
        }
        try {
            while (rs.next()) {
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                adminInfo.setNumber(rs.getString("FNumber"));
                String tempName = rs.getString(namePosition);
                adminInfo.setName(tempName);
                adminInfo.setLongNumber(rs.getString("FLongNumber"));
                adminInfo.setLevel(rs.getInt("FLevel"));
                adminInfo.setSortCode(rs.getString("FSortCode"));
                adminCol.add(adminInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminCol;
    }

    @Override
    protected IObjectCollection _getAdminOrgUnitCollectionWithOrgRangeFilter(Context ctx, String hrOrgUnitID, boolean includeSealUp, boolean showVirtualOrg) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.fid, T1.FNumber, T1.FName_l1, T1.FName_l2, T1.FName_l3, T1.FLongNumber, T1.FLevel, T1.FSortCode  FROM t_org_admin T1 ");
        sql.append("INNER JOIN t_pm_orgrange T2 ON T1.Fid = T2.Forgid ");
        sql.append("INNER JOIN t_org_unitrelation T3 ON t3.ffromunitid = T1.fid ");
        sql.append("WHERE T2.FUSERID = ?");
        sql.append(" AND ");
        sql.append("T2.FTYPE = ");
        sql.append(20);
        sql.append(" AND T3.FTOUNITID = ?");
        sql.append(" AND T3.Ftyperelationid = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        if (!includeSealUp) {
            sql.append(" and T1.FIsSealUp = 0 ");
        }
        if (!showVirtualOrg) {
            sql.append(" and T1.FIsVirtual = 0 ");
        }
        sql.append(" order by T1.FLongNumber asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), hrOrgUnitID});
        AdminOrgUnitCollection adminCol = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminInfo = null;
        Locale l = ctx.getLocale();
        String namePosition = "FName_L2";
        if (l.toString().equalsIgnoreCase("l1")) {
            namePosition = "FName_L1";
        } else if (l.toString().equalsIgnoreCase("l2")) {
            namePosition = "FName_L2";
        } else if (l.toString().equalsIgnoreCase("l3")) {
            namePosition = "FName_L3";
        }
        try {
            while (rs.next()) {
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                adminInfo.setNumber(rs.getString("FNumber"));
                String tempName = rs.getString(namePosition);
                adminInfo.setName(tempName);
                adminInfo.setLongNumber(rs.getString("FLongNumber"));
                adminInfo.setLevel(rs.getInt("FLevel"));
                adminInfo.setSortCode(rs.getString("FSortCode"));
                adminCol.add(adminInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return adminCol;
    }

    @Override
    protected AdminTreeNodeInfo _getAdminOrgTreeData(Context ctx, String rootAdminId, boolean userOrgRange, boolean includeSealup, boolean showVirtualOrg) throws BOSException, EASBizException {
        ArrayList<String> adminList;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (userId.equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            userOrgRange = false;
        }
        if ((adminList = this.getAllAdminList(ctx, rootAdminId, null, includeSealup, userOrgRange)) == null || adminList.size() == 0) {
            return null;
        }
        AdminTreeNodeInfo rootNodeInfo = this.getRootAdminInfo(ctx, rootAdminId, adminList);
        if (rootNodeInfo == null) {
            return null;
        }
        String nodeOrgId = rootNodeInfo.getId();
        StringBuffer sql = new StringBuffer("SELECT FID,FParentID,FNumber,FName_" + ctx.getLocale() + ",FLongNumber,FIsLeaf, FLevel,FIsStartSHR ");
        sql.append("FROM T_ORG_Admin ");
        sql.append(" WHERE (FParentID = '");
        sql.append(nodeOrgId);
        if (StringUtils.isEmpty((String)rootAdminId)) {
            sql.append("' OR FID = '");
            sql.append(nodeOrgId);
        }
        sql.append("') ");
        if (!showVirtualOrg) {
            sql.append(" AND FIsVirtual = 0 ");
        }
        if (!includeSealup) {
            sql.append("AND FIsSealUp = 0 ");
        }
        sql.append(" ORDER BY FSortCode,FLongNumber");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ArrayList<AdminTreeNodeInfo> children = new ArrayList<AdminTreeNodeInfo>();
            AdminTreeNodeInfo subNodeInfo = null;
            String longNumber = null;
            String id = null;
            String adminLongNumbers = adminList.toString();
            boolean hasPermission = true;
            boolean isRemove = false;
            while (rows.next()) {
                isRemove = true;
                longNumber = rows.getString("FLongNumber");
                id = rows.getString("FID");
                if (adminList.contains(longNumber)) {
                    hasPermission = true;
                    isRemove = false;
                } else {
                    int length = adminList.size();
                    for (int t = 0; t < length; ++t) {
                        if (adminList.get(t).indexOf(longNumber + "!") == -1) continue;
                        hasPermission = false;
                        isRemove = false;
                        break;
                    }
                }
                if (id.equals(nodeOrgId)) {
                    rootNodeInfo.setHasPermission(hasPermission);
                    continue;
                }
                if (isRemove) continue;
                subNodeInfo = new AdminTreeNodeInfo();
                subNodeInfo.setId(id);
                subNodeInfo.setLongNumber(longNumber);
                subNodeInfo.setHasPermission(hasPermission);
                if (rows.getBoolean("FIsStartSHR")) {
                    subNodeInfo.setName(rows.getString("FName_" + ctx.getLocale()));
                } else {
                    subNodeInfo.setName(rows.getString("FName_" + ctx.getLocale()) + "\uff08<span style=\"font-weight:bold;\">" + EASResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"Uninitialized", (Locale)ctx.getLocale()) + "</span>\uff09");
                }
                subNodeInfo.setNumber(rows.getString("FNumber"));
                if (adminLongNumbers.indexOf(longNumber + "!") > -1) {
                    subNodeInfo.setLeaf(false);
                } else {
                    subNodeInfo.setLeaf(true);
                }
                subNodeInfo.setLevel(rows.getInt("FLevel"));
                subNodeInfo.setHasPermission(rows.getBoolean("FIsStartSHR"));
                children.add(subNodeInfo);
            }
            rootNodeInfo.setSubAdminlist(children);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rootNodeInfo;
    }

    @Override
    protected AdminTreeNodeInfo _getRootNodeAdminInfo(Context ctx, String rootId, boolean userOrgRange, boolean includeSealup, boolean showVirtualOrg) throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (userId.equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            userOrgRange = false;
        }
        AdminTreeNodeInfo rootNodeInfo = null;
        ArrayList<String> adminList = null;
        if (StringUtils.isEmpty((String)rootId) && ((adminList = this.getAllAdminList(ctx, rootId, null, includeSealup, userOrgRange)) == null || adminList.size() == 0)) {
            return null;
        }
        rootNodeInfo = this.getRootAdminInfo(ctx, rootId, adminList);
        return rootNodeInfo;
    }

    private ArrayList<String> getAllAdminList(Context ctx, String rootId, HashSet<String> hroSet, boolean includeSealup, boolean userOrgRange) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT FLongNumber ");
        sql.append(" FROM T_ORG_Admin ");
        if (userOrgRange) {
            sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        }
        if (hroSet != null && hroSet.size() > 0) {
            sql.append(" INNER JOIN T_ORG_UnitRelation ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID");
        }
        sql.append(" WHERE 1=1 ");
        if (!StringUtils.isEmpty((String)rootId)) {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select flongnumber from t_org_admin where fid = '" + rootId + "'"));
            try {
                if (rowSet.next()) {
                    sql.append("and t_org_admin.flongnumber like '");
                    sql.append(rowSet.getString("flongnumber"));
                    sql.append("%' ");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!includeSealup) {
            sql.append("AND T_ORG_Admin.FIsSealUp = 0 ");
        }
        if (userOrgRange) {
            sql.append(" AND T_PM_OrgRange.FType = 20 ");
            sql.append(" AND T_PM_OrgRange.FUserID='");
            sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            sql.append("'");
        }
        if (hroSet != null && hroSet.size() > 0) {
            sql.append(" AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' AND T_ORG_UnitRelation.FToUnitID IN (");
            Iterator<String> iter = hroSet.iterator();
            while (iter.hasNext()) {
                sql.append("'");
                sql.append(iter.next());
                if (!iter.hasNext()) continue;
                sql.append("',");
            }
            sql.append("')");
        }
        sql.append(" ORDER BY FLongNumber ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> adminList = new ArrayList<String>();
        try {
            while (rows.next()) {
                adminList.add(rows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (adminList.size() == 0) {
            return null;
        }
        return adminList;
    }

    private AdminTreeNodeInfo getRootAdminInfo(Context ctx, String rootId, ArrayList<String> adminList) throws BOSException, EASBizException {
        if ((adminList == null || adminList.size() == 0) && StringUtils.isEmpty((String)rootId)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        if (StringUtils.isEmpty((String)rootId)) {
            String longNumber = adminList == null ? "" : adminList.get(0);
            int size = adminList.size();
            for (int i = 1; i < size; ++i) {
                for (int count = 0; (adminList.get(i).indexOf(longNumber) == -1 || longNumber.lastIndexOf("!") >= 0 && adminList.get(i).lastIndexOf("!") >= 0 && longNumber.substring(0, longNumber.lastIndexOf("!")).equals(adminList.get(i).substring(0, adminList.get(i).lastIndexOf("!")))) && count < 20; ++count) {
                    longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)rootId));
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isStartSHR"));
        view.setSelector(sic);
        view.setFilter(filter);
        AdminOrgUnitCollection adminColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
        AdminTreeNodeInfo rootNodeInfo = null;
        if (adminColl != null && adminColl.size() > 0) {
            rootNodeInfo = new AdminTreeNodeInfo();
            AdminOrgUnitInfo adminInfo = adminColl.get(0);
            rootNodeInfo.setId(adminInfo.getId().toString());
            rootNodeInfo.setNumber(adminInfo.getNumber());
            rootNodeInfo.setName(adminInfo.getName());
            rootNodeInfo.setLongNumber(adminInfo.getLongNumber());
            rootNodeInfo.setLeaf(adminInfo.isIsLeaf());
            rootNodeInfo.setLevel(adminInfo.getLevel());
            rootNodeInfo.setHasPermission(adminInfo.isIsStartSHR());
            if (!adminInfo.isIsStartSHR()) {
                rootNodeInfo.setName(adminInfo.getName() + "\uff08<span style=\"font-weight:bold;\">" + EASResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"Uninitialized", (Locale)ctx.getLocale()) + "</span>\uff09");
            }
            try {
                IRowSet maxLevelExecute = DbUtil.executeQuery((Context)ctx, (String)("SELECT max(FLEVEL) AS maxLevel FROM T_ORG_ADMIN WHERE FLONGNUMBER LIKE '" + adminInfo.getLongNumber() + "%'"));
                if (maxLevelExecute.size() > 0) {
                    while (maxLevelExecute.next()) {
                        rootNodeInfo.setSelectLevel(maxLevelExecute.getInt("maxLevel") - adminInfo.getLevel());
                    }
                } else {
                    rootNodeInfo.setSelectLevel(10);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rootNodeInfo;
    }

    @Override
    public AdminTreeNodeInfo _getAdminOrgTreeData(Context ctx, String rootAdminId, boolean userOrgRange, boolean includeSealup, boolean showVirtualOrg, String userOrgRangeSql) throws BOSException, EASBizException {
        ArrayList<String> adminList;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (userId.equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            userOrgRange = false;
        }
        if ((adminList = this.getAllAdminList(ctx, rootAdminId, null, includeSealup, userOrgRange, userOrgRangeSql)) == null || adminList.size() == 0) {
            return null;
        }
        AdminTreeNodeInfo rootNodeInfo = this.getRootAdminInfo(ctx, rootAdminId, adminList);
        if (rootNodeInfo == null) {
            return null;
        }
        String nodeOrgId = rootNodeInfo.getId();
        StringBuffer sql = new StringBuffer("SELECT FID,FParentID,FNumber,FName_" + ctx.getLocale() + ",FLongNumber,FIsLeaf, FLevel,FIsStartSHR,FIsSealUp ");
        sql.append("FROM T_ORG_Admin ");
        sql.append(" WHERE (FParentID = '");
        sql.append(nodeOrgId);
        if (StringUtils.isEmpty((String)rootAdminId)) {
            sql.append("' OR FID = '");
            sql.append(nodeOrgId);
        }
        sql.append("') ");
        if (!showVirtualOrg) {
            sql.append(" AND FIsVirtual = 0 ");
        }
        if (!includeSealup) {
            sql.append("AND FIsSealUp = 0 ");
        }
        sql.append(" ORDER BY FSortCode,FLongNumber");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ArrayList<AdminTreeNodeInfo> children = new ArrayList<AdminTreeNodeInfo>();
            AdminTreeNodeInfo subNodeInfo = null;
            String longNumber = null;
            String id = null;
            String adminLongNumbers = adminList.toString();
            boolean hasPermission = true;
            boolean isRemove = false;
            while (rows.next()) {
                isRemove = true;
                longNumber = rows.getString("FLongNumber");
                id = rows.getString("FID");
                if (adminList.contains(longNumber)) {
                    hasPermission = true;
                    isRemove = false;
                } else {
                    int length = adminList.size();
                    for (int t = 0; t < length; ++t) {
                        if (adminList.get(t).indexOf(longNumber + "!") == -1) continue;
                        hasPermission = false;
                        isRemove = false;
                        break;
                    }
                }
                if (id.equals(nodeOrgId)) {
                    rootNodeInfo.setHasPermission(hasPermission);
                    continue;
                }
                if (isRemove) continue;
                subNodeInfo = new AdminTreeNodeInfo();
                subNodeInfo.setId(id);
                subNodeInfo.setLongNumber(longNumber);
                subNodeInfo.setHasPermission(hasPermission);
                if (rows.getBoolean("FIsStartSHR")) {
                    subNodeInfo.setName(rows.getString("FName_" + ctx.getLocale()));
                } else {
                    subNodeInfo.setName(rows.getString("FName_" + ctx.getLocale()) + "(" + EASResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"Uninitialized", (Locale)ctx.getLocale()) + ")");
                }
                if (rows.getBoolean("FIsSealUp")) {
                    subNodeInfo.setName(subNodeInfo.getName() + "(" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label63", (Locale)ctx.getLocale()) + ")");
                }
                subNodeInfo.setNumber(rows.getString("FNumber"));
                if (adminLongNumbers.indexOf(longNumber + "!") > -1) {
                    subNodeInfo.setLeaf(false);
                } else {
                    subNodeInfo.setLeaf(true);
                }
                subNodeInfo.setLevel(rows.getInt("FLevel"));
                subNodeInfo.setHasPermission(rows.getBoolean("FIsStartSHR"));
                children.add(subNodeInfo);
            }
            rootNodeInfo.setSubAdminlist(children);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rootNodeInfo;
    }

    @Override
    public AdminTreeNodeInfo _getRootNodeAdminInfo(Context ctx, String rootId, boolean userOrgRange, boolean includeSealup, boolean showVirtualOrg, String userOrgRangeSql) throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (userId.equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            userOrgRange = false;
        }
        AdminTreeNodeInfo rootNodeInfo = null;
        ArrayList<String> adminList = null;
        if (StringUtils.isEmpty((String)rootId) && ((adminList = this.getAllAdminList(ctx, rootId, null, includeSealup, userOrgRange, userOrgRangeSql)) == null || adminList.size() == 0)) {
            return null;
        }
        rootNodeInfo = this.getRootAdminInfo(ctx, rootId, adminList);
        return rootNodeInfo;
    }

    private ArrayList<String> getAllAdminList(Context ctx, String rootId, HashSet<String> hroSet, boolean includeSealup, boolean userOrgRange, String userOrgRangeSql) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT FLongNumber ");
        sql.append(" FROM T_ORG_Admin ");
        if (hroSet != null && hroSet.size() > 0) {
            sql.append(" INNER JOIN T_ORG_UnitRelation ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID");
        }
        sql.append(" WHERE 1=1 ");
        if (!StringUtils.isEmpty((String)rootId)) {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select flongnumber from t_org_admin where fid = '" + rootId + "'"));
            try {
                if (rowSet.next()) {
                    sql.append("and t_org_admin.flongnumber like '");
                    sql.append(rowSet.getString("flongnumber"));
                    sql.append("%' ");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!includeSealup) {
            sql.append("AND T_ORG_Admin.FIsSealUp = 0 ");
        }
        if (userOrgRange) {
            sql.append(" AND T_ORG_Admin.FID IN (" + userOrgRangeSql + ")");
        } else {
            sql.append(" AND T_ORG_Admin.FISSTARTSHR = 1");
        }
        if (hroSet != null && hroSet.size() > 0) {
            sql.append(" AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' AND T_ORG_UnitRelation.FToUnitID IN (");
            Iterator<String> iter = hroSet.iterator();
            while (iter.hasNext()) {
                sql.append("'");
                sql.append(iter.next());
                if (!iter.hasNext()) continue;
                sql.append("',");
            }
            sql.append("')");
        }
        sql.append(" ORDER BY FSortCode,FLongNumber ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> adminList = new ArrayList<String>();
        try {
            while (rows.next()) {
                adminList.add(rows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (adminList.size() == 0) {
            return null;
        }
        return adminList;
    }

    @Override
    protected List<AdminTreeNodeInfo> _getRootAllAdminInfo(Context ctx, String rootId, boolean userOrgRange, boolean includeSealup, boolean showVirtualOrg, String userOrgRangeSql) throws BOSException, EASBizException {
        return this._getRootAllAdminInfo(ctx, rootId, userOrgRange, includeSealup, showVirtualOrg, userOrgRangeSql, null);
    }

    @Override
    protected List<AdminTreeNodeInfo> _getRootAllAdminInfo(Context ctx, String rootId, boolean userOrgRange, boolean includeSealup, boolean showVirtualOrg, String userOrgRangeSql, String orgTypeId) throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (userId.equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            userOrgRange = false;
        }
        StringBuffer sql = new StringBuffer("SELECT FID,FParentID,FNumber,FName_" + ctx.getLocale() + ",FLongNumber,FIsLeaf, FLevel,FIsStartSHR,FIsSealUp ");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" WHERE 1=1 ");
        if (!StringUtils.isEmpty((String)rootId)) {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select flongnumber from t_org_admin where fid = '" + rootId + "'"));
            try {
                if (rowSet.next()) {
                    sql.append("and (t_org_admin.flongnumber = '" + rowSet.getString("flongnumber") + "' or t_org_admin.flongnumber like '");
                    sql.append(rowSet.getString("flongnumber"));
                    sql.append("!%' ) ");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!includeSealup) {
            sql.append("AND T_ORG_Admin.FIsSealUp = 0 ");
        }
        if (userOrgRange) {
            if (userOrgRangeSql.contains("T_HR_SHRUserAdminOrgPerm") || userOrgRangeSql.contains("T_HR_EMPORGRELATION")) {
                sql.append(" AND T_ORG_Admin.FID IN (" + userOrgRangeSql + ")");
            } else {
                sql.append(" AND T_ORG_Admin.FID IN ( select t0.fid FAdminOrgID from T_ORG_ADMIN t0 where exists(select 1 from T_PM_OrgRange t1 where t0.fid = t1.FORGID AND t1.FUserID = '").append(userId).append("' and t1.FType = 20) )");
            }
        } else {
            sql.append(" AND T_ORG_Admin.FISSTARTSHR = 1");
        }
        if (!StringUtils.isEmpty((String)orgTypeId)) {
            List<String> orgTypeIdList = Arrays.asList(orgTypeId.split(","));
            sql.append(" AND T_ORG_Admin.FLayerTypeID in " + StringCollUtil.getStrFromList(orgTypeIdList));
        }
        sql.append(" ORDER BY FSortCode,FLongNumber ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<AdminTreeNodeInfo> children = null;
        try {
            children = new ArrayList<AdminTreeNodeInfo>();
            ArrayList<String> adminList = this.getAllAdminList(ctx, rootId, null, includeSealup, userOrgRange, userOrgRangeSql);
            AdminTreeNodeInfo subNodeInfo = null;
            String longNumber = null;
            boolean isRemove = true;
            while (rows.next()) {
                isRemove = true;
                longNumber = rows.getString("FLongNumber");
                if (adminList.contains(longNumber)) {
                    isRemove = false;
                } else {
                    int length = adminList.size();
                    for (int t = 0; t < length; ++t) {
                        if (adminList.get(t).indexOf(longNumber + "!") == -1) continue;
                        isRemove = false;
                        break;
                    }
                }
                if (isRemove) continue;
                subNodeInfo = new AdminTreeNodeInfo();
                subNodeInfo.setId(rows.getString("FID"));
                subNodeInfo.setLongNumber(longNumber);
                if (rows.getBoolean("FIsStartSHR")) {
                    subNodeInfo.setName(rows.getString("FName_" + ctx.getLocale()));
                } else {
                    subNodeInfo.setName(rows.getString("FName_" + ctx.getLocale()) + "(" + EASResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"Uninitialized", (Locale)ctx.getLocale()) + ")");
                }
                if (rows.getBoolean("FIsSealUp")) {
                    subNodeInfo.setName(subNodeInfo.getName() + "(" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label63", (Locale)ctx.getLocale()) + ")");
                }
                subNodeInfo.setNumber(rows.getString("FNumber"));
                subNodeInfo.setParentId(rows.getString("FParentID"));
                subNodeInfo.setLevel(rows.getInt("FLevel"));
                subNodeInfo.setHasPermission(rows.getBoolean("FIsStartSHR"));
                children.add(subNodeInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return children;
    }
}

