/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.HrOrgBaseException;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelCollection;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.app.AbstractJobLevelControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JobLevelControllerBean
extends AbstractJobLevelControllerBean {
    protected IObjectPK _addnew(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        JobLevelInfo model = (JobLevelInfo)info;
        if (model.getJobFamily() == null) {
            throw new JobException(JobException.JOBFAMILY_NOT_NULL);
        }
        super._checkNameBlank(ctx, (IObjectValue)model);
        if (super._exists(ctx, "where number='" + model.getNumber().trim() + "'")) {
            String number = this._getPropertyAlias(ctx, model, "number") + model.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
        this.checkJobGradeIsAable(ctx, model);
        model.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        return super._addnew(ctx, (IObjectValue)model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue info) throws BOSException, EASBizException {
        JobLevelInfo job;
        JobLevelInfo model = (JobLevelInfo)info;
        if (model.getJobFamily() == null) {
            throw new JobException(JobException.JOBFAMILY_NOT_NULL);
        }
        super._checkNameBlank(ctx, (IObjectValue)model);
        if (super._exists(ctx, "where number='" + model.getNumber().trim() + "' and id<>'" + model.getId().toString() + "'")) {
            String number = this._getPropertyAlias(ctx, model, "number") + model.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
        this.checkJobGradeIsAable(ctx, model);
        if (JobFactory.getLocalInstance((Context)ctx).exists("where jobLevel = '" + model.getId().toString() + "' ") && (job = this.getJobLevelInfo(ctx, pk)).getJobGrade() != null && job.getLowestJobGrade() != null) {
            if (model.getJobGrade() != null && model.getLowestJobGrade() != null) {
                if (!model.getJobGrade().getId().toString().equals(job.getJobGrade().getId().toString()) || !model.getLowestJobGrade().getId().toString().equals(job.getLowestJobGrade().getId().toString())) {
                    throw new HrOrgBaseException(HrOrgBaseException.EXCEPTION0);
                }
            } else {
                throw new HrOrgBaseException(HrOrgBaseException.EXCEPTION0);
            }
        }
        super._update(ctx, pk, (IObjectValue)model);
    }

    private void checkJobGradeIsAable(Context ctx, JobLevelInfo info) throws BOSException, EASBizException {
        if (info.getJobGrade() == null && info.getLowestJobGrade() == null) {
            return;
        }
        if (info.getJobGrade() == null && info.getLowestJobGrade() != null || info.getLowestJobGrade() == null && info.getJobGrade() != null) {
            throw new JobException(JobException.JOB_JOBGRADE_NOT_ALL_NULL);
        }
        JobGradeInfo highJobGrade = JobGradeFactory.getLocalInstance(ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(info.getJobGrade().getId()));
        JobGradeInfo lowJobGrade = JobGradeFactory.getLocalInstance(ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(info.getLowestJobGrade().getId()));
        if (lowJobGrade.getGrade() > highJobGrade.getGrade()) {
            throw new JobException(JobException.JOB_HIGHGRADE_SMALL_LOWGRADE);
        }
    }

    @Override
    protected void _batchSaveJobLevel(Context ctx, Map jobLevelMap) throws BOSException, EASBizException {
        List pkList;
        JobLevelCollection updateLevelColl;
        JobLevelCollection addLevelColl = (JobLevelCollection)((Object)jobLevelMap.get("ADDNEW"));
        UserInfo userInfo = this.getUserInfo(ctx);
        Timestamp createtime = this.getTime();
        JobLevelCollection newAddJobLevelColl = new JobLevelCollection();
        if (addLevelColl != null) {
            JobLevelInfo objectBaseInfo = null;
            for (int i = 0; i < addLevelColl.size(); ++i) {
                objectBaseInfo = addLevelColl.get(i);
                if (objectBaseInfo.getCreator() == null) {
                    objectBaseInfo.setCreator(userInfo);
                }
                if (objectBaseInfo.getCreateTime() == null) {
                    objectBaseInfo.setCreateTime(createtime);
                }
                objectBaseInfo.setLastUpdateUser(userInfo);
                objectBaseInfo.setLastUpdateTime(createtime);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("jobGrade", (Object)objectBaseInfo.getJobGrade().getId().toString()));
                this._delete(ctx, filterInfo);
                newAddJobLevelColl.add(objectBaseInfo);
            }
        }
        if ((updateLevelColl = (JobLevelCollection)((Object)jobLevelMap.get("UPDATE"))) != null) {
            JobLevelInfo objectBaseInfo = null;
            for (int i = 0; i < updateLevelColl.size(); ++i) {
                objectBaseInfo = updateLevelColl.get(i);
                objectBaseInfo.setId(null);
                if (objectBaseInfo.getCreator() == null) {
                    objectBaseInfo.setCreator(userInfo);
                }
                if (objectBaseInfo.getCreateTime() == null) {
                    objectBaseInfo.setCreateTime(createtime);
                }
                objectBaseInfo.setLastUpdateUser(userInfo);
                objectBaseInfo.setLastUpdateTime(createtime);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("jobGrade", (Object)objectBaseInfo.getJobGrade().getId().toString()));
                this._delete(ctx, filterInfo);
                newAddJobLevelColl.add(objectBaseInfo);
            }
        }
        if (newAddJobLevelColl.size() > 0) {
            this._addnewBatchData(ctx, (IObjectCollection)newAddJobLevelColl);
        }
        if ((pkList = (List)jobLevelMap.get("DELETE")) != null) {
            IObjectPK[] pkArray = new IObjectPK[pkList.size()];
            for (int i = 0; i < pkList.size(); ++i) {
                pkArray[i] = new ObjectUuidPK(pkList.get(i).toString());
            }
            this._deleteBatchData(ctx, pkArray);
        }
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
    }
}

