/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.party.IMemberPaymentBase;
import com.kingdee.eas.hr.party.MemOrgBillFactory;
import com.kingdee.eas.hr.party.MemberPaymentBaseFactory;
import com.kingdee.eas.hr.party.MemberPaymentBaseInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MemberPaymentBaseDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.party.app.MemberPaymentBaseDataImport");
    private static BigDecimal ZERO = new BigDecimal(0.0).setScale(2);

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        MemberPaymentBaseInfo memberPaymentBaseInfo = new MemberPaymentBaseInfo();
        String str = null;
        try {
            str = (String)((DataToken)hsData.get((Object)"FPerson_number")).data;
            if (str == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.PersonCmpResource.PER_NUM", (Locale)ctx.getLocale()) + str + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.PersonCmpResource.NOT_NULL", (Locale)ctx.getLocale()));
            }
            PersonInfo pInfo = this.getPersonInfo(ctx, str, "number");
            if (pInfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.PersonCmpResource.PER_NUM", (Locale)ctx.getLocale()) + str + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.PersonCmpResource.NOT_NULL", (Locale)ctx.getLocale()));
            }
            memberPaymentBaseInfo.setPerson(pInfo);
            if (pInfo.get("primaryAdminOrg") != null) {
                memberPaymentBaseInfo.setAdminOrg((AdminOrgUnitInfo)pInfo.get("primaryAdminOrg"));
            } else {
                memberPaymentBaseInfo.setAdminOrg(MemOrgBillFactory.getLocalInstance(ctx).getAdminOrgByPerson(pInfo));
            }
            str = (String)((DataToken)hsData.get((Object)"FImportData")).data;
            if (!StringUtils.isEmpty((String)str)) {
                memberPaymentBaseInfo.setImportData(new BigDecimal(str));
                memberPaymentBaseInfo.setPayBase(new BigDecimal(str));
            } else {
                memberPaymentBaseInfo.setImportData(ZERO);
                memberPaymentBaseInfo.setPayBase(ZERO);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return memberPaymentBaseInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        MemberPaymentBaseInfo paymentBaseInfo = (MemberPaymentBaseInfo)coreBaseInfo;
        paymentBaseInfo.setPayBase(paymentBaseInfo.getImportData());
        MemberPaymentBaseInfo paymentBaseInfobak = null;
        if (paymentBaseInfo.getAdminOrg() == null) {
            try {
                paymentBaseInfo.setAdminOrg(this._getAdminByPersonId(ctx, paymentBaseInfo.getPerson().getId().toString()));
            }
            catch (EASBizException e) {
                throw new TaskExternalException("", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        try {
            IMemberPaymentBase iPaymentBase = MemberPaymentBaseFactory.getLocalInstance(ctx);
            String oql = "where person.id ='" + paymentBaseInfo.getPerson().getId() + "'";
            CoreBaseCollection orgBaseCollection = iPaymentBase.getCollection(oql);
            if (orgBaseCollection != null && orgBaseCollection.size() > 0) {
                paymentBaseInfobak = (MemberPaymentBaseInfo)orgBaseCollection.getObject(0);
            }
            if (paymentBaseInfobak != null) {
                paymentBaseInfo.setId(paymentBaseInfobak.getId());
                iPaymentBase.update((IObjectPK)new ObjectUuidPK(paymentBaseInfobak.getId()), (CoreBaseInfo)paymentBaseInfo);
            } else {
                iPaymentBase.addnew((CoreBaseInfo)paymentBaseInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private PersonInfo getPersonInfo(Context ctx, String str, String filterName) throws BOSException, TaskExternalException {
        if (!this.checkPermission(ctx, str)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.PersonCmpResource.PER_NUM", (Locale)ctx.getLocale()) + " '" + str + "' " + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.PersonCmpResource.NOT_FOUND", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(filterName, (Object)str));
        view.setFilter(filterInfo);
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection personColl = iPerson.getPersonCollection(view);
        return personColl.get(0);
    }

    private boolean checkPermission(Context ctx, String str) throws BOSException {
        Hashtable params = this.getContextParameter();
        String perInfoInScopeSql = null;
        perInfoInScopeSql = (String)params.get("MemberPaymentBaseImportPerInfoInScopeSql");
        if (StringUtils.isEmpty((String)perInfoInScopeSql)) {
            perInfoInScopeSql = CompUtils.getPerInfoInScopeSql((Context)ctx, (String)"#Number#");
            params.put("MemberPaymentBaseImportPerInfoInScopeSql", perInfoInScopeSql);
            perInfoInScopeSql = perInfoInScopeSql.replaceAll("#Number#", str);
        } else {
            perInfoInScopeSql = perInfoInScopeSql.replaceAll("#Number#", str);
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)perInfoInScopeSql);
        return rows.size() > 0;
    }

    protected AdminOrgUnitInfo _getAdminByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgInfo = null;
        String sql = "SELECT PERSON.Fid, ADMIN.Fid, ADMIN.FNAME_L2, ADMIN.FNUMBER FROM T_BD_PERSON PERSON LEFT OUTER JOIN T_HR_PersonPosition PP ON PERSON.FID = PP.FPERSONID LEFT OUTER JOIN T_ORG_ADMIN ADMIN ON PP.FPERSONDEP = ADMIN.FID LEFT OUTER JOIN T_HR_BDEMPLOYEETYPE TYPE ON TYPE.FID = PERSON.FEMPLOYEETYPEID LEFT OUTER JOIN T_ORG_PositionMember PM ON PM.FPERSONID = PERSON.FID LEFT OUTER JOIN T_ORG_Position POSITION ON POSITION.FID = PM.FPOSITIONID LEFT OUTER JOIN T_ORG_ADMIN ADMINP ON ADMINP.FID = POSITION.FADMINORGUNITID WHERE PERSON.Fid ='" + personId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                adminOrgInfo = new AdminOrgUnitInfo();
                adminOrgInfo.setId(BOSUuid.read((String)rs.getString(2)));
                adminOrgInfo.setName(rs.getString(3));
                adminOrgInfo.setNumber(rs.getString(4));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return adminOrgInfo;
    }
}

