/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.AchieveDataEnum;
import com.kingdee.eas.hr.perf.AchieveDataFacadeFactory;
import com.kingdee.eas.hr.perf.AchieveDataFactory;
import com.kingdee.eas.hr.perf.FormulaFacadeFactory;
import com.kingdee.eas.hr.perf.IFormulaFacade;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class AchieveDataHelper {
    public static void createAchieveDataonDeliverTarget(Context ctx, String solutionPeriodId, List tesIds) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return;
        }
        if (ctx == null) {
            AchieveDataFacadeFactory.getRemoteInstance().splitAchieveData(solutionPeriodId, tesIds);
        } else {
            AchieveDataFacadeFactory.getLocalInstance(ctx).splitAchieveData(solutionPeriodId, tesIds);
        }
    }

    public static void createAchieveDataonDeliverTarget2(Context ctx, String solutionPeriodId, List tesIds) throws BOSException, EASBizException {
        if (solutionPeriodId == null || tesIds == null || tesIds.size() <= 0) {
            return;
        }
        if (ctx == null) {
            AchieveDataFacadeFactory.getRemoteInstance().splitAchieveData2(solutionPeriodId, tesIds);
        } else {
            AchieveDataFacadeFactory.getLocalInstance(ctx).splitAchieveData2(solutionPeriodId, tesIds);
        }
    }

    public static boolean verifyFormulaOnSaveTarget(Context ctx, List formulaIds, String spId) throws BOSException, EASBizException {
        IFormulaFacade biz = ctx == null ? FormulaFacadeFactory.getRemoteInstance() : FormulaFacadeFactory.getLocalInstance(ctx);
        return biz.verifyFormula(formulaIds, spId);
    }

    public static boolean verifyFormulaCloneOnSaveTarget(Context ctx, List formulaIds, String spId) throws BOSException, EASBizException {
        IFormulaFacade biz = ctx == null ? FormulaFacadeFactory.getRemoteInstance() : FormulaFacadeFactory.getLocalInstance(ctx);
        return biz.verifyFormulaClone(formulaIds, spId);
    }

    public static void delAchieveDataOnUnDeliverTarget(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("dataType", (Object)AchieveDataEnum.generate));
        if (ctx == null) {
            AchieveDataFactory.getRemoteInstance().delete(fi);
        } else {
            AchieveDataFactory.getLocalInstance(ctx).delete(fi);
        }
    }

    public static void delAchieveDataOnUnDeliverTarget2(Context ctx, String solutionPeriodId, List tesIds) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("dataType", (Object)AchieveDataEnum.generate));
        if (ctx == null) {
            AchieveDataFacadeFactory.getRemoteInstance().removeAchieveData(solutionPeriodId, tesIds);
        } else {
            AchieveDataFacadeFactory.getLocalInstance(ctx).removeAchieveData(solutionPeriodId, tesIds);
        }
    }

    public static void clearValueOnCopySolutionPeriod(Context ctx, String spId) throws BOSException, EASBizException {
        if (ctx == null || spId == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_PF_TargetEvaluStore set FFormulaRank = ? ,FFormulaScore = ? ,FRealValue = ? ");
        sql.append(" where FSolutionPeriodID = ?");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            ps.setNull(1, SQLType.CHAR.getSQLType());
            ps.setNull(2, SQLType.NUMERIC.getSQLType());
            ps.setNull(3, SQLType.CHAR.getSQLType());
            ps.setString(4, spId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static void createAchieveDataAchieveDataForWorkbench(Context ctx, String solutionPeriodId, String evaluObjectId) throws BOSException, EASBizException {
        List targetIDList = new ArrayList();
        targetIDList = AchieveDataHelper.getTargetEvaluStoreIDList(ctx, solutionPeriodId, evaluObjectId);
        if (solutionPeriodId == null || targetIDList == null || targetIDList.size() <= 0) {
            return;
        }
        if (ctx == null) {
            AchieveDataFacadeFactory.getRemoteInstance().splitAchieveData2(solutionPeriodId, targetIDList);
        } else {
            AchieveDataFacadeFactory.getLocalInstance(ctx).splitAchieveData2(solutionPeriodId, targetIDList);
        }
    }

    public static void deleteAchieveDataForWorkbench(Context ctx, String solutionPeriodId, String evaluObjectId) throws BOSException, EASBizException {
        List evalutargetIDList = AchieveDataHelper.getEvaluTargetIDList(ctx, solutionPeriodId, evaluObjectId);
        if (evalutargetIDList != null && evalutargetIDList.size() > 0) {
            String del_sql = AchieveDataHelper.getdeleteAchieveDataSql(ctx, solutionPeriodId, evaluObjectId, evalutargetIDList);
            DbUtil.execute((Context)ctx, (String)del_sql.toString());
        }
    }

    private static String getdeleteAchieveDataSql(Context ctx, String solutionPeriodId, String evaluObjectId, List evalutargetIDList) throws EASBizException, BOSException {
        StringBuffer del_sql = new StringBuffer();
        del_sql.append(" delete from T_PF_AchieveData ");
        del_sql.append(" where FSolutionPeriodID = '");
        del_sql.append(solutionPeriodId).append("'");
        del_sql.append(" and ");
        del_sql.append(" FEVALUOBJECTID = '");
        del_sql.append(evaluObjectId).append("'");
        del_sql.append(" and ");
        del_sql.append(" FTargetID in ").append("(");
        del_sql.append(AchieveDataHelper.getInnerSql(evalutargetIDList)).append(")");
        return del_sql.toString();
    }

    private static String getInnerSql(List evalutargetIDList) {
        if (evalutargetIDList == null) {
            return "";
        }
        StringBuffer sql = new StringBuffer();
        int j = evalutargetIDList.size();
        for (int i = 0; i < j; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(evalutargetIDList.get(i)).append("'");
        }
        return sql.toString();
    }

    public static List getTargetEvaluStoreIDList(Context ctx, String solutionPeriodId, String evaluObjectId) throws BOSException {
        EntityViewInfo evi = AchieveDataHelper.getTargetEvaluStoreEntityViewInfo(solutionPeriodId, evaluObjectId);
        TargetEvaluStoreCollection evaluStoreColl = null;
        evaluStoreColl = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(evi);
        TargetEvaluStoreInfo targetEvaluStoreInfo = null;
        ArrayList<String> storeIDList = new ArrayList<String>();
        if (evaluStoreColl != null && evaluStoreColl.size() > 0) {
            for (int i = 0; i < evaluStoreColl.size(); ++i) {
                targetEvaluStoreInfo = evaluStoreColl.get(i);
                storeIDList.add(targetEvaluStoreInfo.getId().toString());
            }
        }
        return storeIDList;
    }

    public static List getEvaluTargetIDList(Context ctx, String solutionPeriodId, String evaluObjectId) throws BOSException {
        EntityViewInfo evi = AchieveDataHelper.getTargetEvaluStoreEntityViewInfo(solutionPeriodId, evaluObjectId);
        TargetEvaluStoreCollection evaluStoreColl = null;
        evaluStoreColl = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(evi);
        TargetEvaluStoreInfo targetEvaluStoreInfo = null;
        ArrayList<String> evaluTargetIDList = new ArrayList<String>();
        if (evaluStoreColl != null && evaluStoreColl.size() > 0) {
            for (int i = 0; i < evaluStoreColl.size(); ++i) {
                targetEvaluStoreInfo = evaluStoreColl.get(i);
                evaluTargetIDList.add(targetEvaluStoreInfo.getEvaluTarget().getId().toString());
            }
        }
        return evaluTargetIDList;
    }

    public static EntityViewInfo getTargetEvaluStoreEntityViewInfo(String solutionPeriodId, String evaluObjectId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectId));
        fi.getFilterItems().add(new FilterItemInfo("uniteTarget", (Object)Boolean.FALSE));
        fi.getFilterItems().add(new FilterItemInfo("evaluTarget.formula.id", null, CompareType.NOTEQUALS));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluTarget.id"));
        return evi;
    }
}

