/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.hr.perf.AbstractEvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.ConcurrenceArgsCollection;
import com.kingdee.eas.hr.perf.ConcurrenceArgsInfo;
import com.kingdee.eas.hr.perf.EvalWorkFlowFactory;
import com.kingdee.eas.hr.perf.EvaluDetailCollection;
import com.kingdee.eas.hr.perf.EvaluDetailInfo;
import com.kingdee.eas.hr.perf.EvaluNodeInfo;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.NodeProcesserInfo;
import com.kingdee.eas.hr.perf.RankConvertRuleHelper;
import com.kingdee.eas.hr.perf.RankConvertRuleInfo;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import java.math.BigDecimal;
import java.util.Map;

public class BatchEvaluProcessHelper {
    public static final BigDecimal percent = new BigDecimal("0.010000");

    public static void fillCurrentNodeWithExistNode(Map datas, String nodeId, String[] seqNumbers, int currentNodeLevel, boolean isGrade) {
        NodeProcesserInfo curInfo = (NodeProcesserInfo)datas.get(nodeId);
        if (curInfo == null) {
            return;
        }
        if (!curInfo.getEvaluNode().isCanGrade()) {
            return;
        }
        EvaluDetailCollection curColl = curInfo.getEvaluDetails();
        EvaluDetailInfo curDetail = null;
        EvaluDetailInfo detail = null;
        NodeProcesserInfo info = null;
        String curStoreId = null;
        int flag = 0;
        if (curInfo.getId() == null) {
            int n = curColl.size();
            for (int i = datas.size() - 1; i >= 0; --i) {
                info = (NodeProcesserInfo)datas.get(seqNumbers[i]);
                if (!info.getEvaluNode().isCanGrade() || nodeId.equals(seqNumbers[i]) || currentNodeLevel == info.getEvaluNode().getNodeLevel()) continue;
                for (int m = 0; m < n; ++m) {
                    curDetail = curColl.get(m);
                    if (curDetail.getTargetScore() != null || curDetail == null || curDetail.getTargetEvaluStore() == null || curDetail.getTargetEvaluStore().getId() == null || (detail = info.getEvaluDetailByTargetID(curStoreId = curDetail.getTargetEvaluStore().getId().toString())) == null) continue;
                    if (isGrade) {
                        if (detail.getTargetScore() != null) {
                            curDetail.setTargetScore(detail.getTargetScore());
                            ++flag;
                        }
                    } else if (detail.getRank() != null) {
                        curDetail.setRank(detail.getRank());
                        ++flag;
                    }
                    if (flag == n) break;
                }
                if (flag == n) break;
            }
        }
    }

    public static RankInfo convertTotalScoreToRank(GradeModeInfo solutionGradeMode, GradeModeInfo gradeMode, BigDecimal total, RankConvertRuleInfo rankConvertRule) {
        if (total == null) {
            return null;
        }
        BigDecimal newTotal = BatchEvaluProcessHelper.convertTotalScore(solutionGradeMode, gradeMode, total);
        return RankConvertRuleHelper.getRank(solutionGradeMode, rankConvertRule, newTotal);
    }

    public static BigDecimal convertTotalScore(GradeModeInfo solutionGradeMode, GradeModeInfo gradeMode, BigDecimal score) {
        BigDecimal max = gradeMode.getMaxGrade().setScale(6, 4);
        BigDecimal min = gradeMode.getMinGrade().setScale(6, 4);
        BigDecimal smax = solutionGradeMode.getMaxGrade().setScale(6, 4);
        BigDecimal smin = solutionGradeMode.getMinGrade().setScale(6, 4);
        BigDecimal newTotal = new BigDecimal("0.000000");
        newTotal = score.subtract(min).multiply(smax.subtract(smin)).divide(max.subtract(min), 4).add(smin);
        newTotal = newTotal.setScale(2, 4);
        return newTotal;
    }

    public static BigDecimal calNodeProcesserSumValue(NodeProcesserInfo info, boolean isGrade) {
        EvaluDetailInfo detailInfo = null;
        EvaluDetailCollection coll = info.getEvaluDetails();
        if (coll == null) {
            return null;
        }
        BigDecimal totalScore = new BigDecimal("0.000000");
        BigDecimal percent = new BigDecimal("0.01");
        BigDecimal weight = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            detailInfo = coll.get(i);
            weight = detailInfo.getWeight();
            if (isGrade) {
                if (detailInfo.getTargetScore() == null) continue;
                totalScore = totalScore.add(weight.multiply(detailInfo.getTargetScore()));
                continue;
            }
            if (detailInfo.getRank() == null || detailInfo.getRank().getGrade() == null) continue;
            totalScore = totalScore.add(weight.multiply(detailInfo.getRank().getGrade()));
        }
        totalScore = totalScore.multiply(percent).setScale(2, 4);
        info.setNodeScore(totalScore);
        return totalScore;
    }

    public static boolean dealSumValueChange(GradeModeInfo solutionGradeMode, GradeModeInfo gradeMode, KDTPropertyChangeEvent e, NodeProcesserInfo info, String scoreKey, RankConvertRuleInfo rankConvertRule, int sumRowIndex) {
        KDTable table = (KDTable)e.getSource();
        if (e.getRowIndex() == sumRowIndex) {
            Object newValue = e.getNewValue();
            Object oldValue = e.getOldValue();
            boolean isChange = false;
            if (newValue == null) {
                if (oldValue != null) {
                    isChange = true;
                }
            } else if (oldValue == null) {
                isChange = true;
            } else if (((BigDecimal)newValue).compareTo((BigDecimal)oldValue) != 0) {
                isChange = true;
            }
            if (isChange) {
                BatchEvaluProcessHelper.convertRank(solutionGradeMode, gradeMode, table, info, scoreKey, rankConvertRule, sumRowIndex + 1);
            }
            return true;
        }
        return false;
    }

    public static void convertRank(GradeModeInfo solutionGradeMode, GradeModeInfo gradeMode, KDTable table, NodeProcesserInfo info, String scoreKey, RankConvertRuleInfo rankConvertRule, int rankRowIndex) {
        if (info.getEvaluNode().isCanEvaluateLevel() && rankConvertRule != null) {
            RankInfo rank = BatchEvaluProcessHelper.convertTotalScoreToRank(solutionGradeMode, gradeMode, info.getNodeScore(), rankConvertRule);
            if (rank == null) {
                return;
            }
            IRow row = table.getRow(rankRowIndex);
            ICell cell = row.getCell(scoreKey);
            cell.setValue((Object)rank);
            try {
                if (rank != null) {
                    PerfClientUtils.setComboBoxSelected((KDComboBox)((KDComboBox)cell.getEditor().getComponent()), (String)rank.getId().toString());
                }
            }
            catch (Exception e) {
                Logger.error((Throwable)e.getCause(), (String)e.getMessage());
            }
        }
    }

    public static boolean isConcurrenceNode(EvaluNodeInfo node, Context ctx) {
        boolean isConcurrence = false;
        String pk = node.getEvalWorkFlow().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("wfLevels"));
        sic.add(new SelectorItemInfo("concurArgs.concurrenceLevel"));
        AbstractEvalWorkFlowInfo info = null;
        try {
            info = ctx == null ? EvalWorkFlowFactory.getRemoteInstance().getEvalWorkFlowInfo((IObjectPK)new ObjectUuidPK(pk), sic) : EvalWorkFlowFactory.getLocalInstance(ctx).getEvalWorkFlowInfo((IObjectPK)new ObjectUuidPK(pk), sic);
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)e.getMessage());
        }
        ConcurrenceArgsCollection conArgsColl = info.getConcurArgs();
        ConcurrenceArgsInfo conArgsInfo = null;
        int size = conArgsColl.size();
        for (int j = 0; j < size; ++j) {
            conArgsInfo = conArgsColl.get(j);
            if (node.getNodeLevel() != conArgsInfo.getConcurrenceLevel()) continue;
            isConcurrence = true;
            break;
        }
        return isConcurrence;
    }

    public static boolean isLastNode(EvaluNodeInfo node, Context ctx) {
        if (node.getNodeLevel() == node.getEvalWorkFlow().getWfLevels()) {
            return !BatchEvaluProcessHelper.isConcurrenceNode(node, ctx);
        }
        return false;
    }

    public static BigDecimal calCurrentTotalScore(Map datas, String[] seqNumbers, int currentNodeLevel) {
        NodeProcesserInfo oldInfo = null;
        BigDecimal oldTotalScore = new BigDecimal("0.000000");
        int size = datas.size();
        for (int m = 0; m < size; ++m) {
            oldInfo = (NodeProcesserInfo)datas.get(seqNumbers[m]);
            if (oldInfo.getNodeScore() == null || currentNodeLevel == oldInfo.getEvaluNode().getNodeLevel()) continue;
            oldTotalScore = oldTotalScore.add(oldInfo.getNodeScore().multiply(oldInfo.getEvaluNode().getWeight()));
        }
        oldTotalScore = oldTotalScore.multiply(percent);
        return oldTotalScore;
    }
}

