/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf;

import com.kingdee.eas.hr.perf.EvaluDetailCollection;
import com.kingdee.eas.hr.perf.EvaluDetailInfo;
import com.kingdee.eas.hr.perf.EvaluRuleModeEnum;
import com.kingdee.eas.hr.perf.EvaluRuleTool;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.TargetData;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class NodeProcesserUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.NodeProcesserUtils");

    public static List assembleTargetData(EvaluDetailCollection collection, EvaluSolutionInfo evaluSolutionInfo) {
        ArrayList<TargetData> targetDatas = new ArrayList<TargetData>();
        TargetData targetData = null;
        TargetEvaluStoreInfo targetEvaluStoreInfo = null;
        EvaluDetailInfo evaluDetailInfo = null;
        BigDecimal score = null;
        BigDecimal values = null;
        BigDecimal percent = new BigDecimal("0.01");
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            evaluDetailInfo = collection.get(i);
            targetEvaluStoreInfo = evaluDetailInfo.getTargetEvaluStore();
            if (targetEvaluStoreInfo == null) continue;
            targetData = new TargetData();
            if (targetEvaluStoreInfo.getEvaluTarget() != null && targetEvaluStoreInfo.getEvaluTarget().getFirstTypeWeight() != null) {
                targetData.setTypeWeight(targetEvaluStoreInfo.getEvaluTarget().getFirstTypeWeight().multiply(percent));
            }
            if (targetEvaluStoreInfo.getWeight() != null) {
                targetData.setWeight(targetEvaluStoreInfo.getWeight().multiply(percent));
            }
            score = evaluDetailInfo.getTargetScore();
            if (evaluSolutionInfo.isDeduction()) {
                values = EvaluRuleModeEnum.WEIGHT_MODE.equals((Object)evaluSolutionInfo.getEvaluRule().getRuleMode()) ? evaluSolutionInfo.getTargetGradeModeLink().getMaxGrade() : targetEvaluStoreInfo.getValues();
                if (score == null) {
                    score = new BigDecimal("0");
                }
                if (values != null && score != null) {
                    score = values.add(score);
                }
            }
            targetData.setScore(score);
            targetDatas.add(targetData);
        }
        return targetDatas;
    }

    public static BigDecimal computeScore(EvaluDetailCollection collection, EvaluSolutionInfo evaluSolutionInfo) {
        List targetDatas = NodeProcesserUtils.assembleTargetData(collection, evaluSolutionInfo);
        BigDecimal score = null;
        try {
            EvaluRuleTool evaluRuleTool = NodeProcesserUtils.getEvaluRuleTool(evaluSolutionInfo);
            score = evaluRuleTool.countTotalScore(targetDatas);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        return score;
    }

    public static EvaluRuleTool getEvaluRuleTool(EvaluSolutionInfo evaluSolutionInfo) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String ruleClassName = evaluSolutionInfo.getEvaluRule().getEvaluRuleToolClassName();
        return (EvaluRuleTool)Class.forName(ruleClassName).newInstance();
    }

    public static BigDecimal setNumberScale(BigDecimal number, int newScale, int precisionType) {
        if (number == null) {
            return null;
        }
        BigDecimal data = null;
        data = precisionType == 20 ? number.setScale(newScale, 0) : (precisionType == 30 ? number.setScale(newScale, 1) : number.setScale(newScale, 4));
        return data;
    }
}

