/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.PersonPerfUtil;
import com.kingdee.eas.hr.perf.EvalPersonInfo;
import com.kingdee.eas.hr.perf.EvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.FellowTypeEnum;
import com.kingdee.eas.hr.perf.MDEvaluGroupException;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MultiDimTestPaperStateEnum;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class RelationPersonHelper {
    public static final String RELATIONTYPE = "relationType";
    public static String NAME = "name";

    public static HashMap getRelationPerson(Context ctx, MDEvaluTypeEnum type, HashSet personSet, FellowTypeEnum fellowType) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        HashMap stPersonMap = RelationPersonHelper.getPersonByPersonType(ctx, type, personSet, fellowType);
        if (stPersonMap == null) {
            return result;
        }
        Iterator iterator3 = personSet.iterator();
        while (iterator3.hasNext()) {
            String personId = iterator3.next().toString();
            if (stPersonMap.containsKey(personId)) continue;
            stPersonMap.put(personId, new HashSet());
        }
        for (Map.Entry entry : stPersonMap.entrySet()) {
            EvalRelationDetailInfo erdInfo;
            if (result.containsKey(entry.getKey())) {
                erdInfo = (EvalRelationDetailInfo)result.get(entry.getKey());
            } else {
                erdInfo = new EvalRelationDetailInfo();
                result.put(entry.getKey(), erdInfo);
            }
            HashSet tSet = (HashSet)entry.getValue();
            Iterator iterator2 = tSet.iterator();
            while (iterator2.hasNext()) {
                EvalPersonInfo epInfo = new EvalPersonInfo();
                epInfo.put("personid", iterator2.next().toString());
                epInfo.setWfStatus(WFStatuEnum.UNUSED);
                epInfo.setPaperState(MultiDimTestPaperStateEnum.NOTSEND);
                epInfo.setIsOrigin(true);
                erdInfo.getEvalPersons().add(epInfo);
            }
        }
        return result;
    }

    private static HashMap getPrimaryPosistionByPersons(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        HashMap<String, String> personMap = new HashMap<String, String>();
        if (personSet == null || personSet.size() == 0) {
            return personMap;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)personSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("positionMember.isPrimary", (Object)new Integer(1)));
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "PersonToPrimaryPositionQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        try {
            while (rowSet.next()) {
                personMap.put(rowSet.getString("id"), rowSet.getString("position2.id"));
            }
        }
        catch (Exception e) {
            throw new MDEvaluGroupException(MDEvaluGroupException.GETPERSONPOSITION_FAILD, e);
        }
        return personMap;
    }

    public static HashMap getPersonByPersonType(Context ctx, MDEvaluTypeEnum type, HashSet personSet, FellowTypeEnum fellowType) throws BOSException, EASBizException {
        if (type.equals((Object)MDEvaluTypeEnum.SELF)) {
            return RelationPersonHelper.getSelfPerson(ctx, personSet);
        }
        if (type.equals((Object)MDEvaluTypeEnum.DIRECT_SUBORDINATOR)) {
            return RelationPersonHelper.getDirectSubordinatorPerson(ctx, personSet);
        }
        if (type.equals((Object)MDEvaluTypeEnum.INDIRECT_SUBORDINATOR)) {
            return RelationPersonHelper.getInDirectSubordinator(ctx, personSet);
        }
        if (type.equals((Object)MDEvaluTypeEnum.DIRECT_SUPERIOR)) {
            return RelationPersonHelper.getDirectSuperior(ctx, personSet);
        }
        if (type.equals((Object)MDEvaluTypeEnum.INDIRECT_SUPERIOR)) {
            return RelationPersonHelper.getInDirectSuperior(ctx, personSet);
        }
        if (type.equals((Object)MDEvaluTypeEnum.ORGRESPONSER)) {
            return RelationPersonHelper.getOrgResponser(ctx, personSet);
        }
        if (type.equals((Object)MDEvaluTypeEnum.FELLOW)) {
            return RelationPersonHelper.getFellow(ctx, personSet, fellowType);
        }
        return null;
    }

    private static HashMap getFellow(Context ctx, HashSet personSet, FellowTypeEnum fellowType) throws BOSException, EASBizException {
        if (fellowType == null) {
            return new HashMap();
        }
        if (FellowTypeEnum.SAMEJOBLEVEL.equals((Object)fellowType)) {
            int GROUP = 100;
            HashMap result = new HashMap(personSet.size());
            Iterator iterator = personSet.iterator();
            int fetchIndex = 0;
            int count = 0;
            int total = personSet.size();
            HashSet<String> perSet = new HashSet<String>();
            while (iterator.hasNext()) {
                perSet.add(iterator.next().toString());
                if (++fetchIndex % GROUP == 0 && fetchIndex > 0 || fetchIndex % GROUP != 0 && fetchIndex > 0 && count == total - 1) {
                    result.putAll(PersonPerfUtil.getSameGradePerson((Context)ctx, perSet));
                    perSet = new HashSet();
                    fetchIndex = 0;
                }
                ++count;
            }
            return result;
        }
        if (FellowTypeEnum.SAMEPOSITION_OTHERPERSON.equals((Object)fellowType)) {
            return PersonPerfUtil.getSamePositionFellow((Context)ctx, (HashSet)personSet);
        }
        if (FellowTypeEnum.SAMESUPERIOR_ALLPOSITION.equals((Object)fellowType)) {
            return PersonPerfUtil.getAllFellow((Context)ctx, (String)"00000000-0000-0000-0000-000000000001396FCAD0", (HashSet)personSet, (boolean)true);
        }
        if (FellowTypeEnum.SAMESUPERIOR_OTHERPOSITION.equals((Object)fellowType)) {
            return PersonPerfUtil.getAllFellow((Context)ctx, (String)"00000000-0000-0000-0000-000000000001396FCAD0", (HashSet)personSet, (boolean)false);
        }
        return new HashMap();
    }

    private static HashMap getOrgResponser(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        return PersonPerfUtil.getAdminRespPerson((Context)ctx, (HashSet)personSet);
    }

    private static HashMap getInDirectSuperior(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        return PersonPerfUtil.getIndirectSupervisor((Context)ctx, (String)"00000000-0000-0000-0000-000000000001396FCAD0", (HashSet)personSet);
    }

    private static HashMap getDirectSuperior(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        return PersonPerfUtil.getSupervisor((Context)ctx, (String)"00000000-0000-0000-0000-000000000001396FCAD0", (HashSet)personSet);
    }

    private static HashMap getInDirectSubordinator(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        return PersonPerfUtil.getIndirectSubordinate((Context)ctx, (String)"00000000-0000-0000-0000-000000000001396FCAD0", (HashSet)personSet);
    }

    private static HashMap getDirectSubordinatorPerson(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        return PersonPerfUtil.getSubordinate((Context)ctx, (String)"00000000-0000-0000-0000-000000000001396FCAD0", (HashSet)personSet);
    }

    private static HashMap getSelfPerson(Context ctx, HashSet personSet) {
        HashMap map = new HashMap();
        Iterator iterator = personSet.iterator();
        while (iterator.hasNext()) {
            String temp = iterator.next().toString();
            HashSet<String> set = new HashSet<String>();
            set.add(temp);
            map.put(temp, set);
        }
        return map;
    }
}

