/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvalPersonCollection;
import com.kingdee.eas.hr.perf.EvalRelationDetailCollection;
import com.kingdee.eas.hr.perf.EvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.EvaluRelationCollection;
import com.kingdee.eas.hr.perf.EvaluRelationFactory;
import com.kingdee.eas.hr.perf.EvaluRelationInfo;
import com.kingdee.eas.hr.perf.FellowTypeEnum;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;

public class SelfSelectEvaluatorHelp {
    public static boolean existPerson(EvalPersonCollection evalPersons, String id) {
        if (evalPersons == null || id == null) {
            return false;
        }
        int n = evalPersons.size();
        for (int i = 0; i < n; ++i) {
            if (evalPersons.get(i).getPerson().getId() == null || !evalPersons.get(i).getPerson().getId().toString().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static void removeEvalPersonByID(EvalRelationDetailInfo evalRelationDetailInfo, String id) {
        if (evalRelationDetailInfo == null || evalRelationDetailInfo.getEvalPersons() == null || id == null) {
            return;
        }
        int n = evalRelationDetailInfo.getEvalPersons().size();
        for (int i = 0; i < n; ++i) {
            if (!evalRelationDetailInfo.getEvalPersons().get(i).getId().toString().equals(id)) continue;
            evalRelationDetailInfo.getEvalPersons().removeObject(i);
            break;
        }
    }

    public static EvalRelationDetailInfo getRelationDetailByID(EvalRelationDetailCollection evalReDetails, String id) {
        if (evalReDetails == null || evalReDetails.size() == 0 || id == null) {
            return null;
        }
        int n = evalReDetails.size();
        for (int i = 0; i < n; ++i) {
            if (!evalReDetails.get(i).getId().toString().equals(id)) continue;
            return evalReDetails.get(i);
        }
        return null;
    }

    public static EvaluRelationInfo getEvaluRelationByID(EvaluRelationCollection relation2, String evaluRelationID) {
        if (relation2 == null || relation2.size() == 0 || evaluRelationID == null) {
            return null;
        }
        int n = relation2.size();
        for (int i = 0; i < n; ++i) {
            if (!relation2.get(i).getId().toString().equals(evaluRelationID)) continue;
            return relation2.get(i);
        }
        return null;
    }

    public static boolean checkRelationIsModify(EvaluRelationInfo newValue, EvaluRelationInfo oldValue, FellowTypeEnum oldFellowType) {
        if (oldValue == null || newValue == null) {
            return true;
        }
        boolean fellowTypeModify = !newValue.getMdEvaluGroup().getFellowType().equals((Object)oldFellowType);
        return SelfSelectEvaluatorHelp.isRelationModifySelf(newValue, oldValue, fellowTypeModify);
    }

    private static boolean isRelationModifySelf(EvaluRelationInfo newRInfo, EvaluRelationInfo oldRInfo, boolean fellowTypeModify) {
        if (newRInfo.getPersonRestrict() != oldRInfo.getPersonRestrict()) {
            return true;
        }
        if (newRInfo.getMDEvaluTypeEnum().equals((Object)MDEvaluTypeEnum.FELLOW) && fellowTypeModify) {
            return true;
        }
        if (newRInfo.getMDEvaluTypeEnum().equals((Object)MDEvaluTypeEnum.APPOINT)) {
            return !newRInfo.getName().equals(oldRInfo.getName());
        }
        return false;
    }

    public static boolean checkEvaluRelationExist(String relationID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)relationID));
        return EvaluRelationFactory.getRemoteInstance().exists(filterInfo);
    }

    public static boolean checkEvaluRelationExist(Context ctx, String relationID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)relationID));
        return EvaluRelationFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    public static EvaluRelationInfo getEvaluRelationByTypeAndName(EvaluRelationCollection collection, MDEvaluTypeEnum type, String name) {
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            if (!collection.get(i).getMDEvaluTypeEnum().equals((Object)type)) continue;
            if (type.equals((Object)MDEvaluTypeEnum.APPOINT)) {
                if (!collection.get(i).getName().equals(name)) continue;
                return collection.get(i);
            }
            return collection.get(i);
        }
        return null;
    }

    public static EvalRelationDetailInfo getEvalRelationByRelationID(EvalRelationDetailCollection evalReDetails, String relationID) {
        if (evalReDetails == null || evalReDetails.size() == 0) {
            return null;
        }
        int n = evalReDetails.size();
        for (int i = 0; i < n; ++i) {
            if (!evalReDetails.get(i).getEvalRelation().getId().toString().equals(relationID)) continue;
            return evalReDetails.get(i);
        }
        return null;
    }
}

