/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.AchieveDataCollection;
import com.kingdee.eas.hr.perf.AchieveDataComputeException;
import com.kingdee.eas.hr.perf.AchieveDataFactory;
import com.kingdee.eas.hr.perf.AchieveDataInfo;
import com.kingdee.eas.hr.perf.DataTypeEnum;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluResultItemEnum;
import com.kingdee.eas.hr.perf.FormulaAchieveEntryCollection;
import com.kingdee.eas.hr.perf.FormulaAchieveEntryFactory;
import com.kingdee.eas.hr.perf.FormulaAchieveEntryInfo;
import com.kingdee.eas.hr.perf.FormulaAchieveObjectEnum;
import com.kingdee.eas.hr.perf.FormulaPeriodEnum;
import com.kingdee.eas.hr.perf.FormulaSystemEntryCollection;
import com.kingdee.eas.hr.perf.FormulaSystemEntryFactory;
import com.kingdee.eas.hr.perf.FormulaSystemEntryInfo;
import com.kingdee.eas.hr.perf.PerfModeEnum;
import com.kingdee.eas.hr.perf.SumExpInfo;
import com.kingdee.eas.hr.perf.app.AbstractAchieveDataComputeFacadeControllerBean;
import com.kingdee.eas.hr.perf.app.FormulaComputeHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class AchieveDataComputeFacadeControllerBean
extends AbstractAchieveDataComputeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.AchieveDataComputeFacadeControllerBean");

    @Override
    protected void _batchCompute(Context ctx, List achieveDataIds) throws BOSException, EASBizException {
        if (achieveDataIds == null || achieveDataIds.size() <= 0) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", new HashSet(achieveDataIds), CompareType.INCLUDE));
        evi.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("rootPeriod"));
        sic.add(new SelectorItemInfo("formula.id"));
        sic.add(new SelectorItemInfo("achieveItem.id"));
        sic.add(new SelectorItemInfo("achieveItem.dataType"));
        evi.setSelector(sic);
        AchieveDataCollection coll = AchieveDataFactory.getLocalInstance(ctx).getAchieveDataCollection(evi);
        AchieveDataCollection sumColl = new AchieveDataCollection();
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            AchieveDataInfo info = coll.get(i);
            if (info.getFormula() != null) {
                this._computeAchieveDataRealValue(ctx, info.getId().toString());
                continue;
            }
            if (!info.isRootPeriod() || DataTypeEnum.TXT.equals((Object)info.getAchieveItem().getDataType())) continue;
            sumColl.add(info);
        }
        SelectorItemCollection updSic = new SelectorItemCollection();
        updSic.add(new SelectorItemInfo("realValue"));
        Connection conn = null;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select FRealValue from t_pf_achieveData  ");
        sql.append(" where FParentId = ? and FAchieveItemID = ? and FRootPeriod = 0 and FRealValue is not null ");
        try {
            conn = super.getConnection(ctx);
            ps = conn.prepareStatement(sql.toString());
            ResultSet rs = null;
            int j2 = sumColl.size();
            for (int i = 0; i < j2; ++i) {
                AchieveDataInfo info = coll.get(i);
                info.getPerson();
                info.getAchieveItem();
                try {
                    ps.setString(1, info.getId().toString());
                    ps.setString(2, info.getAchieveItem().getId().toString());
                    rs = ps.executeQuery();
                    BigDecimal rv = new BigDecimal("0.00");
                    boolean flag = false;
                    while (rs.next()) {
                        String str = rs.getString("FRealValue");
                        if (str == null || str.trim().length() <= 0) continue;
                        rv = rv.add(new BigDecimal(str));
                        flag = true;
                    }
                    info.setRealValue(rv.toString());
                    if (flag) {
                        AchieveDataFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, updSic);
                    }
                }
                catch (Exception ex) {
                    try {
                        throw new BOSException(ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _computeAchieveDataRealValue(Context ctx, String achieveDataId) throws BOSException, EASBizException {
        int i;
        Map sysTxts;
        Map achTxts;
        HashMap valueMap;
        ArrayList<Object> txtCols;
        ArrayList<Object> numCols;
        String tabName;
        TempTablePool pool;
        Connection conn;
        SumExpInfo exp;
        AchieveDataInfo adInfo;
        block48: {
            Map sysMap;
            if (achieveDataId == null) {
                return;
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("formula.id"));
            sic.add(new SelectorItemInfo("period.id"));
            sic.add(new SelectorItemInfo("solutionPeriod.id"));
            sic.add(new SelectorItemInfo("achieveItem.id"));
            sic.add(new SelectorItemInfo("achieveItem.dataType"));
            sic.add(new SelectorItemInfo("formula.exp.sql"));
            adInfo = AchieveDataFactory.getLocalInstance(ctx).getAchieveDataInfo((IObjectPK)new ObjectUuidPK(achieveDataId), sic);
            if (adInfo.getAchieveItem() == null) {
                return;
            }
            if (adInfo.getFormula() == null) {
                return;
            }
            exp = adInfo.getFormula().getExp();
            if (exp == null) throw new AchieveDataComputeException(AchieveDataComputeException.FORMULA_NULL);
            if (exp.getSql() == null) throw new AchieveDataComputeException(AchieveDataComputeException.FORMULA_NULL);
            if (exp.getSql().trim().length() <= 0) {
                throw new AchieveDataComputeException(AchieveDataComputeException.FORMULA_NULL);
            }
            this.checkCycleRely(ctx, adInfo);
            boolean isNum = false;
            if (DataTypeEnum.NUMERICAL.equals((Object)adInfo.getAchieveItem().getDataType()) || DataTypeEnum.PERCENT.equals((Object)adInfo.getAchieveItem().getDataType())) {
                isNum = true;
            }
            conn = null;
            pool = null;
            tabName = null;
            numCols = new ArrayList<Object>();
            txtCols = new ArrayList<Object>();
            valueMap = new HashMap();
            Map achMap = this.getAchieveElementData(ctx, adInfo);
            Map achNums = (Map)achMap.get("nums");
            achTxts = (Map)achMap.get("txts");
            if (achNums != null && achNums.size() > 0) {
                numCols.addAll(achNums.keySet());
                valueMap.putAll(achNums);
            }
            if (achTxts != null && achTxts.size() > 0) {
                txtCols.addAll(achTxts.keySet());
                valueMap.putAll(achTxts);
            }
            if ((sysMap = this.getSysElementData(ctx, adInfo)) == null) {
                sysMap = Collections.EMPTY_MAP;
            }
            Map sysNums = (Map)sysMap.get("nums");
            sysTxts = (Map)sysMap.get("txts");
            if (sysNums != null && sysNums.size() > 0) {
                numCols.addAll(sysNums.keySet());
                valueMap.putAll(sysNums);
            }
            if (sysTxts != null && sysTxts.size() > 0) {
                txtCols.addAll(sysTxts.keySet());
                valueMap.putAll(sysTxts);
            }
            if (isNum) {
                numCols.add("FRealValue");
            } else {
                txtCols.add("FRealValue");
            }
            if (numCols.size() > 0 || txtCols.size() > 0) break block48;
            try {
                if (tabName == null) return;
                pool.releaseTable(tabName);
                return;
            }
            catch (Exception ex) {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        conn = super.getConnection(ctx);
        pool = TempTablePool.getInstance((Context)ctx);
        tabName = FormulaComputeHelper.createTempTable(conn, pool, numCols, txtCols);
        numCols.addAll(txtCols);
        StringBuffer ins_sql = new StringBuffer();
        ins_sql.append(" insert into ").append(tabName).append(" ");
        ins_sql.append("(");
        ins_sql.append("FID");
        int j = numCols.size();
        for (i = 0; i < j; ++i) {
            if ("FRealValue".equals(numCols.get(i).toString())) continue;
            ins_sql.append(",");
            ins_sql.append(numCols.get(i).toString());
        }
        ins_sql.append(")");
        ins_sql.append("values");
        ins_sql.append("(");
        ins_sql.append("'").append(adInfo.getId().toString()).append("'");
        j = numCols.size();
        for (i = 0; i < j; ++i) {
            String adNum;
            if ("FRealValue".equals(numCols.get(i).toString()) || !valueMap.containsKey(adNum = numCols.get(i).toString())) continue;
            if (valueMap.get(adNum) == null) {
                ins_sql.append(",").append("null");
                continue;
            }
            if (achTxts != null && achTxts.containsKey(adNum) || sysTxts != null && sysTxts.containsKey(adNum)) {
                ins_sql.append(",").append("'").append(valueMap.get(adNum).toString()).append("'");
                continue;
            }
            BigDecimal value = null;
            String beforeFlagStr = null;
            String afterFlagStr = null;
            BigDecimal beforeValue = null;
            BigDecimal afterValue = null;
            int beginIndex = 0;
            if (valueMap.get(adNum).toString() == null) continue;
            String elements = valueMap.get(adNum) + "";
            if (elements.indexOf("E") != -1) {
                beginIndex = valueMap.get(adNum).toString().indexOf("E");
                beforeFlagStr = valueMap.get(adNum).toString().substring(0, beginIndex);
                afterFlagStr = valueMap.get(adNum).toString().substring(beginIndex + 1, valueMap.get(adNum).toString().length());
                beforeValue = new BigDecimal(beforeFlagStr);
                afterValue = new BigDecimal(afterFlagStr);
                if (beforeValue != null && afterValue != null) {
                    value = beforeValue.multiply(new BigDecimal(Math.pow(10.0, afterValue.doubleValue())));
                }
                ins_sql.append(",").append(value);
                continue;
            }
            ins_sql.append(",").append(valueMap.get(adNum).toString());
        }
        ins_sql.append(")");
        DbUtil.execute((Context)ctx, (String)ins_sql.toString());
        String ksql = exp.getSql();
        ksql = ksql.replaceAll("@", tabName);
        StringTokenizer tokens = new StringTokenizer(ksql, ";");
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            while (tokens.hasMoreTokens()) {
                stmt.execute(tokens.nextToken());
            }
        }
        catch (Exception ex) {
            StringBuffer sel_sql = new StringBuffer();
            sel_sql.append(" select formula.fname_l2 as formula_name from t_pf_achieveData as achievedata");
            sel_sql.append(" inner join T_PF_Formula as formula ");
            sel_sql.append(" on achievedata.FFormulaID=formula.fid ");
            sel_sql.append(" where achievedata.FID = '");
            sel_sql.append(achieveDataId);
            sel_sql.append("'");
            ResultSet rs = null;
            Connection sel_conn = super.getConnection(ctx);
            PreparedStatement sel_ps = sel_conn.prepareStatement(sel_sql.toString());
            Object[] name = new String[1];
            try {
                rs = sel_ps.executeQuery();
                while (rs.next()) {
                    name[0] = rs.getString("formula_name");
                }
            }
            catch (Exception ex1) {
                logger.error((Object)ex);
            }
            logger.error((Object)ex);
            throw new AchieveDataComputeException(AchieveDataComputeException.FORMULA_EXECUTE_FAIL, name);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
        StringBuffer upd_sql = new StringBuffer();
        upd_sql.append(" update t_pf_achieveData set FRealValue = ");
        upd_sql.append(" ( ");
        upd_sql.append(" to_char( ");
        upd_sql.append(" select FRealValue from ").append(tabName).append(" ");
        upd_sql.append(" where t_pf_achieveData.fid = ").append(tabName).append(".fid");
        upd_sql.append(" ) ");
        upd_sql.append(" ) ");
        upd_sql.append(" where fid = '").append(achieveDataId).append("'");
        DbUtil.execute((Context)ctx, (String)upd_sql.toString());
        try {
            if (tabName == null) return;
            pool.releaseTable(tabName);
            return;
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        catch (EASBizException e1) {
            try {
                throw e1;
                catch (Exception e2) {
                    throw new BOSException(e2.getMessage(), e2.getCause());
                }
            }
            catch (Throwable throwable) {
                try {
                    if (tabName == null) throw throwable;
                    pool.releaseTable(tabName);
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new BOSException(ex.getMessage(), ex.getCause());
                }
                finally {
                    SQLUtils.cleanup(conn);
                }
            }
        }
    }

    private Map getAchieveElementData(Context ctx, AchieveDataInfo adInfo) throws Exception {
        String key;
        if (adInfo == null || adInfo.getFormula() == null || adInfo.getSolutionPeriod() == null) {
            return Collections.EMPTY_MAP;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("formula.id", (Object)adInfo.getFormula().getId().toString()));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("achieveItem.dataType"));
        evi.setSelector(sic);
        FormulaAchieveEntryCollection aeColl = FormulaAchieveEntryFactory.getLocalInstance(ctx).getFormulaAchieveEntryCollection(evi);
        if (aeColl.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        HashSet<String> pdIds = new HashSet<String>();
        HashSet<String> acIds = new HashSet<String>();
        HashSet<String> pIds = new HashSet<String>();
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> spIds = new HashSet<String>();
        int j = aeColl.size();
        for (int i = 0; i < j; ++i) {
            FormulaAchieveEntryInfo aeInfo = aeColl.get(i);
            acIds.add(aeInfo.getAchieveItem().getId().toString());
            if (FormulaPeriodEnum.current.equals((Object)aeInfo.getPeriodType())) {
                pdIds.add(adInfo.getPeriod().getId().toString());
            } else {
                pdIds.add(aeInfo.getPeriod());
            }
            if (FormulaAchieveObjectEnum.otherOrgUnit.equals((Object)aeInfo.getObjectType())) {
                orgIds.add(aeInfo.getObject());
            } else if (FormulaAchieveObjectEnum.otherPerson.equals((Object)aeInfo.getObjectType())) {
                pIds.add(aeInfo.getObject());
            } else if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)adInfo.getEvaluObjectType())) {
                orgIds.add(adInfo.getOrgUnit().getId().toString());
            } else if (EvaluObjectTypeEnum.PERSON.equals((Object)adInfo.getEvaluObjectType())) {
                pIds.add(adInfo.getPerson().getId().toString());
            }
            if (aeInfo.isDefaultSp()) {
                spIds.add(adInfo.getSolutionPeriod().getId().toString());
                continue;
            }
            spIds.add(aeInfo.getSolutionPeriod());
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FPersonId pId,FOrgUnitID orgId,FPeriodID pdId, ");
        sql.append(" FSolutionPeriodID spId,FAchieveItemID achId,FEvaluObjectType objType,");
        sql.append(" FRealValue rv,FThresholdValue tv,FStandardValue sv,FChallengeValue cv,FReservedField2 rf");
        sql.append(" from t_pf_achieveData ");
        sql.append(" where FPeriodID in  ");
        sql.append(" (").append(FormulaComputeHelper.buildInSql(pdIds)).append(")");
        sql.append(" and FAchieveItemID in ");
        sql.append(" (").append(FormulaComputeHelper.buildInSql(acIds)).append(")");
        sql.append(" and ");
        sql.append(" (");
        if (pIds.size() > 0) {
            sql.append(" FPersonId in(").append(FormulaComputeHelper.buildInSql(pIds)).append(")");
        }
        if (pIds.size() > 0 && orgIds.size() > 0) {
            sql.append(" or ");
            sql.append(" FOrgUnitID in(").append(FormulaComputeHelper.buildInSql(orgIds)).append(")");
        } else if (orgIds.size() > 0) {
            sql.append(" FOrgUnitID in(").append(FormulaComputeHelper.buildInSql(orgIds)).append(")");
        }
        sql.append(")");
        if (spIds.size() > 0) {
            sql.append(" and FSolutionPeriodID in (").append(FormulaComputeHelper.buildInSql(spIds)).append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        while (rs.next()) {
            int objType = rs.getInt("objType");
            key = rs.getString("achId") + rs.getString("pdId") + rs.getString("spId");
            if (objType == 101) {
                key = key + rs.getString("orgId");
            } else if (objType == 100) {
                key = key + rs.getString("pId");
            }
            Object[] values = new Object[]{rs.getString("rv"), rs.getBigDecimal("tv"), rs.getBigDecimal("sv"), rs.getBigDecimal("cv"), rs.getBigDecimal("rf")};
            map.put(key, values);
        }
        HashMap valueMap = new HashMap();
        HashMap<String, Object> numMap = new HashMap<String, Object>();
        HashMap<String, Object> txtMap = new HashMap<String, Object>();
        int j2 = aeColl.size();
        for (int i = 0; i < j2; ++i) {
            FormulaAchieveEntryInfo aeInfo = aeColl.get(i);
            DataTypeEnum aiDt = aeInfo.getAchieveItem().getDataType();
            key = null;
            key = aeInfo.getAchieveItem().getId().toString();
            key = FormulaPeriodEnum.current.equals((Object)aeInfo.getPeriodType()) ? key + adInfo.getPeriod().getId().toString() : key + aeInfo.getPeriod();
            key = aeInfo.isDefaultSp() ? key + adInfo.getSolutionPeriod().getId().toString() : key + aeInfo.getSolutionPeriod();
            if (FormulaAchieveObjectEnum.current.equals((Object)aeInfo.getObjectType())) {
                if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)adInfo.getEvaluObjectType())) {
                    key = key + adInfo.getOrgUnit().getId().toString();
                } else if (EvaluObjectTypeEnum.PERSON.equals((Object)adInfo.getEvaluObjectType())) {
                    key = key + adInfo.getPerson().getId().toString();
                }
            } else {
                key = key + aeInfo.getObject();
            }
            if (!map.containsKey(key)) continue;
            Object[] arr = (Object[])map.get(key);
            int dt = aeInfo.getDataType().getValue();
            Object val = null;
            if (dt == 1) {
                val = arr[0];
            } else if (dt == 2) {
                val = arr[1];
            } else if (dt == 3) {
                val = arr[2];
            } else if (dt == 4) {
                val = arr[3];
            } else if (dt == 5) {
                val = arr[4];
            }
            if (DataTypeEnum.NUMERICAL.equals((Object)aiDt) || DataTypeEnum.PERCENT.equals((Object)aiDt)) {
                numMap.put(aeInfo.getNumber(), val);
                continue;
            }
            txtMap.put(aeInfo.getNumber(), val);
        }
        valueMap.put("nums", numMap);
        valueMap.put("txts", txtMap);
        return valueMap;
    }

    private Map getSysElementData(Context ctx, AchieveDataInfo adInfo) throws Exception {
        StringBuffer objIds;
        StringBuffer spIds;
        if (adInfo == null || adInfo.getFormula() == null) {
            return Collections.EMPTY_MAP;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("formula.id", (Object)adInfo.getFormula().getId().toString()));
        evi.setFilter(fi);
        FormulaSystemEntryCollection seColl = FormulaSystemEntryFactory.getLocalInstance(ctx).getFormulaSystemEntryCollection(evi);
        if (seColl.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        Map condition = new HashMap();
        int j = seColl.size();
        for (int i = 0; i < j; ++i) {
            FormulaSystemEntryInfo seInfo = seColl.get(i);
            PerfModeEnum pm = seInfo.getPerfMode();
            String seSpId = seInfo.getSolutionPeriod();
            String objId = seInfo.getObject();
            if (objId != null && objId.trim().length() > 0) {
                objId = FormulaComputeHelper.getOrgOrPersonId(ctx, objId, pm);
            } else if (PerfModeEnum.orgTarget.equals((Object)pm) && EvaluObjectTypeEnum.PERSON.equals((Object)adInfo.getEvaluObjectType())) {
                FormulaComputeHelper.getOwnerOrg(ctx, adInfo.getPerson().getId().toString());
            } else if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)adInfo.getEvaluObjectType())) {
                objId = adInfo.getOrgUnit().getId().toString();
            } else if (EvaluObjectTypeEnum.PERSON.equals((Object)adInfo.getEvaluObjectType())) {
                objId = adInfo.getPerson().getId().toString();
            }
            if (PerfModeEnum.personTarget.equals((Object)pm)) {
                condition = FormulaComputeHelper.buildConditionMap(condition, "1", seSpId);
                condition = FormulaComputeHelper.buildConditionMap(condition, "2", objId);
                continue;
            }
            if (PerfModeEnum.orgTarget.equals((Object)pm)) {
                condition = FormulaComputeHelper.buildConditionMap(condition, "3", seSpId);
                condition = FormulaComputeHelper.buildConditionMap(condition, "4", objId);
                continue;
            }
            if (PerfModeEnum.personMulti.equals((Object)pm)) {
                condition = FormulaComputeHelper.buildConditionMap(condition, "5", seSpId);
                condition = FormulaComputeHelper.buildConditionMap(condition, "6", objId);
                continue;
            }
            if (PerfModeEnum.orgMulti.equals((Object)pm)) {
                condition = FormulaComputeHelper.buildConditionMap(condition, "7", seSpId);
                condition = FormulaComputeHelper.buildConditionMap(condition, "8", objId);
                continue;
            }
            if (PerfModeEnum.complex.equals((Object)pm)) {
                condition = FormulaComputeHelper.buildConditionMap(condition, "9", seSpId);
                condition = FormulaComputeHelper.buildConditionMap(condition, "10", objId);
                continue;
            }
            if (!PerfModeEnum.sum.equals((Object)pm)) continue;
            condition = FormulaComputeHelper.buildConditionMap(condition, "11", seSpId);
            condition = FormulaComputeHelper.buildConditionMap(condition, "12", objId);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        if (condition.get("1") != null && condition.get("2") != null) {
            spIds = (StringBuffer)condition.get("1");
            objIds = (StringBuffer)condition.get("2");
            sql.append(" select er.FSolutionPeriodID spId,eo.FObjectID objId, ");
            sql.append(" er.FTargetEvaluScore score,er.FModifiedScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_EvaluResult er ");
            sql.append(" left join T_PF_EvaluObject eo on er.FEvaluObjectID = eo.fid ");
            sql.append(" left join T_PF_Rank rk on er.FPerfRankID = rk.FID ");
            sql.append(" where er.FSolutionPeriodID in(").append(spIds.toString()).append(")");
            sql.append(" and eo.FObjectID in(").append(objIds.toString()).append(")");
            sql.append(" and FEvaluObjectType = ").append(100);
        }
        if (condition.get("3") != null && condition.get("4") != null) {
            spIds = (StringBuffer)condition.get("3");
            objIds = (StringBuffer)condition.get("4");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" select er.FSolutionPeriodID spId,eo.FObjectID objId, ");
            sql.append(" er.FTargetEvaluScore score,er.FModifiedScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_EvaluResult er ");
            sql.append(" left join T_PF_EvaluObject eo on er.FEvaluObjectID = eo.fid ");
            sql.append(" left join T_PF_Rank rk on er.FPerfRankID = rk.FID ");
            sql.append(" where er.FSolutionPeriodID in(").append(spIds.toString()).append(")");
            sql.append(" and eo.FObjectID in(").append(objIds.toString()).append(")");
            sql.append(" and FEvaluObjectType = ").append(101);
        }
        if (condition.get("5") != null && condition.get("6") != null) {
            spIds = (StringBuffer)condition.get("5");
            objIds = (StringBuffer)condition.get("6");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" select er.FSolutionPeriodID spId,eo.FPersonID objId, ");
            sql.append(" er.FEvaluScore score,er.FModifiedScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_MDEVALURESULT er ");
            sql.append(" left join T_PF_MultiDimentionObject eo on er.FMdObjectID = eo.fid ");
            sql.append(" left join T_PF_Rank rk on er.FRankID = rk.FID ");
            sql.append(" where er.FSolutionPeriodID in(").append(spIds.toString()).append(")");
            sql.append(" and eo.FPersonID in(").append(objIds.toString()).append(")");
            sql.append(" and FEvaluObjectType = ").append(100);
        }
        if (condition.get("7") != null && condition.get("8") != null) {
            spIds = (StringBuffer)condition.get("7");
            objIds = (StringBuffer)condition.get("8");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" select er.FSolutionPeriodID spId,eo.FEvaluOrgID objId, ");
            sql.append(" er.FEvaluScore score,er.FModifiedScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_MDEVALURESULT er ");
            sql.append(" left join T_PF_MultiDimentionObject eo on er.FMdObjectID = eo.fid ");
            sql.append(" left join T_PF_Rank rk on er.FRankID = rk.FID ");
            sql.append(" where er.FSolutionPeriodID in(").append(spIds.toString()).append(")");
            sql.append(" and eo.FEvaluOrgID in(").append(objIds.toString()).append(")");
            sql.append(" and FEvaluObjectType = ").append(101);
        }
        if (condition.get("9") != null && condition.get("10") != null) {
            spIds = (StringBuffer)condition.get("9");
            objIds = (StringBuffer)condition.get("10");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" select er.FSolutionPeriodID spId,eo.FPersonID objId, ");
            sql.append(" er.FEvaluScore score,er.FModifiedScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_SYNEVALURESULT er ");
            sql.append(" left join T_PF_SynEvaluObject eo on er.FSynObjectID = eo.fid ");
            sql.append(" left join T_PF_Rank rk on er.FRankID = rk.FID ");
            sql.append(" where er.FSolutionPeriodID in(").append(spIds.toString()).append(")");
            sql.append(" and eo.FPersonID in(").append(objIds.toString()).append(")");
        }
        if (condition.get("11") != null && condition.get("12") != null) {
            spIds = (StringBuffer)condition.get("9");
            objIds = (StringBuffer)condition.get("10");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" select sp.FSumSolutionID spId,sp.FPersonID objId, ");
            sql.append(" sr.FScore score,sr.FModifyScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_SumResult sr ");
            sql.append(" left join T_PF_SumPerson sp on sr.FSumPersonID = sp.fid ");
            sql.append(" left join T_PF_Rank rk on er.FRankID = rk.FID ");
            sql.append(" where sp.FSumSolutionID in(").append(spIds.toString()).append(")");
            sql.append(" and sp.FPersonID in(").append(objIds.toString()).append(")");
        }
        if (sql.length() <= 0) {
            return Collections.EMPTY_MAP;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String str = rs.getString("spId") + rs.getString("objId");
            resultMap.put(str + 10, rs.getBigDecimal("score"));
            resultMap.put(str + 20, rs.getBigDecimal("mScore"));
            if (LocaleUtils.getLocale((String)"l1").equals(ctx.getLocale())) {
                resultMap.put(str + 30, rs.getString("rk1"));
                continue;
            }
            if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale())) {
                resultMap.put(str + 30, rs.getString("rk2"));
                continue;
            }
            if (!LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale())) continue;
            resultMap.put(str + 30, rs.getString("rk3"));
        }
        HashMap valueMap = new HashMap();
        HashMap nums = new HashMap();
        HashMap txts = new HashMap();
        int j2 = seColl.size();
        for (int i = 0; i < j2; ++i) {
            FormulaSystemEntryInfo seInfo = seColl.get(i);
            EvaluResultItemEnum dt = seInfo.getDataType();
            String seSpId = seInfo.getSolutionPeriod();
            String objId = seInfo.getObject();
            if (objId == null || objId.trim().length() <= 0) {
                if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)adInfo.getEvaluObjectType())) {
                    objId = adInfo.getOrgUnit().getId().toString();
                } else if (EvaluObjectTypeEnum.PERSON.equals((Object)adInfo.getEvaluObjectType())) {
                    objId = adInfo.getPerson().getId().toString();
                }
            } else {
                objId = FormulaComputeHelper.getOrgOrPersonId(ctx, objId, seInfo.getPerfMode());
            }
            String key = seSpId + objId + dt.getValue();
            if (EvaluResultItemEnum.PERF_RANK.equals((Object)seInfo.getDataType())) {
                txts.put(seInfo.getNumber(), resultMap.get(key));
                continue;
            }
            nums.put(seInfo.getNumber(), resultMap.get(key));
        }
        valueMap.put("nums", nums);
        valueMap.put("txts", txts);
        return valueMap;
    }

    private void checkCycleRely(Context ctx, AchieveDataInfo adInfo) throws BOSException, EASBizException {
        if (adInfo == null || adInfo.getFormula() == null || adInfo.getSolutionPeriod() == null || adInfo.getPeriod() == null || adInfo.getEvaluObjectType() == null) {
            return;
        }
        String spId = adInfo.getSolutionPeriod().getId().toString();
        String achieveItemId = adInfo.getAchieveItem().getId().toString();
        String periodId = adInfo.getPeriod().getId().toString();
        EvaluObjectTypeEnum evaluObjectType = adInfo.getEvaluObjectType();
        String ksql = adInfo.getFormula().getExp().getSql();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("formula.id", (Object)adInfo.getFormula().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("dataType", (Object)new Integer(1)));
        fi.getFilterItems().add(new FilterItemInfo("achieveItem.id", (Object)achieveItemId));
        FilterInfo periodFi = new FilterInfo();
        periodFi.getFilterItems().add(new FilterItemInfo("period", (Object)periodId));
        periodFi.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(1)));
        periodFi.setMaskString("#0 or #1");
        fi.mergeFilter(periodFi, "and");
        FilterInfo spFi = new FilterInfo();
        spFi.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)spId));
        spFi.getFilterItems().add(new FilterItemInfo("defaultSp", (Object)true));
        spFi.setMaskString("#0 or #1");
        fi.mergeFilter(spFi, "and");
        FilterInfo objFi = new FilterInfo();
        objFi.getFilterItems().add(new FilterItemInfo("objectType", (Object)new Integer(1)));
        if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)evaluObjectType)) {
            objFi.getFilterItems().add(new FilterItemInfo("object", (Object)adInfo.getOrgUnit().getId().toString()));
        } else {
            objFi.getFilterItems().add(new FilterItemInfo("object", (Object)adInfo.getPerson().getId().toString()));
        }
        objFi.setMaskString("#0 or #1");
        fi.mergeFilter(objFi, "and");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        FormulaAchieveEntryCollection coll = FormulaAchieveEntryFactory.getLocalInstance(ctx).getFormulaAchieveEntryCollection(evi);
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            FormulaAchieveEntryInfo eInfo = coll.get(i);
            if (ksql.indexOf(eInfo.getNumber()) < 0) continue;
            throw new AchieveDataComputeException(AchieveDataComputeException.FORMULA_RECLE_RELY);
        }
    }
}

