/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.AchieveDataComputeFacadeFactory;
import com.kingdee.eas.hr.perf.AchieveDataException;
import com.kingdee.eas.hr.perf.AchieveDataFactory;
import com.kingdee.eas.hr.perf.AchieveDataInfo;
import com.kingdee.eas.hr.perf.AchieveItemCollection;
import com.kingdee.eas.hr.perf.AchieveItemFactory;
import com.kingdee.eas.hr.perf.AchieveItemInfo;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodFactory;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodInfo;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.PerformTargetItemCollection;
import com.kingdee.eas.hr.perf.PerformTargetItemFactory;
import com.kingdee.eas.hr.perf.PerformTargetItemInfo;
import com.kingdee.eas.hr.perf.ReportFrequencyEnum;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.app.AbstractAchieveDataFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AchieveDataFacadeControllerBean
extends AbstractAchieveDataFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.AchieveDataFacadeControllerBean");
    private static int callCount = 0;

    @Override
    protected void _splitAchieveData(Context ctx, String spId, List tesIds) throws BOSException, EASBizException {
        if (tesIds == null) {
            this._splitAchieveData2(ctx, spId, null);
        } else {
            if (spId == null) {
                return;
            }
            IRowSet rs = this.checkDuplicatedData(ctx, spId, tesIds, false);
            this._splitAchieveDataImp(ctx, spId, tesIds, rs);
        }
    }

    @Override
    protected void _splitAchieveData2(Context ctx, String spId, List tesIds) throws BOSException, EASBizException {
        if (spId == null) {
            return;
        }
        IRowSet rs = this.checkDuplicatedData(ctx, spId, tesIds, true);
        this._splitAchieveDataImp(ctx, spId, tesIds, rs);
    }

    protected void _splitAchieveDataImp(Context ctx, String spId, List tesIds, IRowSet rs) throws BOSException, EASBizException {
        try {
            while (rs.next()) {
                if (rs.getInt("c") <= 1) continue;
                throw new AchieveDataException(AchieveDataException.DUPLICATED_ACHIEVEITEM, new Object[]{rs.getObject("c"), rs.getString("itemName")});
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("evaluSolution.id");
        sic.add("evaluSolution.solutionType");
        sic.add("achievePeriod.id");
        sic.add("achievePeriod.frequency");
        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spId), sic);
        AchieveStatisticsPeriodInfo apInfo = spInfo.getAchievePeriod();
        if (apInfo == null) {
            return;
        }
        String parentPerId = apInfo.getId().toString();
        ArrayList<String> ppIds = new ArrayList<String>();
        ppIds.add(parentPerId);
        ReportFrequencyEnum freqEnum = apInfo.getFrequency();
        if (freqEnum == null || freqEnum.getValue() == 10) {
            return;
        }
        int type = spInfo.getEvaluSolution().getSolutionType().getValue();
        String innerSql = this.getInnerSql(tesIds);
        boolean innerSqlIsNull = innerSql == null || innerSql.trim().length() <= 0;
        StringBuffer del_sql = new StringBuffer();
        del_sql.append(" delete from T_PF_AchieveData ");
        del_sql.append(" where FSolutionPeriodID = '").append(spId).append("'");
        del_sql.append(" and FPeriodID = '").append(parentPerId).append("'");
        del_sql.append(" and FRootPeriod = ").append(1);
        del_sql.append(" and FAchieveItemID in ");
        del_sql.append("(");
        del_sql.append(" select fm.FAchieveItemID from T_PF_TargetEvaluStore tes ");
        del_sql.append(" left join T_PF_EvaluTarget et on tes.FEvaluTargetID = et.fid ");
        del_sql.append(" left join T_PF_Formula fm on et.FFormulaID = fm.fid ");
        del_sql.append(" where tes.FSolutionPeriodID ='").append(spId).append("'");
        if (!innerSqlIsNull) {
            del_sql.append(" and tes.FId in(").append(innerSql).append(")");
        }
        del_sql.append(" and et.FFormulaID is not null ");
        del_sql.append(" ) ");
        if (type == 101) {
            del_sql.append(" and FOrgUnitID ");
        } else {
            del_sql.append(" and FPersonID ");
        }
        del_sql.append(" in (");
        del_sql.append(" select eo.FObjectID from T_PF_TargetEvaluStore tes ");
        del_sql.append(" left join T_PF_EvaluObject eo on tes.FEvaluObjectID = eo.fid ");
        del_sql.append(" where tes.FSolutionPeriodID ='").append(spId).append("'");
        if (!innerSqlIsNull) {
            del_sql.append(" and tes.FId in(").append(innerSql).append(")");
        }
        del_sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)del_sql.toString());
        del_sql.delete(0, del_sql.length());
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(" insert into T_PF_AchieveData ");
        sqlBuf.append(" ( ");
        sqlBuf.append(" FId,FDataType,FRootPeriod,FSolutionPeriodID,FPeriodID,");
        sqlBuf.append(" FTargetID,FAchieveItemID, ");
        if (type == 101) {
            sqlBuf.append(" FOrgUnitID,");
        } else {
            sqlBuf.append(" FPersonID,");
        }
        sqlBuf.append(" FEvaluObjectID, FEvaluObjectType, FPositionID, FResponserID,");
        sqlBuf.append(" FThresholdValue,FStandardValue,FChallengeValue,FReservedField2");
        sqlBuf.append(" ) ");
        sqlBuf.append(" ( ");
        sqlBuf.append(" select newbosid('7B2BF5A8'),20,1,");
        sqlBuf.append("'").append(spId).append("'").append(",");
        sqlBuf.append("'").append(parentPerId).append("'").append(",");
        sqlBuf.append(" et.fid,fm.FAchieveItemID,");
        sqlBuf.append(" eo.FObjectID,eo.fid,eo.FEvaluObjectType,eo.FPositionID,eo.FResponserID,");
        sqlBuf.append(" tes.FThresholdValue,tes.FStandardValue,tes.FChallengeValue,et.FReservedField2 ");
        sqlBuf.append(" from T_PF_TargetEvaluStore tes ");
        sqlBuf.append(" left join T_PF_EvaluObject eo on tes.FEvaluObjectID = eo.fid ");
        sqlBuf.append(" left join T_PF_EvaluTarget et on tes.FEvaluTargetID = et.fid ");
        sqlBuf.append(" left join T_PF_Formula fm on et.FFormulaID = fm.fid ");
        sqlBuf.append(" where tes.FSolutionPeriodID ='").append(spId).append("'");
        if (!innerSqlIsNull) {
            sqlBuf.append(" and tes.FId in(").append(innerSql).append(")");
        }
        sqlBuf.append(" and et.FFormulaID is not null ");
        sqlBuf.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
        sqlBuf.delete(0, sqlBuf.length());
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentPerId));
        if (!AchieveStatisticsPeriodFactory.getLocalInstance(ctx).exists(fi)) {
            return;
        }
        StringBuffer querySql = new StringBuffer();
        querySql.append(" select et.fid targetId,fm.fid formulaId,");
        querySql.append(" fm.FAchieveItemID achieveItemId, eo.FObjectID ObjId,");
        querySql.append(" eo.fid evaluObjectId,eo.FEvaluObjectType evaluObjectType,");
        querySql.append(" eo.FPositionID psId, eo.FResponserID rsId,et.FReportFrequency freq ");
        querySql.append(" from T_PF_TargetEvaluStore tes ");
        querySql.append(" left join T_PF_EvaluObject eo on tes.FEvaluObjectID = eo.fid ");
        querySql.append(" left join T_PF_EvaluTarget et on tes.FEvaluTargetID = et.fid ");
        querySql.append(" left join T_PF_Formula fm on et.FFormulaID = fm.fid ");
        querySql.append(" where tes.FSolutionPeriodID ='").append(spId).append("'");
        if (!innerSqlIsNull) {
            querySql.append(" and tes.FId in(").append(innerSql).append(")");
        }
        querySql.append(" and et.FFormulaID is not null ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        StringBuffer insSql = new StringBuffer();
        insSql.append(" insert into T_PF_AchieveData ");
        insSql.append(" ( ");
        insSql.append(" fid,FDataType,FRootPeriod,FSolutionPeriodID,FTargetID,FPeriodID,");
        insSql.append(" FAchieveItemID,FEvaluObjectID,FEvaluObjectType,FPositionID,FResponserID,");
        if (type == 101) {
            insSql.append(" FOrgUnitID ");
        } else {
            insSql.append(" FPersonID ");
        }
        insSql.append(" )values ");
        insSql.append(" ( ");
        insSql.append(" newbosid('7B2BF5A8'),?,?,?,?,?,?,?,?,?,?,?");
        insSql.append(" ) ");
        Connection conn = null;
        conn = super.getConnection(ctx);
        PreparedStatement ps = null;
        HashMap<String, List> perIds = new HashMap<String, List>();
        HashMap<String, String> achIds = new HashMap<String, String>();
        try {
            ps = conn.prepareStatement(insSql.toString());
            while (row.next()) {
                String targetId = row.getString("targetId");
                String evaluObjectId = row.getString("evaluObjectId");
                String achieveItemId = row.getString("achieveItemId");
                String objId = row.getString("ObjId");
                String psId = row.getString("psId");
                String rsId = row.getString("rsId");
                int evaluObjectType = row.getInt("evaluObjectType");
                int freq = row.getInt("freq");
                if (freq == 10 || freq >= freqEnum.getValue()) continue;
                callCount = 0;
                List list = this.getChildrenPeriod(ctx, ppIds, freq);
                int n = list.size();
                for (int m = 0; m < n; ++m) {
                    ps.setInt(1, 20);
                    ps.setInt(2, 0);
                    ps.setString(3, spId);
                    ps.setString(4, targetId);
                    ps.setString(5, list.get(m).toString());
                    ps.setString(6, achieveItemId);
                    ps.setString(7, evaluObjectId);
                    ps.setInt(8, evaluObjectType);
                    ps.setString(9, psId);
                    ps.setString(10, rsId);
                    ps.setString(11, objId);
                    ps.addBatch();
                }
                perIds.put(objId, list);
                achIds.put(objId, achieveItemId);
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        if (perIds.size() > 0) {
            del_sql.delete(0, del_sql.length());
            del_sql.append(" delete from T_PF_AchieveData ");
            del_sql.append(" where FSolutionPeriodID = '").append(spId).append("'");
            del_sql.append(" and FDataType = ").append(10);
            del_sql.append(" and FRootPeriod = ").append(0);
            del_sql.append(" and FPeriodID = ? ");
            del_sql.append(" and FAchieveItemID = ? ");
            if (type == 101) {
                del_sql.append(" and FOrgUnitID = ? ");
            } else {
                del_sql.append(" and FPersonID = ? ");
            }
            Set set = perIds.entrySet();
            try {
                ps = conn.prepareStatement(del_sql.toString());
                for (Map.Entry entry : set) {
                    String objId = entry.getKey().toString();
                    String achieveItemId = (String)achIds.get(objId);
                    List list = (List)entry.getValue();
                    if (achieveItemId == null || list == null || list.size() <= 0) continue;
                    int j = list.size();
                    for (int i = 0; i < j; ++i) {
                        String perId = list.get(i).toString();
                        ps.setString(1, perId);
                        ps.setString(2, achieveItemId);
                        ps.setString(3, objId);
                        ps.addBatch();
                    }
                }
                ps.executeBatch();
            }
            catch (SQLException ex) {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            finally {
                SQLUtils.cleanup((Statement)ps, (Connection)conn);
            }
        }
        super.updateAchieveDataParent(ctx, spId, type);
    }

    @Override
    protected void _removeAchieveData(Context ctx, String spId, List tesIds) throws BOSException, EASBizException {
        if (spId == null) {
            return;
        }
        if (tesIds == null || tesIds.size() <= 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spId));
            AchieveDataFactory.getLocalInstance(ctx).delete(fi);
        } else {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("evaluSolution.id");
            sic.add("evaluSolution.solutionType");
            sic.add("achievePeriod.id");
            sic.add("achievePeriod.frequency");
            SolutionPeriodInfo spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spId), sic);
            int type = spInfo.getEvaluSolution().getSolutionType().getValue();
            String innerSql = this.getInnerSql(tesIds);
            boolean innerSqlIsNull = innerSql == null || innerSql.trim().length() <= 0;
            StringBuffer del_sql = new StringBuffer();
            del_sql.append(" delete from T_PF_AchieveData ");
            del_sql.append(" where FSolutionPeriodID = '").append(spId).append("'");
            if (type == 101) {
                del_sql.append(" and FOrgUnitID ");
            } else {
                del_sql.append(" and FPersonID ");
            }
            del_sql.append(" in (");
            del_sql.append(" select eo.FObjectID from T_PF_TargetEvaluStore tes ");
            del_sql.append(" left join T_PF_EvaluObject eo on tes.FEvaluObjectID = eo.fid ");
            del_sql.append(" where tes.FSolutionPeriodID ='").append(spId).append("'");
            if (!innerSqlIsNull) {
                del_sql.append(" and tes.FId in(").append(innerSql).append(")");
            }
            del_sql.append(" ) ");
            DbUtil.execute((Context)ctx, (String)del_sql.toString());
        }
    }

    @Override
    protected void _addNewData(Context ctx, Map map, List perList, List objList, String spId, String evaluType) throws BOSException, EASBizException {
        if (map == null || perList == null || objList == null || spId == null || evaluType == null) {
            return;
        }
        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spId));
        if (spInfo.getAchievePeriod() == null) {
            return;
        }
        String spPerId = spInfo.getAchievePeriod().getId().toString();
        Collection formulaIds = map.values();
        Map tgMap = this.getPerformTargetItem(ctx, formulaIds);
        Map ppMap = null;
        if (evaluType.equals("person")) {
            ppMap = this.getPersonPosition(ctx, objList);
        }
        Map opMap = null;
        if (evaluType.equals("org")) {
            opMap = this.getOrgResponserIds(ctx, objList);
        }
        StringBuffer insSql = new StringBuffer();
        insSql.append(" insert into T_PF_AchieveData ");
        insSql.append(" ( ");
        insSql.append(" fid,FDataType,FRootPeriod,FSolutionPeriodID,FTargetID,");
        insSql.append(" FPeriodID,FFormulaID,FAchieveItemID,FEvaluObjectID,");
        insSql.append(" FEvaluObjectType,FPositionID,FResponserID,");
        insSql.append(" FThresholdValue,FStandardValue,FChallengeValue,");
        if (evaluType.equals("org")) {
            insSql.append(" FOrgUnitID");
        } else {
            insSql.append(" FPersonID");
        }
        insSql.append(" )values ");
        insSql.append(" ( ");
        insSql.append(" newbosid('7B2BF5A8'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
        insSql.append(" ) ");
        Connection conn = super.getConnection(ctx);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(insSql.toString());
            String achId = null;
            String perId = null;
            String objId = null;
            String formulaId = null;
            AchieveDataInfo adInfo = null;
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                achId = entry.getKey().toString();
                formulaId = entry.getValue().toString();
                adInfo = (AchieveDataInfo)tgMap.get(formulaId);
                for (int j = 0; j < perList.size(); ++j) {
                    perId = perList.get(j).toString();
                    for (int k = 0; k < objList.size(); ++k) {
                        objId = objList.get(k).toString();
                        if (this.isExistData(ctx, achId, perId, objId, spId, evaluType)) continue;
                        ps.setInt(1, 10);
                        if (perId.equals(spPerId)) {
                            ps.setInt(2, 1);
                        } else {
                            ps.setInt(2, 0);
                        }
                        ps.setString(3, spId);
                        ps.setString(4, null);
                        ps.setString(5, perId);
                        ps.setString(6, formulaId);
                        ps.setString(7, achId);
                        ps.setString(8, null);
                        if (evaluType.equals("person")) {
                            ps.setInt(9, 100);
                            if (ppMap.get(objId) != null) {
                                ps.setString(10, ppMap.get(objId).toString());
                            } else {
                                ps.setNull(10, SQLType.CHAR.getSQLType());
                            }
                            ps.setNull(11, SQLType.CHAR.getSQLType());
                        } else {
                            ps.setInt(9, 101);
                            ps.setString(10, null);
                            if (opMap.get(objId) != null) {
                                ps.setString(11, opMap.get(objId).toString());
                            } else {
                                ps.setNull(11, SQLType.CHAR.getSQLType());
                            }
                        }
                        if (adInfo != null) {
                            ps.setBigDecimal(12, adInfo.getThresholdValue());
                            ps.setBigDecimal(13, adInfo.getStandardValue());
                            ps.setBigDecimal(14, adInfo.getChallengeValue());
                        } else {
                            ps.setNull(12, 3);
                            ps.setNull(13, 3);
                            ps.setNull(14, 3);
                        }
                        ps.setString(15, objId);
                        ps.addBatch();
                    }
                }
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
        if (evaluType.equals("person")) {
            super.updateAchieveDataParent(ctx, spId, 100);
        } else if (evaluType.equals("org")) {
            super.updateAchieveDataParent(ctx, spId, 101);
        }
    }

    @Override
    protected void _updateAchieveData(Context ctx, Map formulaMap, Map valueMap) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            Object value;
            Object key;
            Set set;
            String sql;
            if (formulaMap != null && formulaMap.size() > 0) {
                sql = " update t_pf_achieveData set FFormulaId = ? where FID = ?";
                conn = super.getConnection(ctx);
                ps = conn.prepareStatement(sql);
                set = formulaMap.entrySet();
                for (Map.Entry entry : set) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (value != null && value.toString().trim().length() > 0) {
                        ps.setString(1, value.toString());
                    } else {
                        ps.setString(1, null);
                    }
                    ps.setString(2, key.toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            if (valueMap != null && valueMap.size() > 0) {
                sql = " update t_pf_achieveData set FRealValue = ? where FID = ?";
                conn = super.getConnection(ctx);
                ps = conn.prepareStatement(sql);
                set = valueMap.entrySet();
                for (Map.Entry entry : set) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (value != null && value.toString().trim().length() > 0) {
                        ps.setString(1, value.toString());
                    } else {
                        ps.setString(1, null);
                    }
                    ps.setString(2, key.toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup(ps, conn);
        }
    }

    @Override
    protected void _updateAchieveDataParent(Context ctx, String solutionPeriodId, int evaluType) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_pf_achieveData set FParentId = ");
        sql.append("(");
        sql.append(" select ach.fid from t_pf_achieveData ach ");
        sql.append(" left join t_pf_solutionPeriod sp on ach.FSolutionPeriodId = sp.fid ");
        sql.append(" where ach.FPeriodId = sp.FAchievePeriodID ");
        sql.append(" and ach.FSolutionPeriodId = t_pf_achieveData.FSolutionPeriodId ");
        sql.append(" and t_pf_achieveData.FEvaluObjectType = ach.FEvaluObjectType ");
        sql.append(" and t_pf_achieveData.FAchieveItemId = ach.FAchieveItemId ");
        sql.append(" and ach.FRootPeriod = 1 ");
        if (evaluType == 100) {
            sql.append(" and t_pf_achieveData.FPersonId = ach.FPersonId ");
        } else if (evaluType == 101) {
            sql.append(" and t_pf_achieveData.FOrgUnitId = ach.FOrgUnitId");
        }
        if (solutionPeriodId != null) {
            sql.append(" and sp.FId = '").append(solutionPeriodId).append("'");
        }
        sql.append(" ) ");
        sql.append(" where FRootPeriod = 0 ");
        if (solutionPeriodId != null) {
            sql.append(" and FSolutionPeriodId = '").append(solutionPeriodId).append("'");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private List getChildrenPeriod(Context ctx, List parentIds, int childFre) throws BOSException, EASBizException {
        if (++callCount > 10 || parentIds == null || parentIds.size() <= 0) {
            return Collections.EMPTY_LIST;
        }
        StringBuffer sb = new StringBuffer();
        int j = parentIds.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'").append(parentIds.get(i).toString()).append("'");
        }
        String sql = "select FID,FFrequency from T_PF_AchieveStatisticsPeriod where FParentID in (" + sb.toString() + ")";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        List<String> list = new ArrayList();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            while (row.next()) {
                int inte = row.getInt("FFrequency");
                String fid = row.getString("FID");
                if (inte != childFre) {
                    ids.add(fid);
                    continue;
                }
                list.add(row.getString("FID"));
            }
            if (list.size() <= 0) {
                list = this.getChildrenPeriod(ctx, ids, childFre);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return list;
    }

    private Map getOrgResponserIds(Context ctx, List objList) throws BOSException, EASBizException {
        if (objList == null || objList.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer whe = new StringBuffer();
        int j = objList.size();
        for (int i = 0; i < j; ++i) {
            if (i != 0) {
                whe.append(",");
            }
            whe.append("'").append(objList.get(i).toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct org.fid orgId,pm.FPersonID pId from T_ORG_Admin org ");
        sql.append(" left join T_ORG_PositionMember pm on org.FResponPositionID = pm.FPositionID ");
        sql.append("  where pm.FIsPrimary = 1 ");
        sql.append(" and org.fid in (");
        sql.append(whe.toString());
        sql.append(")");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (row.next()) {
                if (map.containsKey(row.getString("orgId"))) continue;
                map.put(row.getString("orgId"), row.getString("pId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((ResultSet)row);
        }
        return map;
    }

    private Map getPersonPosition(Context ctx, List objList) throws BOSException, EASBizException {
        if (objList == null || objList.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer whe = new StringBuffer();
        int j = objList.size();
        for (int i = 0; i < j; ++i) {
            if (i != 0) {
                whe.append(",");
            }
            whe.append("'").append(objList.get(i).toString()).append("'");
        }
        String sql = " select FPersonID pId,FPositionID psId from T_ORG_PositionMember pm where FPersonID in(" + whe.toString() + ") and FIsPrimary = 1";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (row.next()) {
                map.put(row.getString("pId"), row.getString("psId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((ResultSet)row);
        }
        return map;
    }

    private Map getPerformTargetItem(Context ctx, Collection formulaIds) throws BOSException, EASBizException {
        if (formulaIds == null || formulaIds.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        HashSet set = new HashSet(formulaIds);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("formula.id", set, CompareType.INCLUDE));
        evi.setFilter(fi);
        PerformTargetItemCollection coll = PerformTargetItemFactory.getLocalInstance(ctx).getPerformTargetItemCollection(evi);
        HashMap<String, PerformTargetItemInfo> map = new HashMap<String, PerformTargetItemInfo>();
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            PerformTargetItemInfo info = coll.get(i);
            if (info.getFormula() == null) continue;
            String formulaId = info.getFormula().getId().toString();
            if (map.containsKey(formulaId)) {
                map.remove(formulaId);
                continue;
            }
            map.put(formulaId, info);
        }
        return map;
    }

    @Override
    protected Map _getNeedSynTargetData(Context ctx, String solutionPeriodId, String evaluType) throws BOSException, EASBizException {
        HashMap<String, AchieveItemInfo> m;
        if (solutionPeriodId == null) {
            return Collections.EMPTY_MAP;
        }
        EvaluObjectTypeEnum eType = null;
        if ("org".equals(evaluType)) {
            eType = EvaluObjectTypeEnum.ORGUNIT;
        } else if ("person".equals(evaluType)) {
            eType = EvaluObjectTypeEnum.PERSON;
        }
        SelectorItemCollection si = new SelectorItemCollection();
        si.add(new SelectorItemInfo("id"));
        si.add(new SelectorItemInfo("achievePeriod"));
        SolutionPeriodInfo sInfo = (SolutionPeriodInfo)SolutionPeriodFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(solutionPeriodId), si);
        String achievePeriodId = null;
        if (sInfo.getAchievePeriod() != null) {
            achievePeriodId = sInfo.getAchievePeriod().getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select ts.fid tgId,ts.FThresholdValue tv,ts.FStandardValue sv,");
        sql.append(" ts.FChallengeValue cv,fm.FAchieveItemID achId ,");
        sql.append(" eo.FObjectID objectID,et.fid etId");
        sql.append(" from T_PF_TargetEvaluStore ts ");
        sql.append(" left join T_PF_EvaluObject eo on ts.FEvaluObjectID = eo.fid");
        sql.append(" left join t_pf_evaluTarget et on ts.FEvaluTargetID = et.fid ");
        sql.append(" left join t_pf_formula fm on et.FFormulaId = fm.fid ");
        sql.append(" where fm.FAchieveItemID in ");
        sql.append(" ( ");
        sql.append(" select FAchieveItemID from t_pf_achieveData tpa");
        sql.append(" where tpa.FSolutionPeriodID = '").append(solutionPeriodId).append("'");
        sql.append(" and FEvaluObjectType =").append(eType.getValue());
        sql.append(" and FDataType = 10 ");
        sql.append(" and FRootPeriod = ");
        sql.append(new Integer(1));
        if (achievePeriodId != null) {
            sql.append(" and FPeriodID = '");
            sql.append(achievePeriodId);
            sql.append("' ");
        }
        sql.append(" ) ");
        sql.append(" and ts.FSolutionPeriodID ='").append(solutionPeriodId).append("'");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean hasDup = false;
        HashSet<String> dupAchIds = new HashSet<String>();
        try {
            while (row.next()) {
                List<TargetEvaluStoreInfo> list;
                String achId = row.getString("achId");
                String tgId = row.getString("etId");
                BigDecimal tv = row.getBigDecimal("tv");
                BigDecimal sv = row.getBigDecimal("sv");
                BigDecimal cv = row.getBigDecimal("cv");
                String objectId = row.getString("objectID");
                TargetEvaluStoreInfo info = new TargetEvaluStoreInfo();
                info.setThresholdValue(tv);
                info.setStandardValue(sv);
                info.setChallengeValue(cv);
                EvaluObjectInfo evaluObjectInfo = new EvaluObjectInfo();
                evaluObjectInfo.setObjectID(objectId);
                info.setEvaluObject(evaluObjectInfo);
                EvaluTargetInfo etInfo = new EvaluTargetInfo();
                etInfo.setId(BOSUuid.read((String)tgId));
                info.setEvaluTarget(etInfo);
                if (map.containsKey(achId)) {
                    list = (List)map.get(achId);
                    hasDup = true;
                    dupAchIds.add(achId);
                } else {
                    list = new ArrayList();
                    map.put(achId, list);
                }
                list.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((ResultSet)row);
        }
        if (hasDup) {
            map.put("hasDup", new Boolean(hasDup));
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            evi.setSelector(sic);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", dupAchIds, CompareType.INCLUDE));
            evi.setFilter(fi);
            AchieveItemCollection acColl = AchieveItemFactory.getLocalInstance(ctx).getAchieveItemCollection(evi);
            m = new HashMap<String, AchieveItemInfo>();
            int j = acColl.size();
            for (int i = 0; i < j; ++i) {
                AchieveItemInfo acInfo = acColl.get(i);
                m.put(acInfo.getId().toString(), acInfo);
            }
        } else {
            this._updateAchieveTarget(ctx, map, solutionPeriodId, evaluType);
            return Collections.EMPTY_MAP;
        }
        map.put("dupAch", m);
        return map;
    }

    @Override
    protected void _updateAchieveTarget(Context ctx, Map map, String spId, String evaluType) throws BOSException, EASBizException {
        if (map == null || map.size() <= 0 || spId == null || evaluType == null) {
            return;
        }
        int evaluObjectType = 0;
        if ("org".equals(evaluType)) {
            evaluObjectType = 101;
        } else if ("person".equals(evaluType)) {
            evaluObjectType = 100;
        }
        SelectorItemCollection si = new SelectorItemCollection();
        si.add(new SelectorItemInfo("id"));
        si.add(new SelectorItemInfo("achievePeriod"));
        SolutionPeriodInfo sInfo = (SolutionPeriodInfo)SolutionPeriodFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(spId), si);
        String achievePeriodId = null;
        if (sInfo.getAchievePeriod() != null) {
            achievePeriodId = sInfo.getAchievePeriod().getId().toString();
        }
        StringBuffer upd_sql = new StringBuffer();
        upd_sql.append(" update t_pf_achieveData ");
        upd_sql.append(" set FThresholdValue = ?,FStandardValue = ? ,FChallengeValue = ? ");
        upd_sql.append(" where FAchieveItemID = ?\u3000");
        upd_sql.append(" and FDataType = ").append(10);
        upd_sql.append(" and FSolutionPeriodID ='").append(spId).append("'");
        if ("person".equals(evaluType)) {
            upd_sql.append(" and FPersonID = ?");
        } else {
            upd_sql.append(" and FOrgUnitID = ?");
        }
        upd_sql.append(" and FEvaluObjectType =").append(evaluObjectType);
        upd_sql.append(" and FRootPeriod = ");
        upd_sql.append(new Integer(1));
        if (achievePeriodId != null) {
            upd_sql.append(" and FPeriodID = '");
            upd_sql.append(achievePeriodId);
            upd_sql.append("' ");
        }
        Connection conn = super.getConnection(ctx);
        Set set = map.entrySet();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(upd_sql.toString());
            for (Map.Entry entry : set) {
                TargetEvaluStoreInfo value;
                String key = entry.getKey().toString();
                if (entry.getValue() instanceof List) {
                    value = (TargetEvaluStoreInfo)((List)entry.getValue()).get(0);
                } else {
                    if (!(entry.getValue() instanceof TargetEvaluStoreInfo)) continue;
                    value = (TargetEvaluStoreInfo)entry.getValue();
                }
                ps.setBigDecimal(1, value.getThresholdValue());
                ps.setBigDecimal(2, value.getStandardValue());
                ps.setBigDecimal(3, value.getChallengeValue());
                ps.setString(4, key);
                ps.setString(5, value.getEvaluObject().getObjectID());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
    }

    @Override
    protected void _computeAchieveData(Context ctx, String spId, String evaluType) throws BOSException, EASBizException {
        if (spId == null || evaluType == null) {
            return;
        }
        IRowSet row = null;
        IQueryExecutor exec = null;
        boolean isOrg = "org".equals(evaluType);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spId));
        MetaDataPK queryPK = null;
        if (isOrg) {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "AchieveDataForOrgQuery");
            fi.getFilterItems().add(new FilterItemInfo("evaluObjectType", (Object)new Integer(101)));
        } else {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "AchieveDataForPersonQuery");
            fi.getFilterItems().add(new FilterItemInfo("evaluObjectType", (Object)new Integer(100)));
        }
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        evi.setFilter(fi);
        exec.setObjectView(evi);
        row = exec.executeQuery();
        HashMap<String, String> map = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            while (row.next()) {
                boolean rp = row.getBoolean("rootPeriod");
                String formulaId = row.getString("formula.id");
                if (rp || formulaId == null || formulaId.trim().length() <= 0) continue;
                AchieveDataComputeFacadeFactory.getLocalInstance(ctx).computeAchieveDataRealValue(row.getString("id"));
            }
            String preObjId = null;
            String key = null;
            BigDecimal big = null;
            String objId = null;
            row.beforeFirst();
            while (row.next()) {
                int dt = row.getInt("achieveItem.dataType");
                boolean rp = row.getBoolean("rootPeriod");
                String formulaId = row.getString("formula.id");
                if (rp && formulaId != null && formulaId.trim().length() > 0) {
                    AchieveDataComputeFacadeFactory.getLocalInstance(ctx).computeAchieveDataRealValue(row.getString("id"));
                    continue;
                }
                objId = isOrg ? row.getString("orgUnit.id") : row.getString("person.id");
                if (rp || dt != 1) {
                    if (key != null) {
                        if (big == null) {
                            map.put(key, "");
                        } else {
                            map.put(key, big.toString());
                        }
                    }
                    big = null;
                    preObjId = objId;
                    key = row.getString("id");
                    continue;
                }
                String rv = row.getString("realValue");
                if (objId.equals(preObjId) && rv != null && rv.toString().trim().length() > 0) {
                    if (big == null) {
                        big = new BigDecimal("0.00");
                    }
                    big = big.add(new BigDecimal(rv));
                }
                preObjId = objId;
            }
            StringBuffer upd_sql = new StringBuffer();
            upd_sql.append(" update t_pf_achieveData set FRealValue = ? ");
            upd_sql.append(" where FId = ? ");
            upd_sql.append(" and exists (select fid from t_pf_achieveData where FParentID = ?)");
            conn = super.getConnection(ctx);
            ps = conn.prepareStatement(upd_sql.toString());
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                if (entry.getValue() == null) continue;
                ps.setString(1, entry.getValue().toString());
                ps.setString(2, entry.getKey().toString());
                ps.setString(3, entry.getKey().toString());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected Map _getOrgResponser(Context ctx, List orgIds) throws BOSException, EASBizException {
        if (orgIds == null || orgIds.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer whe = new StringBuffer();
        int j = orgIds.size();
        for (int i = 0; i < j; ++i) {
            if (i != 0) {
                whe.append(",");
            }
            whe.append("'").append(orgIds.get(i).toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct org.fid orgId,pm.FPersonID pId, ");
        sql.append(" p.FName_L1 n1,p.FName_L2 n2,p.FName_L3 n3 ");
        sql.append(" from T_ORG_Admin org ");
        sql.append(" left join T_ORG_PositionMember pm on org.FResponPositionID = pm.FPositionID ");
        sql.append(" left join T_BD_Person p on pm.FPersonId = p.fid ");
        sql.append("  where pm.FIsPrimary = 1 ");
        sql.append(" and org.fid in (");
        sql.append(whe.toString());
        sql.append(")");
        HashMap<String, PersonInfo> map = new HashMap<String, PersonInfo>();
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                String orgId = row.getString("orgId");
                if (map.containsKey(orgId)) continue;
                String pId = row.getString("pId");
                PersonInfo pInfo = new PersonInfo();
                pInfo.setId(BOSUuid.read((String)pId));
                if (LocaleUtils.getLocale((String)"l1").equals(ctx.getLocale())) {
                    pInfo.setName(row.getString("n1"));
                } else if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale())) {
                    pInfo.setName(row.getString("n2"));
                } else if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale())) {
                    pInfo.setName(row.getString("n3"));
                }
                map.put(orgId, pInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup((ResultSet)row);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExistData(Context ctx, String achId, String perId, String objId, String spId, String type) throws Exception {
        Connection conn = super.getConnection(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from T_PF_AchieveData ");
        sql.append(" where FSolutionPeriodID = ? ");
        sql.append(" and FAchieveItemID = ? ");
        sql.append(" and FPeriodID = ? ");
        if (type.equals("person")) {
            sql.append(" and FPersonID = ? ");
        } else {
            sql.append(" and FOrgUnitID = ? ");
        }
        PreparedStatement ps = conn.prepareStatement(sql.toString());
        ps.setString(1, spId);
        ps.setString(2, achId);
        ps.setString(3, perId);
        ps.setString(4, objId);
        ResultSet rs = ps.executeQuery();
        try {
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        }
        return false;
    }

    private IRowSet checkDuplicatedData(Context ctx, String spId, List tesIds, boolean IsMyPlatForm) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(*) c, fachieveItemId,item.fname_");
        sql.append(ctx.getLocale().toString());
        sql.append(" as itemName from t_pf_targetevalustore tes ");
        sql.append(" inner join t_pf_evalutarget et on tes.FEvaluTargetID = et.fid ");
        sql.append(" left join t_pf_evaluMultiTable emt on tes.FMultiTableID = emt.fid ");
        sql.append(" inner join t_pf_formula fm on fm.fid = et.fformulaId ");
        sql.append(" inner join t_pf_achieveItem item on fm.FAchieveItemID = item.fid ");
        sql.append(" LEFT JOIN T_PF_EvaluObject eo ON tes.FEvaluObjectID = eo.FID ");
        sql.append(" where tes.fsolutionperiodid = '").append(spId).append("'");
        sql.append(" and et.FFormulaId is not null ");
        sql.append(" and emt.FCompute =1");
        sql.append(" and fm.fachieveItemId is not null ");
        if (!IsMyPlatForm) {
            sql.append(" and tes.FdeleteableByUndeliver = 1 ");
        }
        if (tesIds != null && !tesIds.isEmpty()) {
            sql.append(" and tes.FEvaluObjectID IN (SELECT FEvaluObjectID FROM T_PF_TargetEvaluStore WHERE FID = '" + tesIds.get(0) + "') ");
        }
        sql.append(" group by tes.FEvaluObjectID,fm.fachieveItemId,item.fname_");
        sql.append(ctx.getLocale().toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    private String getInnerSql(List list) {
        if (list == null) {
            return "";
        }
        StringBuffer sql = new StringBuffer();
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(list.get(i)).append("'");
        }
        return sql.toString();
    }

    @Override
    protected Set _getAchieveDataInputPersons(Context ctx, String personId, String evaluSolutionId) throws BOSException, EASBizException {
        Set idSet = new HashSet();
        if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)evaluSolutionId)) {
            HashSet subSet = this.getSubordinateSet(ctx, personId);
            FilterInfo fi = new FilterInfo();
            FilterItemCollection fic = fi.getFilterItems();
            FilterItemInfo item = null;
            item = subSet != null && subSet.size() > 0 ? new FilterItemInfo("objId", (Object)subSet, CompareType.INCLUDE) : new FilterItemInfo("objId", null);
            fic.add(item);
            item = new FilterItemInfo("includeSuperior", (Object)Boolean.TRUE, CompareType.EQUALS);
            fic.add(item);
            item = new FilterItemInfo("objId", (Object)personId, CompareType.EQUALS);
            fic.add(item);
            item = new FilterItemInfo("includeSelf", (Object)Boolean.TRUE, CompareType.EQUALS);
            fic.add(item);
            item = new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS);
            fic.add(item);
            item = new FilterItemInfo("solution.id", (Object)evaluSolutionId, CompareType.EQUALS);
            fic.add(item);
            fi.setMaskString("((#0 and #1) or (#2 and #3) or #4) and #5");
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fi);
            SelectorItemCollection sic = evi.getSelector();
            sic.add(new SelectorItemInfo("objId"));
            MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.AchieveDataPermissionPersonQuery");
            idSet = this.dealQueryAchPerson(ctx, evi, (IMetaDataPK)pk);
        }
        return idSet;
    }

    private HashSet getSubordinateSet(Context ctx, String personId) throws BOSException, EASBizException {
        IPersonFacade facade = PersonFacadeFactory.getLocalInstance((Context)ctx);
        PersonCollection personColl = facade.getSubordinate(BOSUuid.read((String)"00000000-0000-0000-0000-000000000001396FCAD0"), BOSUuid.read((String)personId));
        PersonInfo person = null;
        HashSet<String> subSet = new HashSet<String>();
        if (personColl != null && personColl.size() > 0) {
            int n = personColl.size();
            for (int i = 0; i < n; ++i) {
                person = personColl.get(i);
                if (personId.equals(person.getId())) continue;
                subSet.add(person.getId().toString());
            }
        }
        return subSet;
    }

    @Override
    protected Set _getAchieveDataInputOrgs(Context ctx, String personId, String evaluSolutionId) throws BOSException, EASBizException {
        Set idSet = new HashSet();
        if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)evaluSolutionId)) {
            HashSet subSet = this.getSubordinateSet(ctx, personId);
            FilterInfo fi = new FilterInfo();
            FilterItemCollection fic = fi.getFilterItems();
            FilterItemInfo item = null;
            item = subSet != null && subSet.size() > 0 ? new FilterItemInfo("responser.id", (Object)subSet, CompareType.INCLUDE) : new FilterItemInfo("responser.id", null);
            fic.add(item);
            item = new FilterItemInfo("includeSuperior", (Object)Boolean.TRUE, CompareType.EQUALS);
            fic.add(item);
            item = new FilterItemInfo("responser.id", (Object)personId, CompareType.EQUALS);
            fic.add(item);
            item = new FilterItemInfo("includeSelf", (Object)Boolean.TRUE, CompareType.EQUALS);
            fic.add(item);
            item = new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS);
            fic.add(item);
            item = new FilterItemInfo("solution.id", (Object)evaluSolutionId, CompareType.EQUALS);
            fic.add(item);
            fi.setMaskString("((#0 and #1) or (#2 and #3) or #4) and #5");
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fi);
            evi.getSelector().add(new SelectorItemInfo("objId"));
            MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.AchieveDataPermissionOrgQuery");
            idSet = this.dealQueryAchPerson(ctx, evi, (IMetaDataPK)pk);
        }
        return idSet;
    }

    private Set dealQueryAchPerson(Context ctx, EntityViewInfo evi, IMetaDataPK pk) throws BOSException {
        IQueryExecutor query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        query.setObjectView(evi);
        query.option().isAutoIgnoreDuplicatedRow = true;
        logger.info((Object)query.getSQL());
        IRowSet rowSet = query.executeQuery();
        HashSet<String> idSet = new HashSet<String>();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("objId"));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return idSet;
    }
}

