/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AchieveDataCollection;
import com.kingdee.eas.hr.perf.AchieveDataEnum;
import com.kingdee.eas.hr.perf.AchieveDataException;
import com.kingdee.eas.hr.perf.AchieveDataFactory;
import com.kingdee.eas.hr.perf.AchieveDataInfo;
import com.kingdee.eas.hr.perf.AchieveItemCollection;
import com.kingdee.eas.hr.perf.AchieveItemFactory;
import com.kingdee.eas.hr.perf.AchieveItemInfo;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodCollection;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodFactory;
import com.kingdee.eas.hr.perf.DataTypeEnum;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Locale;

public class AchieveDataTransmission
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AchieveDataFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        AchieveDataInfo info;
        String spId;
        block21: {
            spId = (String)this.getContextParameter("spId");
            String evaluType = (String)this.getContextParameter("evaluType");
            String spPeriodId = (String)this.getContextParameter("spPeriodId");
            Object obj = null;
            info = new AchieveDataInfo();
            String objId = null;
            try {
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                obj = hsData.get("number");
                FilterInfo filterInfo = new FilterInfo();
                if ("org".equals(evaluType)) {
                    if (obj == null || obj.toString().trim().length() <= 0) {
                        throw new AchieveDataException(AchieveDataException.ORG_NUMBER_NULL);
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)obj.toString().trim()));
                    viewInfo.setFilter(filterInfo);
                    viewInfo.setSelector(selector);
                    AdminOrgUnitCollection orgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(viewInfo);
                    if (orgColl == null || orgColl.size() <= 0) {
                        throw new AchieveDataException(AchieveDataException.ORG_NUMBER_ERROR);
                    }
                    info.setOrgUnit(orgColl.get(0));
                    objId = orgColl.get(0).getId().toString();
                    info.setResponser(this.getOrgResponser(ctx, objId));
                    info.setEvaluObjectType(EvaluObjectTypeEnum.ORGUNIT);
                } else if ("person".equals(evaluType)) {
                    if (obj == null || obj.toString().trim().length() <= 0) {
                        throw new AchieveDataException(AchieveDataException.PERSON_NUMBER_NULL);
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)obj.toString().trim()));
                    viewInfo.setFilter(filterInfo);
                    viewInfo.setSelector(selector);
                    PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
                    if (personColl == null || personColl.size() <= 0) {
                        throw new AchieveDataException(AchieveDataException.PERSON_NUMBER_ERROR);
                    }
                    info.setPerson(personColl.get(0));
                    objId = personColl.get(0).getId().toString();
                    info.setPosition(this.getPrimaryPosition(ctx, objId));
                    info.setEvaluObjectType(EvaluObjectTypeEnum.PERSON);
                } else {
                    return null;
                }
                obj = hsData.get("achieveItem");
                if (obj == null || obj.toString().trim().length() <= 0) {
                    throw new AchieveDataException(AchieveDataException.ACHIEVEITEM_NUMBER_NULL);
                }
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)obj.toString().trim()));
                filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
                viewInfo.setFilter(filterInfo);
                viewInfo.setSelector(null);
                AchieveItemCollection aiColl = AchieveItemFactory.getLocalInstance(ctx).getAchieveItemCollection(viewInfo);
                if (aiColl == null || aiColl.size() <= 0) {
                    throw new AchieveDataException(AchieveDataException.ACHIEVEITEM_NUMBER_ERROR);
                }
                AchieveItemInfo aiInfo = aiColl.get(0);
                info.setAchieveItem(aiInfo);
                obj = hsData.get("period");
                if (obj == null || obj.toString().trim().length() <= 0) {
                    throw new AchieveDataException(AchieveDataException.PERIOD_NUMBER_NULL);
                }
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)obj.toString().trim()));
                filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
                viewInfo.setFilter(filterInfo);
                viewInfo.setSelector(selector);
                AchieveStatisticsPeriodCollection pColl = AchieveStatisticsPeriodFactory.getLocalInstance(ctx).getAchieveStatisticsPeriodCollection(viewInfo);
                if (pColl == null || pColl.size() <= 0) {
                    throw new AchieveDataException(AchieveDataException.PERIOD_NUMBER_ERROR);
                }
                info.setPeriod(pColl.get(0));
                if (pColl.get(0).getId().toString().equals(spPeriodId)) {
                    info.setRootPeriod(true);
                } else {
                    info.setRootPeriod(false);
                    info.setParent(this.getMainAchieveData(ctx, spId, evaluType, objId, aiInfo.getId().toString()));
                }
                obj = hsData.get("value");
                if (obj == null || obj.toString().trim().length() <= 0) break block21;
                String rv = obj.toString().trim();
                DataTypeEnum dType = aiInfo.getDataType();
                if (dType != null && dType.getValue() == 1) {
                    double num = 0.0;
                    try {
                        num = Double.parseDouble(rv);
                    }
                    catch (Exception e) {
                        throw new AchieveDataException(AchieveDataException.REALVALUE_ERROR);
                    }
                    if (num > 2.147483647E9 || num < -2.147483648E9) {
                        throw new AchieveDataException(AchieveDataException.REALVALUE_TOO_BIG);
                    }
                    int pre = aiInfo.getDataPrecision();
                    DecimalFormat df = this.getDecimalFormat(pre);
                    info.setRealValue(df.format(num));
                    break block21;
                }
                if (rv.length() > 225) {
                    throw new AchieveDataException(AchieveDataException.REALVALUE_TOO_BIG);
                }
                info.setRealValue(obj.toString().trim());
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        info.setDataType(AchieveDataEnum.addNew);
        SolutionPeriodInfo spInfo = new SolutionPeriodInfo();
        spInfo.setId(BOSUuid.read((String)spId));
        info.setSolutionPeriod(spInfo);
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        String spId = (String)this.getContextParameter("spId");
        String evaluType = (String)this.getContextParameter("evaluType");
        AchieveDataInfo adInfo = (AchieveDataInfo)coreBaseInfo;
        String tempRealValue = adInfo.getRealValue();
        if (tempRealValue != null && !"".equals(tempRealValue) && tempRealValue.length() >= 2 && tempRealValue.indexOf("%") > -1) {
            tempRealValue = tempRealValue.substring(0, tempRealValue.indexOf("%"));
            BigDecimal BDrealValue = new BigDecimal(tempRealValue).setScale(6);
            adInfo.setRealValue(BDrealValue.divide(BigDecimal.valueOf(100L), 5).toString());
        }
        try {
            FilterInfo fi = new FilterInfo();
            if ("org".equals(evaluType)) {
                fi.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)adInfo.getOrgUnit().getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("evaluObjectType", (Object)EvaluObjectTypeEnum.ORGUNIT));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)adInfo.getPerson().getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("evaluObjectType", (Object)EvaluObjectTypeEnum.PERSON));
            }
            fi.getFilterItems().add(new FilterItemInfo("achieveItem.id", (Object)adInfo.getAchieveItem().getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("period.id", (Object)adInfo.getPeriod().getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spId));
            if (this.isSltImportUpdate()) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(fi);
                AchieveDataCollection coll = AchieveDataFactory.getLocalInstance(ctx).getAchieveDataCollection(evi);
                if (coll.size() > 0) {
                    AchieveDataInfo achieveDataInfo = coll.get(0);
                    adInfo.setDataType(achieveDataInfo.getDataType());
                    adInfo.setThresholdValue(achieveDataInfo.getThresholdValue());
                    adInfo.setStandardValue(achieveDataInfo.getStandardValue());
                    adInfo.setChallengeValue(achieveDataInfo.getChallengeValue());
                    adInfo.setTarget(achieveDataInfo.getTarget());
                    adInfo.setEvaluObject(achieveDataInfo.getEvaluObject());
                    this.getController(ctx).delete(fi);
                }
            } else if (this.getController(ctx).exists(fi)) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"0_AchieveDataTransmission", (Locale)ctx.getLocale()));
            }
            this.getController(ctx).addnew((CoreBaseInfo)adInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String evaluType = (String)this.getContextParameter("evaluType");
            if ("org".equals(evaluType)) {
                result.put("number", rs.getString("orgUnit.number"));
                result.put("name", rs.getString("orgUnit.name"));
            } else {
                result.put("number", rs.getString("person.number"));
                result.put("name", rs.getString("person.name"));
            }
            result.put("achieveItem", rs.getString("achieveItem.number"));
            result.put("achieveItemName", rs.getString("achieveItem.name"));
            result.put("period", rs.getString("period.number"));
            result.put("periodName", rs.getString("period.name"));
            if (rs.getString("realValue") != null) {
                int dataPrecision = rs.getInt("achieveItem.dataPrecision");
                int dataType = rs.getInt("achieveItem.dataType");
                int precisionType = rs.getInt("achieveItem.precisionType");
                int precisionPercent = precisionType + 2;
                String realValue = null;
                switch (dataType) {
                    case 1: {
                        realValue = 10 == precisionType ? rs.getBigDecimal("realValue").setScale(dataPrecision, 4).toString() : (30 == precisionType ? rs.getBigDecimal("realValue").setScale(dataPrecision, 1).toString() : rs.getBigDecimal("realValue").setScale(dataPrecision, 0).toString());
                        result.put("value", realValue);
                        break;
                    }
                    case 3: {
                        realValue = 10 == precisionType ? rs.getBigDecimal("realValue").multiply(BigDecimal.valueOf(100L)).setScale(dataPrecision, 4).toString() : (30 == precisionType ? rs.getBigDecimal("realValue").multiply(BigDecimal.valueOf(100L)).setScale(dataPrecision, 1).toString() : rs.getBigDecimal("realValue").multiply(BigDecimal.valueOf(100L)).setScale(dataPrecision, 0).toString());
                        result.put("value", realValue + "%");
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo userFi;
        String spId = (String)this.getContextParameter("spId");
        String evaluType = (String)this.getContextParameter("evaluType");
        Boolean b = (Boolean)this.getContextParameter("isAll");
        FilterInfo fi = new FilterInfo();
        if ("org".equals(evaluType)) {
            fi.getFilterItems().add(new FilterItemInfo("evaluObjectType", (Object)new Integer(101)));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("evaluObjectType", (Object)new Integer(100)));
        }
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spId));
        if (b != null && !b.booleanValue()) {
            fi.getFilterItems().add(new FilterItemInfo("rootPeriod", (Object)new Integer(1)));
        }
        if ((userFi = (FilterInfo)this.getContextParameter("userFilter")) != null) {
            try {
                fi.mergeFilter(userFi, "and");
            }
            catch (BOSException e) {
                // empty catch block
            }
        }
        return fi;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.perf.app.AchieveDataExportQuery";
    }

    private PositionInfo getPrimaryPosition(Context ctx, String pId) throws BOSException, EASBizException {
        if (pId == null) {
            return null;
        }
        String sql = " select FPositionID psId from T_ORG_PositionMember pm where FPersonID in('" + pId + "'" + ") and FIsPrimary = 1";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        PositionInfo psInfo = new PositionInfo();
        try {
            while (row.next()) {
                String psId = row.getString("psId");
                psInfo.setId(BOSUuid.read((String)psId));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return psInfo;
    }

    private PersonInfo getOrgResponser(Context ctx, String orgId) throws BOSException, EASBizException {
        if (orgId == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct pm.FPersonID pId from T_ORG_Admin org ");
        sql.append(" left join T_ORG_PositionMember pm on org.FResponPositionID = pm.FPositionID ");
        sql.append("  where pm.FIsPrimary = 1 ");
        sql.append(" and org.fid in (");
        sql.append("'").append(orgId).append("'");
        sql.append(")");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        PersonInfo pInfo = new PersonInfo();
        try {
            if (row.next()) {
                String pId = row.getString("pId");
                pInfo.setId(BOSUuid.read((String)pId));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return pInfo;
    }

    private AchieveDataInfo getMainAchieveData(Context ctx, String spId, String evaluType, String objId, String aiId) throws BOSException, EASBizException {
        if (spId == null || evaluType == null || objId == null || aiId == null) {
            return null;
        }
        Object[] params = new Object[]{spId, aiId, new Boolean(true), null, objId};
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from t_pf_achieveData ");
        sql.append(" where FSolutionPeriodID = ? ");
        sql.append(" and FAchieveItemID = ? ");
        sql.append(" and FRootPeriod = ? ");
        sql.append(" and FEvaluObjectType= ? ");
        if ("org".equals(evaluType)) {
            sql.append(" and FOrgUnitID = ? ");
            params[3] = new Integer(101);
        } else {
            sql.append(" and FPersonID = ? ");
            params[3] = new Integer(100);
        }
        AchieveDataInfo adInfo = null;
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (row.next()) {
                String id = row.getString("fid");
                adInfo = new AchieveDataInfo();
                adInfo.setId(BOSUuid.read((String)id));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return adInfo;
    }

    private DecimalFormat getDecimalFormat(int pre) {
        DecimalFormat df;
        switch (pre) {
            case 0: {
                df = new DecimalFormat("0");
                break;
            }
            case 1: {
                df = new DecimalFormat("0.0");
                break;
            }
            case 2: {
                df = new DecimalFormat("0.00");
                break;
            }
            case 3: {
                df = new DecimalFormat("0.000");
                break;
            }
            case 4: {
                df = new DecimalFormat("0.0000");
                break;
            }
            case 5: {
                df = new DecimalFormat("0.00000");
                break;
            }
            default: {
                df = new DecimalFormat("0.00");
            }
        }
        return df;
    }
}

