/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodCollection;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodException;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodFactory;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodInfo;
import com.kingdee.eas.hr.perf.PeriodException;
import com.kingdee.eas.hr.perf.app.AbstractAchieveStatisticsPeriodControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class AchieveStatisticsPeriodControllerBean
extends AbstractAchieveStatisticsPeriodControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.AchieveStatisticsPeriodControllerBean");

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        return filter;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameDup(ctx, model);
        this.checkBeforeAddNew(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CodingRuleServerHelper.recycleNumber((Context)ctx, (IObjectPK)pk, (ICoreBase)AchieveStatisticsPeriodFactory.getLocalInstance(ctx), (String)AchieveStatisticsPeriodInfo.class.getName());
        super._delete(ctx, pk);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBeforeAddNew(ctx, model);
        return super._addnew(ctx, model);
    }

    private void checkBeforeAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AchieveStatisticsPeriodInfo info = (AchieveStatisticsPeriodInfo)model;
        if (info.getNumber() == null) {
            throw new PeriodException(PeriodException.NUMBER_NULL);
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            throw new PeriodException(PeriodException.NAME_NULL);
        }
        info.setStartDate(this.turncate(info.getStartDate()));
        info.setEndDate(this.turncate(info.getEndDate()));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)info.getStartDate(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)info.getEndDate(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
        if (super._exists(ctx, filter)) {
            throw new AchieveStatisticsPeriodException(AchieveStatisticsPeriodException.DATE_SAME);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (info.getParent() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getParent().getId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            viewInfo.setFilter(filterInfo);
            AchieveStatisticsPeriodCollection periodCol = AchieveStatisticsPeriodFactory.getLocalInstance(ctx).getAchieveStatisticsPeriodCollection(viewInfo);
            if (periodCol != null) {
                int size = periodCol.size();
                for (int i = 0; i < size; ++i) {
                    AchieveStatisticsPeriodInfo periodInfo = periodCol.get(i);
                    periodInfo.setStartDate(this.turncate(periodInfo.getStartDate()));
                    periodInfo.setEndDate(this.turncate(periodInfo.getEndDate()));
                    if (info.getStartDate().after(periodInfo.getEndDate()) || info.getEndDate().before(periodInfo.getStartDate())) continue;
                    throw new AchieveStatisticsPeriodException(AchieveStatisticsPeriodException.DATE_DUP);
                }
            }
        }
    }

    private Date turncate(Date date) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = f.parse(f.format(date));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }
}

