/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.biz.agent.DefaultMultiBillWorkAgent;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.AchieveDataComputeException;
import com.kingdee.eas.hr.perf.BatchEvaluProcessHelper;
import com.kingdee.eas.hr.perf.EvalPersonFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluDetailCollection;
import com.kingdee.eas.hr.perf.EvaluDetailFactory;
import com.kingdee.eas.hr.perf.EvaluDetailInfo;
import com.kingdee.eas.hr.perf.EvaluNodeCollection;
import com.kingdee.eas.hr.perf.EvaluNodeFactory;
import com.kingdee.eas.hr.perf.EvaluNodeInfo;
import com.kingdee.eas.hr.perf.EvaluResultCollection;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.IEvalWorkFlowFacade;
import com.kingdee.eas.hr.perf.INodeProcesser;
import com.kingdee.eas.hr.perf.NodeProcesserCollection;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.NodeProcesserInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetScoreComputeFacadeFactory;
import com.kingdee.eas.hr.perf.app.AbstractBatchEvaluProcessFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchEvaluProcessFacadeControllerBean
extends AbstractBatchEvaluProcessFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.BatchEvaluProcessFacadeControllerBean");

    @Override
    protected Map _getBatchEvaluData(Context ctx, String solutionPeriodID, String evaluerID, String evaluObjectID, String nodeID) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        try {
            String evaluGroupID = this.getEvaluGroupID(ctx, solutionPeriodID, evaluObjectID);
            Map evaluObjectEntry = this.getEvaluObjectNodeInfo(ctx, evaluGroupID, evaluerID, solutionPeriodID, false, nodeID);
            IRowSet rowSet = this.getEvaluTarget(ctx, evaluObjectID, solutionPeriodID);
            map.put("nodeProcesser", evaluObjectEntry);
            map.put("evaluTarget", rowSet);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private IRowSet getEvaluObjectID(Context ctx, String evaluGroupId, String evaluerID, String solutionPeriodID) throws BOSException {
        IRowSet rowSet = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct evalWFObjects.FEvaluObjectID as evaluObjectID, evalWFObjects.FProcInstID, evalWFObjects.FEvalWorkFlowID as evalWorkFlowID, assign.FAssignID as assignID, evaluObject.FName_");
        sql.append(ctx.getLocale());
        sql.append(" as evaluObjectName from T_PF_evalWFObjects evalWFObjects ");
        sql.append("inner join T_PF_evaluObject evaluObject on evalWFObjects.FEvaluObjectID = evaluObject.FID ");
        sql.append("inner join T_PF_EvalWorkFlow evalWorkFlow on evalWFObjects.FEvalWorkFlowID = evalWorkFlow.FID ");
        sql.append("inner join T_PF_EvaluGroupObject evalGroupObject on evalGroupObject.FEvaluObjectID = evalWFObjects.FEvaluObjectID ");
        sql.append("inner join T_WFR_assign assign on evalWFObjects.FProcInstID =  assign.FProcInstID where evalGroupObject.FEvaluGroupID = '");
        sql.append(evaluGroupId);
        sql.append("' and assign.FpersonUserID = '");
        sql.append(evaluerID);
        sql.append("' and assign.FState = 1 ");
        sql.append("and evalWorkFlow.FSolutionPeriodID = '");
        sql.append(solutionPeriodID);
        sql.append("'");
        sql.append(" and evaluObject.FDeleted = ");
        sql.append(new Integer(0));
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    private IRowSet getEvaluObjectIDForAllocateTarget(Context ctx, String evaluGroupId, String evaluerID, String solutionPeriodID) throws BOSException {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.AllocateTargetBatchProcessQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)evaluGroupId));
        fi.getFilterItems().add(new FilterItemInfo("personUserID", (Object)evaluerID));
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    private IRowSet getEvaluTarget(Context ctx, String evaluObjectID, String solutionPeriodID) throws BOSException {
        IRowSet rowSet = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select performTargetType.FName_");
        sql.append(ctx.getLocale());
        sql.append(" as targetTypeName");
        sql.append(", evaluTarget.FID as evaluTargetID, evaluTarget.FContent2 as content, evaluTarget.FStandard2 as standard, evaluGroupTarget.FWeight as weight from ");
        sql.append("T_PF_EvaluTarget evaluTarget ");
        sql.append("inner join T_PF_PerformTargetType performTargetType on evaluTarget.FTypeID = performTargetType.FID ");
        sql.append("inner join T_PF_EvaluGroupTarget evaluGroupTarget on evaluTarget.FID = evaluGroupTarget.FEvaluTargetID ");
        sql.append("inner join T_PF_EvaluGroupObject evalGroupObject on evaluGroupTarget.FEvaluGroupID = evalGroupObject.FEvaluGroupID ");
        sql.append("inner join T_PF_EvaluGroup evaluGroup on evalGroupObject.FEvaluGroupID = evaluGroup.FID ");
        sql.append("where evalGroupObject.FEvaluObjectID = '");
        sql.append(evaluObjectID);
        sql.append("'");
        sql.append(" and evaluGroup.FSolutionPeriodID = '");
        sql.append(solutionPeriodID);
        sql.append("'");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    private IRowSet getEvaluTargetForAllocate(Context ctx, String evaluGroupID, String evaluWorkFlowID, String nodeId) throws BOSException {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.GetEvaluTargetForAllocateQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)evaluWorkFlowID));
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupID));
        fi.getFilterItems().add(new FilterItemInfo("evaluNode.id", (Object)nodeId));
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    private TargetEvaluStoreCollection getTargetEvaluStore(Context ctx, String evaluObjectID, String solutionPeriodID) throws BOSException {
        TargetEvaluStoreCollection coll = new TargetEvaluStoreCollection();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject", (Object)evaluObjectID));
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)solutionPeriodID));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("weight"));
        sic.add(new SelectorItemInfo("evaluTarget"));
        sic.add(new SelectorItemInfo("values"));
        sic.add(new SelectorItemInfo("multiTable.*"));
        sic.add(new SelectorItemInfo("formulaScore"));
        evi.setFilter(fi);
        coll = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(evi);
        return coll;
    }

    private EvaluResultInfo getEvaluResultInfo(Context ctx, String evaluObjectID, String solutionPeriodID) throws BOSException {
        EvaluResultInfo info = new EvaluResultInfo();
        FilterInfo fi = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        fi.getFilterItems().add(new FilterItemInfo("evaluObject", (Object)evaluObjectID));
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)solutionPeriodID));
        evi.setFilter(fi);
        evi.getSelector().add("*");
        evi.getSelector().add("evaluObject.id");
        evi.getSelector().add("evaluObject.objectId");
        EvaluResultCollection coll = EvaluResultFactory.getLocalInstance(ctx).getEvaluResultCollection(evi);
        if (coll != null && coll.size() == 1) {
            info = coll.get(0);
        }
        return info;
    }

    private NodeProcesserInfo getNodeProcesserInfo(Context ctx, String evaluNodeID, String evaluResultID, int nodeSeq) throws BOSException {
        NodeProcesserInfo info = new NodeProcesserInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluNode", (Object)evaluNodeID));
        fi.getFilterItems().add(new FilterItemInfo("evaluResult", (Object)evaluResultID));
        fi.getFilterItems().add(new FilterItemInfo("evaluNode.seqNumber", (Object)new Integer(nodeSeq)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("comment"));
        sic.add(new SelectorItemInfo("processerName"));
        sic.add(new SelectorItemInfo("evaluer"));
        sic.add(new SelectorItemInfo("evaluResult.id"));
        sic.add(new SelectorItemInfo("evaluResult.evaluObject.id"));
        sic.add(new SelectorItemInfo("evaluResult.evaluObject.objectID"));
        sic.add(new SelectorItemInfo("rank.*"));
        sic.add(new SelectorItemInfo("nodeScore"));
        sic.add(new SelectorItemInfo("workedState"));
        sic.add(new SelectorItemInfo("evaluNode.*"));
        sic.add(new SelectorItemInfo("evaluDetails.*"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.values"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.multiTable.compute"));
        NodeProcesserCollection coll = NodeProcesserFactory.getLocalInstance(ctx).getNodeProcesserCollection(evi);
        if (coll != null && coll.size() == 1) {
            info = coll.get(0);
        }
        return info;
    }

    private EvaluDetailCollection getEvaluDetailCollection(Context ctx, String nodeProcesserID) throws BOSException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("nodeProcesser", (Object)nodeProcesserID));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("targetScore"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("rank.*"));
        sic.add(new SelectorItemInfo("comment"));
        sic.add(new SelectorItemInfo("weight"));
        sic.add(new SelectorItemInfo("nodeProcesser"));
        sic.add(new SelectorItemInfo("targetEvaluStore.values"));
        sic.add(new SelectorItemInfo("targetEvaluStore.evaluTarget"));
        sic.add(new SelectorItemInfo("targetEvaluStore.multiTable.*"));
        sic.add(new SelectorItemInfo("targetEvaluStore.formulaScore"));
        EvaluDetailCollection coll = EvaluDetailFactory.getLocalInstance(ctx).getEvaluDetailCollection(evi);
        return coll;
    }

    private EvaluNodeInfo getEvaluNodeInfo(Context ctx, String seq, String evalWorkFlowID) throws BOSException {
        EvaluNodeInfo evaluNodeInfo = new EvaluNodeInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evalWorkFlow", (Object)evalWorkFlowID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("seqNumber", (Object)seq, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("weight"));
        sic.add(new SelectorItemInfo("seqNumber"));
        sic.add(new SelectorItemInfo("nodeLevel"));
        sic.add(new SelectorItemInfo("evalWorkFlow.id"));
        sic.add(new SelectorItemInfo("evalWorkFlow.wfLevels"));
        sic.add(new SelectorItemInfo("evalWorkFlow.concurArgs.concurrenceLevel"));
        sic.add(new SelectorItemInfo("evalWorkFlow"));
        sic.add(new SelectorItemInfo("canComment"));
        sic.add(new SelectorItemInfo("canGrade"));
        sic.add(new SelectorItemInfo("canEvaluateLevel"));
        sic.add(new SelectorItemInfo("weightVisable"));
        sic.add(new SelectorItemInfo("canTargetComment"));
        EvaluNodeCollection coll = EvaluNodeFactory.getLocalInstance(ctx).getEvaluNodeCollection(evi);
        if (coll != null && coll.size() > 0) {
            evaluNodeInfo = coll.get(0);
        }
        return evaluNodeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map getEvaluObjectNodeInfo(Context ctx, String evaluGroupId, String evaluerID, String solutionPeriodID, boolean isAllocateTarget, String nodeId) throws BOSException {
        IRowSet rowSet = isAllocateTarget ? this.getEvaluObjectIDForAllocateTarget(ctx, evaluGroupId, evaluerID, solutionPeriodID) : this.getEvaluObjectID(ctx, evaluGroupId, evaluerID, solutionPeriodID);
        String sql = "select es.fscoreToNextNode isToNext, es.ftargetGradeMode gradeMode from t_pf_evaluSolution es inner join t_pf_solutionPeriod sp on es.fid = sp.fevaluSolutionId where sp.fid = '" + solutionPeriodID + "'";
        boolean isScoreToNextNode = false;
        boolean isGrade = true;
        try {
            IRowSet scoreToNextNode = DbUtil.executeQuery((Context)ctx, (String)sql);
            scoreToNextNode.beforeFirst();
            while (scoreToNextNode.next()) {
                int gradeMode;
                int flag = scoreToNextNode.getInt("isToNext");
                if (flag == 1) {
                    isScoreToNextNode = true;
                }
                if (100 == (gradeMode = scoreToNextNode.getInt("gradeMode"))) continue;
                isGrade = false;
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        HashMap map = new HashMap();
        HashMap<String, Object> mapEntry = null;
        try {
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String evaluObjectID = null;
        String evaluObjectName = null;
        String evalWorkFlowID = null;
        String seq = null;
        BigDecimal oldTotalScore = null;
        String[] assignID = new String[1];
        IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
        NodeProcesserInfo nodeProcesserInfo = null;
        EvaluNodeInfo evaluNodeInfo = null;
        EvaluDetailCollection evaluDetails = null;
        EvaluDetailInfo detailInfo = null;
        EvaluResultInfo result = null;
        int flag = 0;
        try {
            while (rowSet.next()) {
                evaluObjectID = rowSet.getString("evaluObjectID");
                evaluObjectName = rowSet.getString("evaluObjectName");
                evalWorkFlowID = rowSet.getString("evalWorkFlowID");
                assignID[0] = rowSet.getString("assignID");
                evaluNodeInfo = this.getEvaluNodeInfo(ctx, nodeId, evalWorkFlowID);
                result = this.getEvaluResultInfo(ctx, evaluObjectID, solutionPeriodID);
                nodeProcesserInfo = this.getNodeProcesserInfo(ctx, evaluNodeInfo.getId().toString(), result.getId().toString(), Integer.parseInt(nodeId));
                nodeProcesserInfo.setEvaluResult(result);
                try {
                    TargetScoreComputeFacadeFactory.getLocalInstance(ctx).computeTargetScore(solutionPeriodID, evaluObjectID);
                }
                catch (AchieveDataComputeException e) {
                    if (nodeProcesserInfo.getId() == null) {
                        if (isAllocateTarget) {
                            Map nodeInfoMap = NodeProcesserFactory.getLocalInstance(ctx).getNodeProcesserInfoOfTheNode(new String[]{nodeId}, evaluObjectID, solutionPeriodID);
                            nodeProcesserInfo = (NodeProcesserInfo)nodeInfoMap.values().iterator().next();
                        } else {
                            TargetEvaluStoreCollection targetStoreColl = this.getTargetEvaluStore(ctx, evaluObjectID, solutionPeriodID);
                            int n = targetStoreColl.size();
                            for (int i = 0; i < n; ++i) {
                                detailInfo = new EvaluDetailInfo();
                                detailInfo.setNodeProcesser(nodeProcesserInfo);
                                detailInfo.setTargetEvaluStore(targetStoreColl.get(i));
                                detailInfo.setSeq(i);
                                detailInfo.setWeight(targetStoreColl.get(i).getWeight());
                                nodeProcesserInfo.getEvaluDetails().add(detailInfo);
                            }
                        }
                    } else {
                        evaluDetails = this.getEvaluDetailCollection(ctx, nodeProcesserInfo.getId().toString());
                        int size = evaluDetails.size();
                        for (int i = 0; i < size; ++i) {
                            nodeProcesserInfo.getEvaluDetails().add(evaluDetails.get(i));
                        }
                    }
                    catch (Throwable throwable) {
                        if (nodeProcesserInfo.getId() == null) {
                            if (isAllocateTarget) {
                                Map nodeInfoMap = NodeProcesserFactory.getLocalInstance(ctx).getNodeProcesserInfoOfTheNode(new String[]{nodeId}, evaluObjectID, solutionPeriodID);
                                nodeProcesserInfo = (NodeProcesserInfo)nodeInfoMap.values().iterator().next();
                            } else {
                                TargetEvaluStoreCollection targetStoreColl = this.getTargetEvaluStore(ctx, evaluObjectID, solutionPeriodID);
                                int n = targetStoreColl.size();
                                for (int i = 0; i < n; ++i) {
                                    detailInfo = new EvaluDetailInfo();
                                    detailInfo.setNodeProcesser(nodeProcesserInfo);
                                    detailInfo.setTargetEvaluStore(targetStoreColl.get(i));
                                    detailInfo.setSeq(i);
                                    detailInfo.setWeight(targetStoreColl.get(i).getWeight());
                                    nodeProcesserInfo.getEvaluDetails().add(detailInfo);
                                }
                            }
                        } else {
                            evaluDetails = this.getEvaluDetailCollection(ctx, nodeProcesserInfo.getId().toString());
                            int size2 = evaluDetails.size();
                            for (int i = 0; i < size2; ++i) {
                                nodeProcesserInfo.getEvaluDetails().add(evaluDetails.get(i));
                            }
                        }
                        throw throwable;
                    }
                }
                if (nodeProcesserInfo.getId() == null) {
                    if (isAllocateTarget) {
                        Map nodeInfoMap = NodeProcesserFactory.getLocalInstance(ctx).getNodeProcesserInfoOfTheNode(new String[]{nodeId}, evaluObjectID, solutionPeriodID);
                        nodeProcesserInfo = (NodeProcesserInfo)nodeInfoMap.values().iterator().next();
                    } else {
                        TargetEvaluStoreCollection targetStoreColl = this.getTargetEvaluStore(ctx, evaluObjectID, solutionPeriodID);
                        int n = targetStoreColl.size();
                        for (int i = 0; i < n; ++i) {
                            detailInfo = new EvaluDetailInfo();
                            detailInfo.setNodeProcesser(nodeProcesserInfo);
                            detailInfo.setTargetEvaluStore(targetStoreColl.get(i));
                            detailInfo.setSeq(i);
                            detailInfo.setWeight(targetStoreColl.get(i).getWeight());
                            nodeProcesserInfo.getEvaluDetails().add(detailInfo);
                        }
                    }
                } else {
                    evaluDetails = this.getEvaluDetailCollection(ctx, nodeProcesserInfo.getId().toString());
                    int size = evaluDetails.size();
                    for (int i = 0; i < size; ++i) {
                        nodeProcesserInfo.getEvaluDetails().add(evaluDetails.get(i));
                    }
                }
                nodeProcesserInfo.setEvaluNode(evaluNodeInfo);
                boolean isLastNode = BatchEvaluProcessHelper.isLastNode(evaluNodeInfo, ctx);
                if (isScoreToNextNode || isAllocateTarget && isLastNode) {
                    NodeProcesserCollection coll = this.getExistNodeProcesser(ctx, solutionPeriodID, evaluObjectID);
                    NodeProcesserInfo info = null;
                    int size = coll.size();
                    HashMap<String, NodeProcesserInfo> datas = new HashMap<String, NodeProcesserInfo>();
                    for (int i = 0; i < size; ++i) {
                        info = coll.get(i);
                        datas.put("" + info.getEvaluNode().getSeqNumber(), info);
                    }
                    if (datas.get("" + seq) == null) {
                        datas.put("" + seq, nodeProcesserInfo);
                        ++size;
                    }
                    String[] seqNumbers = this.sortNodeProcesserSeq(size, datas);
                    int currentNodeLevel = nodeProcesserInfo.getEvaluNode().getNodeLevel();
                    if (isScoreToNextNode) {
                        BatchEvaluProcessHelper.fillCurrentNodeWithExistNode(datas, seq, seqNumbers, currentNodeLevel, isGrade);
                    }
                    if (isAllocateTarget && isLastNode) {
                        oldTotalScore = BatchEvaluProcessHelper.calCurrentTotalScore(datas, seqNumbers, currentNodeLevel);
                        nodeProcesserInfo.put("oldTotalScore", oldTotalScore);
                    }
                }
                mapEntry = new HashMap<String, Object>();
                mapEntry.put("evaluObjectID", evaluObjectID);
                mapEntry.put("evaluObjectName", evaluObjectName);
                mapEntry.put("assignID", assignID[0]);
                mapEntry.put("nodeProcesserInfo", nodeProcesserInfo);
                map.put("" + flag, mapEntry);
                ++flag;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getCause(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private String[] sortNodeProcesserSeq(int size, Map datas) {
        int[] sortNumber = new int[size];
        Object[] seqNumbers = new String[size];
        try {
            int index = 0;
            Iterator iter = datas.keySet().iterator();
            while (iter.hasNext()) {
                sortNumber[index] = Integer.parseInt((String)iter.next());
                ++index;
            }
            Arrays.sort(sortNumber);
            for (int i = 0; i < size; ++i) {
                seqNumbers[i] = "" + sortNumber[i];
            }
        }
        catch (NumberFormatException e) {
            int i = 0;
            Iterator iter = datas.keySet().iterator();
            while (iter.hasNext()) {
                seqNumbers[i] = (String)iter.next();
                ++i;
            }
            Arrays.sort(seqNumbers);
        }
        return seqNumbers;
    }

    private NodeProcesserCollection getExistNodeProcesser(Context ctx, String solutionPeriodID, String evaluObjectID) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod", (Object)solutionPeriodID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.evaluObject.id", (Object)evaluObjectID, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("nodeScore"));
        sic.add(new SelectorItemInfo("evaluNode.id"));
        sic.add(new SelectorItemInfo("evaluNode.seqNumber"));
        sic.add(new SelectorItemInfo("evaluNode.nodeLevel"));
        sic.add(new SelectorItemInfo("evaluNode.canGrade"));
        sic.add(new SelectorItemInfo("evaluNode.weight"));
        sic.add(new SelectorItemInfo("evaluDetails.id"));
        sic.add(new SelectorItemInfo("evaluDetails.targetScore"));
        sic.add(new SelectorItemInfo("evaluDetails.rank.*"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.id"));
        SorterItemCollection sorter = evi.getSorter();
        sorter.add(new SorterItemInfo("evaluNode.seqNumber"));
        sorter.add(new SorterItemInfo("evaluDetails.targetEvaluStore.evaluTarget.seqNumber"));
        sorter.add(new SorterItemInfo("evaluDetails.targetEvaluStore.evaluTarget.type.number"));
        sorter.add(new SorterItemInfo("evaluDetails.targetEvaluStore.evaluTarget.number"));
        return NodeProcesserFactory.getLocalInstance(ctx).getNodeProcesserCollection(evi);
    }

    @Override
    protected void _batchSave(Context ctx, Map datas) throws BOSException, EASBizException {
    }

    @Override
    protected void _batchSubmit(Context ctx, Map datas) throws BOSException, EASBizException {
        Map entry = null;
        NodeProcesserInfo info = null;
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        String assignID = null;
        DefaultMultiBillWorkAgent agent = null;
        AssignmentInfo assignmentInfo = null;
        AssignInfo assignInfo = null;
        HashMap<String, AssignmentInfo> map = null;
        INodeProcesser iNodeProcesser = NodeProcesserFactory.getLocalInstance(ctx);
        IEvalWorkFlowFacade ievalWorkFlowFacade = EvalWorkFlowFacadeFactory.getLocalInstance(ctx);
        int size = datas.size();
        for (int i = 0; i < size; ++i) {
            entry = (Map)datas.get("" + i);
            info = (NodeProcesserInfo)entry.get("nodeProcesserInfo");
            assignID = (String)entry.get("assignID");
            info.setEvaluer(person);
            info.setProcesserName(person.getName());
            agent = new DefaultMultiBillWorkAgent();
            assignInfo = new AssignInfo();
            assignInfo.setAssignID(BOSUuid.read((String)assignID));
            assignmentInfo = new AssignmentInfo(assignInfo);
            map = new HashMap<String, AssignmentInfo>();
            map.put("WfAssignmentInfo", assignmentInfo);
            agent.markNewBill((IObjectValue)info, map);
            ievalWorkFlowFacade.clearReBackReason(assignID);
            logger.info((Object)("entry = " + i + " assignID = " + assignID));
            iNodeProcesser.submit((CoreBaseInfo)info);
            logger.info((Object)("assignID " + assignID + " nodeProcesser submit success"));
        }
    }

    @Override
    protected Map _getBatchEvaluDataForAllocate(Context ctx, String solutionPeriodID, String evaluerID, String evaluObjectID, String nodeId) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        String evaluGroupID = this.getEvaluGroupID(ctx, solutionPeriodID, evaluObjectID);
        String evaluWorkFlowID = this.getEvaluWorkFlowID(ctx, solutionPeriodID, evaluObjectID);
        String evaluNodeID = this.getEvaluNodeID(ctx, nodeId, evaluWorkFlowID);
        IRowSet rowSet = this.getEvaluTargetForAllocate(ctx, evaluGroupID, evaluWorkFlowID, evaluNodeID);
        try {
            Map evaluObjectEntry = this.getEvaluObjectNodeInfo(ctx, evaluGroupID, evaluerID, solutionPeriodID, true, nodeId);
            map.put("nodeProcesser", evaluObjectEntry);
            map.put("evaluTarget", rowSet);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private String getEvaluNodeID(Context ctx, String nodeId, String evaluWorkFlowID) throws BOSException {
        String evaluNodeId = null;
        String sql = "select top 1 fid as id from t_pf_evaluNode where FEvalWorkFlowID = ? and FSeqNumber = ?";
        Object[] params = new Object[]{evaluWorkFlowID, nodeId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            if (rowSet.next()) {
                evaluNodeId = rowSet.getString("id");
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return evaluNodeId;
    }

    private String getEvaluGroupID(Context ctx, String solutionPeriodID, String evaluObjectID) throws BOSException {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.FindEvaluGroupQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        evi.setFilter(fi);
        exec.setObjectView(evi);
        exec.option().topCount = 1;
        IRowSet rowSet = exec.executeQuery();
        String evaluGroupID = null;
        try {
            if (rowSet.next()) {
                evaluGroupID = rowSet.getString("id");
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return evaluGroupID;
    }

    private String getEvaluWorkFlowID(Context ctx, String solutionPeriodID, String evaluObjectID) throws BOSException {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.FindEvaluWorkFlowQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        evi.setFilter(fi);
        exec.setObjectView(evi);
        exec.option().topCount = 1;
        IRowSet row = exec.executeQuery();
        String evaluWorkFlowID = null;
        try {
            if (row.next()) {
                evaluWorkFlowID = row.getString("evalWorkFlow.id");
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return evaluWorkFlowID;
    }

    @Override
    protected void _batchSubmit(Context ctx, IObjectCollection nodeProcessers, List param) throws BOSException, EASBizException {
        INodeProcesser iNodeProcesser = NodeProcesserFactory.getLocalInstance(ctx);
        IEvalWorkFlowFacade evaluWorkFacade = EvalWorkFlowFacadeFactory.getLocalInstance(ctx);
        int size = nodeProcessers.size();
        for (int i = 0; i < size; ++i) {
            NodeProcesserInfo info = (NodeProcesserInfo)nodeProcessers.getObject(i);
            iNodeProcesser.submit((CoreBaseInfo)info);
            String assignmentID = info.getExtendedProperty("assignmentID");
            if (assignmentID == null) continue;
            evaluWorkFacade.clearReBackReason(assignmentID);
        }
        if (param != null && !param.isEmpty()) {
            EvalPersonFactory.getLocalInstance(ctx).batchSubmit(param);
        }
    }
}

