/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AchieveItemCollection;
import com.kingdee.eas.hr.perf.AchieveItemFactory;
import com.kingdee.eas.hr.perf.AchieveItemInfo;
import com.kingdee.eas.hr.perf.AchieveItemTreeException;
import com.kingdee.eas.hr.perf.AchieveItemTreeInfo;
import com.kingdee.eas.hr.perf.DataTypeEnum;
import com.kingdee.eas.hr.perf.IAchieveItem;
import com.kingdee.eas.hr.perf.PrecisionTypeEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DataImportAchieveItemTransmission
extends AbstractDataTransmission {
    private Object obj = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.DataImportAchieveItemTransmission");
    private static final long serialVersionUID = -61166L;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AchieveItemFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (this.isSltImportUpdate()) {
                AchieveItemInfo info = (AchieveItemInfo)coreBaseInfo;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("treeid.hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
                viewInfo.setFilter(filter);
                SelectorItemCollection sic = viewInfo.getSelector();
                sic.add(new SelectorItemInfo("id"));
                IAchieveItem iachieveItem = (IAchieveItem)this.getController(ctx);
                AchieveItemCollection coll = iachieveItem.getAchieveItemCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    info.setId(coll.get(0).getId());
                }
            }
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        AchieveItemInfo ret = new AchieveItemInfo();
        try {
            int enumValue;
            String str;
            Object trainCourseType = this.getContextParameter("AchieveItemType");
            if (trainCourseType == null || !(trainCourseType instanceof AchieveItemTreeInfo)) {
                throw new AchieveItemTreeException(AchieveItemTreeException.NULL_TYPE_NUMBER);
            }
            ret.setTreeid((AchieveItemTreeInfo)trainCourseType);
            this.obj = hsData.get("Number");
            if (this.obj == null || this.obj.toString().trim().length() <= 0) {
                throw new AchieveItemTreeException(AchieveItemTreeException.NULL_NUMBER);
            }
            ret.setNumber(this.obj.toString());
            this.obj = hsData.get("Name");
            if (this.obj == null || this.obj.toString().trim().length() <= 0) {
                throw new AchieveItemTreeException(AchieveItemTreeException.NULL_NAME);
            }
            ret.setName(this.obj.toString());
            this.obj = hsData.get("DataType");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                str = this.obj.toString().trim();
                if (!this.isFloat(str) || Integer.parseInt(str) < 1 || Integer.parseInt(str) > 3) throw new AchieveItemTreeException(AchieveItemTreeException.DATATYPE);
                enumValue = Integer.parseInt(str);
                if (enumValue == 1) {
                    ret.setDataType(DataTypeEnum.NUMERICAL);
                } else {
                    if (enumValue == 2) {
                        throw new AchieveItemTreeException(AchieveItemTreeException.DATATYPE);
                    }
                    if (enumValue == 3) {
                        ret.setDataType(DataTypeEnum.PERCENT);
                    }
                }
            } else {
                ret.setDataType(DataTypeEnum.NUMERICAL);
            }
            this.obj = hsData.get("DataPrecision");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                str = this.obj.toString().trim();
                if (!this.isFloat(str) || Integer.parseInt(str) < 0 || Integer.parseInt(str) > 5) throw new AchieveItemTreeException(AchieveItemTreeException.DATAPRECISION);
                ret.setDataPrecision(Integer.parseInt(str));
            } else {
                ret.setDataPrecision(0);
            }
            this.obj = hsData.get("Description");
            if (this.obj != null) {
                ret.setDescription(this.obj.toString());
            }
            this.obj = hsData.get("precisionType");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                str = this.obj.toString().trim();
                if (!this.isFloat(str)) throw new AchieveItemTreeException(AchieveItemTreeException.PRECISION_TYPE);
                enumValue = Integer.parseInt(str);
                if (enumValue == 10) {
                    ret.setPrecisionType(PrecisionTypeEnum.ROUND);
                } else if (enumValue == 20) {
                    ret.setPrecisionType(PrecisionTypeEnum.CARRY);
                } else {
                    if (enumValue != 30) throw new AchieveItemTreeException(AchieveItemTreeException.PRECISION_TYPE);
                    ret.setPrecisionType(PrecisionTypeEnum.TRUNCATE);
                }
            } else {
                ret.setPrecisionType(PrecisionTypeEnum.ROUND);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        ret.setIsEnable(true);
        ret.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        return ret;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            table.put("Number", rs.getString("number"));
            table.put("Name", rs.getString("name"));
            int i = 0;
            if (rs.getObject("DataType") != null) {
                i = rs.getInt("DataType");
                if (i == 0) {
                    table.put("DataType", "0");
                } else if (i == 1) {
                    table.put("DataType", "1");
                } else if (i == 2) {
                    table.put("DataType", "2");
                } else if (i == 3) {
                    table.put("DataType", "3");
                }
            }
            if (rs.getObject("DataPrecision") != null) {
                i = rs.getInt("DataPrecision");
                table.put("DataPrecision", String.valueOf(i));
            }
            if (rs.getString("precisionType") != null) {
                table.put("precisionType", rs.getString("precisionType"));
            }
            if (rs.getString("description") != null) {
                table.put("Description", rs.getString("description"));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return table;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hrInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrInfo.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)"%noeas%"));
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.perf.app.AchieveItemQuery";
    }

    private boolean isFloat(String str) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        String regex = "^(?:[1-9][0-9]*|0)(?:\\.[0-9]*)?$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str.trim());
        return m.matches();
    }
}

