/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.IPerformTargetType;
import com.kingdee.eas.hr.perf.PerformLibException;
import com.kingdee.eas.hr.perf.PerformTargetTypeCollection;
import com.kingdee.eas.hr.perf.PerformTargetTypeFactory;
import com.kingdee.eas.hr.perf.PerformTargetTypeInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class DataImportPerfTargetTypeTransmission
extends AbstractDataTransmission {
    private IPerformTargetType iptt = null;
    private Object obj = null;
    private String parentNumber = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.DataImportPerfTargetTypeTransmission");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PerformTargetTypeFactory.getLocalInstance(ctx);
        }
        catch (BOSException ex) {
            throw new TaskExternalException("", (Throwable)ex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (this.isSltImportUpdate()) {
                PerformTargetTypeInfo info = (PerformTargetTypeInfo)coreBaseInfo;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
                filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
                viewInfo.setFilter(filter);
                filter.setMaskString(" (#0 or #1) and #2 ");
                SelectorItemCollection sic = viewInfo.getSelector();
                sic.add(new SelectorItemInfo("id"));
                IPerformTargetType iPerformTargetType = (IPerformTargetType)this.getController(ctx);
                PerformTargetTypeCollection coll = iPerformTargetType.getPerformTargetTypeCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    info.setId(coll.get(0).getId());
                }
            }
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PerformTargetTypeInfo ret = new PerformTargetTypeInfo();
        this.obj = null;
        this.parentNumber = null;
        try {
            if (this.iptt == null) {
                this.iptt = PerformTargetTypeFactory.getLocalInstance(ctx);
            }
            this.obj = hsData.get("parentNumber");
            if (this.obj != null) {
                this.parentNumber = this.obj.toString();
            }
            if (!StringUtils.isEmpty((String)this.parentNumber)) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.parentNumber));
                filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
                viewInfo.setFilter(filterInfo);
                CoreBaseCollection coll = this.iptt.getCollection(viewInfo);
                if (coll == null || coll.size() != 1) throw new PerformLibException(PerformLibException.ERROR_PARENT_NUMBER);
                ret.setParent((PerformTargetTypeInfo)coll.get(0));
            } else {
                ret.setParent(null);
            }
            Object obj = hsData.get("name");
            if (obj != null) {
                ret.setName(obj.toString());
            }
            if ((obj = hsData.get("number")) != null) {
                ret.setNumber(obj.toString());
            }
            if ((obj = hsData.get("description")) != null) {
                ret.setDescription(obj.toString());
            }
            ret.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            return ret;
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage(ctx.getLocale()), ex.getCause());
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            table.put("name", rs.getString("name"));
            table.put("number", rs.getString("number"));
            if (rs.getString("parentNumber") != null) {
                table.put("parentNumber", rs.getString("parentNumber"));
            }
            if (rs.getString("description") != null) {
                table.put("description", rs.getString("description"));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return table;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        filter.getFilterItems().add(new FilterItemInfo("enable", (Object)Boolean.TRUE));
        if (hrInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrInfo.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)"%noeas%"));
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.perf.app.TargetTypeExpQuery";
    }
}

