/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.IPerformTargetItem;
import com.kingdee.eas.hr.perf.IPerformTargetType;
import com.kingdee.eas.hr.perf.KindEnum;
import com.kingdee.eas.hr.perf.PerformLibException;
import com.kingdee.eas.hr.perf.PerformTargetItemCollection;
import com.kingdee.eas.hr.perf.PerformTargetItemFactory;
import com.kingdee.eas.hr.perf.PerformTargetItemInfo;
import com.kingdee.eas.hr.perf.PerformTargetTypeFactory;
import com.kingdee.eas.hr.perf.PerformTargetTypeInfo;
import com.kingdee.eas.hr.perf.ReportFrequencyEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DataImportTargetItemTransmission
extends AbstractDataTransmission {
    private IPerformTargetType iptt = null;
    private Object obj = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.DataImportTargetItemTransmission");
    private static final long serialVersionUID = -61166L;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PerformTargetItemFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (this.isSltImportUpdate()) {
                PerformTargetItemInfo info = (PerformTargetItemInfo)coreBaseInfo;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("type.hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
                viewInfo.setFilter(filter);
                SelectorItemCollection sic = viewInfo.getSelector();
                sic.add(new SelectorItemInfo("id"));
                IPerformTargetItem iPerformtargetItem = (IPerformTargetItem)this.getController(ctx);
                PerformTargetItemCollection coll = iPerformtargetItem.getPerformTargetItemCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    info.setId(coll.get(0).getId());
                }
            }
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PerformTargetItemInfo ret = new PerformTargetItemInfo();
        DecimalFormat df = new DecimalFormat("0.00");
        try {
            BigDecimal b;
            String str;
            if (this.iptt == null) {
                this.iptt = PerformTargetTypeFactory.getLocalInstance(ctx);
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            this.obj = hsData.get("typeNumber");
            if (this.obj == null) {
                throw new PerformLibException(PerformLibException.NULL_TYPE);
            }
            this.obj = this.obj.toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", this.obj));
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
            viewInfo.setFilter(filterInfo);
            SelectorItemCollection selector = viewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("isLeaf"));
            CoreBaseCollection coll = this.iptt.getCollection(viewInfo);
            PerformTargetTypeInfo typeInfo = null;
            if (coll != null && coll.size() == 1) {
                typeInfo = (PerformTargetTypeInfo)coll.get(0);
                if (!typeInfo.isIsLeaf()) {
                    throw new PerformLibException(PerformLibException.IMPORT_ITEM_NOTLEAF_ERROR);
                }
            } else {
                throw new PerformLibException(PerformLibException.ERROR_TYPE_NUMBER);
            }
            ret.setType(typeInfo);
            this.obj = hsData.get("number");
            if (this.obj != null) {
                ret.setNumber(this.obj.toString());
            }
            this.obj = hsData.get("content");
            if (this.obj != null) {
                ret.setContent(this.obj.toString());
            }
            this.obj = hsData.get("standard");
            if (this.obj != null) {
                ret.setStandard(this.obj.toString());
            }
            this.obj = hsData.get("value");
            if (this.obj != null && !"".equals(this.obj.toString())) {
                ret.setValueable(true);
                ret.setValue(this.obj.toString());
            } else {
                ret.setValueable(false);
            }
            this.obj = hsData.get("valueable");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                str = this.obj.toString().trim();
                if ("true".equals(str)) {
                    ret.setValueable(true);
                } else if ("false".equals(str)) {
                    ret.setValueable(false);
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"1_DataImportTargetItemTransmission", (Locale)ctx.getLocale()));
                }
            }
            this.obj = hsData.get("thresholdValue");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                str = this.obj.toString().trim();
                if (this.isFloat(str)) {
                    b = new BigDecimal(df.format(Double.parseDouble(str)));
                    b = b.setScale(2);
                    ret.setThresholdValue(b);
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"2_DataImportTargetItemTransmission", (Locale)ctx.getLocale()));
                }
            }
            this.obj = hsData.get("challengeValue");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                str = this.obj.toString().trim();
                if (this.isFloat(str)) {
                    b = new BigDecimal(df.format(Double.parseDouble(str)));
                    b = b.setScale(2);
                    ret.setChallengeValue(b);
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"3_DataImportTargetItemTransmission", (Locale)ctx.getLocale()));
                }
            }
            this.obj = hsData.get("standardValue");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                str = this.obj.toString().trim();
                if (this.isFloat(str)) {
                    b = new BigDecimal(df.format(Double.parseDouble(str)));
                    b = b.setScale(2);
                    ret.setStandardValue(b);
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"4_DataImportTargetItemTransmission", (Locale)ctx.getLocale()));
                }
            }
            this.obj = hsData.get("unit");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                ret.setUnit(this.obj.toString().trim());
            }
            this.obj = hsData.get("reportFrequency");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                str = this.obj.toString().trim();
                if ("weak".equals(str)) {
                    ret.setReportFrequency(ReportFrequencyEnum.WEAK);
                } else if ("month".equals(str)) {
                    ret.setReportFrequency(ReportFrequencyEnum.MONTH);
                } else if ("year".equals(str)) {
                    ret.setReportFrequency(ReportFrequencyEnum.YEAR);
                } else if ("halfYear".equals(str)) {
                    ret.setReportFrequency(ReportFrequencyEnum.HALFYEAR);
                } else if ("quarter".equals(str)) {
                    ret.setReportFrequency(ReportFrequencyEnum.QUARTER);
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"5_DataImportTargetItemTransmission", (Locale)ctx.getLocale()));
                }
            }
            this.obj = hsData.get("scoringMethod");
            if (this.obj != null) {
                ret.setScoringMethod(this.obj.toString().trim());
            }
            this.obj = hsData.get("evaluationSide");
            if (this.obj != null) {
                ret.setEvaluationSide(this.obj.toString().trim());
            }
            this.obj = hsData.get("reservedField1");
            if (this.obj != null) {
                ret.setReservedField1(this.obj.toString().trim());
            }
            this.obj = hsData.get("reservedField2");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                str = this.obj.toString().trim();
                if (this.isFloat(str)) {
                    b = new BigDecimal(df.format(Double.parseDouble(str)));
                    b = b.setScale(2);
                    ret.setReservedField2(b);
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"6_DataImportTargetItemTransmission", (Locale)ctx.getLocale()));
                }
            }
            this.obj = hsData.get("kind");
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                String kind = this.obj.toString().trim();
                if ("1".equals(kind)) {
                    ret.setKind(KindEnum.QUALITATIVE);
                } else if ("2".equals(kind)) {
                    ret.setKind(KindEnum.QUANTITATIVE);
                } else if ("3".equals(kind)) {
                    ret.setKind(KindEnum.QUANTITATIVE2);
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"7_DataImportTargetItemTransmission", (Locale)ctx.getLocale()));
                }
            }
            this.obj = hsData.get("description");
            if (this.obj != null) {
                ret.setDescription(this.obj.toString());
            }
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage(ctx.getLocale()), ex.getCause());
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return ret;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        try {
            table.put("number", rs.getString("number"));
            table.put("content", rs.getString("content"));
            if (rs.getString("standard") != null) {
                table.put("standard", rs.getString("standard"));
            }
            table.put("typeNumber", rs.getString("typeNumber"));
            if (rs.getBigDecimal("thresholdValue") != null) {
                table.put("thresholdValue", rs.getBigDecimal("thresholdValue"));
            }
            if (rs.getBigDecimal("challengeValue") != null) {
                table.put("challengeValue", rs.getBigDecimal("challengeValue"));
            }
            if (rs.getBigDecimal("standardValue") != null) {
                table.put("standardValue", rs.getBigDecimal("standardValue"));
            }
            if (rs.getString("unit") != null) {
                table.put("unit", rs.getString("unit"));
            }
            int i = 0;
            if (rs.getObject("reportFrequency") != null) {
                // empty if block
            }
            if ((i = rs.getInt("reportFrequency")) == 1) {
                table.put("reportFrequency", "weak");
            } else if (i == 2) {
                table.put("reportFrequency", "month");
            } else if (i == 5) {
                table.put("reportFrequency", "year");
            } else if (i == 4) {
                table.put("reportFrequency", "halfYear");
            } else if (i == 3) {
                table.put("reportFrequency", "quarter");
            }
            if (rs.getString("scoringMethod") != null) {
                table.put("scoringMethod", rs.getString("scoringMethod"));
            }
            if (rs.getString("evaluationSide") != null) {
                table.put("evaluationSide", rs.getString("evaluationSide"));
            }
            if (rs.getString("reservedField1") != null) {
                table.put("reservedField1", rs.getString("reservedField1"));
            }
            if (rs.getBigDecimal("reservedField2") != null) {
                table.put("reservedField2", rs.getBigDecimal("reservedField2"));
            }
            if (rs.getObject("kind") != null) {
                i = rs.getInt("kind");
                if (i == 10) {
                    table.put("kind", "1");
                } else if (i == 21) {
                    table.put("kind", "2");
                } else if (i == 22) {
                    table.put("kind", "3");
                }
            }
            if (rs.getString("description") != null) {
                table.put("description", rs.getString("description"));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return table;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hrInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrInfo.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)"%noeas%"));
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.perf.app.TargetItemExpQuery";
    }

    private boolean isFloat(String str) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        String regex = "^(?:[1-9][0-9]*|0)(?:\\.[0-9]*)?$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str.trim());
        return m.matches();
    }
}

