/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.MDEvaluCommentReportException;
import com.kingdee.eas.hr.perf.PaperQueDetailFactory;
import com.kingdee.eas.hr.perf.PaperQueDetailInfo;
import com.kingdee.eas.hr.perf.TestPageFormCollection;
import com.kingdee.eas.hr.perf.TestPageFormFacadeFactory;
import com.kingdee.eas.hr.perf.TestPageFormFactory;
import com.kingdee.eas.hr.perf.TestPageFormInfo;
import com.kingdee.eas.hr.perf.TestPaperInfo;
import com.kingdee.eas.hr.perf.app.AbstractEvalPersonControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EvalPersonControllerBean
extends AbstractEvalPersonControllerBean {
    private static final long serialVersionUID = -61166L;

    @Override
    protected void _saveFormData(Context ctx, IObjectValue testPageFormInfo, String evalPersonID, BigDecimal score, String rankID, String mdEvaluatorID, String evalReDetailID, String mdSolutionPeriodID, String mdObjectID) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_EvalPerson SET FScore = ?, FRankID = ?, FPaperState = ?, FWfStatus = ?  WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            score = score.setScale(6, 4);
            pstmt.setBigDecimal(1, score);
            if (rankID != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)rankID);
            } else {
                pstmt.setString(2, null);
            }
            pstmt.setInt(3, 20);
            pstmt.setInt(4, 30);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)evalPersonID);
            pstmt.execute();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        TestPageFormInfo info = (TestPageFormInfo)testPageFormInfo;
        info.setProcessTime(new Date());
        TestPageFormFactory.getLocalInstance(ctx).save(info);
        TestPageFormFacadeFactory.getLocalInstance(ctx).updateStatusAndCountScoreNoWorkFlow(evalPersonID, mdSolutionPeriodID, mdObjectID, mdEvaluatorID, evalReDetailID);
    }

    @Override
    protected boolean _batchSubmit(Context ctx, List param) throws BOSException, EASBizException {
        TestPageFormInfo testPageFormInfo = null;
        TestPageFormCollection testPageFormCollection = null;
        boolean flag = false;
        ArrayList<String> evalPersonList = new ArrayList<String>();
        ArrayList<String> updateScoreList = new ArrayList<String>();
        HashMap<String, String> rankMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> ScoreMap = new HashMap<String, BigDecimal>();
        HashMap<String, Integer> pageFormIndexMap = new HashMap<String, Integer>();
        if (param != null && !param.isEmpty()) {
            int i;
            for (i = 0; i < param.size(); ++i) {
                Map tempMap = new HashMap();
                tempMap = (Map)param.get(i);
                String evalPersonID = (String)tempMap.get("evalPersonID");
                String mdObjectID = (String)tempMap.get("mdObjectID");
                String solutionPeriodID = (String)tempMap.get("solutionPeriodID");
                Integer rowIndex = (Integer)tempMap.get("rowIndex");
                String mdEvaluatorID = (String)tempMap.get("mdEvaluatorID");
                String evalReDetailID = (String)tempMap.get("evalReDetailID");
                updateScoreList.add(evalPersonID + "," + solutionPeriodID + "," + mdObjectID + "," + mdEvaluatorID + "," + evalReDetailID);
                evalPersonList.add(evalPersonID);
                pageFormIndexMap.put(evalPersonID, rowIndex);
            }
            testPageFormCollection = this.getTestPageFormCollection(ctx, evalPersonList);
            if (testPageFormCollection != null && testPageFormCollection.size() > 0) {
                if (testPageFormCollection.size() != evalPersonList.size()) {
                    HashMap<String, Integer> tempMap = pageFormIndexMap;
                    for (int i2 = 0; i2 < testPageFormCollection.size(); ++i2) {
                        testPageFormInfo = testPageFormCollection.get(i2);
                        if (testPageFormInfo.getEvalPerson() == null) continue;
                        tempMap.remove(testPageFormInfo.getEvalPerson().getId().toString());
                    }
                    String rows = "";
                    Iterator it = tempMap.keySet().iterator();
                    ArrayList<Integer> sortIndex = new ArrayList<Integer>();
                    while (it.hasNext()) {
                        Integer rowNum = (Integer)pageFormIndexMap.get(it.next());
                        sortIndex.add(rowNum);
                    }
                    Collections.sort(sortIndex);
                    for (int l = 0; l < sortIndex.size(); ++l) {
                        rows = rows + String.valueOf((Integer)sortIndex.get(l) + 1) + ",";
                    }
                    rows = rows.substring(0, rows.length() - 1);
                    throw new MDEvaluCommentReportException(MDEvaluCommentReportException.TESTPAPERNOTCOMPLETE, new Object[]{rows});
                }
                for (i = 0; i < testPageFormCollection.size(); ++i) {
                    testPageFormInfo = testPageFormCollection.get(i);
                    if (testPageFormInfo == null || testPageFormInfo.getId() == null) continue;
                    Integer rowNum = (Integer)pageFormIndexMap.get(testPageFormInfo.getEvalPerson().getId().toString());
                    if (testPageFormInfo.getRank() != null && testPageFormInfo.getRank().getId() != null) {
                        rankMap.put(testPageFormInfo.getEvalPerson().getId().toString(), testPageFormInfo.getRank().getId().toString());
                        continue;
                    }
                    TestPaperInfo info = testPageFormInfo.getTestPaper();
                    GradeModeInfo soluGradeMode = testPageFormInfo.getMdEvaluResult().getSolutionPeriod().getMDSolution().getGradeMode();
                    BigDecimal soluScore = this.getScore(info, soluGradeMode, testPageFormInfo, rowNum);
                    ScoreMap.put(testPageFormInfo.getEvalPerson().getId().toString(), soluScore);
                }
            } else {
                String rows = "";
                Iterator it = pageFormIndexMap.keySet().iterator();
                ArrayList<Integer> sortIndex = new ArrayList<Integer>();
                while (it.hasNext()) {
                    Integer rowNum = (Integer)pageFormIndexMap.get(it.next());
                    sortIndex.add(rowNum);
                }
                Collections.sort(sortIndex);
                for (int l = 0; l < sortIndex.size(); ++l) {
                    rows = rows + String.valueOf((Integer)sortIndex.get(l) + 1) + ",";
                }
                rows = rows.substring(0, rows.length() - 1);
                throw new MDEvaluCommentReportException(MDEvaluCommentReportException.TESTPAPERNOTCOMPLETE, new Object[]{rows});
            }
            this.checkPaperQueDetail(ctx, testPageFormCollection, pageFormIndexMap);
            this.updateState(ctx, evalPersonList, ScoreMap, rankMap);
            this.updateScore(ctx, updateScoreList);
            flag = true;
        }
        return flag;
    }

    private BigDecimal getScore(TestPaperInfo info, GradeModeInfo soluGradeMode, TestPageFormInfo testPageFormInfo, Integer rowNum) throws EASBizException {
        BigDecimal score;
        BigDecimal minGrade = null;
        BigDecimal maxGrade = null;
        BigDecimal soluScore = null;
        if (info.getGradeMode() != null) {
            minGrade = info.getGradeMode().getMinGrade();
            minGrade = minGrade.setScale(6, 4);
            maxGrade = info.getGradeMode().getMaxGrade();
            maxGrade = maxGrade.setScale(6, 4);
        }
        if ((score = testPageFormInfo.getScore()) == null) {
            throw new MDEvaluCommentReportException(MDEvaluCommentReportException.TESTPAPERNOTCOMPLETE, new Object[]{new Integer(rowNum + 1)});
        }
        score = score.setScale(6, 4);
        BigDecimal zero = new BigDecimal("0.000000");
        soluScore = zero.add(score.subtract(minGrade)).divide(maxGrade.subtract(minGrade), 4);
        soluScore = soluScore.multiply(soluGradeMode.getMaxGrade().subtract(soluGradeMode.getMinGrade())).add(soluGradeMode.getMinGrade());
        return soluScore;
    }

    private TestPageFormCollection getTestPageFormCollection(Context ctx, List evalPersonList) throws BOSException {
        TestPageFormCollection testPageFormCollection = null;
        if (evalPersonList != null && evalPersonList.size() > 0) {
            HashSet set = new HashSet();
            for (int i = 0; i < evalPersonList.size(); ++i) {
                set.add(evalPersonList.get(i));
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evalPerson.id", set, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("rank.*"));
            sic.add(new SelectorItemInfo("evalPerson.id"));
            sic.add(new SelectorItemInfo("testPaper.id"));
            sic.add(new SelectorItemInfo("testPaper.rankGroup.id"));
            sic.add(new SelectorItemInfo("testPaper.name"));
            sic.add(new SelectorItemInfo("testPaper.gradeMode.id"));
            sic.add(new SelectorItemInfo("testPaper.gradeMode.name"));
            sic.add(new SelectorItemInfo("testPaper.gradeMode.minGrade"));
            sic.add(new SelectorItemInfo("testPaper.gradeMode.maxGrade"));
            sic.add(new SelectorItemInfo("mdEvaluResult.solutionPeriod.MDSolution.id"));
            sic.add(new SelectorItemInfo("mdEvaluResult.solutionPeriod.MDSolution.GradeMode.*"));
            testPageFormCollection = TestPageFormFactory.getLocalInstance(ctx).getTestPageFormCollection(viewInfo);
        }
        return testPageFormCollection;
    }

    private void checkPaperQueDetail(Context ctx, TestPageFormCollection testPageFormCollection, Map pageFormIndexMap) throws BOSException, EASBizException {
        TestPageFormInfo testPageFormInfo = null;
        CoreBaseCollection paperQueDetailCollection = null;
        PaperQueDetailInfo paperQueDetailInfo = null;
        if (testPageFormCollection != null && testPageFormCollection.size() > 0) {
            for (int i = 0; i < testPageFormCollection.size(); ++i) {
                testPageFormInfo = testPageFormCollection.get(i);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("testPageForm.id", (Object)testPageFormInfo.getId().toString(), CompareType.EQUALS));
                view.setFilter(filterInfo);
                paperQueDetailCollection = PaperQueDetailFactory.getLocalInstance(ctx).getCollection(view);
                if (paperQueDetailCollection == null || paperQueDetailCollection.size() <= 0) continue;
                for (int j = 0; j < paperQueDetailCollection.size(); ++j) {
                    paperQueDetailInfo = (PaperQueDetailInfo)paperQueDetailCollection.get(j);
                    if (paperQueDetailInfo != null) {
                        if (paperQueDetailInfo.getScore() != null || paperQueDetailInfo.getRank() != null) continue;
                        Integer rowIndex = (Integer)pageFormIndexMap.get(testPageFormInfo.getEvalPerson().getId().toString());
                        throw new MDEvaluCommentReportException(MDEvaluCommentReportException.TESTPAPERNOTCOMPLETE, new Object[]{new Integer(rowIndex + 1)});
                    }
                    Integer rowIndex = (Integer)pageFormIndexMap.get(testPageFormInfo.getEvalPerson().getId().toString());
                    throw new MDEvaluCommentReportException(MDEvaluCommentReportException.TESTPAPERNOTCOMPLETE, new Object[]{new Integer(rowIndex + 1)});
                }
            }
        }
    }

    private void updateState(Context ctx, List evalPersonList, Map ScoreMap, Map rankMap) throws BOSException, EASBizException {
        if (evalPersonList != null && evalPersonList.size() > 0) {
            String sql = "UPDATE T_PF_EvalPerson SET FScore = ?, FRankID = ?, FPaperState = ?, FWfStatus = ?  WHERE FID = ?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                for (int n = 0; n < evalPersonList.size(); ++n) {
                    String evalPersonId = evalPersonList.get(n).toString();
                    if (ScoreMap.get(evalPersonId) != null) {
                        BigDecimal score = (BigDecimal)ScoreMap.get(evalPersonId);
                        score = score.setScale(6, 4);
                        pstmt.setBigDecimal(1, score);
                    } else {
                        pstmt.setBigDecimal(1, null);
                    }
                    if (rankMap.get(evalPersonId) != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)((String)rankMap.get(evalPersonId)));
                    } else {
                        pstmt.setString(2, null);
                    }
                    pstmt.setInt(3, 20);
                    pstmt.setInt(4, 30);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)evalPersonId);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (Exception e) {
                try {
                    throw new MDEvaluCommentReportException(MDEvaluCommentReportException.SQLEXCEPTION, e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    private void updateScore(Context ctx, List updateScoreList) throws EASBizException, BOSException {
        if (!updateScoreList.isEmpty()) {
            for (int i = 0; i < updateScoreList.size(); ++i) {
                String str = (String)updateScoreList.get(i);
                String[] arr = str.split(",");
                TestPageFormFacadeFactory.getLocalInstance(ctx).updateStatusAndCountScoreNoWorkFlow(arr[0], arr[1], arr[2], arr[3], arr[4]);
            }
        }
    }
}

