/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.ProcessStartParam;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ActualParameterType;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.define.IExecuteObject;
import com.kingdee.bos.workflow.define.JoinType;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.OrgTypeDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.define.ReferenceHumanType;
import com.kingdee.bos.workflow.define.RelationType;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.SplitType;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.diagram.ActivityNode;
import com.kingdee.bos.workflow.define.diagram.Coordinate;
import com.kingdee.bos.workflow.define.diagram.Line;
import com.kingdee.bos.workflow.define.diagram.Node;
import com.kingdee.bos.workflow.define.diagram.NodeCollection;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.wfdesigner.WorkFlowProcessInfo;
import com.kingdee.bos.workflow.wfdesigner.service.WorkFlowDefineService;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.perf.ConcurrenceArgsCollection;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvalWFObjectsCollection;
import com.kingdee.eas.hr.perf.EvalWFObjectsFactory;
import com.kingdee.eas.hr.perf.EvalWFObjectsInfo;
import com.kingdee.eas.hr.perf.EvalWorkFlowCollection;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeException;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.EvalorNodeInfo;
import com.kingdee.eas.hr.perf.EvaluGroupCollection;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluNodeCollection;
import com.kingdee.eas.hr.perf.EvaluNodeInfo;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluResultCollection;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.FellowTypeEnum;
import com.kingdee.eas.hr.perf.IEvalWorkFlowFacade;
import com.kingdee.eas.hr.perf.IEvaluGroup;
import com.kingdee.eas.hr.perf.IEvaluResult;
import com.kingdee.eas.hr.perf.MessageString;
import com.kingdee.eas.hr.perf.NodeProcesserCollection;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.NodeProcesserInfo;
import com.kingdee.eas.hr.perf.NodeVisibleCollection;
import com.kingdee.eas.hr.perf.NodeVisibleInfo;
import com.kingdee.eas.hr.perf.ParticipatorTypeEnum;
import com.kingdee.eas.hr.perf.RelationTypeEnum;
import com.kingdee.eas.hr.perf.ResultObjectInstInfo;
import com.kingdee.eas.hr.perf.SelectedOrgTypeEnum;
import com.kingdee.eas.hr.perf.SolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.TargetScoreComputeFacadeFactory;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.WfParam;
import com.kingdee.eas.hr.perf.WfParamException;
import com.kingdee.eas.hr.perf.WfParamFacadeFactory;
import com.kingdee.eas.hr.perf.app.AbstractEvalWorkFlowFacadeControllerBean;
import com.kingdee.eas.hr.perf.app.PfServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EvalWorkFlowFacadeControllerBean
extends AbstractEvalWorkFlowFacadeControllerBean {
    private static final long serialVersionUID = 6981231696937807190L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvalWorkFlowFacadeControllerBean");
    String ROUTERPREFIX = "R";
    String MANPOWERPREFIX = "N";
    int xLen = 90;
    int yLen = 60;
    int DEFAULTLEVELS = 10;
    Locale l2 = new Locale("l2");
    Locale[] locales = null;
    int DELPROCINSTMAX = 5;
    int TERMINALINSTMAX = 10;
    int CREATEPROCINSTMAX = 10;
    private final int BATCH_SIZE = 200;
    private static final String SOLUTION_PERIOD = "spInfo";
    private static BOSObjectType bosType = new NodeProcesserInfo().getBOSType();

    @Override
    protected String _realeaseProcess(Context ctx, ProcessDef procDef) throws BOSException, EASBizException {
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        enactmentService.releaseProcessDef(procDef.toXml(), true).getProcessDefInfo();
        return procDef.getID();
    }

    @Override
    protected void _startSolutionPeriod(Context ctx, BOSUuid solutionPeriodID) throws BOSException, EASBizException {
        HashSet<String> evaluObjectIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID.toString()));
        view.setFilter(filter);
        view.getSelector().add("evaluObject.id");
        EvalWFObjectsCollection coll = EvalWFObjectsFactory.getLocalInstance(ctx).getEvalWFObjectsCollection(view);
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                evaluObjectIdSet.add(coll.get(i).getEvaluObject().getId().toString());
            }
        }
        this.startWorkFlow(ctx, solutionPeriodID.toString(), evaluObjectIdSet);
    }

    private void startWorkFlow(Context ctx, String solutionPeriodID, Set evaluObjectIdSet) throws BOSException, EASBizException, EvalWorkFlowFacadeException {
        if (solutionPeriodID == null || evaluObjectIdSet == null || evaluObjectIdSet.size() == 0) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID));
        if (!EvalWFObjectsFactory.getLocalInstance(ctx).exists(filter)) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.NULL_FLOWOBJ);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("evaluSolution.solutionType"));
        sic.add(new SelectorItemInfo("evaluSolution.deliverMode"));
        sic.add(new SelectorItemInfo("status"));
        SolutionPeriodInfo info = null;
        info = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
        if (!SolutionPeriodStatusEnum.UN_EVALU.equals((Object)info.getStatus())) {
            return;
        }
        boolean flag = DeliverModeEnum.DIRECT_ENTER.equals((Object)info.getEvaluSolution().getDeliverMode());
        EvalWorkFlowCollection evalWorkFlowCollection = this.getEvalWorkFlowCollection(ctx, BOSUuid.read((String)solutionPeriodID));
        ctx.put((Object)SOLUTION_PERIOD, (Object)info);
        this.createProcessInst(ctx, flag, solutionPeriodID.toString(), evalWorkFlowCollection, evaluObjectIdSet);
        ctx.remove((Object)SOLUTION_PERIOD);
    }

    private EvalWorkFlowCollection getEvalWorkFlowCollection(Context ctx, BOSUuid solutionPeriodID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID.toString());
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("workFlowID"));
        EvalWorkFlowCollection evalWorkFlowCollection = EvalWorkFlowFactory.getLocalInstance(ctx).getEvalWorkFlowCollection(viewInfo);
        return evalWorkFlowCollection;
    }

    private boolean isDirectEnter(Context ctx, BOSUuid solutionPeriodID) throws BOSException, EvalWorkFlowFacadeException {
        boolean flag = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)solutionPeriodID.toString());
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("evaluSolution.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluSolution.deliverMode"));
        SolutionPeriodCollection solutionPeriodCollection = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodCollection(viewInfo);
        if (solutionPeriodCollection.size() == 1) {
            flag = DeliverModeEnum.DIRECT_ENTER.equals((Object)solutionPeriodCollection.get(0).getEvaluSolution().getDeliverMode());
        } else {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.EVALUSOLUTION_FAILD);
        }
        return flag;
    }

    public void startSolutionPeriodSuccess(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        this.insertEvaluResult(ctx, solutionPeriodId);
        SolutionPeriodFactory.getLocalInstance(ctx).startSolutionPeriod(solutionPeriodId);
    }

    private void insertEvaluResult(Context ctx, String solutionPeriodId) throws BOSException, SQLDataException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement up = null;
        String sqlt = "UPDATE T_PF_EvaluResult SET @ = (SELECT # FROM t_hr_personposition p inner join t_pf_evaluobject o on p.fpersonid = o.fobjectid where o.fid = T_PF_EvaluResult.fevaluobjectid) where T_PF_EvaluResult.FSolutionPeriodID=?";
        EvaluResultInfo resultInfo = new EvaluResultInfo();
        String bosType = resultInfo.getBOSType().toString();
        String CUID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String HRID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO T_PF_EvaluResult (FID, FControlUnitID, FEvaluObjectID, FSolutionPeriodID, FHROrgUnitID,FIsModified,FIsReferenced,FIsApproved) ");
        sb.append("SELECT newbosid('");
        sb.append(bosType);
        sb.append("'),'");
        sb.append(CUID);
        sb.append("',");
        sb.append("flowObject.FEvaluObjectID,'");
        sb.append(solutionPeriodId);
        sb.append("','");
        sb.append(HRID);
        sb.append("',0,0,0");
        sb.append(" FROM T_PF_EvalWFObjects flowObject INNER JOIN T_PF_EvalWorkFlow flow ON flowObject.FEvalWorkFlowID = flow.FID");
        sb.append(" WHERE flow.FSolutionPeriodID = ? ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            pstmt.setString(1, solutionPeriodId);
            pstmt.execute();
            SQLUtils.cleanup((Statement)pstmt);
            up = conn.prepareStatement(sqlt.replaceAll("@", "FPositionID").replaceAll("#", "FPrimaryPositionID"));
            up.setString(1, solutionPeriodId);
            up.execute();
            SQLUtils.cleanup((Statement)up);
            up = conn.prepareStatement(sqlt.replaceAll("@", "FAdminOrgUnitID").replaceAll("#", "FPersondep"));
            up.setString(1, solutionPeriodId);
            up.execute();
            SQLUtils.cleanup((Statement)up);
            up = conn.prepareStatement(sqlt.replaceAll("@", "FJobGradeID").replaceAll("#", "FJobGrade"));
            up.setString(1, solutionPeriodId);
            up.execute();
            SQLUtils.cleanup((Statement)up);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int _stopSolutionPeriod(Context ctx, BOSUuid solutionPeriodID) throws BOSException, EASBizException {
        int unDeleteProcess;
        EvalWorkFlowCollection evalWorkFlowCollection;
        block5: {
            boolean flag = false;
            flag = this.isDirectEnter(ctx, solutionPeriodID);
            evalWorkFlowCollection = this.getEvalWorkFlowCollection(ctx, solutionPeriodID);
            if (flag) {
                this.deleteManuEnterProcess(ctx, solutionPeriodID, evalWorkFlowCollection);
                this.deleteWorkFlowSuccess(ctx, solutionPeriodID);
                return 0;
            }
            HashMap instToResultObjectMap = this.getResultObjectInstMap(ctx, solutionPeriodID);
            try {
                IEvalWorkFlowFacade ifacade = EvalWorkFlowFacadeFactory.getLocalInstance(ctx);
                int n = evalWorkFlowCollection.size();
                for (int i = 0; i < n; ++i) {
                    ifacade.deleteProcess(evalWorkFlowCollection.get(i).getWorkFlowID().toString(), instToResultObjectMap);
                }
            }
            catch (Exception e3) {
                int unDeleteProcess2 = this.countUnDeleteProcess(ctx, solutionPeriodID, evalWorkFlowCollection);
                if (unDeleteProcess2 <= 0) break block5;
                Object[] param = new Object[]{new Integer(unDeleteProcess2)};
                throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.RESET_FAILD, param);
            }
        }
        if ((unDeleteProcess = this.countUnDeleteProcess(ctx, solutionPeriodID, evalWorkFlowCollection)) == 0) {
            this.deleteManuEnterProcess(ctx, solutionPeriodID, evalWorkFlowCollection);
            this.deleteWorkFlowSuccess(ctx, solutionPeriodID);
            return 0;
        }
        Object[] param = new Object[]{new Integer(unDeleteProcess)};
        throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.RESET_FAILD, param);
    }

    private void deleteManuEnterProcess(Context ctx, BOSUuid solutionPeriodID, EvalWorkFlowCollection evalWorkFlowCollection) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_PF_EvalWFObjects SET FStatus = ? ,FProcInstID = ?  WHERE FEvalWorkFlowID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int n = evalWorkFlowCollection.size();
            for (int i = 0; i < n; ++i) {
                pstmt.setInt(1, 10);
                pstmt.setString(2, null);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)evalWorkFlowCollection.get(i).getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod.id", (Object)solutionPeriodID));
        NodeProcesserFactory.getLocalInstance(ctx).delete(filterInfo);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID.toString()));
        IEvaluResult evaluResult = EvaluResultFactory.getLocalInstance(ctx);
        evaluResult.delete(fi);
    }

    private void deleteWorkFlowSuccess(Context ctx, BOSUuid solutionPeriodID) throws BOSException, EASBizException {
        HashSet<String> evaluGroupIdSet = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        IEvaluGroup evaluGroup = EvaluGroupFactory.getLocalInstance(ctx);
        EvaluGroupCollection groupColl = evaluGroup.getEvaluGroupCollection(evi);
        if (groupColl != null && groupColl.size() > 0) {
            int size = groupColl.size();
            for (int i = 0; i < size; ++i) {
                evaluGroupIdSet.add(groupColl.get(i).getId().toString());
            }
        }
        EvaluSolutionFacadeFactory.getLocalInstance(ctx).undeliverGroupTarget(solutionPeriodID.toString(), evaluGroupIdSet, true);
        SolutionPeriodFactory.getLocalInstance(ctx).resetSolutionPeriod(solutionPeriodID.toString());
    }

    private int countUnDeleteProcess(Context ctx, BOSUuid solutionPeriodID, EvalWorkFlowCollection evalWorkFlowCollection) throws BOSException, EASBizException {
        HashSet<ProcessInstInfo> unDeleteSet = new HashSet<ProcessInstInfo>();
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        int n = evalWorkFlowCollection.size();
        for (int i = 0; i < n; ++i) {
            ProcessInstInfo[] processInstInfo = enactmentService.getProcessInstancesByProcDefId(evalWorkFlowCollection.get(i).getWorkFlowID().toString());
            if (processInstInfo == null) continue;
            int m = processInstInfo.length;
            for (int k = 0; k < m; ++k) {
                unDeleteSet.add(processInstInfo[k]);
            }
        }
        return unDeleteSet.size();
    }

    private HashMap getResultObjectInstMap(Context ctx, BOSUuid solutionPeriodID) throws BOSException, EvalWorkFlowFacadeException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID.toString());
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("solutionPeriod2.id", (Object)solutionPeriodID.toString());
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "SolutionPeriodToResultObjectInstQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        HashMap<String, ResultObjectInstInfo> instToResultObjectMap = new HashMap<String, ResultObjectInstInfo>();
        if (rowSet.size() != 0) {
            try {
                while (rowSet.next()) {
                    if (rowSet.getString("procInstID") == null || rowSet.getString("procInstID").trim().length() <= 0) continue;
                    ResultObjectInstInfo info = new ResultObjectInstInfo();
                    info.setEvaluResultID(rowSet.getString("evaluResult.id"));
                    info.setWfObjectID(rowSet.getString("id"));
                    info.setProcInstID(rowSet.getString("procInstID"));
                    instToResultObjectMap.put(rowSet.getString("procInstID"), info);
                }
            }
            catch (UuidException e) {
                throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.DELETENODEPROCESSER_ERROR, e);
            }
            catch (SQLException e) {
                throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.DELETENODEPROCESSER_ERROR, e);
            }
        }
        return instToResultObjectMap;
    }

    @Override
    protected void _stopProcess(Context ctx, String workflowid) throws BOSException {
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        ProcessInstInfo[] processInstInfo = enactmentService.getProcessInstancesByProcDefId(workflowid);
        int n = processInstInfo.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (processInstInfo[i].getState().startsWith(WfState.CLOSED.getValue())) continue;
                enactmentService.terminateProcessInst(processInstInfo[i].getProcInstId());
                continue;
            }
            catch (WfException e) {
                // empty catch block
            }
        }
    }

    @Override
    protected HashMap _startProcess(Context ctx, HashMap evalorMap, String workflowid) throws BOSException, EASBizException {
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        HashMap succeser = new HashMap();
        if (evalorMap.size() == 0) {
            return succeser;
        }
        for (Map.Entry entry : evalorMap.entrySet()) {
            EvalorNodeInfo nodeInfo = (EvalorNodeInfo)entry.getValue();
            try {
                ProcessInstInfo procInstInfo = enactmentService.createProcessInstWithPersonID(workflowid, nodeInfo.getEvalorID());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("evaluObjectID", nodeInfo.getEvaluObjectID());
                map.put("evaluObjectName", nodeInfo.getEvaluObjectName());
                map.put("evalor", nodeInfo.getEvalorID());
                map.put("personId", nodeInfo.getEvalorID());
                map.put("billID", this.createNodeProcesserBillId());
                enactmentService.setProcessContext(procInstInfo.getProcInstId(), map);
                enactmentService.startProcessInst(procInstInfo.getProcInstId());
                succeser.put(entry.getKey(), entry.getValue());
            }
            catch (WfException e) {}
        }
        return succeser;
    }

    private String createNodeProcesserBillId() {
        String billId = BOSUuid.create((BOSObjectType)bosType).toString();
        logger.info((Object)("billId = " + billId));
        return billId;
    }

    private String createWf(Context ctx, WfParam wfParam) throws BOSException, EASBizException {
        if (this.locales == null || this.locales.length == 0) {
            this.locales = EvalWorkFlowFacadeControllerBean.getContextLocales(ctx);
        }
        HashMap numberToNodeId = new HashMap();
        ProcessDef procDef = this.fetchWfTemplate(ctx);
        DataFieldDef personId = new DataFieldDef(procDef);
        personId.setDataType((DataType)ExternalType.OBJECT);
        personId.setDataType((DataType)BasicType.PERFORMER);
        personId.setArray(false);
        personId.setSystemDefault(false);
        personId.setName("personId");
        procDef.getDataFields().add("personId", personId);
        procDef.setID(Uuid.create().toString() + procDef.bosType());
        if (this.locales == null || this.locales.length == 0) {
            this.locales = EvalWorkFlowFacadeControllerBean.getContextLocales(ctx);
        }
        int n = this.locales.length;
        for (int i = 0; i < n; ++i) {
            procDef.setName(this.locales[i], wfParam.getName());
        }
        this.setDataFieldValueByName(procDef, "solutionPeriodID", wfParam.getSolutionPeriodID().toString());
        this.setDataFieldValueByName(procDef, "evaluPeriodName", wfParam.getAssessPeriodName());
        this.removeNodesToWfLevels(procDef, wfParam);
        this.addConcurrentNodesToWf(procDef, wfParam, numberToNodeId);
        this.putValueToWfNode(ctx, procDef, wfParam, numberToNodeId);
        this.modifyNodesSpaceBetween(ctx, procDef, wfParam, numberToNodeId);
        procDef.getProcessHeader().setEnableClientStart(false);
        return this.realeaseProcess(ctx, procDef);
    }

    private ProcessDef fetchWfTemplate(Context ctx) throws WfException, EvalWorkFlowFacadeException, WfKpdlParseException {
        WorkFlowDefineService service = new WorkFlowDefineService(ctx);
        WorkFlowProcessInfo wfInfo = service.getTemplateByPackageAndName("com.kingdee.eas.hr", ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"8_EvalWorkFlowFacadeControllerBean", (Locale)new Locale("l2")));
        String xml = wfInfo.getProcessXml();
        if (xml == null) {
            wfInfo = service.getTemplateByPackageAndName("com.kingdee.eas.hr", ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"9_EvalWorkFlowFacadeControllerBean", (Locale)new Locale("l2")));
            xml = wfInfo.getProcessXml();
        }
        if (xml == null) {
            wfInfo = service.getByPackageAndName("com.kingdee.eas.hr", ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"9_EvalWorkFlowFacadeControllerBean", (Locale)new Locale("l2")), ProcessType.NORMAL);
            xml = wfInfo.getProcessXml();
        }
        if (xml == null) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.WORKFLOWTEMPLATE_IS_NULL);
        }
        ProcessDef procDef = KpdlParser.parseKpdl((String)xml);
        return procDef;
    }

    private void modifyNodesSpaceBetween(Context ctx, ProcessDef procDef, WfParam wfParam, HashMap numberToNodeId) throws BOSException, EASBizException {
        int y;
        ActivityDef fromActivityDef = procDef.getActivityDef((String)numberToNodeId.get("1")).getPostActivities().get(0);
        ActivityNode activityNode = this.getDiagramNodeByActivityID(procDef, fromActivityDef.getID());
        int lastLevelNodeSpace = 50;
        int lastLevelX = activityNode.getCoordinate().x + lastLevelNodeSpace;
        int minLen = 90;
        int maxLen = 310;
        do {
            ActivityCollection activityCollection = fromActivityDef.getPostActivities();
            lastLevelNodeSpace = this.countNodeSpace(ctx, activityCollection, minLen, maxLen);
            int n = activityCollection.size();
            for (int i = 0; i < n; ++i) {
                ActivityDef activityDef = activityCollection.get(i);
                activityNode = this.getDiagramNodeByActivityID(procDef, activityDef.getID());
                y = activityNode.getCoordinate().y;
                activityNode.setCoordinate(new Coordinate(lastLevelX + lastLevelNodeSpace, y));
            }
            fromActivityDef = activityCollection.get(0);
            lastLevelX = lastLevelX + lastLevelNodeSpace + lastLevelNodeSpace;
        } while (!(fromActivityDef instanceof EndActivityDef));
        int n = wfParam.getWfLevels();
        for (int i = 2; i <= n; ++i) {
            ActivityDef preRouterActivityDef = this.getActiveNodeByName(procDef, this.ROUTERPREFIX + (i - 1));
            activityNode = this.getDiagramNodeByActivityID(procDef, preRouterActivityDef.getID());
            int preX = activityNode.getCoordinate().x;
            ActivityDef postRouterActivityDef = this.getActiveNodeByName(procDef, this.ROUTERPREFIX + i);
            activityNode = this.getDiagramNodeByActivityID(procDef, postRouterActivityDef.getID());
            int postX = activityNode.getCoordinate().x;
            int betweenLen = postX - preX;
            List list = wfParam.getLevelNodes(i);
            int m = list.size();
            for (int k = 0; k < m; ++k) {
                int nodeLen = this.countStringOutPutLen(((EvaluNodeInfo)list.get(k)).getNodeName(), 6, 5);
                ActivityDef manpowerActivityDef = procDef.getActivityDef((String)numberToNodeId.get("" + ((EvaluNodeInfo)list.get(k)).getSeqNumber()));
                activityNode = this.getDiagramNodeByActivityID(procDef, manpowerActivityDef.getID());
                y = activityNode.getCoordinate().y;
                activityNode.setCoordinate(new Coordinate(preX + (betweenLen - nodeLen) / 2, y));
            }
        }
    }

    private int countNodeSpace(Context ctx, ActivityCollection activityCollection, int min, int max) {
        int len = 0;
        int tempLen = 0;
        int charLen = 8;
        int varcharLen = 12;
        int n = activityCollection.size();
        for (int i = 0; i < n; ++i) {
            tempLen = this.countStringOutPutLen(activityCollection.get(i).getName(ctx.getLocale()), 8, 12, min, max);
            if (tempLen <= len) continue;
            len = tempLen;
        }
        return len / 2;
    }

    private int countStringOutPutLen(String string, int charLen, int varcharLen, int minLen, int maxLen) {
        if (PfServerUtils.objectIsNull(string)) {
            return minLen;
        }
        int returnLen = this.countStringOutPutLen(string, charLen, varcharLen);
        if (returnLen > maxLen) {
            return maxLen;
        }
        if (returnLen < minLen) {
            return minLen;
        }
        return returnLen;
    }

    private int countStringOutPutLen(String string, int charLen, int varcharLen) {
        if (PfServerUtils.objectIsNull(string)) {
            return 0;
        }
        int returnLen = 0;
        int lens = string.length();
        int bytes = string.getBytes().length;
        returnLen = varcharLen * (bytes - lens);
        return returnLen += charLen * (2 * lens - bytes);
    }

    @Override
    protected String _createWf(Context ctx, BOSUuid solutionPeriodID, BOSUuid evaluWorkFlowID) throws BOSException, EASBizException {
        WfParam wfParam = WfParamFacadeFactory.getLocalInstance(ctx).getWfParam(solutionPeriodID, evaluWorkFlowID.toString());
        String workflowid = this.createWf(ctx, wfParam);
        return this.updateWorkFlowID(ctx, evaluWorkFlowID, workflowid);
    }

    private String updateWorkFlowID(Context ctx, BOSUuid evaluWorkFlowID, String workflowid) throws SQLDataException, BOSException {
        String sql = "UPDATE T_PF_EvalWorkFlow SET FWorkFlowID = ? WHERE FID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)workflowid);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluWorkFlowID.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return workflowid;
    }

    private void removeNodesToWfLevels(ProcessDef procDef, WfParam wfParam) throws BOSException, EASBizException {
        int j;
        int n;
        TransitionCollection nodeTransitionCollection;
        ActivityDef toActivityDef;
        ActivityDef fromActivityDef;
        int i;
        String startActivityName = this.ROUTERPREFIX + wfParam.getWfLevels();
        ActivityDef startActivity = this.getActiveNodeByName(procDef, startActivityName);
        ActivityDef endActivity = this.getActiveNodeByName(procDef, this.ROUTERPREFIX + this.DEFAULTLEVELS).getPostActivities().get(0);
        endActivity.getActivityHeader().setRollback(true);
        TransitionCollection transitionCollection = procDef.getTransitions();
        for (i = wfParam.getWfLevels(); i < this.DEFAULTLEVELS; ++i) {
            fromActivityDef = this.getActiveNodeByName(procDef, this.ROUTERPREFIX + i);
            toActivityDef = this.getActiveNodeByName(procDef, this.MANPOWERPREFIX + (i + 1));
            nodeTransitionCollection = procDef.getTransitionsByActivity(fromActivityDef.getID(), toActivityDef.getID());
            n = nodeTransitionCollection.size();
            for (j = 0; j < n; ++j) {
                procDef.destoryLine(nodeTransitionCollection.get(j).getRelatedLine());
            }
        }
        for (i = wfParam.getWfLevels() + 1; i <= this.DEFAULTLEVELS; ++i) {
            fromActivityDef = this.getActiveNodeByName(procDef, this.MANPOWERPREFIX + i);
            toActivityDef = this.getActiveNodeByName(procDef, this.ROUTERPREFIX + i);
            nodeTransitionCollection = procDef.getTransitionsByActivity(fromActivityDef.getID(), toActivityDef.getID());
            n = nodeTransitionCollection.size();
            for (j = 0; j < n; ++j) {
                procDef.destoryLine(nodeTransitionCollection.get(j).getRelatedLine());
            }
        }
        fromActivityDef = this.getActiveNodeByName(procDef, this.ROUTERPREFIX + this.DEFAULTLEVELS);
        toActivityDef = endActivity;
        nodeTransitionCollection = procDef.getTransitionsByActivity(fromActivityDef.getID(), toActivityDef.getID());
        int n2 = nodeTransitionCollection.size();
        for (int j2 = 0; j2 < n2; ++j2) {
            procDef.destoryLine(nodeTransitionCollection.get(j2).getRelatedLine());
        }
        ActivityCollection activityCollection = procDef.getActivitys();
        for (int i2 = wfParam.getWfLevels() + 1; i2 <= this.DEFAULTLEVELS; ++i2) {
            ActivityDef activityDef = this.getActiveNodeByName(procDef, this.ROUTERPREFIX + i2);
            procDef.destoryNode((Node)activityDef.getRelatedNode());
            procDef.destroyActivity(activityDef.getID());
            activityDef = this.getActiveNodeByName(procDef, this.MANPOWERPREFIX + i2);
            procDef.destoryNode((Node)activityDef.getRelatedNode());
            procDef.destroyActivity(activityDef.getID());
        }
        TransitionDef transitionDef = new TransitionDef(procDef);
        transitionDef.setFrom(startActivity);
        transitionDef.setTo(endActivity);
        transitionCollection.add(transitionDef.getID(), transitionDef);
        Line line = new Line(procDef.getDiagram());
        line.setRefTransition(transitionDef);
        line.setFromPort("p3");
        line.setToPort("p4");
        ActivityNode activityNode = this.getDiagramNodeByActivityID(procDef, startActivity.getID());
        int x = activityNode.getCoordinate().x;
        int y = activityNode.getCoordinate().y;
        activityNode = this.getDiagramNodeByActivityID(procDef, endActivity.getID());
        activityNode.setCoordinate(new Coordinate(x + this.xLen, y));
        int count = 1;
        while (!(endActivity instanceof EndActivityDef)) {
            activityCollection = endActivity.getPostActivities();
            startActivity = endActivity;
            endActivity = activityCollection.get(0);
            activityNode = this.getDiagramNodeByActivityID(procDef, endActivity.getID());
            activityNode.setCoordinate(new Coordinate(x + ++count * this.xLen, y));
        }
    }

    private void addConcurrentNodesToWf(ProcessDef procDef, WfParam wfParam, HashMap numberToNodeId) throws BOSException, EASBizException {
        int n = wfParam.getWfLevels();
        for (int i = 1; i <= n; ++i) {
            EvaluNodeInfo nodeInfo;
            ManpowerActivityDef activityDef = (ManpowerActivityDef)this.getActiveNodeByName(procDef, this.MANPOWERPREFIX + i);
            activityDef.getActivityHeader().setRollback(true);
            List list = wfParam.getLevelNodes(i);
            if (list.size() == 1) {
                nodeInfo = (EvaluNodeInfo)list.get(0);
                numberToNodeId.put("" + nodeInfo.getSeqNumber(), activityDef.getID());
                continue;
            }
            int len = list.size();
            for (int j = 1; j < len; ++j) {
                nodeInfo = (EvaluNodeInfo)list.get(j);
                ManpowerActivityDef newActivityDef = this.createNewNode(procDef, activityDef, i, j, len);
                numberToNodeId.put("" + nodeInfo.getSeqNumber(), newActivityDef.getID());
            }
            if (list.size() % 2 == 0) {
                int x = activityDef.getRelatedNode().getCoordinate().x;
                int y = activityDef.getRelatedNode().getCoordinate().y;
                activityDef.getRelatedNode().setCoordinate(new Coordinate(x, y + this.yLen / 2));
            }
            nodeInfo = (EvaluNodeInfo)list.get(0);
            numberToNodeId.put("" + nodeInfo.getSeqNumber(), activityDef.getID());
            this.setRouterToAll(activityDef);
        }
    }

    private void putValueToWfNode(Context ctx, ProcessDef procDef, WfParam wfParam, HashMap numberToNodeId) throws BOSException, EASBizException {
        EvaluNodeCollection evaluNodeCollection = wfParam.getNodeCollection();
        if (this.locales == null || this.locales.length == 0) {
            this.locales = EvalWorkFlowFacadeControllerBean.getContextLocales(ctx);
        }
        int n = evaluNodeCollection.size();
        for (int i = 0; i < n; ++i) {
            EvaluNodeInfo nodeInfo = evaluNodeCollection.get(i);
            ManpowerActivityDef activityDef = (ManpowerActivityDef)procDef.getActivityDef((String)numberToNodeId.get("" + nodeInfo.getSeqNumber()));
            AssignmentMessage message = activityDef.getMessage();
            if (message != null) {
                message.setSendMail(nodeInfo.isCanEmail());
            }
            int m = this.locales.length;
            for (int k = 0; k < m; ++k) {
                activityDef.setName(this.locales[k], nodeInfo.getNodeName());
            }
            ParticipantCollection participantCollection = activityDef.getParticipants();
            DataFieldDef dataFieldDef = this.createNewDataField(procDef, "nodeId" + nodeInfo.getSeqNumber(), "" + nodeInfo.getSeqNumber());
            ActualParameterCollection actualCollection = activityDef.getActualParameters();
            ActualParameterDef actualParameterDef = new ActualParameterDef((IExecuteObject)activityDef);
            ActualParameterDef oldActualParameterDef = this.getActualParameterByIndex(activityDef, 1);
            if (oldActualParameterDef != null) {
                actualCollection.remove(oldActualParameterDef);
            }
            actualParameterDef.setIndex(1);
            actualParameterDef.setActualParameterType(ActualParameterType.DEFAULT);
            actualParameterDef.setExpr(dataFieldDef.getID());
            actualCollection.addObject(1, (Object)actualParameterDef);
            ParticipantDef tempParticipant = new ParticipantDef((ActivityDef)activityDef);
            if (ParticipatorTypeEnum.PERSON.equals((Object)nodeInfo.getParticipatorType())) {
                tempParticipant.setParticipantType(ParticipantType.HUMAN);
                tempParticipant.setParticipantValue(nodeInfo.getParticipatorID().toString());
                tempParticipant.setName(nodeInfo.getNodeName());
                OrgTypeDef tempOrgTypeDef = new OrgTypeDef();
                tempOrgTypeDef.setOrgTypeID(nodeInfo.getParticipatorID().toString());
                tempParticipant.setOrgType(tempOrgTypeDef);
            } else if (ParticipatorTypeEnum.POSITION.equals((Object)nodeInfo.getParticipatorType())) {
                tempParticipant.setParticipantType(ParticipantType.POSITION);
                tempParticipant.setParticipantValue(nodeInfo.getParticipatorID().toString());
                tempParticipant.setName(nodeInfo.getNodeName());
            } else if (ParticipatorTypeEnum.ORGUNIT.equals((Object)nodeInfo.getParticipatorType())) {
                if (SelectedOrgTypeEnum.DIRECTLY_UNDER_PERSON.equals((Object)nodeInfo.getSelectedOrgType())) {
                    tempParticipant.setParticipantType(ParticipantType.ORGANIZATIONAL_UNIT_MEMBER);
                } else {
                    tempParticipant.setParticipantType(ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL);
                }
                tempParticipant.setName(nodeInfo.getNodeName());
                tempParticipant.setParticipantValue(nodeInfo.getParticipatorID().toString());
            } else {
                tempParticipant.setParticipantType(ParticipantType.RELATION);
                tempParticipant.setHierarchyId(wfParam.getHierarchyID());
                if (nodeInfo.getNodeLevel() == 1) {
                    tempParticipant.setReferenceHumanType(ReferenceHumanType.PROCESS_VARIABLE);
                    tempParticipant.setReferenceHumanId(procDef.getDataFieldDef("personId").getID());
                    if (RelationTypeEnum.SUBORDINATE.equals((Object)nodeInfo.getRelationType())) {
                        tempParticipant.setRelationType(RelationType.SUBORDINATOR);
                    } else if (RelationTypeEnum.SUPERIOR.equals((Object)nodeInfo.getRelationType())) {
                        tempParticipant.setRelationType(RelationType.PRIMARY_POSITION_SUPERVISOR);
                    } else if (RelationTypeEnum.INDIRECTSUPERVISOR.equals((Object)nodeInfo.getRelationType())) {
                        tempParticipant.setRelationType(RelationType.INDIRECTSUPERVISOR);
                    } else if (RelationTypeEnum.HOMOLEVEL.equals((Object)nodeInfo.getRelationType())) {
                        if (FellowTypeEnum.SAMESUPERIOR_ALLPOSITION.equals((Object)wfParam.getFellowType())) {
                            tempParticipant.setRelationType(RelationType.SAMELEVEL_ALLPOSITION);
                        } else if (FellowTypeEnum.SAMESUPERIOR_OTHERPOSITION.equals((Object)wfParam.getFellowType())) {
                            tempParticipant.setRelationType(RelationType.SAMELEVEL_OTHERPOSITION);
                        } else if (FellowTypeEnum.SAMEPOSITION_OTHERPERSON.equals((Object)wfParam.getFellowType())) {
                            tempParticipant.setRelationType(RelationType.FELLOW);
                        } else if (FellowTypeEnum.SAMEJOBLEVEL.equals((Object)wfParam.getFellowType())) {
                            tempParticipant.setRelationType(RelationType.SAME_JOB_GRADE);
                        } else {
                            tempParticipant.setRelationType(RelationType.FELLOW);
                        }
                    } else {
                        tempParticipant.setRelationType(RelationType.SELF);
                    }
                } else {
                    tempParticipant.setReferenceHumanType(ReferenceHumanType.ACTIVITY_PERFORMER);
                    if (nodeInfo.getRefNode() == -1) {
                        tempParticipant.setReferenceHumanType(ReferenceHumanType.PROCESS_VARIABLE);
                        tempParticipant.setReferenceHumanId(procDef.getDataFieldDef("personId").getID());
                    }
                    if (RelationTypeEnum.SUBORDINATE.equals((Object)nodeInfo.getRelationType())) {
                        tempParticipant.setRelationType(RelationType.SUBORDINATOR);
                    } else if (RelationTypeEnum.SUPERIOR.equals((Object)nodeInfo.getRelationType())) {
                        tempParticipant.setRelationType(RelationType.PRIMARY_POSITION_SUPERVISOR);
                    } else if (RelationTypeEnum.INDIRECTSUPERVISOR.equals((Object)nodeInfo.getRelationType())) {
                        tempParticipant.setRelationType(RelationType.INDIRECTSUPERVISOR);
                    } else if (RelationTypeEnum.HOMOLEVEL.equals((Object)nodeInfo.getRelationType())) {
                        if (FellowTypeEnum.SAMESUPERIOR_ALLPOSITION.equals((Object)wfParam.getFellowType())) {
                            tempParticipant.setRelationType(RelationType.SAMELEVEL_ALLPOSITION);
                        } else if (FellowTypeEnum.SAMESUPERIOR_OTHERPOSITION.equals((Object)wfParam.getFellowType())) {
                            tempParticipant.setRelationType(RelationType.SAMELEVEL_OTHERPOSITION);
                        } else if (FellowTypeEnum.SAMEPOSITION_OTHERPERSON.equals((Object)wfParam.getFellowType())) {
                            tempParticipant.setRelationType(RelationType.FELLOW);
                        } else if (FellowTypeEnum.SAMEJOBLEVEL.equals((Object)wfParam.getFellowType())) {
                            tempParticipant.setRelationType(RelationType.SAME_JOB_GRADE);
                        } else {
                            tempParticipant.setRelationType(RelationType.FELLOW);
                        }
                    } else {
                        tempParticipant.setRelationType(RelationType.SELF);
                        tempParticipant.setReferenceHumanType(ReferenceHumanType.PROCESS_VARIABLE);
                        tempParticipant.setReferenceHumanId(procDef.getDataFieldDef("personId").getID());
                    }
                    if (nodeInfo.getRefNode() > 0) {
                        tempParticipant.setReferenceHumanId((String)numberToNodeId.get("" + nodeInfo.getRefNode()));
                    }
                }
            }
            participantCollection.add(tempParticipant.getID(), tempParticipant);
        }
    }

    private ManpowerActivityDef createNewNode(ProcessDef procDef, ManpowerActivityDef activityDef, int level, int concurrent, int len) throws BOSException, EASBizException {
        ManpowerActivityDef newActivity = this.copyActivityNode(procDef, activityDef);
        newActivity.setName(this.l2, this.MANPOWERPREFIX + level + concurrent);
        newActivity.getActivityHeader().setRollback(true);
        ActivityDef preActivityDef = activityDef.getPreviousActivities().get(0);
        ActivityDef postActivityDef = activityDef.getPostActivities().get(0);
        TransitionDef transitionDef = new TransitionDef(procDef);
        transitionDef.setFrom(preActivityDef);
        transitionDef.setTo((ActivityDef)newActivity);
        procDef.getTransitions().add(transitionDef.getID(), transitionDef);
        Line line = new Line(procDef.getDiagram());
        line.setRefTransition(transitionDef);
        line.setFromPort("p3");
        line.setToPort("p4");
        transitionDef = new TransitionDef(procDef);
        transitionDef.setFrom((ActivityDef)newActivity);
        transitionDef.setTo(postActivityDef);
        procDef.getTransitions().set(transitionDef.getID(), transitionDef);
        line = new Line(procDef.getDiagram());
        line.setRefTransition(transitionDef);
        line.setFromPort("p3");
        line.setToPort("p4");
        boolean isOddNumber = len % 2 == 1;
        ActivityNode activityNode = activityDef.getRelatedNode();
        int x = activityNode.getCoordinate().x;
        int y = activityNode.getCoordinate().y;
        if (isOddNumber) {
            boolean flag;
            boolean bl = flag = concurrent <= len / 2;
            y = flag ? (y -= concurrent * this.yLen) : (y += (len - concurrent) * this.yLen);
        } else {
            boolean flag;
            boolean bl = flag = concurrent <= len / 2;
            y = flag ? (y -= (int)(((double)concurrent - 0.5) * (double)this.yLen)) : (y += (int)(((double)(len - concurrent) + 0.5) * (double)this.yLen));
        }
        newActivity.getRelatedNode().setCoordinate(new Coordinate(x, y));
        return newActivity;
    }

    private ManpowerActivityDef copyActivityNode(ProcessDef procDef, ManpowerActivityDef activityDef) throws BOSException, EASBizException {
        ManpowerActivityDef newActivity = new ManpowerActivityDef(procDef, activityDef.toElement());
        newActivity.setID(Uuid.create().toString() + newActivity.bosType());
        ApplicationDef applicationDef = new ApplicationDef(procDef, activityDef.getRelatedApplication().toElement());
        applicationDef.setID(Uuid.create().toString() + applicationDef.bosType());
        newActivity.setRelatedApplication(applicationDef);
        procDef.getApplications().set(applicationDef.getID(), applicationDef);
        int n = newActivity.getActualParameters().size();
        for (int i = 0; i < n; ++i) {
            newActivity.getActualParameters().remove(this.getActualParameterByIndex(newActivity, i));
        }
        String[] datafieldStr = new String[]{"billID", "nodeId1", "solutionPeriodID", "evaluObjectID", "evalor", "billIDoutPut"};
        int n2 = datafieldStr.length;
        for (int i = 0; i < n2; ++i) {
            DataFieldDef dataFieldDef = this.getDataFieldByName(procDef, datafieldStr[i]);
            ActualParameterDef actualParameterDef = new ActualParameterDef((IExecuteObject)newActivity);
            actualParameterDef.setIndex(i);
            actualParameterDef.setActualParameterType(ActualParameterType.DEFAULT);
            actualParameterDef.setExpr(dataFieldDef.getID());
            newActivity.getActualParameters().addObject(i, (Object)actualParameterDef);
        }
        ActivityNode activityNode = new ActivityNode(procDef.getDiagram());
        activityNode.setRefActivity((ActivityDef)newActivity);
        return newActivity;
    }

    private DataFieldDef createNewDataField(ProcessDef procDef, String name, String initValue) {
        DataFieldDef _datafieldDef = this.getDataFieldByName(procDef, name);
        if (_datafieldDef != null) {
            _datafieldDef.setInitValue(initValue);
            return _datafieldDef;
        }
        _datafieldDef = new DataFieldDef(procDef);
        _datafieldDef.setName(name);
        _datafieldDef.setDataType((DataType)BasicType.STRING);
        _datafieldDef.setInitValue(initValue);
        _datafieldDef.setSystemDefault(false);
        procDef.getDataFields().add(_datafieldDef.getID(), _datafieldDef);
        return _datafieldDef;
    }

    private void setDataFieldValueByName(ProcessDef procDef, String name, String initValue) {
        DataFieldDef dataFieldDef = this.getDataFieldByName(procDef, name);
        dataFieldDef.setInitValue(initValue);
    }

    private ActivityDef getActiveNodeByName(ProcessDef procDef, String name) {
        if (name == null) {
            return null;
        }
        ActivityCollection col = procDef.getActivitys();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            if (!name.equals(col.get(i).getName(this.l2))) continue;
            return col.get(i);
        }
        return null;
    }

    private ActivityNode getDiagramNodeByActivityID(ProcessDef procDef, String activityId) {
        NodeCollection nodeCollection = procDef.getDiagram().getNodes();
        int n = nodeCollection.size();
        for (int i = 0; i < n; ++i) {
            ActivityNode activityNode = (ActivityNode)nodeCollection.get(i);
            if (!activityNode.getRefActivity().getID().equals(activityId)) continue;
            return activityNode;
        }
        return null;
    }

    private ActualParameterDef getActualParameterByIndex(ManpowerActivityDef activityDef, int index) {
        ActualParameterCollection actualCollection = activityDef.getActualParameters();
        int n = actualCollection.size();
        for (int i = 0; i < n; ++i) {
            ActualParameterDef actualParameterDef = actualCollection.get(i);
            if (actualParameterDef.getIndex() != index) continue;
            return actualParameterDef;
        }
        return null;
    }

    private void setRouterToAll(ManpowerActivityDef activityDef) throws BOSException, EASBizException {
        ActivityDef routerActivityDef = activityDef.getPostActivities().get(0);
        routerActivityDef.getActivityHeader().setJoinType(JoinType.AND);
        routerActivityDef.getActivityHeader().setRollback(true);
        routerActivityDef = activityDef.getPreviousActivities().get(0);
        routerActivityDef.getActivityHeader().setJoinType(JoinType.AND);
        routerActivityDef.getActivityHeader().setSplitType(SplitType.AND);
        routerActivityDef.getActivityHeader().setRollback(true);
    }

    private DataFieldDef getDataFieldByName(ProcessDef procDef, String name) {
        if (name == null) {
            return null;
        }
        DataFieldCollection collection = procDef.getDataFields();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            if (!name.equals(collection.get(i).getName())) continue;
            return collection.get(i);
        }
        return null;
    }

    @Override
    protected void _restartProcess(Context ctx, String solutionPeriodID, String evaluObjectID) throws BOSException, EASBizException {
        if (PfServerUtils.objectIsNull(solutionPeriodID) || PfServerUtils.objectIsNull(evaluObjectID)) {
            return;
        }
        this.checkIsDirectMode(ctx, solutionPeriodID);
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(evaluObjectID);
        EvalWFObjectsCollection collection = this.getEvalWFObjects(ctx, solutionPeriodID, idSet);
        if (collection != null && collection.size() > 0) {
            IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            String message = this.getLogInfo(ctx, collection.get(0), iAdminOrgUnit, iPerson);
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)EvalWFObjectsFactory.getLocalInstance(ctx).getType(), null, (String)message, (String)"perf_TargetEvalWFTrack_reset");
            this.startWorkFlow(ctx, solutionPeriodID, collection.get(0));
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
    }

    private String getLogInfo(Context ctx, EvalWFObjectsInfo evalWFObjectsInfo, IAdminOrgUnit iAdminOrgUnit, IPerson iPerson) throws BOSException, EASBizException {
        StringBuffer retValue = new StringBuffer();
        if (evalWFObjectsInfo.getEvaluObject() != null && evalWFObjectsInfo.getEvaluObject().getObjectID() != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)evalWFObjectsInfo.getEvaluObject().getEvaluObjectType())) {
                selector.add(new SelectorItemInfo("name"));
                AdminOrgUnitInfo info = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(evalWFObjectsInfo.getEvaluObject().getObjectID()), selector);
                retValue.append(info.getName());
            } else {
                selector.add(new SelectorItemInfo("name"));
                PersonInfo info = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(evalWFObjectsInfo.getEvaluObject().getObjectID()), selector);
                retValue.append(info.getName());
            }
        }
        retValue.append("  ");
        retValue.append(evalWFObjectsInfo.getEvalWorkFlow().getSolutionPeriod().getName());
        return retValue.toString();
    }

    @Override
    protected void _batchStartProcess(Context ctx, String solutionPeriodId, Set evaluObjectIdSet) throws BOSException, EASBizException {
        if (solutionPeriodId == null || evaluObjectIdSet == null || evaluObjectIdSet.size() == 0) {
            return;
        }
        this.checkIsDirectMode(ctx, solutionPeriodId);
        Set idSet = null;
        idSet = EvaluSolutionFacadeFactory.getLocalInstance(ctx).getEvaluableObject(solutionPeriodId, evaluObjectIdSet);
        if (idSet == null || idSet.size() == 0) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.NO_FLOW_CAN_START);
        }
        EvalWFObjectsCollection coll = this.getEvalWFObjects(ctx, solutionPeriodId, idSet);
        if (coll == null || coll.size() == 0) {
            return;
        }
        EvalWFObjectsInfo evalWFObjectsInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            evalWFObjectsInfo = coll.get(i);
            this.startWorkFlow(ctx, solutionPeriodId, evalWFObjectsInfo);
        }
    }

    private void checkIsDirectMode(Context ctx, String solutionPeriodId) throws BOSException, EASBizException, EvalWorkFlowFacadeException {
        SolutionPeriodInfo spInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluSolution.deliverMode"));
        spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId), sic);
        if (DeliverModeEnum.DIRECT_ENTER.equals((Object)spInfo.getEvaluSolution().getDeliverMode())) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.DIRECTENTER_NOT_START);
        }
    }

    private EvalWFObjectsCollection getEvalWFObjects(Context ctx, String solutionPeriodId, Set idSet) throws BOSException {
        if (idSet == null || idSet.size() == 0) {
            return new EvalWFObjectsCollection();
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("procInstID"));
        sic.add(new SelectorItemInfo("evalWorkFlow.id"));
        sic.add(new SelectorItemInfo("evalWorkFlow.workFlowID"));
        sic.add(new SelectorItemInfo("evalWorkFlow.solutionPeriod.evaluSolution.deliverMode"));
        sic.add(new SelectorItemInfo("evalWorkFlow.solutionPeriod.name"));
        sic.add(new SelectorItemInfo("evaluObject.id"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        sic.add(new SelectorItemInfo("evaluObject.evaluObjectType"));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        sic.add(new SelectorItemInfo("evaluObject.responser.id"));
        evi.setSelector(sic);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)idSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodId));
        evi.setFilter(fi);
        EvalWFObjectsCollection coll = EvalWFObjectsFactory.getLocalInstance(ctx).getEvalWFObjectsCollection(evi);
        return coll;
    }

    private void startWorkFlow(Context ctx, String solutionPeriodId, EvalWFObjectsInfo evalWFObjectsInfo) throws BOSException, WfParamException, EvalWorkFlowFacadeException, EASBizException, SQLDataException {
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        String workflowID = null;
        String evalWorkFlowID = null;
        String procInstID = null;
        EvaluObjectInfo evaluObjectInfo = null;
        String initiator = null;
        String evaluObjectName = null;
        String personID = null;
        ProcessInstInfo procInst = null;
        String evaluObjectID = null;
        String evaluResultID = null;
        workflowID = evalWFObjectsInfo.getEvalWorkFlow().getWorkFlowID().toString();
        evalWorkFlowID = evalWFObjectsInfo.getEvalWorkFlow().getId().toString();
        procInstID = evalWFObjectsInfo.getProcInstID();
        evaluObjectInfo = evalWFObjectsInfo.getEvaluObject();
        evaluObjectID = evaluObjectInfo.getId().toString();
        personID = evaluObjectInfo.getObjectID();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("solutionPeriod.name"));
        String solutionPeriodName = null;
        EvaluResultCollection evaluResultCollection = EvaluResultFactory.getLocalInstance(ctx).getEvaluResultCollection(evi);
        if (evaluResultCollection.size() <= 0) {
            throw new WfParamException(WfParamException.NOEVALURESULT);
        }
        evaluResultID = evaluResultCollection.get(0).getId().toString();
        solutionPeriodName = evaluResultCollection.get(0).getSolutionPeriod().getName();
        initiator = EvaluObjectTypeEnum.ORGUNIT.equals((Object)evaluObjectInfo.getEvaluObjectType()) ? evaluObjectInfo.getResponser().getId().toString() : evaluObjectInfo.getObjectID();
        evaluObjectName = evaluObjectInfo.getName();
        if (!StringUtils.isEmpty((String)procInstID)) {
            try {
                procInst = enactmentService.getProcessInstInfo(procInstID);
            }
            catch (Exception e) {
                logger.error((Object)("procInstID: " + procInstID));
                logger.error((Object)e);
            }
            try {
                if (procInst != null && !procInst.getState().startsWith(WfState.CLOSED.getValue())) {
                    enactmentService.terminateProcessInst(procInst.getProcInstId());
                }
            }
            catch (Exception e2) {
                logger.error((Object)("procInstID: " + procInstID));
                logger.error((Object)("procInst: " + procInst));
                logger.error((Object)e2);
                throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.START_FLOW_FAILD);
            }
        }
        EvalorNodeInfo nodeInfo = new EvalorNodeInfo();
        nodeInfo.setEvaluObjectID(evaluObjectInfo.getId().toString());
        nodeInfo.setEvaluObjectName(evaluObjectName);
        nodeInfo.setEvalorID(initiator);
        ProcessInstInfo processInstInfo = null;
        try {
            enactmentService = new EnactmentServiceProxy(ctx);
            String[] userIds = this.getUsersByPerson(ctx, nodeInfo.getEvalorID());
            if (userIds != null && userIds.length > 0) {
                nodeInfo.setUserID(userIds[0]);
                processInstInfo = enactmentService.createProcessInstWithPersonID(workflowID, nodeInfo.getEvalorID());
            } else {
                processInstInfo = enactmentService.createProcessInstWithPersonID(workflowID, ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString());
            }
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("evaluObjectID", nodeInfo.getEvaluObjectID());
            map2.put("evaluObjectName", nodeInfo.getEvaluObjectName());
            map2.put("evalor", nodeInfo.getEvalorID());
            if (solutionPeriodName != null) {
                map2.put("evaluPeriodName", solutionPeriodName);
            }
            Person wfPersonInfo = new Person();
            wfPersonInfo.setEmployeeId(nodeInfo.getEvalorID());
            wfPersonInfo.setUserId(nodeInfo.getUserID());
            wfPersonInfo.setEmployeeName(this.l2, nodeInfo.getEvaluObjectName());
            map2.put("personId", (String)wfPersonInfo);
            map2.put("billID", this.createNodeProcesserBillId());
            enactmentService.setProcessContext(processInstInfo.getProcInstId(), map2);
            enactmentService.startProcessInst(processInstInfo.getProcInstId());
        }
        catch (WfException e) {
            logger.error((Object)e);
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.START_FLOW_FAILD);
        }
        FilterItemInfo filterItem = null;
        fi = new FilterInfo();
        filterItem = new FilterItemInfo("evaluResult.id", (Object)evaluResultID);
        fi.getFilterItems().add(filterItem);
        NodeProcesserFactory.getLocalInstance(ctx).delete(fi);
        fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
        IEvaluResult evaluResult = EvaluResultFactory.getLocalInstance(ctx);
        evaluResult.delete(fi);
        EvaluResultInfo resultInfo = new EvaluResultInfo();
        SolutionPeriodInfo solutionPeriodInfo = new SolutionPeriodInfo();
        solutionPeriodInfo.setId(BOSUuid.read((String)solutionPeriodId));
        evaluObjectInfo = new EvaluObjectInfo();
        evaluObjectInfo.setId(BOSUuid.read((String)evaluObjectID));
        resultInfo.setSolutionPeriod(solutionPeriodInfo);
        resultInfo.setEvaluObject(evaluObjectInfo);
        resultInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        resultInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        resultInfo.setIsApproved(false);
        resultInfo.setIsReferenced(false);
        resultInfo.setIsModified(false);
        evi = new EntityViewInfo();
        fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        evi.setFilter(fi);
        PersonPositionCollection ppcoll = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(evi);
        if (ppcoll != null && ppcoll.size() > 0) {
            PersonPositionInfo pInfo = ppcoll.get(0);
            resultInfo.setPosition(pInfo.getPrimaryPosition());
            resultInfo.setAdminOrgUnit(pInfo.getPersonDep());
            resultInfo.setJobGrade(pInfo.getJobGrade());
        }
        evaluResult.submit((CoreBaseInfo)resultInfo);
        String sql = "UPDATE T_PF_EvalWFObjects SET FStatus = ? ,FProcInstID = ? WHERE FEvalWorkFlowID = ? AND  FEvaluObjectID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 20);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)processInstInfo.getProcInstId());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)evalWorkFlowID);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)evaluObjectID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.START_FLOW_FAILD);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected String _getAssignmentID(Context ctx, String solutionPeriodID, String evaluObjectID) throws BOSException, EASBizException {
        if (solutionPeriodID == null || evaluObjectID == null) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
        filterInfo.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("procInstID"));
        EvalWFObjectsCollection collection = EvalWFObjectsFactory.getLocalInstance(ctx).getEvalWFObjectsCollection(viewInfo);
        String procInstID = null;
        if (collection == null || collection.size() == 0) {
            return null;
        }
        procInstID = collection.get(0).getProcInstID();
        if (procInstID == null) {
            return null;
        }
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        AssignmentInfo[] assignmentInfos = enactmentService.getAssignmentAllByProcInstId(procInstID);
        int n = assignmentInfos.length;
        for (int i = 0; i < n; ++i) {
            if (!WfAssignmentState.ASSIGNED.equals((Object)assignmentInfos[i].getState()) && !WfAssignmentState.ACCEPTED.equals((Object)assignmentInfos[i].getState())) continue;
            return assignmentInfos[i].getAssignmentId();
        }
        if (assignmentInfos.length == 0) {
            return null;
        }
        return assignmentInfos[0].getAssignmentId();
    }

    @Override
    protected void _sendMessage(Context ctx, HashMap pmMap) throws BOSException, EASBizException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = EvalWorkFlowFacadeControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        for (Map.Entry entry : pmMap.entrySet()) {
            String personId = entry.getKey().toString();
            MessageString messageString = (MessageString)entry.getValue();
            String[] userIds = this.getUsersByPerson(ctx, personId);
            if (PfServerUtils.objectIsNull(userIds)) continue;
            Message message = MessageFactory.newMessage((String)"kingdee.workflow");
            for (Locale locale2 : lcla) {
                message.setLocaleStringHeader("title", messageString.getTitle(), locale2);
                message.setLocaleStringHeader("sender", messageString.getSender(), locale2);
                message.setLocaleStringHeader("body", messageString.getTitle(), locale2);
            }
            message.setIntHeader("type", 0);
            message.setIntHeader("bizType", 0);
            message.setIntHeader("sourceStatus", 0);
            message.setIntHeader("priority", 10);
            message.setStringHeader("databaseCenter", ctx.getAIS());
            message.setStringHeader("solution", ctx.getSolution());
            int n = userIds.length;
            for (int i = 0; i < n; ++i) {
                if (PfServerUtils.objectIsNull(userIds[i])) continue;
                message.setStringHeader("receiver", userIds[i]);
                senderAgent.sendMessage(message);
            }
        }
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    private String[] getUsersByPerson(Context ctx, String personId) throws BOSException, EASBizException {
        String[] userIDs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_pm_user where fpersonid = '");
        sql.append(personId);
        sql.append("' and fIsLocked = 0 and fForbidden = 0 and fIsDelete = 0 and fInvalidationDate >= NOW()");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet == null) {
                return userIDs;
            }
            rowSet.beforeFirst();
            userIDs = new String[rowSet.size()];
            int flag = 0;
            while (rowSet.next()) {
                userIDs[flag] = rowSet.getString("fid");
                ++flag;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return userIDs;
    }

    @Override
    protected String[] _getPersonIdsFromInst(Context ctx, String solutionPeriodID, String evaluObjectID) throws BOSException, EASBizException {
        if (solutionPeriodID == null || evaluObjectID == null) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
        filterInfo.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("procInstID"));
        EvalWFObjectsCollection collection = EvalWFObjectsFactory.getLocalInstance(ctx).getEvalWFObjectsCollection(viewInfo);
        String procInstID = null;
        if (collection == null || collection.size() == 0) {
            return null;
        }
        procInstID = collection.get(0).getProcInstID();
        if (procInstID == null) {
            throw new WfParamException(WfParamException.NOACCORDINGWORFLOW);
        }
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        AssignmentInfo[] assignmentInfos = enactmentService.getAssignmentByProcInstId(procInstID);
        HashMap<String, String> personMap = new HashMap<String, String>();
        int n = assignmentInfos.length;
        for (int i = 0; i < n; ++i) {
            if (!WfAssignmentState.ASSIGNED.equals((Object)assignmentInfos[i].getState()) && !WfAssignmentState.ACCEPTED.equals((Object)assignmentInfos[i].getState())) continue;
            personMap.put(assignmentInfos[i].getEmployeeId(), assignmentInfos[i].getEmployeeId());
        }
        String[] personIds = new String[personMap.size()];
        Iterator iterator = personMap.entrySet().iterator();
        int l = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            personIds[l] = (String)entry.getValue();
            ++l;
        }
        return personIds;
    }

    @Override
    protected IObjectValue _getNodeProcesserRankInfo(Context ctx, String solutionPeriodID, String evaluObjectID) throws BOSException, EASBizException {
        WfParam wfParam = new WfParam();
        BOSUuid evalworkflowId = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("evaluObject.id", (Object)evaluObjectID);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0 AND #1");
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvalWorkFlowQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        if (rowSet.size() != 0) {
            try {
                rowSet.next();
                evalworkflowId = BOSUuid.read((String)rowSet.getString("id"));
            }
            catch (UuidException e) {
                throw new WfParamException(WfParamException.EVALUWORKFLOWFAILED, e);
            }
            catch (SQLException e) {
                throw new WfParamException(WfParamException.EVALUWORKFLOWFAILED, e);
            }
        } else {
            return null;
        }
        EvalWorkFlowInfo wfInfo = EvalWorkFlowFactory.getLocalInstance(ctx).getEvalWorkFlowInfo((IObjectPK)new ObjectUuidPK(evalworkflowId));
        wfParam.setNodeCollection(wfInfo.getEvaluNodes());
        viewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        filterItem = new FilterItemInfo("evaluObject.id", (Object)evaluObjectID);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0 AND #1");
        viewInfo.setFilter(filter);
        EvaluResultCollection evaluResultCollection = EvaluResultFactory.getLocalInstance(ctx).getEvaluResultCollection(viewInfo);
        if (evaluResultCollection.size() <= 0) {
            return null;
        }
        String evaluResultID = evaluResultCollection.get(0).getId().toString();
        viewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        filterItem = new FilterItemInfo("evaluResult.id", (Object)evaluResultID);
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNode.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("rank.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("rank.name"));
        NodeProcesserCollection nodeProcesserCollection = NodeProcesserFactory.getLocalInstance(ctx).getNodeProcesserCollection(viewInfo);
        wfParam.setNodeProcesserCollection(nodeProcesserCollection);
        for (int i = wfInfo.getWfLevels(); i > 0; --i) {
            List list = wfParam.getLevelNodes(i);
            int m = list.size();
            for (int j = 0; j < m; ++j) {
                NodeProcesserInfo nodeProcesserInfo;
                EvaluNodeInfo nodeInfo = (EvaluNodeInfo)list.get(j);
                if (!nodeInfo.isCanEvaluateLevel() || PfServerUtils.objectIsNull(nodeProcesserInfo = wfParam.getNodeProcesserInfoByNodeID(nodeInfo.getId()))) continue;
                return nodeProcesserInfo.getRank();
            }
        }
        return null;
    }

    @Override
    protected int _closeSolutionPeriod(Context ctx, BOSUuid solutionPeriodID) throws BOSException, EASBizException {
        boolean flag = false;
        flag = this.isDirectEnter(ctx, solutionPeriodID);
        EvalWorkFlowCollection evalWorkFlowCollection = this.getEvalWorkFlowCollection(ctx, solutionPeriodID);
        if (!flag) {
            block4: {
                HashMap instToResultObjectMap = this.getResultObjectInstMap(ctx, solutionPeriodID);
                try {
                    int n = evalWorkFlowCollection.size();
                    for (int i = 0; i < n; ++i) {
                        EvalWorkFlowFacadeFactory.getLocalInstance(ctx).terminalProcess(evalWorkFlowCollection.get(i).getWorkFlowID().toString(), instToResultObjectMap);
                    }
                }
                catch (Exception e4) {
                    int unTerminateProcess = this.countUnTerminateProcess(ctx, solutionPeriodID, evalWorkFlowCollection);
                    if (unTerminateProcess <= 0) break block4;
                    Object[] param = new Object[]{new Integer(unTerminateProcess)};
                    throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.TERMINATE_FAILD, param);
                }
            }
            this.setWfObjectStateToClose(ctx, evalWorkFlowCollection);
            SolutionPeriodFactory.getLocalInstance(ctx).finishSolutionPeriod(solutionPeriodID.toString());
            return 0;
        }
        this.setWfObjectStateToClose(ctx, evalWorkFlowCollection);
        SolutionPeriodFactory.getLocalInstance(ctx).finishSolutionPeriod(solutionPeriodID.toString());
        return 0;
    }

    private void setWfObjectStateToClose(Context ctx, EvalWorkFlowCollection evalWorkFlowCollection) throws SQLDataException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_PF_EvalWFObjects SET FStatus = ? WHERE FEvalWorkFlowID = ? ";
        int n = evalWorkFlowCollection.size();
        for (int i = 0; i < n; ++i) {
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, 30);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evalWorkFlowCollection.get(i).getId().toString());
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    private int countUnTerminateProcess(Context ctx, BOSUuid solutionPeriodID, EvalWorkFlowCollection evalWorkFlowCollection) throws BOSException, EASBizException {
        HashSet<ProcessInstInfo> unTerminalSet = new HashSet<ProcessInstInfo>();
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        int n = evalWorkFlowCollection.size();
        for (int i = 0; i < n; ++i) {
            ProcessInstInfo[] processInstInfo = enactmentService.getProcessInstancesByProcDefId(evalWorkFlowCollection.get(i).getWorkFlowID().toString());
            if (processInstInfo == null) continue;
            int m = processInstInfo.length;
            for (int k = 0; k < m; ++k) {
                if (processInstInfo[k].getState().startsWith(WfState.CLOSED.getValue())) continue;
                unTerminalSet.add(processInstInfo[k]);
            }
        }
        return unTerminalSet.size();
    }

    private ActivityInstInfo getActivityInstInfoById(Context ctx, String procInstId, String actInstID) throws BOSException, EASBizException {
        EnactmentServiceProxy workflowClient = new EnactmentServiceProxy(ctx);
        ActivityInstInfo[] activityInstInfos = workflowClient.getActInstMetaArrayByProcInstId(procInstId);
        int n = activityInstInfos.length;
        for (int i = 0; i < n; ++i) {
            if (!actInstID.equals(activityInstInfos[i].getActInstId())) continue;
            return activityInstInfos[i];
        }
        return null;
    }

    @Override
    protected void _reBack(Context ctx, String assignmentID, String reBackTitle, String reBackReason) throws BOSException, EASBizException {
        EnactmentServiceProxy workflowClient = new EnactmentServiceProxy(ctx);
        AssignmentInfo assignmentInfo = workflowClient.getAssignmentById(assignmentID);
        ActivityInstInfo activityInstInfo = this.getActivityInstInfoById(ctx, assignmentInfo.getProcInstId(), assignmentInfo.getActInstId());
        ActivityInstInfo routerActivityInstInfo = null;
        if (!"open.running".equals(activityInstInfo.getState()) && !"open.not_running.not_started".equals(activityInstInfo.getState())) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.REBACK_FAILD);
        }
        String[] activityInstIDs = activityInstInfo.getPreActInstList();
        String proInstID = assignmentInfo.getProcInstId();
        ActivityInstInfo actInfo = workflowClient.getActivityInstByActInstId(activityInstIDs[0]);
        ActivityDef activityDef = workflowClient.getActDefByActInstInfo(actInfo);
        if (activityDef instanceof StartActivityDef) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.FIRSTNODE_CANNOTREBACK);
        }
        if (!(activityDef instanceof RouterActivityDef)) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.REBACK_FAILD);
        }
        routerActivityInstInfo = this.getActivityInstInfoById(ctx, assignmentInfo.getProcInstId(), activityInstIDs[0]);
        activityInstIDs = routerActivityInstInfo.getPreActInstList();
        Map oldMap = workflowClient.getProcessContext(assignmentInfo.getProcInstId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("reBackTitle", reBackTitle);
        map.put("reBackReason", reBackReason);
        map.put("billID", (String)oldMap.get("billIDoutPut"));
        workflowClient.setProcessContext(assignmentInfo.getProcInstId(), map);
        ActivityInstInfo actInfotemp = workflowClient.getActivityInstByActInstId(activityInstIDs[0]);
        if (activityInstIDs.length > 1) {
            String[] activityInstIDsTemp = actInfotemp.getPreActInstList();
            ActivityInstInfo actInfotemp1 = workflowClient.getActivityInstByActInstId(activityInstIDsTemp[0]);
            ActivityDef activityDeftemp = workflowClient.getActDefByActInstInfo(actInfotemp1);
            workflowClient.jump(proInstID, activityDeftemp);
        } else {
            ActivityDef activityDeftemp = workflowClient.getActDefByActInstInfo(actInfotemp);
            workflowClient.jump(proInstID, activityDeftemp);
        }
    }

    @Override
    protected void _reBack2(Context ctx, String assignmentID, String reBackTitle, String reBackReason, String spId, String objId, int nl) throws BOSException, EASBizException {
        this._reBack(ctx, assignmentID, reBackTitle, reBackReason);
        if (nl == 2) {
            TargetScoreComputeFacadeFactory.getLocalInstance(ctx).updateAchieveDataState(spId, objId, false);
        }
        if (nl > 1) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_PF_NodeProcesser set FWorkedState = 10");
            sql.append(" where FId in (");
            sql.append(" select t2.fid");
            sql.append(" from T_PF_EvaluResult t1,T_PF_NodeProcesser t2,T_PF_EvaluNode t3");
            sql.append(" where t1.FSolutionPeriodID = '").append(spId).append("'");
            sql.append(" and t1.FEvaluObjectID= '").append(objId).append("'");
            sql.append(" and t1.FId=t2.FEvaluResultID");
            sql.append(" and t2.FEvaluNodeID=t3.FId");
            sql.append(" and t3.FNodeLevel=").append(nl - 1);
            sql.append(" )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void clearFormulaScore(Context ctx, String spId, String objId) throws SQLDataException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_PF_EvaluDetail set FTargetScore = null, FRankID = null, FCompValue = null where fid in (");
        sql.append("select evaluDetail.fid from T_PF_NodeProcesser nodeProcesser ");
        sql.append("inner join T_PF_EvaluResult evaluResult on nodeProcesser.FEvaluResultID = evaluResult.FID ");
        sql.append("inner join T_PF_EvaluNode evaluNode on nodeProcesser.FEvaluNodeID = evaluNode.FID ");
        sql.append("inner join T_PF_EvaluDetail evaluDetail on nodeProcesser.FID = evaluDetail.FNodeProcesserID ");
        sql.append("inner join T_PF_TargetEvaluStore store on evaluDetail.FTargetEvaluStoreID = store.FID ");
        sql.append("inner join T_PF_EvaluTarget evaluTarget on store.FEvaluTargetID = evaluTarget.FID ");
        sql.append("where evaluResult.FSolutionPeriodID = ? and evaluResult.FEvaluObjectID = ? and evaluNode.FCanGrade = 1 ");
        sql.append("and evaluTarget.FFormulaID is not null)");
        Connection conn = this.getConnection(ctx);
        PreparedStatement prst = null;
        try {
            prst = conn.prepareStatement(sql.toString());
            DbUtil.prepareVarcharParam((PreparedStatement)prst, (int)1, (String)spId);
            DbUtil.prepareVarcharParam((PreparedStatement)prst, (int)2, (String)objId);
            prst.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)prst, (Connection)conn);
        }
    }

    @Override
    protected void _clearReBackReason(Context ctx, String assignmentID) throws BOSException, EASBizException {
        if (assignmentID == null) {
            return;
        }
        EnactmentServiceProxy workflowClient = new EnactmentServiceProxy(ctx);
        AssignmentInfo assignmentInfo = workflowClient.getAssignmentById(assignmentID);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("reBackTitle", "");
        map.put("reBackReason", "");
        workflowClient.setProcessContext(assignmentInfo.getProcInstId(), map);
    }

    @Override
    protected void _copyWorkFlow(Context ctx, String fromSolutionPeriodID, String toSolutionPeriodID) throws BOSException, EASBizException {
        if (fromSolutionPeriodID == null || toSolutionPeriodID == null) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.COPYSOLUTIONPERIODID_NOT_NULL);
        }
        boolean allocateTarget = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("evaluSolution.allocateTarget"));
        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(toSolutionPeriodID), sic);
        allocateTarget = spInfo.getEvaluSolution().getAllocateTarget() == 1;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)toSolutionPeriodID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        filterItem = new FilterItemInfo("solutionPeriod.id", (Object)fromSolutionPeriodID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.nodes.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("concurArgs.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("wfObjects.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("wfObjects.evaluObject.deleted"));
        EvalWorkFlowCollection collection = EvalWorkFlowFactory.getLocalInstance(ctx).getEvalWorkFlowCollection(viewInfo);
        if (collection == null || collection.size() == 0) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.FROMSOLUTIONPERIOD_NO_WORKFLOW);
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            this.copyFlow(ctx, collection.get(i), toSolutionPeriodID, allocateTarget);
        }
    }

    private void copyFlow(Context ctx, EvalWorkFlowInfo info, String toSolutionPeriodID, boolean allocateTarget) throws BOSException, EASBizException {
        int i;
        info.setId(null);
        EvaluNodeCollection nodeCollection = info.getEvaluNodes();
        EvaluNodeInfo evaluNodeInfo = null;
        int n = nodeCollection.size();
        for (int i2 = 0; i2 < n; ++i2) {
            evaluNodeInfo = nodeCollection.get(i2);
            evaluNodeInfo.setId(null);
            evaluNodeInfo.setEvalWorkFlow(null);
            this.setNodeVisibleIdNull(evaluNodeInfo);
        }
        ConcurrenceArgsCollection argsCollection = info.getConcurArgs();
        int n2 = argsCollection.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            argsCollection.get(i3).setId(null);
            argsCollection.get(i3).setEvalWorkFlow(null);
        }
        if (!allocateTarget) {
            EvalWFObjectsCollection wfObjectCollection = info.getWfObjects();
            HashSet<EvalWFObjectsInfo> set = new HashSet<EvalWFObjectsInfo>();
            int n3 = wfObjectCollection.size();
            for (int i4 = 0; i4 < n3; ++i4) {
                if (!wfObjectCollection.get(i4).getEvaluObject().isDeleted()) continue;
                set.add(wfObjectCollection.get(i4));
            }
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                wfObjectCollection.remove((EvalWFObjectsInfo)iter.next());
            }
            n3 = wfObjectCollection.size();
            for (int i5 = 0; i5 < n3; ++i5) {
                wfObjectCollection.get(i5).setId(null);
                wfObjectCollection.get(i5).setEvalWorkFlow(null);
                wfObjectCollection.get(i5).setProcInstID(null);
                wfObjectCollection.get(i5).setStatus(WFStatuEnum.UNUSED);
            }
        } else {
            info.put("wfObjects", null);
        }
        EvalWFObjectsCollection existedWfObjects = this.getEvalWFObjects(ctx, toSolutionPeriodID, null);
        EvalWFObjectsCollection wfObjectCollection = info.getWfObjects();
        EvalWFObjectsCollection tmp = new EvalWFObjectsCollection();
        block5: for (i = 0; i < wfObjectCollection.size(); ++i) {
            for (int j = 0; j < existedWfObjects.size(); ++j) {
                if (wfObjectCollection.get(i) == null || !wfObjectCollection.get(i).getEvaluObject().getId().equals((Object)existedWfObjects.get(j).getEvaluObject().getId())) continue;
                tmp.add(wfObjectCollection.get(i));
                continue block5;
            }
        }
        for (i = 0; i < tmp.size(); ++i) {
            info.getWfObjects().remove(tmp.get(i));
        }
        if (info.getWfObjects().size() == 0) {
            return;
        }
        SolutionPeriodInfo solutionPeriodInfo = new SolutionPeriodInfo();
        solutionPeriodInfo.setId(BOSUuid.read((String)toSolutionPeriodID));
        info.setSolutionPeriod(solutionPeriodInfo);
        this.addNewWorkFlow(ctx, info);
    }

    private void setNodeVisibleIdNull(EvaluNodeInfo evaluNodeInfo) {
        NodeVisibleCollection nodes = evaluNodeInfo.getNodes();
        int size = nodes.size();
        for (int j = 0; j < size; ++j) {
            NodeVisibleInfo nodeVisibleInfo = nodes.get(j);
            nodeVisibleInfo.setId(null);
        }
    }

    @Override
    protected IObjectPK _addNewWorkFlow(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = EvalWorkFlowFactory.getLocalInstance(ctx).addnew((EvalWorkFlowInfo)model);
        this.createWf(ctx, ((EvalWorkFlowInfo)model).getSolutionPeriod().getId(), BOSUuid.read((String)pk.toString()));
        return pk;
    }

    @Override
    protected void _updateWfObjectStateByRevaluResultID(Context ctx, HashSet evaluResultSet, int state) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        block11: {
            block10: {
                if (evaluResultSet == null || evaluResultSet.size() == 0) {
                    throw new WfParamException(EvalWorkFlowFacadeException.EVALURESULT_NOT_NULL);
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                FilterItemInfo filterItem = new FilterItemInfo("evaluResultToWorkFlow.id", (Object)evaluResultSet, CompareType.INCLUDE);
                filter.getFilterItems().add(filterItem);
                viewInfo.setFilter(filter);
                IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvaluResultToWFObjectsQuery"));
                iqec.setObjectView(viewInfo);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
                if (rowSet.size() == 0) break block10;
                conn = null;
                pstmt = null;
                HashMap<Integer, String> evalWfObjectMap = new HashMap<Integer, String>();
                int index = 0;
                StringBuffer sqlBuffer = new StringBuffer();
                sqlBuffer.append("UPDATE T_PF_EvalWFObjects SET FStatus = ? WHERE ");
                try {
                    while (rowSet.next()) {
                        if (index > 0) {
                            sqlBuffer.append(" OR ");
                        }
                        sqlBuffer.append(" FID = ? ");
                        evalWfObjectMap.put(new Integer(index), rowSet.getString("id"));
                        ++index;
                    }
                }
                catch (SQLException e) {
                    throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.EVALWFOBJECT_NOT_NULL);
                }
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sqlBuffer.toString());
                    pstmt.setInt(1, state);
                    Iterator iterator = evalWfObjectMap.entrySet().iterator();
                    index = 2;
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index, (String)entry.getValue().toString());
                        ++index;
                    }
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
                break block11;
            }
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.EVALWFOBJECT_NOT_NULL);
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    public void _createProcessInst(Context ctx, boolean flag, String solutionPeriodId, IObjectCollection evalWorkFlowCollection2, Set evaluObjectIdSet) throws BOSException, EASBizException, SQLDataException {
        block10: {
            EvalWorkFlowCollection evalWorkFlowCollection;
            block9: {
                if (evaluObjectIdSet == null || evaluObjectIdSet.size() <= 0) {
                    return;
                }
                evalWorkFlowCollection = (EvalWorkFlowCollection)evalWorkFlowCollection2;
                EvalWorkFlowInfo flowInfo = null;
                if (flag) break block9;
                IEvalWorkFlowFacade facade = EvalWorkFlowFacadeFactory.getLocalInstance(ctx);
                HashSet objectSet = null;
                int success = 0;
                int n = evalWorkFlowCollection.size();
                for (int i = 0; i < n; ++i) {
                    flowInfo = evalWorkFlowCollection.get(i);
                    objectSet = this.getEvaloObjectIDofFlow(ctx, flowInfo.getId().toString());
                    if (objectSet == null) continue;
                    objectSet.retainAll(evaluObjectIdSet);
                    success += facade.createProcessRequireNew(flowInfo.getId().toString(), flowInfo.getWorkFlowID().toString(), solutionPeriodId, objectSet);
                }
                if (success == 0) {
                    throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.START_FAILD);
                }
                this.startSolutionPeriodSuccess(ctx, solutionPeriodId);
                break block10;
            }
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append("UPDATE T_PF_EvalWFObjects SET FStatus = ? WHERE FEvalWorkFlowID = ? ");
            int n = evalWorkFlowCollection.size();
            for (int i = 1; i < n; ++i) {
                strBuffer.append("  OR  FEvalWorkFlowID = ? ");
            }
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(strBuffer.toString());
                pstmt.setInt(1, 20);
                int n2 = evalWorkFlowCollection.size();
                for (int i = 0; i < n2; ++i) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)(2 + i), (String)evalWorkFlowCollection.get(i).getId().toString());
                }
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            this.startSolutionPeriodSuccess(ctx, solutionPeriodId);
        }
    }

    @Override
    protected int _createProcessRequireNew(Context ctx, String evalWorkFlowID, String workflowid, String solutionPeriodId, HashSet objectSet) throws BOSException, EASBizException {
        SolutionPeriodInfo spInfo = (SolutionPeriodInfo)ctx.get((Object)SOLUTION_PERIOD);
        HashSet<EvalorNodeInfo> succeser = new HashSet<EvalorNodeInfo>();
        HashSet subSet = new HashSet();
        int count = 0;
        int okCount = 0;
        ArrayList nodeInfoArray = null;
        ProcessStartParam[] params = null;
        HashMap<String, String> map = null;
        int index = 0;
        String solutionPeriodName = spInfo.getName();
        IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
        String[] procInstArray = null;
        HashMap userMap = null;
        Iterator iter = objectSet.iterator();
        while (iter.hasNext()) {
            subSet.add(iter.next());
            if (++count % 200 != 0 && iter.hasNext()) continue;
            userMap = this.getUserIDByPerson(ctx, subSet);
            nodeInfoArray = this.getEvaluNodeInfoSet(ctx, subSet, evalWorkFlowID, userMap);
            if (nodeInfoArray.size() > 0) {
                params = new ProcessStartParam[nodeInfoArray.size()];
                index = 0;
                for (EvalorNodeInfo nodeInfo : nodeInfoArray) {
                    params[index] = new ProcessStartParam();
                    map = new HashMap<String, String>();
                    map.put("evaluObjectID", nodeInfo.getEvaluObjectID());
                    map.put("evaluObjectName", nodeInfo.getEvaluObjectName());
                    map.put("evalor", nodeInfo.getEvalorID());
                    map.put("evaluPeriodName", solutionPeriodName);
                    Person wfPersonInfo = new Person();
                    wfPersonInfo.setEmployeeId(nodeInfo.getEvalorID());
                    wfPersonInfo.setUserId(nodeInfo.getUserID());
                    wfPersonInfo.setEmployeeName(this.l2, nodeInfo.getEvaluObjectName());
                    map.put("personId", (String)wfPersonInfo);
                    map.put("billID", this.createNodeProcesserBillId());
                    params[index].setProcessStartContext(map);
                    if (nodeInfo.getUserID() != null) {
                        params[index].setInitiatorID(nodeInfo.getUserID());
                    } else {
                        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                        params[index].setInitiatorID(userId);
                    }
                    params[index].setProcessDefID(workflowid);
                    ++index;
                }
                procInstArray = service.createAndStartProcesses(params);
                if (procInstArray != null) {
                    for (int i = 0; i < procInstArray.length; ++i) {
                        EvalorNodeInfo nodeInfo;
                        nodeInfo = (EvalorNodeInfo)nodeInfoArray.get(i);
                        nodeInfo.setProcInstID(procInstArray[i]);
                        succeser.add(nodeInfo);
                        ++okCount;
                    }
                }
            }
            this.updateSynFlowObjectInfo(ctx, succeser, evalWorkFlowID);
            succeser.clear();
            subSet.clear();
        }
        return okCount;
    }

    private HashMap getUserIDByPerson(Context ctx, Set subSet) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T_PM_User.FID userID ,T_PM_User.FPersonId personID ,T_HR_PersonPosition.FPrimaryPositionID positionID FROM T_PM_User INNER JOIN T_PF_EvaluObject ON T_PM_User.FPersonId = T_PF_EvaluObject.@ID@ ");
        sb.append(" INNER JOIN T_HR_PersonPosition ON T_PM_User.FPersonId = T_HR_PersonPosition.FPersonID ");
        sb.append("WHERE T_PM_User.FIsDelete = 0 and T_PM_User.FIsLocked = 0 and T_PM_User.FForbidden = 0 and T_PM_User.FInvalidationDate >= NOW() ");
        sb.append("and T_PF_EvaluObject.FID IN (");
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = subSet.iterator();
        while (iter.hasNext()) {
            sb.append("'");
            sb.append((String)iter.next());
            sb.append("'");
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        SolutionPeriodInfo spInfo = (SolutionPeriodInfo)ctx.get((Object)SOLUTION_PERIOD);
        String typeField = null;
        typeField = EvaluSolutionTypeEnum.PERSON.equals((Object)spInfo.getEvaluSolution().getSolutionType()) ? "FObjectID" : "FResponserID";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString().replaceFirst("@ID@", typeField));
        try {
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString("positionID"))) {
                    map.put(rowSet.getString("personID"), null);
                    continue;
                }
                map.put(rowSet.getString("personID"), rowSet.getString("userID"));
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return map;
    }

    private ArrayList getEvaluNodeInfoSet(Context ctx, HashSet objectSet, String evalWorkFlowID, HashMap personUserMap) throws BOSException {
        StringBuffer sql = new StringBuffer("select evaluObject.fid evaluObjectID, evaluObject.FName_");
        sql.append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        sql.append(" name , evaluObject.@ID@ evalorID");
        sql.append(" from T_PF_EvaluObject evaluObject ");
        sql.append(" where evaluObject.fid in (");
        Iterator iter = objectSet.iterator();
        while (iter.hasNext()) {
            sql.append("'");
            sql.append(iter.next().toString());
            sql.append("'");
            sql.append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        ArrayList<EvalorNodeInfo> array = new ArrayList<EvalorNodeInfo>();
        SolutionPeriodInfo spInfo = (SolutionPeriodInfo)ctx.get((Object)SOLUTION_PERIOD);
        String typeField = null;
        typeField = EvaluSolutionTypeEnum.PERSON.equals((Object)spInfo.getEvaluSolution().getSolutionType()) ? "FObjectID" : "FResponserID";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString().replaceFirst("@ID@", typeField));
            EvalorNodeInfo nodeInfo = null;
            String evalorID = null;
            String userID = null;
            while (rowSet.next()) {
                evalorID = rowSet.getString("evalorID");
                userID = (String)personUserMap.get(evalorID);
                nodeInfo = new EvalorNodeInfo();
                nodeInfo.setEvalorID(evalorID);
                nodeInfo.setEvaluObjectName(rowSet.getString("name"));
                nodeInfo.setEvaluObjectID(rowSet.getString("evaluObjectID"));
                nodeInfo.setUserID(userID);
                array.add(nodeInfo);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        return array;
    }

    private void updateSynFlowObjectInfo(Context ctx, HashSet succeser, String evalWorkFlowID) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        if (succeser.size() > 0) {
            String sql = "UPDATE T_PF_EvalWFObjects SET FStatus = ? , FProcInstID = ?  WHERE FEvalWorkFlowID = ?  AND FEvaluObjectID = ?";
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                EvalorNodeInfo nodeInfo2 = null;
                for (EvalorNodeInfo nodeInfo2 : succeser) {
                    pstmt.setInt(1, 20);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)nodeInfo2.getProcInstID());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)evalWorkFlowID);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)nodeInfo2.getEvaluObjectID());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (SQLException e1) {
                try {
                    logger.error((Object)e1);
                    throw new BOSException((Throwable)e1);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    @Override
    protected String _createStartProcessInstRequiredNew(Context ctx, String workflowID, EvalorNodeInfo nodeInfo, Person person, String solutionPeriodName) throws BOSException, EASBizException {
        ProcessInstInfo processInstInfo;
        try {
            EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
            Date b1 = new Date();
            processInstInfo = enactmentService.createProcessInstWithPersonID(workflowID, nodeInfo.getEvalorID());
            Date b2 = new Date();
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"10_EvalWorkFlowFacadeControllerBean", (Locale)ctx.getLocale()) + (b2.getTime() - b1.getTime())));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("evaluObjectID", nodeInfo.getEvaluObjectID());
            map.put("evaluObjectName", nodeInfo.getEvaluObjectName());
            map.put("evalor", nodeInfo.getEvalorID());
            map.put("evaluPeriodName", solutionPeriodName);
            Person wfPersonInfo = new Person();
            wfPersonInfo.setEmployeeId(nodeInfo.getEvalorID());
            wfPersonInfo.setUserId(nodeInfo.getUserID());
            wfPersonInfo.setEmployeeName(this.l2, nodeInfo.getEvaluObjectName());
            map.put("personId", (String)wfPersonInfo);
            map.put("billID", this.createNodeProcesserBillId());
            Date c1 = new Date();
            enactmentService.setProcessContext(processInstInfo.getProcInstId(), map);
            Date c2 = new Date();
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"11_EvalWorkFlowFacadeControllerBean", (Locale)ctx.getLocale()) + (c2.getTime() - c1.getTime())));
            Date a1 = new Date();
            enactmentService.startProcessInst(processInstInfo.getProcInstId());
            Date a2 = new Date();
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"12_EvalWorkFlowFacadeControllerBean", (Locale)ctx.getLocale()) + (a2.getTime() - a1.getTime())));
        }
        catch (WfException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return processInstInfo.getProcInstId();
    }

    @Override
    public void _deleteProcess(Context ctx, String workFlowID, HashMap instToResultObjectMap) throws BOSException, EASBizException {
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        ProcessInstInfo[] processInstInfo = enactmentService.getProcessInstancesByProcDefId(workFlowID);
        HashSet<ProcessInstInfo> deleteSet = new HashSet<ProcessInstInfo>();
        int count = 0;
        int n = processInstInfo.length;
        for (int i = 0; i < n; ++i) {
            deleteSet.add(processInstInfo[i]);
            if ((++count % this.DELPROCINSTMAX != 0 || count <= 0) && (count % this.DELPROCINSTMAX == 0 || count <= 0 || i + 1 < n)) continue;
            EvalWorkFlowFacadeFactory.getLocalInstance(ctx).deleteProcessInstRequiredNew(deleteSet, instToResultObjectMap);
            deleteSet = new HashSet();
            count = 0;
        }
    }

    @Override
    public void _deleteProcessInstRequiredNew(Context ctx, HashSet instSet, HashMap instToResultObjectMap) throws BOSException, EASBizException {
        Iterator iterator = instSet.iterator();
        HashSet<String> resultSet = new HashSet<String>();
        HashSet<String> wfObjectSet = new HashSet<String>();
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        String[] ids = new String[instSet.size()];
        HashSet<String> temmin = new HashSet<String>();
        int count = 0;
        while (iterator.hasNext()) {
            ProcessInstInfo instInfo = (ProcessInstInfo)iterator.next();
            ids[count] = instInfo.getProcInstId();
            ++count;
            if (!instInfo.getState().startsWith(WfState.CLOSED.getValue())) {
                temmin.add(instInfo.getProcInstId());
            }
            if (!instToResultObjectMap.containsKey(instInfo.getProcInstId())) continue;
            ResultObjectInstInfo nodeInfo = (ResultObjectInstInfo)instToResultObjectMap.get(instInfo.getProcInstId());
            resultSet.add(nodeInfo.getEvaluResultID());
            wfObjectSet.add(nodeInfo.getWfObjectID());
        }
        try {
            count = 0;
            if (temmin.size() > 0) {
                String[] tId = new String[temmin.size()];
                Iterator iter = temmin.iterator();
                while (iter.hasNext()) {
                    tId[count] = (String)iter.next();
                    ++count;
                }
                enactmentService.batchTerminate(tId);
            }
            if (instSet.size() > 0) {
                enactmentService.batchPhysicsDelete(ids);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (resultSet.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluResult.id", resultSet, CompareType.INCLUDE));
            NodeProcesserFactory.getLocalInstance(ctx).delete(filterInfo);
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", resultSet, CompareType.INCLUDE));
            EvaluResultFactory.getLocalInstance(ctx).delete(filterInfo);
        }
        if (wfObjectSet.size() > 0) {
            Connection conn = null;
            PreparedStatement pstmt = null;
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE T_PF_EvalWFObjects SET FStatus = ? ,FProcInstID = ? WHERE FID = ? ");
            iterator = wfObjectSet.iterator();
            count = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (++count <= 1) continue;
                sb.append(" OR FID = ? ");
            }
            iterator = wfObjectSet.iterator();
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sb.toString());
                pstmt.setInt(1, 10);
                pstmt.setString(2, null);
                count = 0;
                while (iterator.hasNext()) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)(3 + count), (String)iterator.next().toString());
                    ++count;
                }
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    @Override
    public void _terminalProcess(Context ctx, String workflowid, HashMap instToResultObjectMap) throws BOSException, EASBizException {
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        ProcessInstInfo[] processInstInfo = enactmentService.getProcessInstancesByProcDefId(workflowid);
        HashSet<ProcessInstInfo> terminalSet = new HashSet<ProcessInstInfo>();
        int count = 0;
        int n = processInstInfo.length;
        for (int i = 0; i < n; ++i) {
            terminalSet.add(processInstInfo[i]);
            if ((++count % this.TERMINALINSTMAX != 0 || count <= 0) && (count % this.TERMINALINSTMAX == 0 || count <= 0 || i + 1 < n)) continue;
            EvalWorkFlowFacadeFactory.getLocalInstance(ctx).terminalProcessRequiredNew(terminalSet, instToResultObjectMap);
            terminalSet = new HashSet();
            count = 0;
        }
    }

    @Override
    public void _terminalProcessRequiredNew(Context ctx, HashSet terminalSet, HashMap instToResultObjectMap) throws BOSException, EASBizException {
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        Iterator iterator = terminalSet.iterator();
        HashSet<String> evalWfObjectSet = new HashSet<String>();
        while (iterator.hasNext()) {
            ProcessInstInfo instInfo = (ProcessInstInfo)iterator.next();
            if (!instInfo.getState().startsWith(WfState.CLOSED.getValue())) {
                enactmentService.terminateProcessInst(instInfo.getProcInstId());
            }
            if (!instToResultObjectMap.containsKey(instInfo.getProcInstId())) continue;
            ResultObjectInstInfo nodeInfo = (ResultObjectInstInfo)instToResultObjectMap.get(instInfo.getProcInstId());
            evalWfObjectSet.add(nodeInfo.getWfObjectID());
        }
        if (evalWfObjectSet.size() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sb = new StringBuffer();
        int count = 0;
        sb.append("UPDATE T_PF_EvalWFObjects SET FStatus = ? WHERE FID = ? ");
        iterator = evalWfObjectSet.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if (++count <= 1) continue;
            sb.append(" OR FID = ? ");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            pstmt.setInt(1, 30);
            iterator = evalWfObjectSet.iterator();
            count = 0;
            while (iterator.hasNext()) {
                pstmt.setString(2 + count, iterator.next().toString());
                ++count;
            }
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private HashSet getEvaloObjectIDofFlow(Context ctx, String workFlowID) throws BOSException {
        String sql = "select FEvaluObjectID objectID from T_PF_EvalWFObjects where FEvalWorkFlowID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashSet<String> set = new HashSet<String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, workFlowID);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                set.add(result.getString("objectID"));
            }
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return set;
    }

    @Override
    protected void _startSolutionPeriod(Context ctx, String solutionPeriodId, Set evaluObjectIdSet) throws BOSException, EASBizException {
        this.startWorkFlow(ctx, solutionPeriodId, evaluObjectIdSet);
    }

    @Override
    protected HashMap _copyWorkFlow(Context ctx, HashSet workflowIds, String toSolutionPeriodID) throws BOSException, EASBizException {
        boolean allocateTarget = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("evaluSolution.allocateTarget"));
        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(toSolutionPeriodID), sic);
        allocateTarget = spInfo.getEvaluSolution().getAllocateTarget() == 1;
        FilterInfo filter = new FilterInfo();
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer workflowId = new StringBuffer("");
        Iterator it = workflowIds.iterator();
        for (int i = 0; i < workflowIds.size() - 1; ++i) {
            workflowId.append(it.next().toString()).append("','");
        }
        workflowId.append(it.next().toString()).append("'");
        try {
            StringBuffer str = new StringBuffer();
            String sql = "select FSolutionType from T_PF_EvaluSolution,T_PF_SolutionPeriod where T_PF_SolutionPeriod.FEvaluSolutionID = T_PF_EvaluSolution.fid and T_PF_SolutionPeriod.fid='" + toSolutionPeriodID + "'";
            IRowSet rows = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL();
            if (rows.next() && 100 == rows.getInt("FSolutionType")) {
                str.append("select a.name1,a.objectname1,b.name2 from ");
                str.append("(select  T_PF_EvalWorkFlow.FName as name1, T_PF_EvaluObject.FObjectID as object1 ,T_BD_Person.Fname_l2 as objectname1 ");
                str.append("from T_PF_EvalWFObjects ,T_PF_EvalWorkFlow, T_PF_EvaluObject,T_BD_Person ");
                str.append("where T_PF_EvalWFObjects.FEvaluObjectID=T_PF_EvaluObject.fid ");
                str.append("and T_PF_EvalWFObjects.FEvalWorkFlowID = T_PF_EvalWorkFlow.fid ");
                str.append("and T_PF_EvaluObject.FObjectID=T_BD_Person.fid ");
                str.append("and T_PF_EvalWorkFlow.fid in ('").append(workflowId).append(") ");
                str.append(") as a ");
                str.append("inner join( ");
                str.append("select  T_PF_EvalWorkFlow.FName as name2, T_PF_EvaluObject.FObjectID as object2 ,T_BD_Person.Fname_l2 as objectname2 ");
                str.append("from T_PF_EvalWFObjects ,T_PF_EvalWorkFlow, T_PF_EvaluObject,T_BD_Person ");
                str.append("where T_PF_EvalWFObjects.FEvaluObjectID=T_PF_EvaluObject.fid ");
                str.append(" and T_PF_EvalWFObjects.FEvalWorkFlowID = T_PF_EvalWorkFlow.fid ");
                str.append("and T_PF_EvaluObject.FObjectID=T_BD_Person.fid ");
                str.append("and T_PF_EvalWorkFlow.FSolutionPeriodID='").append(toSolutionPeriodID).append("'");
                str.append(") as b on a.object1=b.object2 order by a.name1,b.name2");
            } else {
                str.append("select a.name1,a.objectname1,b.name2 from ");
                str.append("(select  T_PF_EvalWorkFlow.FName as name1, T_PF_EvaluObject.FObjectID as object1 ,T_ORG_BaseUnit.Fname_l2 as objectname1 ");
                str.append("from T_PF_EvalWFObjects ,T_PF_EvalWorkFlow, T_PF_EvaluObject,T_ORG_BaseUnit ");
                str.append("where T_PF_EvalWFObjects.FEvaluObjectID=T_PF_EvaluObject.fid ");
                str.append("and T_PF_EvalWFObjects.FEvalWorkFlowID = T_PF_EvalWorkFlow.fid ");
                str.append("and T_PF_EvaluObject.FObjectID=T_ORG_BaseUnit.fid ");
                str.append("and T_PF_EvalWorkFlow.fid in ('").append(workflowId).append(") ");
                str.append(") as a ");
                str.append("inner join( ");
                str.append("select  T_PF_EvalWorkFlow.FName as name2, T_PF_EvaluObject.FObjectID as object2 ,T_ORG_BaseUnit.Fname_l2 as objectname2 ");
                str.append("from T_PF_EvalWFObjects ,T_PF_EvalWorkFlow, T_PF_EvaluObject,T_ORG_BaseUnit ");
                str.append("where T_PF_EvalWFObjects.FEvaluObjectID=T_PF_EvaluObject.fid ");
                str.append(" and T_PF_EvalWFObjects.FEvalWorkFlowID = T_PF_EvalWorkFlow.fid ");
                str.append("and T_PF_EvaluObject.FObjectID=T_ORG_BaseUnit.fid ");
                str.append("and T_PF_EvalWorkFlow.FSolutionPeriodID='").append(toSolutionPeriodID).append("'");
                str.append(") as b on a.object1=b.object2 order by a.name1,b.name2");
            }
            rows = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)str.toString()).executeSQL();
            while (rows.next()) {
                Object names = map.get(rows.getString("name1") + "," + rows.getString("name2"));
                if (names == null) {
                    map.put(rows.getString("name1") + "," + rows.getString("name2"), rows.getString("objectname1"));
                    continue;
                }
                map.put(rows.getString("name1") + "," + rows.getString("name2"), names.toString() + ", " + rows.getString("objectname1"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)workflowIds, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("concurArgs.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("wfObjects.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("wfObjects.evaluObject.deleted"));
        EvalWorkFlowCollection collection = EvalWorkFlowFactory.getLocalInstance(ctx).getEvalWorkFlowCollection(viewInfo);
        if (collection == null || collection.size() == 0) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.FROMSOLUTIONPERIOD_NO_WORKFLOW);
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            this.copyFlow(ctx, collection.get(i), toSolutionPeriodID, allocateTarget);
        }
        return map;
    }
}

