/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionContractTemplateCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionContractTemplateFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionContractTemplateInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryTypeEnum;
import com.kingdee.eas.hr.perf.EvaluFormSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionStateEnum;
import com.kingdee.eas.hr.perf.EvaluGroupCollection;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.IEvaluFormSolution;
import com.kingdee.eas.hr.perf.IEvaluFormSolutionContractTemplate;
import com.kingdee.eas.hr.perf.IEvaluFormSolutionEntry;
import com.kingdee.eas.hr.perf.IEvaluFormSolutionMultiTable;
import com.kingdee.eas.hr.perf.IEvaluGroup;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.SolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.app.AbstractEvaluFormSolutionFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class EvaluFormSolutionFacadeControllerBean
extends AbstractEvaluFormSolutionFacadeControllerBean {
    @Override
    protected void _initEntry(Context ctx, String id, EvaluFormSolutionEntryTypeEnum type, String multiTableID) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        IEvaluFormSolutionEntry iEvaluFormSolutionEntry = EvaluFormSolutionEntryFactory.getLocalInstance(ctx);
        boolean existEntry = type.equals((Object)EvaluFormSolutionEntryTypeEnum.head) ? iEvaluFormSolutionEntry.exists("where evaluFormSolution.id = '" + id + "' and type =" + type.getValue() + "") : iEvaluFormSolutionEntry.exists("where evaluFormSolution.id = '" + id + "' and multiTable='" + multiTableID + "' and type=" + type.getValue() + "");
        if (!existEntry) {
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into T_PF_EvaluFormSolutionEntry(FId,FSolutionID,FCode,FOldName,FVisible,FSeq,FType,FRequired,FStaticColumn,");
            sql.append("FEvaluObjectType,FColumnWidth, FName_l1, FName_l2, FName_l3,FMultiTableID ) ");
            sql.append(" ( ");
            sql.append(" select  newbosid('EA60778F'),");
            sql.append("'").append(id).append("'");
            sql.append(",FCode,FName,FVisible,FSeq,FType,FRequired,FStaticColumn,FEvaluObjectType,FColumnWidth, FOriginalName_l1, FOriginalName_l2, FOriginalName_l3 ");
            sql.append(",'").append(multiTableID).append("'");
            sql.append(" from T_PF_EvaluFormSolutionInitData where Ftype=" + type.getValue() + "");
            sql.append(" ) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected void _copySolution(Context ctx, String number, String name, String id) throws BOSException, EASBizException {
        if (number == null || name == null || id == null) {
            return;
        }
        EvaluFormSolutionInfo newInfo = new EvaluFormSolutionInfo();
        newInfo.setNumber(number.trim());
        newInfo.setName(name.trim());
        newInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        IEvaluFormSolution dao = EvaluFormSolutionFactory.getLocalInstance(ctx);
        EvaluFormSolutionInfo sourceInfo = dao.getEvaluFormSolutionInfo((IObjectPK)new ObjectUuidPK(id));
        if (sourceInfo != null) {
            newInfo.setDescription(sourceInfo.getDescription());
            newInfo.setMemo(sourceInfo.getMemo());
            newInfo.setMemoVisible(sourceInfo.isMemoVisible());
            newInfo.setEvaluObjectType(sourceInfo.getEvaluObjectType());
            newInfo.setMeetRuleMode(sourceInfo.getMeetRuleMode());
            newInfo.setSolutionState(EvaluFormSolutionStateEnum.NO_START_USING);
            this.copyEvaluFormSolutionEntry(sourceInfo, newInfo);
            dao.addnew((CoreBaseInfo)newInfo);
            this.copyEvaluFormSolutionMultiTable(sourceInfo, newInfo, ctx);
            this.dealLogInfo(ctx, id, "perf_EvaluFormSolution_copy", false);
        }
    }

    private void copyEvaluFormSolutionEntry(EvaluFormSolutionInfo sourceInfo, EvaluFormSolutionInfo newInfo) {
        EvaluFormSolutionEntryCollection sourceEntry = sourceInfo.getEntry();
        EvaluFormSolutionEntryCollection tempColl = new EvaluFormSolutionEntryCollection();
        int size = sourceEntry.size();
        for (int i = 0; i < size; ++i) {
            if (!sourceEntry.get(i).getType().getName().equals(EvaluFormSolutionEntryTypeEnum.head.getName())) continue;
            EvaluFormSolutionEntryInfo eInfo = sourceEntry.get(i);
            eInfo.setId(null);
            tempColl.add(eInfo);
        }
        newInfo.put("entry", (Object)tempColl);
    }

    private void copyEvaluFormSolutionMultiTable(EvaluFormSolutionInfo sourceInfo, EvaluFormSolutionInfo newInfo, Context ctx) throws BOSException, EASBizException {
        EvaluFormSolutionMultiTableCollection sourceMultiTable = sourceInfo.getMultiTable();
        IEvaluFormSolutionEntry entryDao = EvaluFormSolutionEntryFactory.getLocalInstance(ctx);
        IEvaluFormSolutionContractTemplate contractTemplateDao = EvaluFormSolutionContractTemplateFactory.getLocalInstance(ctx);
        IEvaluFormSolutionMultiTable multiTableDao = EvaluFormSolutionMultiTableFactory.getLocalInstance(ctx);
        int size = sourceMultiTable.size();
        for (int i = 0; i < size; ++i) {
            EvaluFormSolutionContractTemplateCollection evaluFormSolutionContractTemplateCollection;
            CoreBaseCollection newEFSEntryInfoCollection = new CoreBaseCollection();
            CoreBaseCollection newEFSContractTemplateInfoCollection = new CoreBaseCollection();
            EvaluFormSolutionMultiTableInfo multiTableInfo = sourceMultiTable.get(i);
            String solutionID = multiTableInfo.getEvaluFormSolution().getId().toString();
            String multiTableID = multiTableInfo.getId().toString();
            multiTableInfo.setId(null);
            multiTableInfo.setEvaluFormSolution(newInfo);
            multiTableDao.addnew((CoreBaseInfo)multiTableInfo);
            EvaluFormSolutionEntryCollection evaluFormSolutionEntryCollection = this.getMultiTableCollection(ctx, solutionID, multiTableID);
            if (evaluFormSolutionEntryCollection != null && evaluFormSolutionEntryCollection.size() > 0) {
                int n = evaluFormSolutionEntryCollection.size();
                for (int m = 0; m < n; ++m) {
                    EvaluFormSolutionEntryInfo eEntryInfo = evaluFormSolutionEntryCollection.get(m);
                    eEntryInfo.setId(null);
                    eEntryInfo.setMultiTable(multiTableInfo);
                    eEntryInfo.setEvaluFormSolution(newInfo);
                    newEFSEntryInfoCollection.add((CoreBaseInfo)eEntryInfo);
                }
                entryDao.addnew(newEFSEntryInfoCollection);
            }
            if ((evaluFormSolutionContractTemplateCollection = this.getContractTemplateCollection(ctx, multiTableID)) == null || evaluFormSolutionContractTemplateCollection.size() <= 0) continue;
            int n = evaluFormSolutionContractTemplateCollection.size();
            for (int m = 0; m < n; ++m) {
                EvaluFormSolutionContractTemplateInfo eContractTemplateInfo = evaluFormSolutionContractTemplateCollection.get(m);
                eContractTemplateInfo.setId(null);
                eContractTemplateInfo.setMultiTable(multiTableInfo);
                newEFSContractTemplateInfoCollection.add((CoreBaseInfo)eContractTemplateInfo);
            }
            contractTemplateDao.addnew(newEFSContractTemplateInfoCollection);
        }
    }

    private EvaluFormSolutionEntryCollection getMultiTableCollection(Context ctx, String solutionID, String multiTableID) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluFormSolution", (Object)solutionID));
        filterInfo.getFilterItems().add(new FilterItemInfo("multiTable", (Object)multiTableID));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(EvaluFormSolutionEntryTypeEnum.body.getValue())));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("seq");
        sorterItemInfo.setSortType(SortType.ASCEND);
        EntityViewInfo multiTableEntryViewInfo = new EntityViewInfo();
        multiTableEntryViewInfo.setFilter(filterInfo);
        multiTableEntryViewInfo.getSorter().add(sorterItemInfo);
        IEvaluFormSolutionEntry iEvaluFormSolutionEntry = EvaluFormSolutionEntryFactory.getLocalInstance(ctx);
        EvaluFormSolutionEntryCollection evaluFormSolutionEntryCollection = iEvaluFormSolutionEntry.getEvaluFormSolutionEntryCollection(multiTableEntryViewInfo);
        return evaluFormSolutionEntryCollection;
    }

    private EvaluFormSolutionContractTemplateCollection getContractTemplateCollection(Context ctx, String multiTableID) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("multiTable", (Object)multiTableID));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("seq");
        sorterItemInfo.setSortType(SortType.ASCEND);
        EntityViewInfo contractTemplateEntryViewInfo = new EntityViewInfo();
        contractTemplateEntryViewInfo.setFilter(filterInfo);
        contractTemplateEntryViewInfo.getSorter().add(sorterItemInfo);
        IEvaluFormSolutionContractTemplate iEvaluFormSolutionContractTemplate = EvaluFormSolutionContractTemplateFactory.getLocalInstance(ctx);
        EvaluFormSolutionContractTemplateCollection evaluFormSolutionContractTemplateCollection = iEvaluFormSolutionContractTemplate.getEvaluFormSolutionContractTemplateCollection(contractTemplateEntryViewInfo);
        return evaluFormSolutionContractTemplateCollection;
    }

    @Override
    protected void _setState(Context ctx, List ids, int state) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return;
        }
        HashSet set = new HashSet(ids);
        String sql = null;
        sql = state == 0 ? "update t_pf_evaluFormSolution set FEnable = 0 where FId in(" : (state == 1 ? "update t_pf_evaluFormSolution set FEnable = 1 where FId in(" : "update t_pf_evaluFormSolution set FEnable = 2 where FId in(");
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String id = it.next().toString();
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("'").append(id).append("'");
        }
        sql = sql + sb.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected List _reverseUsingEvaluFormSolution(Context ctx, List evaluFormSolutionIdList) throws BOSException, EASBizException {
        ArrayList<String> usingIdList = new ArrayList<String>();
        ArrayList<String> noUsingIdList = new ArrayList<String>();
        ISolutionPeriod solutionPeriodDao = SolutionPeriodFactory.getLocalInstance(ctx);
        int size = evaluFormSolutionIdList.size();
        for (int i = 0; i < size; ++i) {
            if (this.isUsedBySolutionPeriod(ctx, solutionPeriodDao, evaluFormSolutionIdList.get(i).toString())) {
                usingIdList.add(evaluFormSolutionIdList.get(i).toString());
                continue;
            }
            noUsingIdList.add(evaluFormSolutionIdList.get(i).toString());
        }
        if (noUsingIdList.size() > 0) {
            this._reverseEnable(ctx, noUsingIdList);
        }
        return usingIdList;
    }

    @Override
    protected boolean _isUsedAndGroupAssigned(Context ctx, String id) throws BOSException, EASBizException {
        boolean isExit = false;
        ISolutionPeriod solutionPeriodDao = SolutionPeriodFactory.getLocalInstance(ctx);
        SolutionPeriodCollection solutionPeriodIdCollection = this.getUsedSolutionPeriodCollection(ctx, solutionPeriodDao, id);
        HashSet<String> solutionPeriodIdSet = new HashSet<String>();
        if (solutionPeriodIdCollection != null && solutionPeriodIdCollection.size() > 0) {
            for (int i = 0; i < solutionPeriodIdCollection.size(); ++i) {
                solutionPeriodIdSet.add(solutionPeriodIdCollection.get(i).get("id").toString());
            }
        }
        if (this.isExitAssignedGroup(ctx, solutionPeriodIdSet)) {
            isExit = true;
        }
        return isExit;
    }

    public boolean isExitAssignedGroup(Context ctx, Set solutionPeriodIdSet) throws BOSException, EASBizException {
        boolean isExit = false;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("delivered", (Object)Boolean.TRUE, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        IEvaluGroup iEvaluGroup = EvaluGroupFactory.getLocalInstance(ctx);
        EvaluGroupCollection evaluGroupCollection = iEvaluGroup.getEvaluGroupCollection(evi);
        if (evaluGroupCollection.size() > 0) {
            isExit = true;
        }
        return isExit;
    }

    private boolean isUsedBySolutionPeriod(Context ctx, ISolutionPeriod solutionPeriodDao, String id) throws BOSException, EASBizException {
        boolean isUsed = false;
        SolutionPeriodCollection solutionPeriodCollection = this.getUsedSolutionPeriodCollection(ctx, solutionPeriodDao, id);
        if (solutionPeriodCollection != null && solutionPeriodCollection.size() > 0) {
            isUsed = true;
        }
        return isUsed;
    }

    private SolutionPeriodCollection getUsedSolutionPeriodCollection(Context ctx, ISolutionPeriod solutionPeriodDao, String id) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("formSolution.id", (Object)id));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("id"));
        SolutionPeriodCollection solutionPeriodCollection = solutionPeriodDao.getSolutionPeriodCollection(evi);
        return solutionPeriodCollection;
    }

    @Override
    protected List _getRelatedSolutionPeriod(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            return Collections.EMPTY_LIST;
        }
        Locale lc = ctx.getLocale();
        StringBuffer sql = new StringBuffer();
        if (LocaleUtils.getLocale((String)"l2").equals(lc)) {
            sql.append(" select es.FNumber esNum,es.Fname_l2 esName,ap.FName_l2 apName,ap.FName_l2 apName ");
        } else if (LocaleUtils.getLocale((String)"l3").equals(lc)) {
            sql.append(" select es.FNumber esNum,es.Fname_l3 esName,ap.FName_l3 apName,ap.FName_l3 apName ");
        } else {
            sql.append(" select es.FNumber esNum,es.Fname_l1 esName,ap.FName_l1 apName,ap.FName_l1 apName ");
        }
        sql.append(" from T_PF_SolutionPeriod sp ");
        sql.append(" left join T_PF_EvaluSolution es on sp.FEvaluSolutionID = es.FID ");
        sql.append(" left join T_PF_AssessPeriod ap on sp.FAssessPeriodID = ap.FID ");
        sql.append(" where FFormSolutionID = '").append(id).append("'");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String[]> list = new ArrayList<String[]>();
        try {
            while (row.next()) {
                String[] s = new String[]{row.getString("esNum"), row.getString("esName"), row.getString("apName")};
                list.add(s);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return list;
    }

    @Override
    protected Map _getEntrys(Context ctx, String solutionPeriodId, int type) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select entry.FCode code,entry.FNewName nName,Entry.FOldName oName, entry.FAlias_l1 alias_l1, entry.FAlias_l2 alias_l2, entry.FAlias_l3 alias_l3, ");
        sql.append(" entry.FName_l1 name_l1, entry.FName_l2 name_l2, entry.FName_l3 name_l3,");
        sql.append(" Entry.FSeq seq ,entry.FVisible visible, entry.FStaticColumn sCol, entry.FColumnWidth colWidth ,entry.FMultiTableID multiTableID");
        sql.append(" from T_PF_EvaluFormSolutionEntry entry ");
        sql.append(" left outer join T_PF_EvaluMultiTable evaluMutiTable on evaluMutiTable.fid = entry.FMultiTableID");
        sql.append(" where entry.FSolutionID in ");
        sql.append(" ( ");
        sql.append(" select FFormSolutionID from T_PF_SolutionPeriod  ");
        sql.append(" where FId = '").append(solutionPeriodId).append("'");
        sql.append(" ) ");
        sql.append(" and entry.FType = ").append(type);
        sql.append(" order by entry.FMultiTableID,entry.FSeq asc ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        LinkedHashMap<String, EvaluFormSolutionEntryInfo> map = null;
        LinkedHashMap<String, LinkedHashMap<String, EvaluFormSolutionEntryInfo>> _map = new LinkedHashMap<String, LinkedHashMap<String, EvaluFormSolutionEntryInfo>>();
        boolean visible = false;
        String multiTableId = null;
        EvaluFormSolutionEntryInfo info = null;
        try {
            while (row.next()) {
                String code = row.getString("code");
                if (code == null) continue;
                info = new EvaluFormSolutionEntryInfo();
                String nName = row.getString("alias_" + ctx.getLocale().toString());
                String oName = row.getString("name_" + ctx.getLocale().toString());
                int seq = row.getInt("seq");
                visible = row.getBoolean("visible");
                info.setAlias(nName);
                info.setName(oName);
                info.setSeq(seq);
                info.setVisible(visible);
                info.setStaticColumn(row.getBoolean("sCol"));
                int columnWidth = row.getInt("colWidth");
                info.setColumnWidth(columnWidth);
                multiTableId = row.getString("multiTableID");
                map = (LinkedHashMap<String, EvaluFormSolutionEntryInfo>)_map.get(multiTableId);
                if (map == null) {
                    map = new LinkedHashMap<String, EvaluFormSolutionEntryInfo>();
                    _map.put(multiTableId, map);
                }
                map.put(code, info);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return _map;
    }

    @Override
    protected Map _getVisibleSortedEntrys(Context ctx, String formSolutionId, EvaluObjectTypeEnum type) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)formSolutionId)) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FCode code,FNewName nName,FOldName oName,FType type,FEvaluObjectType objType, FStaticColumn staticColumn, FColumnWidth colWidth, ");
        sql.append(" FAlias_l1 alias_l1, FAlias_l2 alias_l2, FAlias_l3 alias_l3, ");
        sql.append(" FName_l1 name_l1, FName_l2 name_l2, FName_l3 name_l3 ");
        sql.append(" from T_PF_EvaluFormSolutionEntry  ");
        sql.append(" where FSolutionID ='").append(formSolutionId).append("'");
        sql.append(" and FVisible = 1");
        sql.append(" and FType = ");
        sql.append(10);
        sql.append(" and FEvaluObjectType = ");
        sql.append(type.getValue());
        sql.append(" order by FSeq asc ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            while (row.next()) {
                String code = row.getString("code");
                if (code == null) continue;
                String nName = row.getString("alias_" + ctx.getLocale().toString());
                String oName = row.getString("name_" + ctx.getLocale().toString());
                if (nName != null && nName.trim().length() > 0) {
                    map.put(code, nName);
                    continue;
                }
                map.put(code, oName);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return map;
    }

    @Override
    protected void _updateEntrys(Context ctx, List list) throws BOSException, EASBizException {
        if (list == null || list.size() <= 0) {
            return;
        }
        IEvaluFormSolutionEntry dao = EvaluFormSolutionEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("alias"));
        sic.add(new SelectorItemInfo("visible"));
        sic.add(new SelectorItemInfo("staticColumn"));
        sic.add(new SelectorItemInfo("columnWidth"));
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            EvaluFormSolutionEntryInfo info = (EvaluFormSolutionEntryInfo)list.get(i);
            dao.updatePartial((CoreBaseInfo)info, sic);
        }
    }

    @Override
    protected Map _getInitEntrys(Context ctx, int type) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FCode code,FName name,FSeq seq ,FVisible visible, ");
        sql.append(" FOriginalName_l1 originalName_l1,  FOriginalName_l2 originalName_l2,  FOriginalName_l3 originalName_l3 ");
        sql.append(" from T_PF_EvaluFormSolutionInitData ");
        sql.append(" where FType = ").append(type);
        sql.append(" order by FSeq asc ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        LinkedHashMap<String, EvaluFormSolutionEntryInfo> map = new LinkedHashMap<String, EvaluFormSolutionEntryInfo>();
        try {
            while (row.next()) {
                String code = row.getString("code");
                if (code == null) continue;
                EvaluFormSolutionEntryInfo info = new EvaluFormSolutionEntryInfo();
                String name = row.getString("name");
                int seq = row.getInt("seq");
                boolean visible = row.getBoolean("visible");
                info.setName(name);
                info.setSeq(seq);
                info.setVisible(visible);
                map.put(code, info);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return map;
    }

    @Override
    protected Map _getDefaultSolution(Context ctx, int type) throws BOSException, EASBizException {
        return this.innerGetDefaultSolution(ctx, type, type);
    }

    @Override
    protected Map _getHeadEntrys(Context ctx, String spId, String objId, int evaluObjectType) throws BOSException, EASBizException {
        if (spId == null || objId == null) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select entry.FCode code,entry.FNewName nName,Entry.FOldName oName,Entry.FSeq seq ,entry.FVisible visible,");
        sql.append(" FAlias_l1 alias_l1, FAlias_l2 alias_l2, FAlias_l3 alias_l3, ");
        sql.append(" FName_l1 name_l1, FName_l2 name_l2, FName_l3 name_l3 ");
        sql.append(" from T_PF_EvaluFormSolutionEntry entry ");
        sql.append(" where entry.FSolutionID in ");
        sql.append(" ( ");
        sql.append(" select FFormSolutionID from T_PF_SolutionPeriod  ");
        sql.append(" where FId = '").append(spId).append("'");
        sql.append(" ) ");
        sql.append(" and entry.FType = ").append(10);
        sql.append(" and entry.FEvaluObjectType = ").append(evaluObjectType);
        sql.append(" and entry.FVisible = ").append(1);
        sql.append(" order by entry.FSeq asc ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Map<String, String> map = new LinkedHashMap();
        try {
            while (row.next()) {
                String code = row.getString("code");
                if (code == null) continue;
                String nName = row.getString("alias_" + ctx.getLocale().toString());
                String oName = row.getString("name_" + ctx.getLocale().toString());
                if (nName != null && nName.trim().length() > 0) {
                    map.put(code, nName);
                    continue;
                }
                map.put(code, oName);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        if (map.size() <= 0) {
            map = this.innerGetDefaultSolution(ctx, 10, evaluObjectType);
        }
        Map valueMap = null;
        Set codeSet = map.keySet();
        sql.delete(0, sql.length());
        valueMap = evaluObjectType == 100 ? this.getHeaderEntrysPerson(ctx, spId, objId, codeSet) : this.getHeaderEntrysOrg(ctx, spId, objId, codeSet);
        HashMap<String, Map> result = new HashMap<String, Map>();
        result.put("names", map);
        result.put("values", valueMap);
        return result;
    }

    private Map getHeaderEntrysPerson(Context ctx, String spId, String objId, Set codeSet) throws BOSException {
        StringBuffer sql = new StringBuffer();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append(" select eo.FObjectID pId, pType.FName_");
        sql.append(locale);
        sql.append(" personType");
        sql.append(",person.FNumber personNumber,person.FName_");
        sql.append(locale);
        sql.append("  personName ");
        sql.append(",ps.FName_");
        sql.append(locale);
        sql.append("  primaryPosition, org.FName_");
        sql.append(locale);
        sql.append("  personOrg");
        sql.append(",gm.FName_");
        sql.append(locale);
        sql.append("  gradeMode ,es.FName_");
        sql.append(locale);
        sql.append("  evaluSolution,ap.FName_");
        sql.append(locale);
        sql.append("  assessPeriod");
        sql.append(",jobGrade.FGrade");
        sql.append("  jobGrade, diploma.FName_");
        sql.append(locale);
        sql.append("  highDegree");
        sql.append(",jobLevel.FName_");
        sql.append(locale);
        sql.append("  jobLevel,job.FName_");
        sql.append(locale);
        sql.append("  job");
        sql.append(",person.FCell cellPhone,person.FBackupCell backCellPhone");
        sql.append(",person.FEMail email,person.FBackupEMail backEmail");
        sql.append(",pp.FWorkTime workYears,pp.FTryoutMonth tryDate");
        sql.append(",pp.FJoinGroupYears groupYears,pp.FJoinCompanyYears companyYears");
        sql.append(",pp.FSysServiceYears systemYears,pp.FLenOfActualService realWorkAge");
        sql.append(",pp.FExtWorkTime extWorkAge,pp.FFormalDate formalDate,pp.FEnterDate entryDate");
        sql.append(",pp.FJoinGroupDate joinGroupDate,pp.FJoinDate joinCompanyDate");
        sql.append(",pp.FJoinSystemDate joinSystemDate,pp.FJobGradeEndDate jobGradeEndDate");
        sql.append(",er.FPositionId psId ");
        sql.append(" from t_pf_evaluResult er ");
        sql.append(" inner join t_pf_evaluObject eo on er.FEvaluObjectID = eo.FId ");
        sql.append(" left join T_PF_SolutionPeriod sp on sp.FId = er.FSolutionPeriodID ");
        sql.append(" left join T_org_Position ps on ps.FId = er.FPositionId ");
        sql.append(" left join T_org_Admin org on org.FId = er.FAdminOrgUnitId");
        sql.append(" left join T_PF_AssessPeriod ap on ap.FId = sp.FAssessPeriodID ");
        sql.append(" left join T_PF_EvaluSolution es on es.FId = sp.FEvaluSolutionID ");
        sql.append(" left join T_PF_GradeMode gm on gm.FId = es.FTargetGradeModeLinkID ");
        sql.append(" inner join T_BD_Person person on person.FId = eo.FObjectID ");
        sql.append(" left join T_BD_HRDiploma diploma on diploma.FId = person.FHighestDegreeID ");
        sql.append(" left join T_HR_EmployeeClassify pType on pType.FId = person.FEmployeeClassifyID ");
        sql.append(" left join T_HR_PersonPosition pp on pp.FPersonID = eo.FObjectID");
        sql.append(" left join T_HR_JobLevel jobLevel on jobLevel.FId = pp.FJobLevelID");
        sql.append(" left join T_ORG_Job job on job.FId = jobLevel.FJobID ");
        sql.append(" left join T_HR_JobGrade jobGrade on jobGrade.FId = pp.FJobGrade");
        sql.append(" where eo.FId = '").append(objId).append("'");
        sql.append(" and sp.FId = '").append(spId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String pId = null;
        String psId = null;
        try {
            if (rs.next()) {
                pId = rs.getString("pId");
                valueMap.put("personId", pId);
                psId = rs.getString("psId");
                HashSet<String> excSet = new HashSet<String>();
                excSet.add("directSuperior");
                excSet.add("positionType");
                excSet.add("jzPosition");
                excSet.add("primaryPositionSD");
                excSet.add("primaryPositionED");
                Iterator it = codeSet.iterator();
                while (it.hasNext()) {
                    String code = it.next().toString();
                    if (excSet.contains(code) || rs.getObject(code) == null) continue;
                    valueMap.put(code, rs.getObject(code));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        if (codeSet.contains("positionType") || codeSet.contains("jzPosition") || codeSet.contains("primaryPositionSD") || codeSet.contains("primaryPositionED")) {
            sql.delete(0, sql.length());
            sql.append(" select ps.FName_");
            sql.append(locale);
            sql.append("  psName,type.FName_");
            sql.append(locale);
            sql.append("  positionType");
            sql.append(" ,pm.FBeginDate primaryPositionSD,pm.FEndDate primaryPositionED,pm.FIsPrimary isPrimary ");
            sql.append(" from T_ORG_PositionMember pm ");
            sql.append(" left join t_org_position ps on ps.FId = pm.FPositionID ");
            sql.append(" left join T_BD_PersonRZType type on type.FId = pm.FPersonRZTypeID ");
            sql.append(" where pm.FPersonId = '").append(pId).append("'");
            try {
                if (!codeSet.contains("jzPosition")) {
                    sql.append(" and pm.FIsPrimary = 1 ");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    if (rs.next()) {
                        valueMap.put("positionType", rs.getString("positionType"));
                        valueMap.put("primaryPositionSD", rs.getDate("primaryPositionSD"));
                        valueMap.put("primaryPositionED", rs.getDate("primaryPositionED"));
                    }
                } else {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    StringBuffer sb = new StringBuffer();
                    while (rs.next()) {
                        boolean isPrimary = rs.getBoolean("isPrimary");
                        if (isPrimary) {
                            valueMap.put("positionType", rs.getString("positionType"));
                            valueMap.put("primaryPositionSD", rs.getDate("primaryPositionSD"));
                            valueMap.put("primaryPositionED", rs.getDate("primaryPositionED"));
                            continue;
                        }
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(rs.getString("psName"));
                    }
                    valueMap.put("jzPosition", sb.toString());
                }
            }
            catch (Exception exp) {
                throw new BOSException(exp.getMessage());
            }
        }
        if (codeSet.contains("directSuperior") && psId != null) {
            valueMap.put("directSuperior", this.getSuperior(ctx, psId));
        }
        return valueMap;
    }

    private Map getHeaderEntrysOrg(Context ctx, String solutionPeriodId, String objId, Set codeSet) throws BOSException {
        StringBuffer sql = new StringBuffer();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append(" select eo.FName_");
        sql.append(locale);
        sql.append("  orgName,eo.FNumber orgNumber,eo.FObjectID orgId ");
        sql.append(",ps.FName_");
        sql.append(locale);
        sql.append("  orgResponPosition,ps.FId psId ");
        sql.append(",person.FName_");
        sql.append(locale);
        sql.append("  orgResponserName,person.FId personId ");
        sql.append(",jobGrade.FName_");
        sql.append(locale);
        sql.append("  orgResponserGrade ");
        sql.append(",gm.FName_");
        sql.append(locale);
        sql.append("  gradeMode,es.FName_");
        sql.append(locale);
        sql.append("  evaluSolution ");
        sql.append(",ap.FName_");
        sql.append(locale);
        sql.append("  assessPeriod,orgType.FName_");
        sql.append(locale);
        sql.append("  orgUnitType");
        sql.append(",parentOrg.FName_");
        sql.append(locale);
        sql.append("  superOrg,parentOrg.FResponPositionID poRpId ");
        sql.append(" from t_pf_evaluResult er ");
        sql.append(" inner join t_pf_evaluObject eo on er.FEvaluObjectID = eo.FId ");
        sql.append(" inner join T_ORG_Admin org on org.FId = eo.FObjectID ");
        sql.append(" left join T_PF_SolutionPeriod sp on sp.FId = er.FSolutionPeriodID ");
        sql.append(" left join T_PF_AssessPeriod ap on ap.FId = sp.FAssessPeriodID ");
        sql.append(" left join T_PF_EvaluSolution es on es.FId = sp.FEvaluSolutionID ");
        sql.append(" left join T_PF_GradeMode gm on gm.FId = es.FTargetGradeModeLinkID ");
        sql.append(" left join T_BD_Person person on person.FId = eo.FResponserID ");
        sql.append(" left join T_HR_PersonPosition pp on pp.FPersonID = person.FId ");
        sql.append(" left join T_HR_JobGrade jobGrade on jobGrade.FId = pp.FJobGrade ");
        sql.append(" left join T_ORG_Position ps on ps.FId = org.FResponPositionID ");
        sql.append(" left join T_Org_LayerType orgType on orgType.FId = org.FLayerTypeID ");
        sql.append(" left join T_ORG_Admin parentOrg on parentOrg.FId = org.FParentID ");
        sql.append(" where eo.FId = ");
        sql.append("'");
        sql.append(objId);
        sql.append("'");
        sql.append(" and sp.FID = ");
        sql.append("'");
        sql.append(solutionPeriodId);
        sql.append("'");
        String psId = null;
        String personId = null;
        String poRpId = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                valueMap.put("orgId", rs.getString("orgId"));
                HashSet<String> excSet = new HashSet<String>();
                excSet.add("playDate");
                excSet.add("superLeader");
                psId = rs.getString("psId");
                personId = rs.getString("personId");
                poRpId = rs.getString("poRpId");
                Iterator it = codeSet.iterator();
                while (it.hasNext()) {
                    String code = it.next().toString();
                    if (excSet.contains(code) || rs.getObject(code) == null) continue;
                    valueMap.put(code, rs.getObject(code));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (codeSet.contains("playDate") && psId != null && personId != null) {
            sql.delete(0, sql.length());
            sql.append(" select pm.FBeginDate playDate From T_ORG_PositionMember pm ");
            sql.append(" where FPositionID = '").append(psId).append("'");
            sql.append(" and FPersonID = '").append(personId).append("'");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    valueMap.put("playDate", rs.getDate("playDate"));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (codeSet.contains("superLeader")) {
            sql.delete(0, sql.length());
            sql.append(" select superleader.FName_");
            sql.append(locale);
            sql.append("  superLeader  from   T_ORG_Admin admin ");
            sql.append("  left outer join t_org_position responsepos on admin.fresponpositionid = responsepos.fid ");
            sql.append("  left outer join t_org_positionmember responsepm on admin.fresponpositionid = responsepm.fpositionid ");
            sql.append("  left outer join t_org_positionhierarchy poshy on admin.fresponpositionid  = poshy.fchildid ");
            sql.append("  left outer join t_bd_person person on responsepm.fpersonid  = person.fid ");
            sql.append("  left outer join t_org_position parentstion on poshy.fparentid  = parentstion.fid ");
            sql.append("  left outer join t_org_hierarchy hcy on poshy.fhierarchyid = hcy.fid ");
            sql.append("  left outer join t_org_positionmember pm on poshy.fparentid= pm.fpositionid ");
            sql.append("  left outer join t_bd_person superleader on pm.fpersonid=  superleader.fid ");
            sql.append("  where admin.fid = '");
            sql.append(valueMap.get("orgId"));
            sql.append("'");
            sql.append("  and");
            sql.append("  (");
            sql.append("  poshy.FHierarchyID = '00000000-0000-0000-0000-000000000001396FCAD0'");
            sql.append("  or");
            sql.append("  poshy.FHierarchyID IS NULL");
            sql.append("  )");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    valueMap.put("superLeader", rs.getString("superLeader"));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return valueMap;
    }

    private String getSuperior(Context ctx, String psId) throws BOSException {
        if (psId == null) {
            return null;
        }
        String superior = "";
        MetaDataPK qryPk = new MetaDataPK("com.kingdee.eas.hr.emp.app.SuperiorQuery");
        IQueryExecutor iqryEx = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)qryPk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("child.id", (Object)psId));
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)"00000000-0000-0000-0000-000000000001396FCAD0"));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iqryEx.setObjectView(evi);
        IRowSet rows = iqryEx.executeQuery();
        try {
            while (rows.next()) {
                if (superior.length() == 0) {
                    superior = superior + rows.getString("name");
                    continue;
                }
                superior = superior + "," + rows.getString("name");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return superior;
    }

    protected Map innerGetDefaultSolution(Context ctx, int type, int evaluObjectType) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FCode code,FoldName oldNm,FNewName newNm,FSeq seq ,FVisible visible, FColumnWidth colWidth, ");
        sql.append(" FAlias_l1 alias_l1, FAlias_l2 alias_l2, FAlias_l3 alias_l3, ");
        sql.append(" FName_l1 name_l1, FName_l2 name_l2, FName_l3 name_l3 ");
        sql.append(" from T_PF_EvaluFormSolutionEntry ");
        sql.append(" where FType = ").append(type);
        sql.append(" and FSolutionID ='").append("00000000-0000-0000-0000-000000000000CD864EA3").append("'");
        if (type == 10) {
            sql.append(" and FEvaluObjectType = ").append(evaluObjectType);
            sql.append(" and FVisible = ").append(1);
        }
        sql.append(" order by FSeq asc ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        try {
            while (row.next()) {
                String code = row.getString("code");
                if (code == null) continue;
                EvaluFormSolutionEntryInfo info = new EvaluFormSolutionEntryInfo();
                String oldNm = row.getString("name_" + ctx.getLocale().toString());
                String newNm = row.getString("alias_" + ctx.getLocale().toString());
                if (type == 10) {
                    if (newNm != null && newNm.trim().length() > 0) {
                        map.put(code, newNm);
                        continue;
                    }
                    map.put(code, oldNm);
                    continue;
                }
                int seq = row.getInt("seq");
                boolean visible = row.getBoolean("visible");
                info.setAlias(newNm);
                info.setName(oldNm);
                info.setSeq(seq);
                info.setVisible(visible);
                int colWidth = row.getInt("colWidth");
                info.setColumnWidth(colWidth);
                map.put(code, info);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return map;
    }

    @Override
    protected void _disenable(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return;
        }
        HashSet set = new HashSet(ids);
        String sql = "update t_pf_evaluFormSolution set FEnable = 2 where FId in(";
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String id = it.next().toString();
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("'").append(id).append("'");
        }
        sql = sql + sb.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sql);
        String evaluFormSolutionId = ids.get(0).toString();
        if (ids.size() == 1) {
            this.dealLogInfo(ctx, evaluFormSolutionId, "perf_evaluFormSolution_disenable", false);
        }
        if (ids.size() > 1) {
            this.dealLogInfo(ctx, evaluFormSolutionId, "perf_evaluFormSolution_disenable", true);
        }
    }

    @Override
    protected void _enable(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return;
        }
        HashSet set = new HashSet(ids);
        String sql = "update t_pf_evaluFormSolution set FEnable = 1 where FId in(";
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String id = it.next().toString();
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("'").append(id).append("'");
        }
        sql = sql + sb.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sql);
        String evaluFormSolutionId = ids.get(0).toString();
        if (ids.size() == 1) {
            this.dealLogInfo(ctx, evaluFormSolutionId, "perf_evaluFormSolution_enable", false);
        }
        if (ids.size() > 1) {
            this.dealLogInfo(ctx, evaluFormSolutionId, "perf_evaluFormSolution_enable", true);
        }
    }

    @Override
    protected void _reverseEnable(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return;
        }
        HashSet set = new HashSet(ids);
        String sql = "update t_pf_evaluFormSolution set FEnable = 0 where FId in(";
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String id = it.next().toString();
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("'").append(id).append("'");
        }
        sql = sql + sb.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sql);
        String evaluFormSolutionId = ids.get(0).toString();
        if (ids.size() == 1) {
            this.dealLogInfo(ctx, evaluFormSolutionId, "perf_evaluFormSolution_reverseEnable", false);
        }
        if (ids.size() > 1) {
            this.dealLogInfo(ctx, evaluFormSolutionId, "perf_evaluFormSolution_reverseEnable", true);
        }
    }

    private void dealLogInfo(Context ctx, String evaluFormSolutionId, String logItem, boolean flag) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        EvaluFormSolutionInfo info = EvaluFormSolutionFactory.getLocalInstance(ctx).getEvaluFormSolutionInfo((IObjectPK)new ObjectUuidPK(evaluFormSolutionId), sic);
        StringBuffer retValue = new StringBuffer();
        if (info.getName() != null) {
            retValue.append(info.getName());
        }
        if (flag) {
            retValue.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"120_EvaluFormSolutionFacade"));
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)EvaluFormSolutionFactory.getLocalInstance(ctx).getType(), null, (String)retValue.toString(), (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

