/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvalWFObjectsFactory;
import com.kingdee.eas.hr.perf.EvalWFObjectsInfo;
import com.kingdee.eas.hr.perf.EvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectInfo;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluTargetTypeStoreFactory;
import com.kingdee.eas.hr.perf.ITargetDeploy;
import com.kingdee.eas.hr.perf.ITargetEvaluStore;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetDeployCollection;
import com.kingdee.eas.hr.perf.TargetDeployFactory;
import com.kingdee.eas.hr.perf.TargetDeployInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.app.AbstractEvaluGroupObjectControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EvaluGroupObjectControllerBean
extends AbstractEvaluGroupObjectControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvaluGroupObjectControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!(model instanceof EvaluGroupObjectInfo)) {
            return null;
        }
        EvaluGroupObjectInfo groupObjectInfo = (EvaluGroupObjectInfo)model;
        IObjectPK groupObjectId = super._submit(ctx, model);
        String evaluGroupId = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluGroup.id"));
        sic.add(new SelectorItemInfo("evaluGroup.solutionPeriod"));
        EvaluGroupObjectInfo info = EvaluGroupObjectFactory.getLocalInstance(ctx).getEvaluGroupObjectInfo(groupObjectId, sic);
        evaluGroupId = info.getEvaluGroup().getId().toString();
        HashSet<String> evaluObjectIdSet = new HashSet<String>();
        if (groupObjectInfo.getEvaluObject().getId() != null) {
            evaluObjectIdSet.add(groupObjectInfo.getEvaluObject().getId().toString());
            String solutionPeriodId = info.getEvaluGroup().getSolutionPeriod().getId().toString();
            this.createWorkFlowObject(ctx, evaluGroupId, solutionPeriodId, evaluObjectIdSet);
        }
        return groupObjectId;
    }

    private EntityViewInfo getEntityViewInfo(BOSUuid evaluGroupId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("weight"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.thresholdValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.standardValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.challengeValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.type.id"));
        return evi;
    }

    @Override
    protected void _delete(Context ctx, String solutionPeriodId, String evaluObjectId, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectId));
        fi.getFilterItems().add(new FilterItemInfo("uniteTarget", (Object)Boolean.TRUE, CompareType.EQUALS));
        ITargetEvaluStore evaluStore = TargetEvaluStoreFactory.getLocalInstance(ctx);
        evaluStore.delete(fi);
        super.delete(ctx, pk);
        HashSet<String> eoidSet = new HashSet<String>(1);
        eoidSet.add(evaluObjectId);
        this.deleteWorkFlowObject(ctx, eoidSet, String.valueOf(pk));
    }

    @Override
    protected void _delete(Context ctx, List idList) throws BOSException, EASBizException {
        HashSet<String> spidSet = new HashSet<String>();
        HashSet<String> eoidSet = new HashSet<String>();
        HashSet<String> egoidSet = new HashSet<String>();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            Map map = (Map)idList.get(i);
            String solutionPeriodId = (String)map.get("SPID");
            String evaluObjectId = (String)map.get("EOID");
            String evaluGroupObjectId = (String)map.get("EGOID");
            spidSet.add(solutionPeriodId);
            eoidSet.add(evaluObjectId);
            egoidSet.add(evaluGroupObjectId);
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", spidSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", eoidSet, CompareType.INCLUDE));
        EvaluTargetTypeStoreFactory.getLocalInstance(ctx).delete(fi);
        fi.getFilterItems().add(new FilterItemInfo("uniteTarget", (Object)Boolean.TRUE, CompareType.EQUALS));
        ITargetEvaluStore evaluStore = TargetEvaluStoreFactory.getLocalInstance(ctx);
        evaluStore.delete(fi);
        FilterInfo fi2 = new FilterInfo();
        fi2.getFilterItems().add(new FilterItemInfo("id", egoidSet, CompareType.INCLUDE));
        this._delete(ctx, fi2);
        this.deleteWorkFlowObject(ctx, eoidSet, String.valueOf(egoidSet.toArray()[0]));
    }

    private void deleteWorkFlowObject(Context ctx, Set eoidSet, String egoid) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)egoid) || "null".equals(egoid) || eoidSet == null || eoidSet.isEmpty()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        StringBuffer deleteSql = new StringBuffer("SELECT TOP 1 FEvalWorkFlowID FROM T_PF_TargetDeploy deploy ");
        deleteSql.append(" INNER JOIN T_PF_EvaluGroupObject ego ON deploy.FEvaluGroupID = ego.FEvaluGroupID");
        deleteSql.append(" WHERE ego.FID = ");
        deleteSql.append("'");
        deleteSql.append(egoid);
        deleteSql.append("'");
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)deleteSql.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)eoidSet, CompareType.INCLUDE));
        filter.setMaskString("#0 and #1");
        EvalWFObjectsFactory.getLocalInstance(ctx).delete(filter);
    }

    private void createWorkFlowObject(Context ctx, String evaluGroupId, String solutionPeriodId, Set evaluObjectIdSet) throws BOSException, EASBizException {
        EvalWorkFlowInfo flowInfo;
        if (StringUtils.isEmpty((String)evaluGroupId)) {
            return;
        }
        if (evaluObjectIdSet == null || evaluObjectIdSet.size() == 0) {
            return;
        }
        TargetDeployInfo deployInfo = this.getTargetDeployByEvaluGroup(ctx, evaluGroupId);
        if (deployInfo != null && (flowInfo = deployInfo.getEvalWorkFlow()) != null && flowInfo.getId() != null) {
            CoreBaseCollection wfs = new CoreBaseCollection();
            EvalWFObjectsInfo info = null;
            EvaluObjectInfo evaluObjectInfo = null;
            String evaluObjectId2 = null;
            for (String evaluObjectId2 : evaluObjectIdSet) {
                if (evaluObjectId2 == null) continue;
                evaluObjectInfo = new EvaluObjectInfo();
                evaluObjectInfo.setId(BOSUuid.read((String)evaluObjectId2));
                info = new EvalWFObjectsInfo();
                info.setEvaluObject(evaluObjectInfo);
                info.setEvalWorkFlow(flowInfo);
                info.setStatus(WFStatuEnum.UNUSED);
                wfs.add((CoreBaseInfo)info);
            }
            if (wfs.size() > 0) {
                String sql = "delete from t_pf_evalWFObjects where fid in (select ew.fid from t_pf_evalWFObjects ew inner join t_pf_evaluObject eo on ew.fevaluObjectid = eo.fid inner join t_pf_evalworkflow wf on ew.fevalworkflowid = wf.fid where eo.fid = ? and wf.fsolutionPeriodid = ?) ";
                Connection conn = this.getConnection(ctx);
                PreparedStatement prst = null;
                try {
                    prst = conn.prepareStatement(sql.toString());
                    Iterator iterator = evaluObjectIdSet.iterator();
                    while (iterator.hasNext()) {
                        prst.setString(1, (String)iterator.next());
                        prst.setString(2, solutionPeriodId);
                        prst.addBatch();
                    }
                    prst.executeBatch();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((Statement)prst, (Connection)conn);
                }
                EvalWFObjectsFactory.getLocalInstance(ctx).submit(wfs);
            }
        }
    }

    private TargetDeployInfo getTargetDeployByEvaluGroup(Context ctx, String evaluGroupId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("evalWorkFlow.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupId));
        view.setFilter(filter);
        ITargetDeploy dao = TargetDeployFactory.getLocalInstance(ctx);
        TargetDeployCollection collection = dao.getTargetDeployCollection(view);
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    @Override
    protected Map _submitBatchGroupObject(Context ctx, IObjectCollection evaluGroupObjectCollection) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        HashMap<String, String> map;
        block9: {
            map = new HashMap<String, String>();
            if (evaluGroupObjectCollection == null || evaluGroupObjectCollection.size() <= 0) {
                return map;
            }
            conn = null;
            pstmt = null;
            try {
                String sql = "INSERT INTO T_PF_EvaluGroupObject (FID, FControlUnitID, FEvaluGroupID, FEvaluObjectID) VALUES (?,?,?,?)";
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                String id = null;
                String evaluGroupId = null;
                String evaluObjectId = null;
                EvaluGroupObjectInfo info = null;
                HashSet<String> evaluObjectIdSet = new HashSet<String>(evaluGroupObjectCollection.size());
                int size = evaluGroupObjectCollection.size();
                for (int i = 0; i < size; ++i) {
                    info = (EvaluGroupObjectInfo)evaluGroupObjectCollection.getObject(i);
                    evaluGroupId = info.getEvaluGroup().getId().toString();
                    evaluObjectId = info.getEvaluObject().getId().toString();
                    evaluObjectIdSet.add(info.getEvaluObject().getId().toString());
                    id = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)evaluGroupId);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)evaluObjectId);
                    pstmt.addBatch();
                    map.put(evaluObjectId, id);
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("solutionPeriod.id"));
                sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.id"));
                sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.deliverMode"));
                SolutionPeriodInfo solutionPeriodInfo = EvaluGroupFactory.getLocalInstance(ctx).getEvaluGroupInfo((IObjectPK)new ObjectUuidPK(evaluGroupId), sic).getSolutionPeriod();
                String solutionPeriodId = solutionPeriodInfo.getId().toString();
                this.createWorkFlowObject(ctx, evaluGroupId, solutionPeriodId, evaluObjectIdSet);
                String creatorID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                String controlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                HashMap typeMap = new HashMap();
                boolean isTargetTemplateMode = DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)solutionPeriodInfo.getEvaluSolution().getDeliverMode());
                if (!isTargetTemplateMode) break block9;
                String tmpSql = "INSERT INTO T_PF_EvaluTargetTypeStore (FID,FCreatorID,FCreateTime,FControlUnitID,FSolutionPeriodID,FEvaluGroupTargetTypeID,FDelivered,FEvaluObjectID) values(?,?,?,?,?,?,?,?)";
                pstmt = conn.prepareStatement(tmpSql);
                StringBuffer selectSql = new StringBuffer();
                selectSql.append("SELECT FID,FPerformTargetTypeID FROM T_PF_EvaluGroupTargetType WHERE FEvaluGroupID = '");
                selectSql.append(evaluGroupId).append("'");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
                int executeCount = 0;
                while (rowSet.next()) {
                    String targetTypeID = rowSet.getString("FID");
                    Iterator iterator = evaluObjectIdSet.iterator();
                    HashMap<String, String> storeMap = new HashMap<String, String>();
                    typeMap.put(rowSet.getString("FPerformTargetTypeID"), storeMap);
                    while (iterator.hasNext()) {
                        evaluObjectId = iterator.next().toString();
                        String storeID = BOSUuid.create((String)"9CD98D30").toString();
                        pstmt.setString(1, storeID);
                        storeMap.put(evaluObjectId, storeID);
                        pstmt.setString(2, creatorID);
                        pstmt.setDate(3, new Date(Calendar.getInstance().getTimeInMillis()));
                        pstmt.setString(4, controlUnitID);
                        pstmt.setString(5, solutionPeriodId);
                        pstmt.setString(6, targetTypeID);
                        pstmt.setBoolean(7, false);
                        pstmt.setString(8, evaluObjectId);
                        pstmt.addBatch();
                        if (++executeCount != 1000) continue;
                        pstmt.executeBatch();
                        executeCount = 0;
                    }
                }
                if (executeCount > 0) {
                    pstmt.executeBatch();
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return map;
    }
}

