/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionException;
import com.kingdee.eas.hr.perf.EvaluTargetFactory;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.EvaluTargetTypeStoreCollection;
import com.kingdee.eas.hr.perf.EvaluTargetTypeStoreFactory;
import com.kingdee.eas.hr.perf.EvaluTargetTypeStoreInfo;
import com.kingdee.eas.hr.perf.IEvaluGroupTarget;
import com.kingdee.eas.hr.perf.IEvaluTarget;
import com.kingdee.eas.hr.perf.ITargetEvaluStore;
import com.kingdee.eas.hr.perf.IWorkItem;
import com.kingdee.eas.hr.perf.KindEnum;
import com.kingdee.eas.hr.perf.PerfContractTemplateHelper;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetDeployEntryFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.WorkItemCollection;
import com.kingdee.eas.hr.perf.WorkItemFactory;
import com.kingdee.eas.hr.perf.app.AbstractEvaluGroupTargetControllerBean;
import com.kingdee.eas.hr.perf.app.EvaluSolutionServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EvaluGroupTargetControllerBean
extends AbstractEvaluGroupTargetControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvaluGroupTargetControllerBean");

    @Override
    protected String[] _submitGroupTarget(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!(model instanceof EvaluGroupTargetInfo)) {
            return null;
        }
        EvaluGroupTargetInfo groupTargetInfo = (EvaluGroupTargetInfo)model;
        String evaluGroupId = groupTargetInfo.getEvaluGroup().getId().toString();
        EvaluTargetInfo targetInfo = groupTargetInfo.getEvaluTarget();
        String targetId = EvaluTargetFactory.getLocalInstance(ctx).submit((CoreBaseInfo)targetInfo).toString();
        targetInfo.setId(BOSUuid.read((String)targetId));
        String groupTargetId = super._submit(ctx, model).toString();
        EvaluObjectCollection objectColl = EvaluSolutionServerHelper.getEvaluObjectCollection(ctx, groupTargetInfo.getEvaluGroup().getId().toString());
        HashSet<String> idSet = new HashSet<String>();
        int size = objectColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(objectColl.get(i).getId().toString());
        }
        SolutionPeriodInfo solutionPeriodInfo = EvaluGroupFactory.getLocalInstance(ctx).getEvaluGroupInfo((IObjectPK)new ObjectUuidPK(evaluGroupId)).getSolutionPeriod();
        if (objectColl.size() != 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", idSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodInfo.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("evaluTarget.id", (Object)targetId));
            TargetEvaluStoreFactory.getLocalInstance(ctx).delete(fi);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql2 = "INSERT INTO T_PF_TargetEvaluStore (FID, FWeight, FIsDelivered, FEvaluObjectID, FEvaluTargetID, FSolutionPeriodID, FUniteTarget,FThresholdValue,FStandardValue,FChallengeValue) VALUES (?,?,?,?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql2);
            EvaluObjectInfo info = null;
            int size2 = objectColl.size();
            for (int j = 0; j < size2; ++j) {
                info = (EvaluObjectInfo)objectColl.getObject(j);
                pstmt.setString(1, BOSUuid.create((BOSObjectType)new TargetEvaluStoreInfo().getBOSType()).toString());
                pstmt.setBigDecimal(2, groupTargetInfo.getWeight());
                pstmt.setInt(3, 0);
                pstmt.setString(4, info.getId().toString());
                pstmt.setString(5, targetId);
                pstmt.setString(6, solutionPeriodInfo.getId().toString());
                pstmt.setInt(7, 1);
                if (targetInfo.getThresholdValue() != null) {
                    pstmt.setBigDecimal(8, targetInfo.getThresholdValue());
                } else {
                    pstmt.setNull(8, 3);
                }
                if (targetInfo.getThresholdValue() != null) {
                    pstmt.setBigDecimal(9, targetInfo.getStandardValue());
                } else {
                    pstmt.setNull(9, 3);
                }
                if (targetInfo.getThresholdValue() != null) {
                    pstmt.setBigDecimal(10, targetInfo.getChallengeValue());
                } else {
                    pstmt.setNull(10, 3);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return new String[]{targetId, groupTargetId};
    }

    @Override
    protected void _delete(Context ctx, String solutionPeriodId, String evaluTargetId, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluTarget", (Object)evaluTargetId, CompareType.EQUALS));
        IWorkItem iWorkItem = WorkItemFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        WorkItemCollection coll = iWorkItem.getWorkItemCollection(evi);
        if (coll.size() > 0) {
            throw new EvaluSolutionException(EvaluSolutionException.CAN_NOT_DEL_EVALUTARGET);
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("evaluTarget.id", (Object)evaluTargetId));
        ITargetEvaluStore evaluStore = TargetEvaluStoreFactory.getLocalInstance(ctx);
        evaluStore.delete(fi);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluTarget", (Object)evaluTargetId, CompareType.EQUALS));
        TargetDeployEntryFactory.getLocalInstance(ctx).delete(filter);
        super.delete(ctx, pk);
        IEvaluTarget evaluTarget = EvaluTargetFactory.getLocalInstance(ctx);
        evaluTarget.delete((IObjectPK)new ObjectUuidPK(evaluTargetId));
    }

    @Override
    protected void _delete(Context ctx, List idList) throws BOSException, EASBizException {
        HashSet<String> spidSet = new HashSet<String>();
        HashSet<String> etidSet = new HashSet<String>();
        HashSet<String> egtidSet = new HashSet<String>();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            Map map = (Map)idList.get(i);
            String solutionPeriodId = (String)map.get("SPID");
            String evaluTargetId = (String)map.get("ETID");
            String evaluGroupTargetId = (String)map.get("EGTID");
            spidSet.add(solutionPeriodId);
            etidSet.add(evaluTargetId);
            egtidSet.add(evaluGroupTargetId);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluTarget", etidSet, CompareType.INCLUDE));
        IWorkItem iWorkItem = WorkItemFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        WorkItemCollection coll = iWorkItem.getWorkItemCollection(evi);
        if (coll.size() > 0) {
            throw new EvaluSolutionException(EvaluSolutionException.CAN_NOT_DEL_EVALUTARGET);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fevalutargetid from t_pf_targetevalustore where fsolutionperiodid in (");
        sql.append(PerfUtils.convertSetToString(spidSet));
        sql.append(") and (fdeleteableByUndeliver is null or fdeleteableByUndeliver = 0)");
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        IEvaluTarget evaluTarget = EvaluTargetFactory.getLocalInstance(ctx);
        evaluTarget.delete(filter);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", spidSet, CompareType.INCLUDE));
        ITargetEvaluStore evaluStore = TargetEvaluStoreFactory.getLocalInstance(ctx);
        evaluStore.delete(filter);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluTarget", etidSet, CompareType.INCLUDE));
        TargetDeployEntryFactory.getLocalInstance(ctx).delete(filter);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", egtidSet, CompareType.INCLUDE));
        this._delete(ctx, filter);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", etidSet, CompareType.INCLUDE));
        evaluTarget.delete(filter);
    }

    @Override
    protected Map _submitBatchGroupTarget(Context ctx, IObjectCollection evaluGroupTargetCollection) throws BOSException, EASBizException {
        HashMap idMap = new HashMap();
        HashMap<BOSUuid, String> targetIDMap = new HashMap<BOSUuid, String>();
        HashMap<BOSUuid, String> groupTargetIDMap = new HashMap<BOSUuid, String>();
        idMap.put("TargetID", targetIDMap);
        idMap.put("GroupTargetID", groupTargetIDMap);
        Connection conn = null;
        PreparedStatement pstmt = null;
        String evaluGroupId = null;
        String solutionPeriodId = null;
        try {
            int i;
            conn = this.getConnection(ctx);
            String sql = "INSERT INTO T_PF_EvaluTarget (FID, FControlUnitID, FContent2, FStandard2, FDescription, FKind, FThresholdValue, FStandardValue, FChallengeValue, FUnit, FReportFrequency, FScoringMethod, FEvaluationSide, FReservedField1, FReservedField2, FTypeID, FNumber, FTargetType, FSolutionPeriodID, FTargetID,FDataPrecision,FPrecisionType,FFormulaID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql);
            EvaluGroupTargetInfo groupTargetInfo = null;
            for (int i2 = 0; i2 < evaluGroupTargetCollection.size(); ++i2) {
                groupTargetInfo = (EvaluGroupTargetInfo)evaluGroupTargetCollection.getObject(i2);
                if (evaluGroupId == null) {
                    evaluGroupId = groupTargetInfo.getEvaluGroup().getId().toString();
                }
                if (solutionPeriodId == null) {
                    solutionPeriodId = EvaluGroupFactory.getLocalInstance(ctx).getEvaluGroupInfo((IObjectPK)new ObjectUuidPK(evaluGroupId)).getSolutionPeriod().getId().toString();
                }
                EvaluTargetInfo targetInfo = groupTargetInfo.getEvaluTarget();
                String evaluTargetId = BOSUuid.create((BOSObjectType)targetInfo.getBOSType()).toString();
                targetIDMap.put(targetInfo.getTargetID(), evaluTargetId);
                targetInfo.setId(BOSUuid.read((String)evaluTargetId));
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)evaluTargetId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                pstmt.setString(3, targetInfo.getContent());
                pstmt.setString(4, targetInfo.getStandard());
                pstmt.setString(5, targetInfo.getDescription());
                if (targetInfo.getKind() != null) {
                    pstmt.setInt(6, targetInfo.getKind().getValue());
                } else {
                    pstmt.setInt(6, 10);
                }
                boolean isPercent = KindEnum.QUANTITATIVE2.equals((Object)targetInfo.getKind());
                BigDecimal per = new BigDecimal("0.01");
                if (targetInfo.getThresholdValue() != null) {
                    if (isPercent) {
                        pstmt.setBigDecimal(7, targetInfo.getThresholdValue().multiply(per));
                    } else {
                        pstmt.setBigDecimal(7, targetInfo.getThresholdValue());
                    }
                } else {
                    pstmt.setString(7, null);
                }
                if (targetInfo.getStandardValue() != null) {
                    if (isPercent) {
                        pstmt.setBigDecimal(8, targetInfo.getStandardValue().multiply(per));
                    } else {
                        pstmt.setBigDecimal(8, targetInfo.getStandardValue());
                    }
                } else {
                    pstmt.setString(8, null);
                }
                if (targetInfo.getChallengeValue() != null) {
                    if (isPercent) {
                        pstmt.setBigDecimal(9, targetInfo.getChallengeValue().multiply(per));
                    } else {
                        pstmt.setBigDecimal(9, targetInfo.getChallengeValue());
                    }
                } else {
                    pstmt.setString(9, null);
                }
                pstmt.setString(10, targetInfo.getUnit());
                if (targetInfo.getReportFrequency() != null) {
                    pstmt.setInt(11, targetInfo.getReportFrequency().getValue());
                } else {
                    pstmt.setString(11, null);
                }
                pstmt.setString(12, targetInfo.getScoringMethod());
                pstmt.setString(13, targetInfo.getEvaluationSide());
                pstmt.setString(14, targetInfo.getReservedField1());
                if (targetInfo.getReservedField2() != null) {
                    if (isPercent) {
                        pstmt.setBigDecimal(15, targetInfo.getReservedField2().multiply(per));
                    } else {
                        pstmt.setBigDecimal(15, targetInfo.getReservedField2());
                    }
                } else {
                    pstmt.setString(15, null);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)16, (String)targetInfo.getType().getId().toString());
                pstmt.setString(17, targetInfo.getNumber());
                pstmt.setInt(18, 100);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)19, (String)solutionPeriodId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)20, (String)targetInfo.getTargetID().toString());
                pstmt.setInt(21, targetInfo.getDataPrecision());
                if (targetInfo.getPrecisionType() != null) {
                    pstmt.setInt(22, targetInfo.getPrecisionType().getValue());
                } else {
                    pstmt.setInt(22, 10);
                }
                if (targetInfo.getFormula() != null) {
                    pstmt.setString(23, targetInfo.getFormula().getId().toString());
                } else {
                    pstmt.setString(23, null);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            Map evaluTargetTypeStoreMap = this.getEvaluTargetTypeStoreMap(ctx, solutionPeriodId);
            String sql2 = "INSERT INTO T_PF_EvaluGroupTarget (FID, FControlUnitID, FWeight, FEvaluGroupID, FEvaluTargetID) VALUES (?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql2);
            for (int i3 = 0; i3 < evaluGroupTargetCollection.size(); ++i3) {
                groupTargetInfo = (EvaluGroupTargetInfo)evaluGroupTargetCollection.getObject(i3);
                if (evaluGroupId == null) {
                    evaluGroupId = groupTargetInfo.getEvaluGroup().getId().toString();
                }
                if (solutionPeriodId == null) {
                    solutionPeriodId = EvaluGroupFactory.getLocalInstance(ctx).getEvaluGroupInfo((IObjectPK)new ObjectUuidPK(evaluGroupId)).getSolutionPeriod().getId().toString();
                }
                String groupTargetId = BOSUuid.create((BOSObjectType)groupTargetInfo.getBOSType()).toString();
                groupTargetIDMap.put(groupTargetInfo.getEvaluTarget().getTargetID(), groupTargetId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)groupTargetId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                pstmt.setBigDecimal(3, groupTargetInfo.getWeight());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)evaluGroupId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)groupTargetInfo.getEvaluTarget().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            EvaluObjectCollection objectColl = EvaluSolutionServerHelper.getEvaluObjectCollection(ctx, groupTargetInfo.getEvaluGroup().getId().toString());
            HashSet<String> idSet = new HashSet<String>();
            int size = objectColl.size();
            for (i = 0; i < size; ++i) {
                idSet.add(objectColl.get(i).getId().toString());
            }
            if (objectColl.size() != 0) {
                for (i = 0; i < evaluGroupTargetCollection.size(); ++i) {
                    groupTargetInfo = (EvaluGroupTargetInfo)evaluGroupTargetCollection.getObject(i);
                    FilterInfo fi = new FilterInfo();
                    fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", idSet, CompareType.INCLUDE));
                    fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
                    fi.getFilterItems().add(new FilterItemInfo("evaluTarget.id", (Object)groupTargetInfo.getEvaluTarget().getId().toString()));
                    TargetEvaluStoreFactory.getLocalInstance(ctx).delete(fi);
                }
            }
            String sql3 = "INSERT INTO T_PF_TargetEvaluStore (FID, FCreatorID, FCreateTime, FControlUnitID, FWeight, FIsDelivered, FEvaluObjectID, FEvaluTargetID, FSolutionPeriodID, FHROrgUnitID, FUniteTarget,FThresholdValue,FStandardValue,FChallengeValue,FEvaluTargetStoreTypeID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql3);
            EvaluObjectInfo info = null;
            EvaluTargetInfo targetInfo = null;
            for (int i4 = 0; i4 < evaluGroupTargetCollection.size(); ++i4) {
                groupTargetInfo = (EvaluGroupTargetInfo)evaluGroupTargetCollection.getObject(i4);
                targetInfo = groupTargetInfo.getEvaluTarget();
                if (targetInfo == null) continue;
                int size2 = objectColl.size();
                for (int j = 0; j < size2; ++j) {
                    info = (EvaluObjectInfo)objectColl.getObject(j);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)BOSUuid.create((BOSObjectType)new TargetEvaluStoreInfo().getBOSType()).toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                    pstmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    pstmt.setBigDecimal(5, groupTargetInfo.getWeight() == null ? new BigDecimal("0") : groupTargetInfo.getWeight());
                    pstmt.setInt(6, 0);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)7, (String)info.getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)groupTargetInfo.getEvaluTarget().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)9, (String)solutionPeriodId);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)10, (String)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
                    pstmt.setInt(11, 1);
                    if (targetInfo.getThresholdValue() != null) {
                        pstmt.setBigDecimal(12, targetInfo.getThresholdValue());
                    } else {
                        pstmt.setNull(12, 3);
                    }
                    if (targetInfo.getThresholdValue() != null) {
                        pstmt.setBigDecimal(13, targetInfo.getStandardValue());
                    } else {
                        pstmt.setNull(13, 3);
                    }
                    if (targetInfo.getThresholdValue() != null) {
                        pstmt.setBigDecimal(14, targetInfo.getChallengeValue());
                    } else {
                        pstmt.setNull(14, 3);
                    }
                    if (evaluTargetTypeStoreMap != null && evaluTargetTypeStoreMap.size() > 0) {
                        if (evaluTargetTypeStoreMap.get(info.getId().toString() + targetInfo.getType().getId().toString()) != null) {
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)15, (String)((String)evaluTargetTypeStoreMap.get(info.getId().toString() + targetInfo.getType().getId().toString())));
                        } else {
                            pstmt.setString(15, null);
                        }
                    } else {
                        pstmt.setString(15, null);
                    }
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return idMap;
    }

    private Map getEvaluTargetTypeStoreMap(Context ctx, String solutionPeriodId) throws BOSException {
        HashMap<String, String> evaluTargetTypeStoreMap = new HashMap<String, String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("evaluGroupTargetType.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluGroupTargetType.performTargetType.*"));
        evi.getSelector().add(new SelectorItemInfo("evaluGroupTargetType.evaluGroup.*"));
        evi.getSelector().add(new SelectorItemInfo("solutionPeriod.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluObject.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluObject.name"));
        EvaluTargetTypeStoreCollection evaluTargetTypeStoreCollection = EvaluTargetTypeStoreFactory.getLocalInstance(ctx).getEvaluTargetTypeStoreCollection(evi);
        for (int i = 0; i < evaluTargetTypeStoreCollection.size(); ++i) {
            EvaluTargetTypeStoreInfo evaluTargetTypeStoreInfo = evaluTargetTypeStoreCollection.get(i);
            evaluTargetTypeStoreMap.put(evaluTargetTypeStoreInfo.getEvaluObject().getId().toString() + evaluTargetTypeStoreInfo.getEvaluGroupTargetType().getPerformTargetType().getId().toString(), evaluTargetTypeStoreInfo.getId().toString());
        }
        return evaluTargetTypeStoreMap;
    }

    @Override
    protected void _updateWeight(Context ctx, Map weightMap) throws BOSException, EASBizException {
        Iterator it = weightMap.keySet().iterator();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            String sql = "UPDATE  T_PF_TargetEvaluStore SET FWeight = ? WHERE FEvaluTargetID = ?";
            pstmt = conn.prepareStatement(sql);
            while (it.hasNext()) {
                String evaluTargetId = (String)it.next();
                BigDecimal weight = (BigDecimal)weightMap.get(evaluTargetId);
                pstmt.setBigDecimal(1, weight == null ? new BigDecimal("0") : weight);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluTargetId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql2 = "UPDATE  T_PF_EvaluGroupTarget SET FWeight = ? WHERE FEvaluTargetID = ?";
            pstmt = conn.prepareStatement(sql2);
            for (String evaluTargetId : weightMap.keySet()) {
                BigDecimal weight = (BigDecimal)weightMap.get(evaluTargetId);
                pstmt.setBigDecimal(1, weight == null ? new BigDecimal("0") : weight);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluTargetId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _submitBatchEvaluGroupTarget(Context ctx, String evaluGroupID, IObjectCollection evaluGroupTargetColl) throws BOSException, EASBizException {
        FilterInfo filterInfo;
        CoreBaseCollection updateEvaluGroupTargetColl = new CoreBaseCollection();
        CoreBaseCollection updateEvaluTargetColl = new CoreBaseCollection();
        HashSet<String> updateEvaluGroupTargetIDS = new HashSet<String>();
        HashSet<String> updateEvaluTargetIDS = new HashSet<String>();
        EvaluGroupTargetInfo evaluGroupTargetInfo = null;
        EvaluTargetInfo evaluTargetInfo = null;
        EvaluGroupInfo evaluGroupInfo = new EvaluGroupInfo();
        evaluGroupInfo.setId(BOSUuid.read((String)evaluGroupID));
        for (int i = 0; i < evaluGroupTargetColl.size(); ++i) {
            evaluGroupTargetInfo = (EvaluGroupTargetInfo)evaluGroupTargetColl.getObject(i);
            evaluGroupTargetInfo.setEvaluGroup(evaluGroupInfo);
            evaluTargetInfo = evaluGroupTargetInfo.getEvaluTarget();
            if (evaluGroupTargetInfo.getId() != null) {
                updateEvaluGroupTargetIDS.add(evaluGroupTargetInfo.getId().toString());
            }
            if (evaluTargetInfo.getId() != null) {
                updateEvaluTargetIDS.add(evaluTargetInfo.getId().toString());
            } else {
                evaluTargetInfo.setId(BOSUuid.create((BOSObjectType)evaluTargetInfo.getBOSType()));
            }
            updateEvaluGroupTargetColl.add((CoreBaseInfo)evaluGroupTargetInfo);
            updateEvaluTargetColl.add((CoreBaseInfo)evaluTargetInfo);
        }
        HashSet<String> deleteEvaluGroupTargetIDS = new HashSet<String>();
        HashSet<String> deleteEvaluTargetIDS = new HashSet<String>();
        EvaluGroupTargetCollection oldEvaluGroupTargetCollection = PerfContractTemplateHelper.getEvaluGroupTargetCollectionByGroupId(evaluGroupID, ctx);
        for (int i = 0; i < oldEvaluGroupTargetCollection.size(); ++i) {
            evaluGroupTargetInfo = oldEvaluGroupTargetCollection.get(i);
            evaluTargetInfo = evaluGroupTargetInfo.getEvaluTarget();
            if (!updateEvaluGroupTargetIDS.contains(evaluGroupTargetInfo.getId().toString())) {
                deleteEvaluGroupTargetIDS.add(evaluGroupTargetInfo.getId().toString());
            }
            if (updateEvaluTargetIDS.contains(evaluTargetInfo.getId().toString())) continue;
            deleteEvaluTargetIDS.add(evaluTargetInfo.getId().toString());
        }
        IEvaluGroupTarget iEvaluGroupTarget = EvaluGroupTargetFactory.getLocalInstance(ctx);
        IEvaluTarget iEvaluTarget = EvaluTargetFactory.getLocalInstance(ctx);
        if (deleteEvaluGroupTargetIDS.size() > 0) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", deleteEvaluGroupTargetIDS, CompareType.INCLUDE));
            iEvaluGroupTarget.delete(filterInfo);
        }
        if (deleteEvaluTargetIDS.size() > 0) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", deleteEvaluTargetIDS, CompareType.INCLUDE));
            iEvaluTarget.delete(filterInfo);
        }
        iEvaluGroupTarget.save(updateEvaluGroupTargetColl);
        iEvaluTarget.save(updateEvaluTargetColl);
        evaluGroupInfo.setSavedTemplateTarget(true);
        EvaluGroupFactory.getLocalInstance(ctx).save((CoreBaseInfo)evaluGroupInfo);
    }

    protected void _deleteBySolutionPeriod(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        String sql = "select fid from t_pf_evalugroup where fsolutionperiodid = '" + solutionPeriodId + "'";
        FilterInfo evaluTargetFI = new FilterInfo();
        evaluTargetFI.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)sql, CompareType.INCLUDE));
        EvaluTargetFactory.getLocalInstance(ctx).delete(evaluTargetFI);
    }
}

