/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupObjectCollection;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeInfo;
import com.kingdee.eas.hr.perf.EvaluTargetTypeStoreCollection;
import com.kingdee.eas.hr.perf.EvaluTargetTypeStoreFactory;
import com.kingdee.eas.hr.perf.IEvaluTargetTypeStore;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.app.AbstractEvaluGroupTargetTypeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EvaluGroupTargetTypeControllerBean
extends AbstractEvaluGroupTargetTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvaluGroupTargetTypeControllerBean");

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("weight"));
        evi.getSelector().add(new SelectorItemInfo("evaluGroup.id"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.parent.id"));
        EvaluGroupTargetTypeCollection typeColl = this.getEvaluGroupTargetTypeCollection(ctx, evi);
        EvaluGroupTargetTypeCollection updateWeightColl = this.getNeedUpdateWeightTypeCollection(typeColl);
        EvaluGroupTargetTypeInfo typeInfo = null;
        int size = updateWeightColl.size();
        for (int i = 0; i < size; ++i) {
            typeInfo = updateWeightColl.get(i);
            if (typeInfo.getPerformTargetType().getParent() == null) continue;
            String typeId = typeInfo.getPerformTargetType().getId().toString();
            String parentId = typeInfo.getPerformTargetType().getParent().getId().toString();
            BigDecimal weight = typeInfo.getWeight();
            String evaluGroupId = typeInfo.getEvaluGroup().getId().toString();
            this.updateParentWeight(ctx, parentId, evaluGroupId, weight == null ? new BigDecimal("0") : weight);
        }
        HashSet<String> idSet = new HashSet<String>();
        int len = typeColl.size();
        for (int i = 0; i < len; ++i) {
            idSet.add(typeColl.get(i).getId().toString());
        }
        if (idSet != null && idSet.size() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("evaluGroupTargetType", idSet, CompareType.INCLUDE));
            evi = new EntityViewInfo();
            evi.setFilter(fi);
            IEvaluTargetTypeStore typeStore = EvaluTargetTypeStoreFactory.getLocalInstance(ctx);
            EvaluTargetTypeStoreCollection targetTypeColl = typeStore.getEvaluTargetTypeStoreCollection(evi);
            if (targetTypeColl != null && targetTypeColl.size() > 0) {
                HashSet<String> typeIds = new HashSet<String>();
                int len2 = typeColl.size();
                for (int i = 0; i < len2; ++i) {
                    typeIds.add(typeColl.get(i).getId().toString());
                }
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("evaluTargetStoreType", typeIds, CompareType.INCLUDE));
                TargetEvaluStoreFactory.getLocalInstance(ctx).delete(fi);
            }
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("evaluGroupTargetType", idSet, CompareType.INCLUDE));
            typeStore.delete(fi);
        }
        return super._delete(ctx, filter);
    }

    private EvaluGroupTargetTypeCollection getNeedUpdateWeightTypeCollection(EvaluGroupTargetTypeCollection typeColl) {
        EvaluGroupTargetTypeCollection updateWeightColl = new EvaluGroupTargetTypeCollection();
        EvaluGroupTargetTypeInfo typeInfo = null;
        int size = typeColl.size();
        for (int i = 0; i < size; ++i) {
            typeInfo = typeColl.get(i);
            String typeId = typeInfo.getPerformTargetType().getId().toString();
            if (this.isHaveParentTargetType(typeId, typeColl)) continue;
            updateWeightColl.add(typeInfo);
        }
        return updateWeightColl;
    }

    private boolean isHaveParentTargetType(String typeId, EvaluGroupTargetTypeCollection typeColl) {
        EvaluGroupTargetTypeInfo typeInfo = null;
        int size = typeColl.size();
        for (int i = 0; i < size; ++i) {
            typeInfo = typeColl.get(i);
            if (typeInfo.getPerformTargetType().getParent() == null) {
                return false;
            }
            String parentId = typeInfo.getPerformTargetType().getParent().getId().toString();
            if (!typeId.equals(parentId)) continue;
            return true;
        }
        return false;
    }

    private void updateParentWeight(Context ctx, String parentId, String evaluGroupId, BigDecimal weight) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("performTargetType.id", (Object)parentId));
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("weight"));
        evi.getSelector().add(new SelectorItemInfo("evaluGroup.id"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.parent.id"));
        EvaluGroupTargetTypeCollection typeColl = this.getEvaluGroupTargetTypeCollection(ctx, evi);
        if (typeColl != null && typeColl.size() != 0) {
            EvaluGroupTargetTypeInfo typeInfo;
            typeInfo.setWeight(((typeInfo = typeColl.get(0)).getWeight() == null ? new BigDecimal("0") : typeInfo.getWeight()).subtract(weight));
            this.submit(ctx, (CoreBaseInfo)typeInfo);
            if (typeInfo.getPerformTargetType().getParent() != null) {
                this.updateParentWeight(ctx, typeInfo.getPerformTargetType().getParent().getId().toString(), evaluGroupId, weight);
            }
        }
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        if (!(model instanceof EvaluGroupTargetTypeInfo)) {
            return null;
        }
        EvaluGroupTargetTypeInfo typeInfo = (EvaluGroupTargetTypeInfo)model;
        if (typeInfo.getId() == null) {
            BOSUuid id = BOSUuid.create((BOSObjectType)typeInfo.getBOSType());
            typeInfo.setId(id);
            String groupId = typeInfo.getEvaluGroup().getId().toString();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("solutionPeriod.id"));
            selector.add(new SelectorItemInfo("solutionPeriod.evaluSolution.id"));
            selector.add(new SelectorItemInfo("solutionPeriod.evaluSolution.deliverMode"));
            EvaluGroupInfo group = EvaluGroupFactory.getLocalInstance(ctx).getEvaluGroupInfo((IObjectPK)new ObjectUuidPK(groupId), selector);
            if (DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)group.getSolutionPeriod().getEvaluSolution().getDeliverMode())) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("evaluGroup", (Object)groupId));
                evi.setFilter(fi);
                evi.getSelector().add(new SelectorItemInfo("id"));
                evi.getSelector().add(new SelectorItemInfo("evaluGroup.id"));
                evi.getSelector().add(new SelectorItemInfo("evaluObject.id"));
                EvaluGroupObjectCollection evaluGroupObjects = EvaluGroupObjectFactory.getLocalInstance(ctx).getEvaluGroupObjectCollection(evi);
                if (evaluGroupObjects != null && evaluGroupObjects.size() > 0) {
                    Connection conn = this.getConnection(ctx);
                    PreparedStatement pstmt = null;
                    try {
                        String insertSql = "INSERT INTO T_PF_EvaluTargetTypeStore(FID,FSolutionPeriodID,FDelivered,FEvaluObjectID,FEvaluGroupTargetTypeID) VALUES(?,?,?,?,?)";
                        pstmt = conn.prepareStatement(insertSql);
                        String solutionPeriodID = group.getSolutionPeriod().getId().toString();
                        int len = evaluGroupObjects.size();
                        for (int i = 0; i < len; ++i) {
                            pstmt.setString(1, BOSUuid.create((String)"9CD98D30").toString());
                            pstmt.setString(2, solutionPeriodID);
                            pstmt.setBoolean(3, false);
                            pstmt.setString(4, evaluGroupObjects.get(i).getEvaluObject().getId().toString());
                            pstmt.setString(5, id.toString());
                            pstmt.addBatch();
                        }
                        pstmt.executeBatch();
                        pstmt.close();
                    }
                    catch (SQLException e) {
                        try {
                            throw new BOSException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(pstmt, (Connection)conn);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                }
            }
        }
        return super._submit(ctx, (IObjectValue)model);
    }
}

