/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.AchieveDataPermissionCollection;
import com.kingdee.eas.hr.perf.AchieveDataPermissionEntryCollection;
import com.kingdee.eas.hr.perf.AchieveDataPermissionEntryInfo;
import com.kingdee.eas.hr.perf.AchieveDataPermissionInfo;
import com.kingdee.eas.hr.perf.EvalWFObjectsFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionException;
import com.kingdee.eas.hr.perf.EvaluSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.IEvalWFObjects;
import com.kingdee.eas.hr.perf.IEvaluGroupObject;
import com.kingdee.eas.hr.perf.ITargetEvaluStore;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.TargetDelivererCollection;
import com.kingdee.eas.hr.perf.TargetDelivererInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.app.AbstractEvaluObjectControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EvaluObjectControllerBean
extends AbstractEvaluObjectControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvaluObjectControllerBean");

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        if (EvaluSolutionFacadeFactory.getLocalInstance(ctx).isEvaluObjectRefered(pk.toString())) {
            throw new EvaluSolutionException(EvaluSolutionException.CAN_NOT_DEL_EVALU_OBJECT);
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)pk.toString()));
        IEvaluGroupObject evaluGroupObject = EvaluGroupObjectFactory.getLocalInstance(ctx);
        evaluGroupObject.delete(fi);
        ITargetEvaluStore evaluStore = TargetEvaluStoreFactory.getLocalInstance(ctx);
        evaluStore.delete(fi);
        IEvalWFObjects evalWFObjects = EvalWFObjectsFactory.getLocalInstance(ctx);
        evalWFObjects.delete(fi);
        super._delete(ctx, pk);
    }

    @Override
    protected Map _submitBatchEvaluObject(Context ctx, IObjectCollection evaluObjectCollection) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Locale locale = ctx.getLocale();
            locale.getDisplayName();
            String sql = "INSERT INTO T_PF_EvaluObject (FID, FControlUnitID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FEvaluObjectType, FObjectID, FResponserID, FEvaluSolutionID, FPositionID,FAppointPerson,FOneself,FSuperior,FCreateTime) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            EvaluObjectInfo info = null;
            String id = null;
            String name = null;
            String sname = null;
            String tname = null;
            String description = null;
            String sdescription = null;
            String tdescription = null;
            int size = evaluObjectCollection.size();
            for (int i = 0; i < size; ++i) {
                info = (EvaluObjectInfo)evaluObjectCollection.getObject(i);
                name = info.getName();
                sname = STConverter.tc2sc((String)name);
                tname = STConverter.sc2tc((String)name);
                description = info.getDescription();
                if (StringUtils.isEmpty((String)description)) {
                    description = "";
                }
                sdescription = STConverter.tc2sc((String)description);
                tdescription = STConverter.sc2tc((String)description);
                id = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                info.setId(BOSUuid.read((String)id));
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                pstmt.setString(3, name);
                pstmt.setString(4, name);
                pstmt.setString(5, tname);
                pstmt.setString(6, info.getNumber());
                pstmt.setString(7, description);
                pstmt.setString(8, description);
                pstmt.setString(9, tdescription);
                if (info.getSimpleName() != null) {
                    pstmt.setString(10, info.getSimpleName());
                } else {
                    pstmt.setString(10, null);
                }
                pstmt.setInt(11, info.getEvaluObjectType().getValue());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)12, (String)info.getObjectID());
                pstmt.setString(13, info.getResponser() == null ? null : info.getResponser().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)14, (String)info.getEvaluSolution().getId().toString());
                pstmt.setString(15, info.getPosition() == null ? null : info.getPosition().getId().toString());
                pstmt.setInt(16, info.isAppointPerson() ? 1 : 0);
                pstmt.setInt(17, info.isOneself() ? 1 : 0);
                pstmt.setInt(18, info.isSuperior() ? 1 : 0);
                pstmt.setTimestamp(19, info.getCreateTime());
                pstmt.addBatch();
                map.put(info.getObjectID(), id);
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql2 = "INSERT INTO T_PF_TargetDeliverer (FID, FControlUnitID, FPersonID, FEvaluObjectID) VALUES (?,?,?,?)";
            pstmt = conn.prepareStatement(sql2);
            TargetDelivererInfo delivererInfo = null;
            int size2 = evaluObjectCollection.size();
            for (int i = 0; i < size2; ++i) {
                info = (EvaluObjectInfo)evaluObjectCollection.getObject(i);
                TargetDelivererCollection delivererColl = info.getTargetDeliverers();
                int size22 = delivererColl.size();
                for (int j = 0; j < size22; ++j) {
                    delivererInfo = delivererColl.get(j);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)BOSUuid.create((BOSObjectType)delivererInfo.getBOSType()).toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)delivererInfo.getPerson().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getId().toString());
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
            String sql3 = "insert into T_PF_AchPermission (FID, FSolutionID, FObjId, FIncludeSelf, FIncludeSuperior, FEvaluObjectID) VALUES (?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql3);
            String sql4 = "insert into T_PF_AchPermEntry (FID, FSeq, FParentID, FPersonID, FPositionID) VALUES (?,?,?,?,?)";
            PreparedStatement entryPstmt = conn.prepareStatement(sql4);
            AchieveDataPermissionCollection achDataPermissionColl = null;
            AchieveDataPermissionInfo achDataPermissionInfo = null;
            AchieveDataPermissionEntryCollection entryColl = null;
            AchieveDataPermissionEntryInfo entry = null;
            String parentId = null;
            BOSObjectType permissionType = new AchieveDataPermissionInfo().getBOSType();
            BOSObjectType entryType = new AchieveDataPermissionEntryInfo().getBOSType();
            int size3 = evaluObjectCollection.size();
            for (int i = 0; i < size3; ++i) {
                info = (EvaluObjectInfo)evaluObjectCollection.getObject(i);
                achDataPermissionColl = info.getAchDataPermissions();
                int count = achDataPermissionColl.size();
                for (int j = 0; j < count; ++j) {
                    achDataPermissionInfo = achDataPermissionColl.get(j);
                    achDataPermissionInfo.setEvaluObject(info);
                    parentId = BOSUuid.create((BOSObjectType)permissionType).toString();
                    achDataPermissionInfo.setId(BOSUuid.read((String)parentId));
                    achDataPermissionInfo.setObjId(info.getObjectID());
                    achDataPermissionInfo.setSolution(info.getEvaluSolution());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)parentId);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)info.getEvaluSolution().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getObjectID());
                    pstmt.setBoolean(4, achDataPermissionInfo.isIncludeSelf());
                    pstmt.setBoolean(5, achDataPermissionInfo.isIncludeSuperior());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)6, (String)info.getId().toString());
                    pstmt.addBatch();
                    entryColl = achDataPermissionInfo.getEntry();
                    int k = entryColl.size();
                    for (int m = 0; m < k; ++m) {
                        entry = entryColl.get(m);
                        DbUtil.prepareVarcharParam((PreparedStatement)entryPstmt, (int)1, (String)BOSUuid.create((BOSObjectType)entryType).toString());
                        entryPstmt.setInt(2, m + 1);
                        DbUtil.prepareVarcharParam((PreparedStatement)entryPstmt, (int)3, (String)parentId);
                        if (entry.getPerson() != null) {
                            DbUtil.prepareVarcharParam((PreparedStatement)entryPstmt, (int)4, (String)entry.getPerson().getId().toString());
                        } else {
                            entryPstmt.setNull(4, 12);
                        }
                        if (entry.getPosition() != null) {
                            DbUtil.prepareVarcharParam((PreparedStatement)entryPstmt, (int)5, (String)entry.getPosition().getId().toString());
                        } else {
                            entryPstmt.setNull(5, 12);
                        }
                        entryPstmt.addBatch();
                    }
                }
            }
            pstmt.executeBatch();
            entryPstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return map;
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<String> canNotDelIdList;
        block9: {
            HashSet<String> delIDSet = new HashSet<String>();
            canNotDelIdList = new ArrayList<String>();
            Set referedIDSet = EvaluSolutionFacadeFactory.getLocalInstance(ctx).getReferedEvaluObjectIDSet(idSet, SolutionPeriodStatusEnum.ON_EVALU);
            Set endIDSet = EvaluSolutionFacadeFactory.getLocalInstance(ctx).getReferedEvaluObjectIDSet(idSet, SolutionPeriodStatusEnum.END_EVALU);
            endIDSet.removeAll(referedIDSet);
            Iterator it = idSet.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                if (referedIDSet.contains(id)) {
                    canNotDelIdList.add(id);
                    continue;
                }
                if (endIDSet.contains(id)) continue;
                delIDSet.add(id);
            }
            if (delIDSet.size() != 0) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", delIDSet, CompareType.INCLUDE));
                IEvaluGroupObject evaluGroupObject = EvaluGroupObjectFactory.getLocalInstance(ctx);
                evaluGroupObject.delete(fi);
                ITargetEvaluStore evaluStore = TargetEvaluStoreFactory.getLocalInstance(ctx);
                evaluStore.delete(fi);
                IEvalWFObjects evalWFObjects = EvalWFObjectsFactory.getLocalInstance(ctx);
                evalWFObjects.delete(fi);
                FilterInfo fi2 = new FilterInfo();
                fi2.getFilterItems().add(new FilterItemInfo("id", delIDSet, CompareType.INCLUDE));
                super._delete(ctx, fi2);
            }
            if (endIDSet.size() <= 0) break block9;
            String sql = "UPDATE T_PF_EvaluObject SET FDELETED = 1 WHERE FID = ?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                Iterator iter = endIDSet.iterator();
                while (iter.hasNext()) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)iter.next().toString());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BOSException(ex.getMessage(), ex.getCause());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)endIDSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.status", (Object)new Integer(100)));
            EvalWFObjectsFactory.getLocalInstance(ctx).delete(filter);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)endIDSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.status", (Object)new Integer(100)));
            TargetEvaluStoreFactory.getLocalInstance(ctx).delete(filter);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)endIDSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("evaluGroup.solutionPeriod.status", (Object)new Integer(100)));
            EvaluGroupObjectFactory.getLocalInstance(ctx).delete(filter);
        }
        ObjectUuidPK[] pk = new ObjectUuidPK[canNotDelIdList.size()];
        int size = canNotDelIdList.size();
        for (int i = 0; i < size; ++i) {
            pk[i] = new ObjectUuidPK((String)canNotDelIdList.get(i));
        }
        return pk;
    }

    @Override
    protected void _saveResponser(Context ctx, String objectId, String responserId) throws BOSException, EASBizException {
        String sql = "UPDATE  T_PF_EVALUOBJECT  SET FResponserID = '" + responserId + "'" + "  WHERE FID = " + "'" + objectId + "'";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

