/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.hr.perf.AuditStatusEnum;
import com.kingdee.eas.hr.perf.EvaluResultAuditBillEntryCollection;
import com.kingdee.eas.hr.perf.EvaluResultAuditBillFactory;
import com.kingdee.eas.hr.perf.EvaluResultAuditBillInfo;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.IEvaluResult;
import com.kingdee.eas.hr.perf.IEvaluResultAuditBill;
import com.kingdee.eas.hr.perf.app.AbstractEvaluResultAuditBillControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EvaluResultAuditBillControllerBean
extends AbstractEvaluResultAuditBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvaluResultAuditBillControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EvaluResultAuditBillInfo info = (EvaluResultAuditBillInfo)model;
        EvaluResultAuditBillEntryCollection entries = info.getEntries();
        HashSet<String> ids = new HashSet<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            ids.add(entries.get(i).getEvaluResult());
        }
        MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.hr.perf.app.PersonalEvaluResultListQuery");
        IQueryExecutor query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("auditStatus", (Object)new Integer(20)));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("Person.name");
        evi.setSelector(sic);
        query.setObjectView(evi);
        IRowSet rowSet = query.executeQuery();
        Object row = null;
        try {
            StringBuffer str = new StringBuffer();
            int index = 0;
            while (rowSet.next()) {
                if (index != 0) {
                    str.append(",");
                }
                str.append(rowSet.getString("Person.name"));
                ++index;
            }
            if (str.length() > 0) {
                throw new EvaluResultException(EvaluResultException.EVALURESULT_AUDING, new Object[]{str.toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ObjectUuidPK pk = null;
        if (info.getId() != null) {
            pk = new ObjectUuidPK(info.getId().toString());
        }
        this._checkNumberDup(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    @Override
    protected void _setStatusAuditing(Context ctx, IObjectPK EvaluResultPk) throws BOSException {
        this.setDataStatus(ctx, EvaluResultPk, AuditStatusEnum.AUDITING);
    }

    private void setDataStatus(Context ctx, IObjectPK evaluResultPk, AuditStatusEnum status) throws BOSException {
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("entries.evaluResult");
            IEvaluResultAuditBill iEvaluResultAuditBill = EvaluResultAuditBillFactory.getLocalInstance(ctx);
            EvaluResultAuditBillInfo info = iEvaluResultAuditBill.getEvaluResultAuditBillInfo(evaluResultPk, sic);
            info.setAuditStatus(status);
            sic.clear();
            sic.add(new SelectorItemInfo("auditStatus"));
            iEvaluResultAuditBill.updatePartial((CoreBaseInfo)info, sic);
            EvaluResultAuditBillEntryCollection entries = info.getEntries();
            EvaluResultInfo evaluResultInfo = null;
            IEvaluResult iEvaluResult = EvaluResultFactory.getLocalInstance(ctx);
            sic.add(new SelectorItemInfo("isApproved"));
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                evaluResultInfo = new EvaluResultInfo();
                evaluResultInfo.setId(BOSUuid.read((String)entries.get(i).getEvaluResult()));
                evaluResultInfo.setAuditStatus(status);
                evaluResultInfo.setIsApproved(AuditStatusEnum.PASS.equals((Object)status));
                iEvaluResult.updatePartial((CoreBaseInfo)evaluResultInfo, sic);
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _setStatusNopass(Context ctx, IObjectPK EvaluResultPK) throws BOSException {
        this.setDataStatus(ctx, EvaluResultPK, AuditStatusEnum.NOTPASS);
    }

    @Override
    protected void _setStatusPass(Context ctx, IObjectPK EvaluResultPK) throws BOSException {
        this.setDataStatus(ctx, EvaluResultPK, AuditStatusEnum.PASS);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EvaluResultAuditBillInfo info = (EvaluResultAuditBillInfo)model;
        String companyID = null;
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, companyID) && info.getNumber() == null) {
            info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, companyID));
        }
        super._checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), model);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String companyID = null;
        CoreBillBaseInfo billBase = this.getCoreBillBaseInfo(ctx, pk);
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        if (iCodingRuleManager.isExist((IObjectValue)billBase, companyID) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)billBase, companyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)billBase, companyID, billBase.getNumber());
        }
        super._delete(ctx, pk);
    }
}

