/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.AbstractReferenceItemInfo;
import com.kingdee.eas.hr.perf.EvaluResultCollection;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.EvaluResultItemEnum;
import com.kingdee.eas.hr.perf.HistoryKeyEventsFactory;
import com.kingdee.eas.hr.perf.HistoryKeyEventsInfo;
import com.kingdee.eas.hr.perf.HistoryOrgKeyEventsFactory;
import com.kingdee.eas.hr.perf.HistoryOrgKeyEventsInfo;
import com.kingdee.eas.hr.perf.IEvaluResult;
import com.kingdee.eas.hr.perf.IHistoryKeyEvents;
import com.kingdee.eas.hr.perf.IHistoryOrgKeyEvents;
import com.kingdee.eas.hr.perf.IOrgKeyEvent;
import com.kingdee.eas.hr.perf.IPersonKeyEvent;
import com.kingdee.eas.hr.perf.IReferenceItem;
import com.kingdee.eas.hr.perf.OrgKeyEventCollection;
import com.kingdee.eas.hr.perf.OrgKeyEventFactory;
import com.kingdee.eas.hr.perf.OrgKeyEventInfo;
import com.kingdee.eas.hr.perf.PersonKeyEventCollection;
import com.kingdee.eas.hr.perf.PersonKeyEventFactory;
import com.kingdee.eas.hr.perf.PersonKeyEventInfo;
import com.kingdee.eas.hr.perf.ReferenceItemCollection;
import com.kingdee.eas.hr.perf.ReferenceItemFactory;
import com.kingdee.eas.hr.perf.ReferenceItemInfo;
import com.kingdee.eas.hr.perf.app.AbstractEvaluResultControllerBean;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EvaluResultControllerBean
extends AbstractEvaluResultControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvaluResultControllerBean");
    private static final String TABLE_NAME = " T_PF_EvaluResult ";
    private static final String TARGET_EVALU_SCORE = "targetEvaluScore";
    private static final String MODIFIED_SCORE = "modifiedScore";
    private static final String PERF_RANK = "perfRank.name";

    @Override
    protected void _setAllCmpPeriod(Context ctx, String solutionPeriodID, String cmpPeriodID) throws BOSException, EASBizException {
        if (solutionPeriodID == null) {
            SysUtil.abort();
        }
        String clearSql = "UPDATE T_PF_EvaluResult  SET FCmpPeriodID = ? WHERE (FEvaluObjectID IN (SELECT FID FROM T_PF_EvaluObject WHERE (FObjectID IN (SELECT FObjectID FROM T_PF_EvaluObject WHERE FID IN (SELECT FEvaluObjectID FROM T_PF_EvaluResult  WHERE FSolutionPeriodID = ? ))))) AND (FCmpPeriodID = ? )";
        String sql = "UPDATE T_PF_EvaluResult  SET FCmpPeriodID = ? WHERE FSolutionPeriodID = ?";
        Connection conn = null;
        PreparedStatement clearPstmt = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            clearPstmt = conn.prepareStatement(clearSql);
            clearPstmt.setString(1, null);
            if (cmpPeriodID != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)clearPstmt, (int)3, (String)cmpPeriodID);
            } else {
                clearPstmt.setString(3, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)clearPstmt, (int)2, (String)solutionPeriodID);
            clearPstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(clearPstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)clearPstmt);
        try {
            pstmt = conn.prepareStatement(sql);
            if (cmpPeriodID != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)cmpPeriodID);
            } else {
                pstmt.setString(1, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)solutionPeriodID);
            pstmt.execute();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION);
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    @Override
    protected void _setCmpPeriod(Context ctx, String evaluResultID, String cmpPeriodID) throws BOSException, EASBizException {
        String clearSql = "UPDATE T_PF_EvaluResult  SET FCmpPeriodID = ? WHERE (FEvaluObjectID IN (SELECT FID FROM T_PF_EvaluObject WHERE (FObjectID IN (SELECT FObjectID FROM T_PF_EvaluObject WHERE FID IN (SELECT FEvaluObjectID FROM T_PF_EvaluResult  WHERE FID = ? ))))) AND (FCmpPeriodID = ? )";
        String sql = "UPDATE T_PF_EvaluResult  SET FCmpPeriodID = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement clearPstmt = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            clearPstmt = conn.prepareStatement(clearSql);
            clearPstmt.setString(1, null);
            if (cmpPeriodID != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)clearPstmt, (int)3, (String)cmpPeriodID);
            } else {
                clearPstmt.setString(3, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)clearPstmt, (int)2, (String)evaluResultID);
            clearPstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(clearPstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)clearPstmt);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            if (cmpPeriodID != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)cmpPeriodID);
            } else {
                pstmt.setString(1, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluResultID);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected HashMap _getEvaluResults(Context ctx, List personIDList, IObjectPK cmpPeriodID, IObjectPK cmpItemID) throws BOSException, EASBizException {
        String colName = this.getRefType(cmpItemID, ctx);
        if (colName == null) {
            throw new EvaluResultException(EvaluResultException.NO_CMPITEM_MAPING_EXCEPTION);
        }
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("perfRank.id"));
        sic.add(new SelectorItemInfo("evaluObject.id"));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        sic.add(new SelectorItemInfo(colName));
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet();
        set.addAll(personIDList);
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.objectID", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)cmpPeriodID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        EvaluResultCollection coll = this.getEvaluResultCollection(ctx, viewInfo);
        Iterator iter = personIDList.iterator();
        while (iter.hasNext()) {
            ret.put(iter.next(), null);
        }
        EvaluResultInfo info = null;
        HashSet<String> idSet = new HashSet<String>();
        if (coll != null && coll.size() > 0) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                info = coll.get(i);
                if (colName.equals(TARGET_EVALU_SCORE)) {
                    ret.put(info.getEvaluObject().getObjectID(), info.getTargetEvaluScore());
                } else if (colName.equals(MODIFIED_SCORE)) {
                    ret.put(info.getEvaluObject().getObjectID(), info.getModifiedScore());
                } else if (colName.equals(PERF_RANK)) {
                    ret.put(info.getEvaluObject().getObjectID(), info.getPerfRank().getName());
                }
                idSet.add(info.getId().toString());
            }
        }
        this.setIsRefernenced(ctx, idSet, true);
        return ret;
    }

    private String getRefType(IObjectPK cmpItemID, Context ctx) throws BOSException, EASBizException {
        String resultColName = null;
        IReferenceItem iri = ReferenceItemFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cmpItem.id", (Object)cmpItemID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("refType"));
        ReferenceItemCollection coll = iri.getReferenceItemCollection(viewInfo);
        AbstractReferenceItemInfo info = null;
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
        }
        if (info != null) {
            switch (info.getRefType().getValue()) {
                case 10: {
                    resultColName = TARGET_EVALU_SCORE;
                    break;
                }
                case 20: {
                    resultColName = MODIFIED_SCORE;
                    break;
                }
                case 30: {
                    resultColName = PERF_RANK;
                }
            }
        }
        return resultColName;
    }

    private void setIsRefernenced(Context ctx, HashSet idSet, boolean status) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        String sql = " UPDATE  T_PF_EvaluResult  SET FIsReferenced = ? WHERE FID IN (";
        StringBuffer sb = new StringBuffer(sql);
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            sb.append("? ,");
            iter.next();
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            pstmt.setBoolean(1, status);
            int count = 1;
            Iterator iter2 = idSet.iterator();
            while (iter2.hasNext()) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)(++count), (String)iter2.next().toString());
            }
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected HashMap _getEvaluResults(Context ctx, List personIDList, IObjectPK cmpPeriodID, List cmpItemIDList) throws BOSException, EASBizException {
        ArrayList personIDListBak = new ArrayList();
        personIDListBak.addAll(personIDList);
        if (personIDListBak == null || cmpItemIDList == null || personIDListBak.size() == 0 || cmpItemIDList.size() == 0) {
            return new HashMap();
        }
        HashMap ret = new HashMap();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("perfRank.id"));
        sic.add(new SelectorItemInfo("evaluObject.id"));
        sic.add(new SelectorItemInfo(TARGET_EVALU_SCORE));
        sic.add(new SelectorItemInfo(MODIFIED_SCORE));
        sic.add(new SelectorItemInfo(PERF_RANK));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)cmpPeriodID.toString(), CompareType.EQUALS));
        HashSet set = new HashSet();
        set.addAll(personIDListBak);
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.objectID", set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        EvaluResultCollection coll = this.getEvaluResultCollection(ctx, viewInfo);
        HashMap valueMap = null;
        HashMap typeMap = this.getRefType(cmpItemIDList, ctx);
        EvaluResultItemEnum evaluResultItemEnum = null;
        EvaluResultInfo resultInfo = null;
        String objectID = null;
        HashSet<String> refedSet = new HashSet<String>();
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            resultInfo = coll.get(i);
            valueMap = new HashMap();
            for (Object key : cmpItemIDList) {
                evaluResultItemEnum = (EvaluResultItemEnum)((Object)typeMap.get(key.toString()));
                if (evaluResultItemEnum != null) {
                    if (evaluResultItemEnum.equals((Object)EvaluResultItemEnum.EVALUE_SCORE)) {
                        valueMap.put(key, resultInfo.getTargetEvaluScore());
                        continue;
                    }
                    if (evaluResultItemEnum.equals((Object)EvaluResultItemEnum.MODIFIED_SCORE)) {
                        valueMap.put(key, resultInfo.getModifiedScore());
                        continue;
                    }
                    valueMap.put(key, resultInfo.getPerfRank().getName());
                    continue;
                }
                valueMap.put(key, null);
            }
            objectID = resultInfo.getEvaluObject().getObjectID();
            ret.put(objectID, valueMap);
            personIDListBak.remove(objectID);
            refedSet.add(resultInfo.getId().toString());
        }
        Iterator iter = personIDListBak.iterator();
        while (iter.hasNext()) {
            ret.put(iter.next().toString(), new HashMap());
        }
        this.setIsRefernenced(ctx, refedSet, true);
        return ret;
    }

    private HashMap getRefType(List cmpItemIDList, Context ctx) throws BOSException, EASBizException {
        HashMap<String, EvaluResultItemEnum> ret = new HashMap<String, EvaluResultItemEnum>();
        IReferenceItem iRefItem = ReferenceItemFactory.getLocalInstance(ctx);
        HashSet set = new HashSet();
        set.addAll(cmpItemIDList);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cmpItem.id", set, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add("id");
        sic.add("cmpItem.id");
        sic.add("refType");
        ReferenceItemCollection coll = iRefItem.getReferenceItemCollection(viewInfo);
        Iterator iter = cmpItemIDList.iterator();
        while (iter.hasNext()) {
            ret.put(iter.next().toString(), null);
        }
        ReferenceItemInfo info = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            info = coll.get(i);
            ret.put(info.getCmpItem().getId().toString(), info.getRefType());
        }
        Object key2 = null;
        EvaluResultException mappingException = null;
        for (Object key2 : ret.keySet()) {
            if (ret.get(key2) != null) continue;
            mappingException = new EvaluResultException(EvaluResultException.NO_CMPITEM_MAPING_EXCEPTION);
            logger.error((Object)("cmpItemID:" + key2));
            logger.error((Object)mappingException);
            throw mappingException;
        }
        return ret;
    }

    public String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return " ";
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("solutionPeriod.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        sic.add(new SelectorItemInfo("evaluObject.id"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        IObjectValue obj = super._getValue(ctx, pk, sic);
        if (obj == null) {
            return " ";
        }
        EvaluResultInfo info = (EvaluResultInfo)obj;
        StringBuffer sb = new StringBuffer();
        if (info.getSolutionPeriod() != null) {
            sb.append(info.getSolutionPeriod().getName());
        }
        sb.append("_");
        if (info.getEvaluObject() != null) {
            sb.append(info.getEvaluObject().getName());
        }
        return sb.toString();
    }

    @Override
    protected HashMap _getEvaluResults(Context ctx, String cmpShemeID, IObjectPK cmpPeriodID, List cmpItemIDList) throws BOSException, EASBizException {
        if (cmpShemeID == null || cmpItemIDList == null || cmpItemIDList.size() == 0) {
            return new HashMap();
        }
        HashMap ret = new HashMap();
        String pack = "com.kingdee.eas.hr.perf.app";
        String query = "CmpEvaluResultQuery";
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CmpScheme.id", (Object)cmpShemeID));
        filter.getFilterItems().add(new FilterItemInfo("CmpPeriod.id", (Object)cmpPeriodID));
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "CmpEvaluResultQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        HashMap typeMap = this.getRefType(cmpItemIDList, ctx);
        String objectID = null;
        HashMap<Object, Object> valueMap = new HashMap<Object, Object>();
        Object key2 = null;
        EvaluResultItemEnum evaluResultItemEnum = null;
        try {
            while (rowSet.next()) {
                objectID = rowSet.getString("person.id");
                valueMap = (HashMap<Object, Object>)ret.get(objectID);
                if (valueMap == null) {
                    valueMap = new HashMap<Object, Object>();
                    ret.put(objectID, valueMap);
                }
                for (Object key2 : cmpItemIDList) {
                    evaluResultItemEnum = (EvaluResultItemEnum)((Object)typeMap.get(key2.toString()));
                    if (evaluResultItemEnum != null) {
                        if (evaluResultItemEnum.equals((Object)EvaluResultItemEnum.EVALUE_SCORE)) {
                            valueMap.put(key2, rowSet.getBigDecimal("EvaluResult.targetEvaluScore"));
                            continue;
                        }
                        if (evaluResultItemEnum.equals((Object)EvaluResultItemEnum.MODIFIED_SCORE)) {
                            valueMap.put(key2, rowSet.getBigDecimal("EvaluResult.modifiedScore"));
                            continue;
                        }
                        valueMap.put(key2, rowSet.getString("Rank.name"));
                        continue;
                    }
                    valueMap.put(key2, null);
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        return ret;
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        EvaluResultInfo info = (EvaluResultInfo)model;
        Date date = info.getModifyDate();
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
        }
        info.setModifyDate(date);
        return super.save(ctx, model);
    }

    public void save(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        EvaluResultInfo info = (EvaluResultInfo)model;
        Date date = info.getModifyDate();
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
        }
        info.setModifyDate(date);
        super.save(ctx, pk, model);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        EvaluResultInfo info = (EvaluResultInfo)model;
        Date date = info.getModifyDate();
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
        }
        info.setModifyDate(date);
        return super.submit(ctx, model);
    }

    public void submit(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        EvaluResultInfo info = (EvaluResultInfo)model;
        Date date = info.getModifyDate();
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
        }
        info.setModifyDate(date);
        super.submit(ctx, pk, model);
    }

    @Override
    protected void _updateKeyEventScore(Context ctx, Map map, int keyEventType) throws BOSException, EASBizException {
        if (map == null || map.size() <= 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            String sql = "update T_PF_EvaluResult Set FKEYEVENTSUM=? WHERE FID=?";
            pstmt = conn.prepareStatement(sql);
            Set objIdSet = map.keySet();
            Iterator<Object> iter = objIdSet.iterator();
            String personId = null;
            String id2 = null;
            BigDecimal score = null;
            Map entry = null;
            HashSet<String> evaluResultSet = new HashSet<String>();
            while (iter.hasNext()) {
                personId = (String)iter.next();
                entry = (Map)map.get(personId);
                if (entry == null) continue;
                id2 = (String)entry.get("evaluResult");
                evaluResultSet.add(id2);
                score = (BigDecimal)entry.get("sumScore");
                pstmt.setBigDecimal(1, score);
                pstmt.setString(2, id2);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            String sql2 = "update T_PF_EvaluResult set FTargetEvaluScore = FKEYEVENTSUM + FEvaluateSum where fid = ? and FKEYEVENTSUM is not null";
            pstmt = conn.prepareStatement(sql2);
            for (String id2 : evaluResultSet) {
                pstmt.setString(1, id2);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            if (evaluResultSet.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("evaluResult", evaluResultSet, CompareType.INCLUDE));
                try {
                    if (keyEventType == 0) {
                        HistoryKeyEventsFactory.getLocalInstance(ctx).delete(filter);
                    } else {
                        HistoryOrgKeyEventsFactory.getLocalInstance(ctx).delete(filter);
                    }
                }
                catch (EASBizException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                    throw new BOSException((Throwable)e1);
                }
            }
            iter = map.keySet().iterator();
            Set keyEventSet = null;
            IPersonKeyEvent iPersonKeyEvent = PersonKeyEventFactory.getLocalInstance(ctx);
            IOrgKeyEvent iOrgKeyEvent = OrgKeyEventFactory.getLocalInstance(ctx);
            IEvaluResult ievaluResult = EvaluResultFactory.getLocalInstance(ctx);
            IHistoryKeyEvents ihistoryKeyEvents = HistoryKeyEventsFactory.getLocalInstance(ctx);
            IHistoryOrgKeyEvents ihistoryOrgKeyEvents = HistoryOrgKeyEventsFactory.getLocalInstance(ctx);
            while (iter.hasNext()) {
                int i;
                AbstractObjectCollection coll;
                personId = (String)iter.next();
                entry = (Map)map.get(personId);
                if (entry == null) continue;
                keyEventSet = (Set)entry.get("keyEvent");
                String evaluResultId = (String)entry.get("evaluResult");
                EvaluResultInfo evaluResultInfo = ievaluResult.getEvaluResultInfo((IObjectPK)new ObjectUuidPK(evaluResultId));
                if (keyEventType == 0) {
                    coll = this.getPersonKeyEventCollById(ctx, iPersonKeyEvent, keyEventSet);
                    if (coll == null || coll.size() <= 0) continue;
                    PersonKeyEventInfo personKeyInfo = null;
                    for (i = 0; i < coll.size(); ++i) {
                        personKeyInfo = coll.get(i);
                        HistoryKeyEventsInfo historyKeyEventsInfo = new HistoryKeyEventsInfo();
                        historyKeyEventsInfo.setPerson(personKeyInfo.getPerson());
                        historyKeyEventsInfo.setContent(personKeyInfo.getContent());
                        historyKeyEventsInfo.setEventEndDate(personKeyInfo.getEventEndDate());
                        historyKeyEventsInfo.setEventStartDate(personKeyInfo.getEventStartDate());
                        historyKeyEventsInfo.setRecordDate(personKeyInfo.getRecordDate());
                        historyKeyEventsInfo.setGrade(personKeyInfo.getGrade());
                        historyKeyEventsInfo.setKeyEventType(personKeyInfo.getKeyEventType());
                        historyKeyEventsInfo.setEvaluResult(evaluResultInfo);
                        ihistoryKeyEvents.addnew((CoreBaseInfo)historyKeyEventsInfo);
                    }
                    continue;
                }
                coll = this.getOrgKeyEventCollById(ctx, iOrgKeyEvent, keyEventSet);
                if (coll == null || coll.size() <= 0) continue;
                OrgKeyEventInfo orgKeyInfo = null;
                for (i = 0; i < coll.size(); ++i) {
                    orgKeyInfo = coll.get(i);
                    HistoryOrgKeyEventsInfo historyOrgKeyEventsInfo = new HistoryOrgKeyEventsInfo();
                    historyOrgKeyEventsInfo.setAdminOrgUnit(orgKeyInfo.getAdminOrgUnit());
                    historyOrgKeyEventsInfo.setContent(orgKeyInfo.getContent());
                    historyOrgKeyEventsInfo.setEventEndDate(orgKeyInfo.getEventEndDate());
                    historyOrgKeyEventsInfo.setEventStartDate(orgKeyInfo.getEventStartDate());
                    historyOrgKeyEventsInfo.setRecordDate(orgKeyInfo.getRecordDate());
                    historyOrgKeyEventsInfo.setGrade(orgKeyInfo.getGrade());
                    historyOrgKeyEventsInfo.setKeyEventType(orgKeyInfo.getKeyEventType());
                    historyOrgKeyEventsInfo.setEvaluResult(evaluResultInfo);
                    ihistoryOrgKeyEvents.addnew((CoreBaseInfo)historyOrgKeyEventsInfo);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private PersonKeyEventCollection getPersonKeyEventCollById(Context ctx, IPersonKeyEvent iPersonKeyEvent, Set keyEventIdSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)keyEventIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("grade"));
        view.getSelector().add(new SelectorItemInfo("person.id"));
        view.getSelector().add(new SelectorItemInfo("person.name"));
        view.getSelector().add(new SelectorItemInfo("content"));
        view.getSelector().add(new SelectorItemInfo("eventStartDate"));
        view.getSelector().add(new SelectorItemInfo("eventEndDate"));
        view.getSelector().add(new SelectorItemInfo("recordDate"));
        view.getSelector().add(new SelectorItemInfo("keyEventType"));
        PersonKeyEventCollection coll = iPersonKeyEvent.getPersonKeyEventCollection(view);
        return coll;
    }

    private OrgKeyEventCollection getOrgKeyEventCollById(Context ctx, IOrgKeyEvent iOrgKeyEvent, Set keyEventIdSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)keyEventIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("grade"));
        view.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
        view.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
        view.getSelector().add(new SelectorItemInfo("adminOrgUnit.displayname"));
        view.getSelector().add(new SelectorItemInfo("content"));
        view.getSelector().add(new SelectorItemInfo("eventStartDate"));
        view.getSelector().add(new SelectorItemInfo("eventEndDate"));
        view.getSelector().add(new SelectorItemInfo("recordDate"));
        view.getSelector().add(new SelectorItemInfo("keyEventType"));
        OrgKeyEventCollection coll = iOrgKeyEvent.getOrgKeyEventCollection(view);
        return coll;
    }
}

