/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.IEvaluResult;
import com.kingdee.eas.hr.perf.IRankConvertRule;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.RankConvertRuleDetailCollection;
import com.kingdee.eas.hr.perf.RankConvertRuleDetailInfo;
import com.kingdee.eas.hr.perf.RankConvertRuleFactory;
import com.kingdee.eas.hr.perf.RankConvertRuleInfo;
import com.kingdee.eas.hr.perf.app.AbstractEvaluResultFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class EvaluResultFacadeControllerBean
extends AbstractEvaluResultFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvaluResultFacadeControllerBean");
    private static final String TABLE_NAME = " T_PF_EvaluResult ";

    @Override
    protected void _auditBill(Context ctx, String[] idList) throws BOSException, EASBizException {
        this.executeAuditAction(true, idList, ctx);
    }

    @Override
    protected void _antiAuditBill(Context ctx, String[] idList) throws BOSException, EASBizException {
        this.executeAuditAction(false, idList, ctx);
    }

    private void executeAuditAction(boolean direction, String[] idList, Context ctx) throws BOSException, EASBizException {
        if (idList == null || idList.length <= 0) {
            return;
        }
        boolean isShow = PerfUtils.getParamValue(ctx, "hr_perf_003");
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE");
        sb.append(TABLE_NAME);
        sb.append("SET FIsApproved = ? , FAuditorID = ? , FAuditDate = ?, FAuditStatus = ?");
        if (isShow && !direction) {
            sb.append(" , FIsShow = ? , FShowerID = ? , FShowDate = ?");
        }
        sb.append(" WHERE FID IN ( ");
        for (int i = 0; i < idList.length; ++i) {
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append("'");
            sb.append(idList[i]);
            sb.append("'");
        }
        sb.append(" )");
        Connection conn = null;
        PreparedStatement pstmt = null;
        String auditorID = null;
        Timestamp date = null;
        if (direction) {
            auditorID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            date = new Timestamp(DateTimeUtils.truncateDate((Date)new Date()).getTime());
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            if (direction) {
                pstmt.setInt(1, 1);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)auditorID);
                pstmt.setTimestamp(3, date);
                pstmt.setInt(4, 30);
            } else {
                pstmt.setInt(1, 0);
                pstmt.setString(2, null);
                pstmt.setTimestamp(3, null);
                pstmt.setInt(4, 10);
                if (isShow) {
                    pstmt.setInt(5, 0);
                    pstmt.setString(6, null);
                    pstmt.setString(7, null);
                }
            }
            pstmt.execute();
            IEvaluResult iEvaluResult = EvaluResultFactory.getLocalInstance(ctx);
            IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            String logMessage = null;
            String logItem = null;
            IObjectPK logPK = null;
            logItem = direction ? "perf_EvaluResult_audit" : "perf_EvaluResult_antiAudit";
            for (int i = 0; i < idList.length; ++i) {
                logMessage = this.getLogInfo(ctx, (IObjectPK)new ObjectUuidPK(idList[i]), iEvaluResult, iAdminOrgUnit, iPerson);
                logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)EvaluResultFactory.getLocalInstance(ctx).getType(), null, (String)logMessage, (String)logItem);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _updatePerfRank(Context ctx, HashMap changdePerfRank) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_EvaluResult SET FPerfRankID = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            String perfID = null;
            Iterator iter = changdePerfRank.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                perfID = (String)changdePerfRank.get(key);
                if (perfID != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)perfID);
                } else {
                    pstmt.setString(1, null);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)key);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _updateScore(Context ctx, HashMap changedScore) throws BOSException, EASBizException {
        ObjectUuidPK pk = null;
        IEvaluResult ier = EvaluResultFactory.getLocalInstance(ctx);
        EvaluResultInfo info = null;
        Object score = null;
        for (Object key : changedScore.keySet()) {
            Object value = changedScore.get(key);
            if (value == null || !(value instanceof BigDecimal)) continue;
            pk = new ObjectUuidPK(key.toString());
            info = ier.getEvaluResultInfo((IObjectPK)pk);
            info.setTargetEvaluScore((BigDecimal)value);
            ier.update((IObjectPK)pk, (CoreBaseInfo)info);
        }
        HashSet set = new HashSet();
        set.addAll(changedScore.keySet());
        EvalWorkFlowFacadeFactory.getLocalInstance(ctx).updateWfObjectStateByRevaluResultID(set, 30);
    }

    @Override
    protected void _convertModfiedSocreToRank(Context ctx, String[] idList, BOSUuid convertRuleID) throws BOSException, EASBizException {
        this.convertScoreToRank(idList, convertRuleID, "FModifiedScore", ctx);
    }

    @Override
    protected void _convertTotalScoreToRank(Context ctx, String[] idList, BOSUuid convertRuleID) throws BOSException, EASBizException {
        this.convertScoreToRank(idList, convertRuleID, "FTargetEvaluScore", ctx);
    }

    private void convertScoreToRank(String[] idList, BOSUuid convertRuleID, String colName, Context ctx) throws BOSException, EASBizException {
        IRankConvertRule iRankConvertRule = RankConvertRuleFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.minScore"));
        sic.add(new SelectorItemInfo("entries.maxScore"));
        sic.add(new SelectorItemInfo("entries.minScoreCondition"));
        sic.add(new SelectorItemInfo("entries.maxScoreCondition"));
        sic.add(new SelectorItemInfo("entries.rank.id"));
        RankConvertRuleInfo rule = (RankConvertRuleInfo)iRankConvertRule.getValue((IObjectPK)new ObjectUuidPK(convertRuleID), sic);
        RankConvertRuleDetailCollection coll = rule.getEntries();
        if (coll != null && coll.size() > 0) {
            RankConvertRuleDetailInfo detail = null;
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                StringBuffer header = new StringBuffer();
                header.append("UPDATE ");
                header.append(TABLE_NAME);
                header.append(" SET FPerfRankID = ? , FRankConvertRuleID = ? WHERE (FID IN ( ");
                for (int k = 0; k < idList.length; ++k) {
                    if (k > 0) {
                        header.append(" , ");
                    }
                    header.append("'");
                    header.append(idList[k]);
                    header.append("'");
                }
                header.append(" ) ) and ");
                conn = this.getConnection(ctx);
                String headerSql = header.toString();
                int n = coll.size();
                for (int i = 0; i < n; ++i) {
                    detail = coll.get(i);
                    StringBuffer sql = new StringBuffer();
                    sql.append(headerSql);
                    sql.append(" ( ");
                    sql.append(" ? ");
                    sql.append(this.transForSql(detail.getMinScoreCondition()));
                    sql.append(colName);
                    sql.append(" ) and ");
                    sql.append(" ( ");
                    sql.append(colName);
                    sql.append(this.transForSql(detail.getMaxScoreCondition()));
                    sql.append(" ? ) ");
                    pstmt = conn.prepareStatement(sql.toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)detail.getRank().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)convertRuleID.toString());
                    pstmt.setBigDecimal(3, detail.getMinScore());
                    pstmt.setBigDecimal(4, detail.getMaxScore());
                    pstmt.execute();
                    SQLUtils.cleanup((Statement)pstmt);
                }
                StringBuffer nullSQL = new StringBuffer();
                nullSQL.append("UPDATE");
                nullSQL.append(TABLE_NAME);
                nullSQL.append(" SET FPerfRankID = ? WHERE (FID IN ( ");
                for (int k = 0; k < idList.length; ++k) {
                    if (k > 0) {
                        nullSQL.append(" , ");
                    }
                    nullSQL.append("'");
                    nullSQL.append(idList[k]);
                    nullSQL.append("'");
                }
                nullSQL.append(" ) ) and ");
                nullSQL.append(colName);
                nullSQL.append(" IS NULL ");
                pstmt = conn.prepareStatement(nullSQL.toString());
                pstmt.setString(1, null);
                pstmt.execute();
                SQLUtils.cleanup((Statement)pstmt);
                String maxRankID = null;
                String minRankID = null;
                BigDecimal maxGrade = rule.getGradeMode().getMaxGrade();
                BigDecimal minGrade = rule.getGradeMode().getMinGrade();
                int n2 = coll.size();
                for (int i = 0; i < n2; ++i) {
                    detail = coll.get(i);
                    if (detail.getMinScoreCondition().equals("\u2264")) {
                        if (detail.getMaxScoreCondition().equals("\u2264")) {
                            if (maxGrade.compareTo(detail.getMinScore()) >= 0 && maxGrade.compareTo(detail.getMaxScore()) <= 0) {
                                maxRankID = detail.getRank().getId().toString();
                            }
                            if (minGrade.compareTo(detail.getMinScore()) < 0 || minGrade.compareTo(detail.getMaxScore()) > 0) continue;
                            minRankID = detail.getRank().getId().toString();
                            continue;
                        }
                        if (maxGrade.compareTo(detail.getMinScore()) >= 0 && maxGrade.compareTo(detail.getMaxScore()) < 0) {
                            maxRankID = detail.getRank().getId().toString();
                        }
                        if (minGrade.compareTo(detail.getMinScore()) < 0 || minGrade.compareTo(detail.getMaxScore()) >= 0) continue;
                        minRankID = detail.getRank().getId().toString();
                        continue;
                    }
                    if (detail.getMaxScoreCondition().equals("\u2264")) {
                        if (maxGrade.compareTo(detail.getMinScore()) > 0 && maxGrade.compareTo(detail.getMaxScore()) <= 0) {
                            maxRankID = detail.getRank().getId().toString();
                        }
                        if (minGrade.compareTo(detail.getMinScore()) <= 0 || minGrade.compareTo(detail.getMaxScore()) > 0) continue;
                        minRankID = detail.getRank().getId().toString();
                        continue;
                    }
                    if (maxGrade.compareTo(detail.getMinScore()) > 0 && maxGrade.compareTo(detail.getMaxScore()) < 0) {
                        maxRankID = detail.getRank().getId().toString();
                    }
                    if (minGrade.compareTo(detail.getMinScore()) <= 0 || minGrade.compareTo(detail.getMaxScore()) >= 0) continue;
                    minRankID = detail.getRank().getId().toString();
                }
                StringBuffer sqlOutMax = new StringBuffer();
                sqlOutMax.append(headerSql);
                sqlOutMax.append(" ( ");
                sqlOutMax.append(colName);
                sqlOutMax.append(" > ");
                sqlOutMax.append(" ? ");
                sqlOutMax.append(" ) ");
                pstmt = conn.prepareStatement(sqlOutMax.toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)maxRankID);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)convertRuleID.toString());
                pstmt.setBigDecimal(3, maxGrade);
                pstmt.execute();
                SQLUtils.cleanup((Statement)pstmt);
                StringBuffer sqlOutMin = new StringBuffer();
                sqlOutMin.append(headerSql);
                sqlOutMin.append(" ( ");
                sqlOutMin.append(colName);
                sqlOutMin.append(" < ");
                sqlOutMin.append(" ? ");
                sqlOutMin.append(" ) ");
                pstmt = conn.prepareStatement(sqlOutMin.toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)minRankID);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)convertRuleID.toString());
                pstmt.setBigDecimal(3, minGrade);
                pstmt.execute();
                SQLUtils.cleanup((Statement)pstmt);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private String transForSql(String condition) {
        if (condition.equals("\u2264")) {
            return " <= ";
        }
        return " < ";
    }

    @Override
    protected void _updateScoreAndPerfRank(Context ctx, HashMap changedScore, HashMap changedPerfRank) throws BOSException, EASBizException {
        String sqlScore = " UPDATE  T_PF_EvaluResult  SET FTargetEvaluScore = ?, FEvaluateSum = ? WHERE ( FID = ? )";
        String sqlPerfRank = " UPDATE  T_PF_EvaluResult  SET FPerfRankID = ? WHERE ( FID = ? )";
        String sqlAll = " UPDATE  T_PF_EvaluResult  SET FTargetEvaluScore = ? , FEvaluateSum = ?, FPerfRankID = ? WHERE ( FID = ? )";
        HashSet workFlowSet = new HashSet();
        workFlowSet.addAll(changedScore.keySet());
        workFlowSet.addAll(changedPerfRank.keySet());
        EvalWorkFlowFacadeFactory.getLocalInstance(ctx).updateWfObjectStateByRevaluResultID(workFlowSet, 30);
        HashSet commonSet = new HashSet();
        for (Object keyObj : changedScore.keySet()) {
            if (!changedPerfRank.keySet().contains(keyObj)) continue;
            commonSet.add(keyObj);
        }
        HashSet idset = new HashSet();
        for (Object keyObj : changedScore.keySet()) {
            idset.add(keyObj);
        }
        for (Object keyObj : changedPerfRank.keySet()) {
            if (idset.contains(keyObj)) continue;
            commonSet.add(keyObj);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String key2 = null;
        try {
            conn = this.getConnection(ctx);
            if (commonSet.size() > 0) {
                pstmt = conn.prepareStatement(sqlAll);
                for (String key2 : commonSet) {
                    pstmt.setBigDecimal(1, (BigDecimal)changedScore.get(key2));
                    pstmt.setBigDecimal(2, (BigDecimal)changedScore.get(key2));
                    if (changedPerfRank.get(key2) != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)((String)changedPerfRank.get(key2)));
                    } else {
                        pstmt.setString(3, null);
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)key2);
                    changedScore.remove(key2);
                    changedPerfRank.remove(key2);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
            }
            if (changedScore.size() > 0) {
                pstmt = conn.prepareStatement(sqlScore);
                for (String key2 : changedScore.keySet()) {
                    pstmt.setBigDecimal(1, (BigDecimal)changedScore.get(key2));
                    pstmt.setBigDecimal(2, (BigDecimal)changedScore.get(key2));
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)key2);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
            }
            if (changedPerfRank.size() > 0) {
                pstmt = conn.prepareStatement(sqlPerfRank);
                for (String key2 : changedPerfRank.keySet()) {
                    if (changedPerfRank.get(key2) != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)((String)changedPerfRank.get(key2)));
                    } else {
                        pstmt.setString(1, null);
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)key2);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
            }
            if (idset.size() > 0) {
                IEvaluResult iEvaluResult = EvaluResultFactory.getLocalInstance(ctx);
                IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                String logMessage = null;
                IObjectPK logPK = null;
                String id = null;
                Iterator iter = idset.iterator();
                while (iter.hasNext()) {
                    id = iter.next().toString();
                    logMessage = this.getLogInfo(ctx, (IObjectPK)new ObjectUuidPK(id), iEvaluResult, iAdminOrgUnit, iPerson);
                    logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)EvaluResultFactory.getLocalInstance(ctx).getType(), null, (String)logMessage, (String)"perf_EmpEvalResult_update");
                    LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _showBill(Context ctx, String[] idList) throws BOSException, EASBizException {
        if (idList == null || idList.length <= 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE");
        sb.append(TABLE_NAME);
        sb.append("SET FIsShow = ? , FShowerID = ? , FShowDate = ?");
        sb.append(" WHERE FID IN ( ");
        for (int i = 0; i < idList.length; ++i) {
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append("'");
            sb.append(idList[i]);
            sb.append("'");
        }
        sb.append(" )");
        Connection conn = null;
        PreparedStatement pstmt = null;
        String showerID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp date = new Timestamp(DateTimeUtils.truncateDate((Date)new Date()).getTime());
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            pstmt.setInt(1, 1);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)showerID);
            pstmt.setTimestamp(3, date);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private String getLogInfo(Context ctx, IObjectPK pk, IEvaluResult iEvaluResult, IAdminOrgUnit iAdminOrgUnit, IPerson iPerson) throws BOSException, EASBizException {
        StringBuffer retValue = new StringBuffer();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        sic.add(new SelectorItemInfo("evaluObject.evaluObjectType"));
        EvaluResultInfo resultInfo = iEvaluResult.getEvaluResultInfo(pk, sic);
        retValue.append(resultInfo.getSolutionPeriod().getName());
        retValue.append("--");
        if (resultInfo.getEvaluObject() != null && resultInfo.getEvaluObject().getObjectID() != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)resultInfo.getEvaluObject().getEvaluObjectType())) {
                selector.add(new SelectorItemInfo("dispalyName"));
                AdminOrgUnitInfo info = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(resultInfo.getEvaluObject().getObjectID()), selector);
                retValue.append(info.getDisplayName());
            } else {
                selector.add(new SelectorItemInfo("name"));
                PersonInfo info = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(resultInfo.getEvaluObject().getObjectID()), selector);
                retValue.append(info.getName());
            }
        }
        return retValue.toString();
    }
}

