/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvalWFObjectsInfo;
import com.kingdee.eas.hr.perf.EvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.EvaluGroupObjectInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetFactory;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.EvaluRuleCollection;
import com.kingdee.eas.hr.perf.EvaluRuleFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.GradeModeCollection;
import com.kingdee.eas.hr.perf.GradeModeFactory;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.RankGroupCollection;
import com.kingdee.eas.hr.perf.RankGroupFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.app.AbstractEvaluSolutionControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class EvaluSolutionControllerBean
extends AbstractEvaluSolutionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvaluSolutionControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EvaluSolutionInfo info = (EvaluSolutionInfo)model;
        String companyID = null;
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"HRO")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"HRO")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, companyID, "solutionType") && info.getNumber() == null) {
            info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, companyID, "solutionType", ""));
        }
        super._checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected void _closeEvaluSolution(Context ctx, String evaluSolutionId) throws BOSException, EASBizException {
        this.setEvaluSolutionStatus(ctx, evaluSolutionId, 102);
    }

    @Override
    protected void _startEvaluSolution(Context ctx, String evaluSolutionId) throws BOSException, EASBizException {
        this.setEvaluSolutionStatus(ctx, evaluSolutionId, 101);
    }

    private void setEvaluSolutionStatus(Context ctx, String evaluSolutionId, int status) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_EvaluSolution SET FSolutionStatus = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, status);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluSolutionId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        EvaluSolutionInfo info = (EvaluSolutionInfo)model;
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getHrOrgUnit().getId().toString()));
        if (info.getSolutionType().equals((Object)EvaluSolutionTypeEnum.PERSON)) {
            filter.getFilterItems().add(new FilterItemInfo("solutionType", (Object)new Integer(100)));
        } else if (info.getSolutionType().equals((Object)EvaluSolutionTypeEnum.ORGUNIT)) {
            filter.getFilterItems().add(new FilterItemInfo("solutionType", (Object)new Integer(101)));
        }
        return filter;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EvaluSolutionInfo solution;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if (dataBaseInfo.getName() != null) {
            dataBaseInfo.setName(dataBaseInfo.getName().trim());
            if (dataBaseInfo.getName() != null && dataBaseInfo.getName().length() > 0) {
                this._checkNameDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if ((solution = (EvaluSolutionInfo)model).getDeliverMode() == null) {
            solution.setDeliverMode(DeliverModeEnum.UNITY_DELIVER);
        }
        IObjectPK pk = super._submit(ctx, model);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)pk.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.solutionStatus", (Object)new Integer(102), CompareType.NOTEQUALS));
        if (SolutionPeriodFactory.getLocalInstance(ctx).exists(filterInfo)) {
            solution.setSolutionStatus(SolutionStatusEnum.ONUSED);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("solutionStatus"));
            EvaluSolutionFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)solution, sic);
        }
        return pk;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EvaluSolutionInfo info = (EvaluSolutionInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getHrOrgUnit().getId().toString()));
        if (info.getSolutionType().equals((Object)EvaluSolutionTypeEnum.PERSON)) {
            filter.getFilterItems().add(new FilterItemInfo("solutionType", (Object)new Integer(100)));
        } else if (info.getSolutionType().equals((Object)EvaluSolutionTypeEnum.ORGUNIT)) {
            filter.getFilterItems().add(new FilterItemInfo("solutionType", (Object)new Integer(101)));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, info, "name") + info.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    @Override
    protected void _unStartEvaluSolution(Context ctx, String evaluSolutionId) throws BOSException, EASBizException {
        this.setEvaluSolutionStatus(ctx, evaluSolutionId, 100);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        EvaluSolutionInfo evaluSolutionInfo = (EvaluSolutionInfo)model;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)pk.toString()));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("assessPeriod.startDate"));
        evi.getSelector().add(new SelectorItemInfo("assessPeriod.endDate"));
        ISolutionPeriod solutionPeriod = SolutionPeriodFactory.getLocalInstance(ctx);
        SolutionPeriodCollection coll = solutionPeriod.getSolutionPeriodCollection(evi);
        SolutionPeriodInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            AssessPeriodInfo assessPeriod = info.getAssessPeriod();
            StringBuffer sb = new StringBuffer();
            if (assessPeriod != null) {
                sb.append(evaluSolutionInfo.getName());
                sb.append(" ");
                sb.append(assessPeriod.getStartDate());
                sb.append("----");
                sb.append(assessPeriod.getEndDate());
                info.setName(sb.toString());
            }
            solutionPeriod.submit((CoreBaseInfo)info);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String companyID = null;
        DataBaseInfo dataBase = this.getDataBaseInfo(ctx, pk);
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"HRO")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"HRO")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        if (iCodingRuleManager.isExist((IObjectValue)dataBase, companyID, "solutionType") && iCodingRuleManager.isUseIntermitNumber((IObjectValue)dataBase, companyID, "solutionType")) {
            iCodingRuleManager.recycleNumber((IObjectValue)dataBase, companyID, "solutionType", "", dataBase.getNumber());
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)pk.toString()));
        EvaluObjectFactory.getLocalInstance(ctx).delete(fi);
        super._delete(ctx, pk);
    }

    @Override
    protected HashMap _getUsebleGradeModeAndRankGroup(Context ctx) throws BOSException, EASBizException {
        HashMap<String, AbstractObjectCollection> ret = new HashMap<String, AbstractObjectCollection>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("minGrade"));
        evi.getSelector().add(new SelectorItemInfo("maxGrade"));
        evi.getSelector().add(new SelectorItemInfo("isDefault"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        evi.setFilter(filter);
        GradeModeCollection gradeModeCollection = GradeModeFactory.getLocalInstance(ctx).getGradeModeCollection(evi);
        ret.put("GradeMode", gradeModeCollection);
        HashSet<String> set = new HashSet<String>();
        int n = gradeModeCollection.size();
        for (int i = 0; i < n; ++i) {
            set.add(gradeModeCollection.get(i).getId().toString());
        }
        if (set.size() > 0) {
            evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("gradeMode.minGrade"));
            evi.getSelector().add(new SelectorItemInfo("gradeMode.maxGrade"));
            evi.getSelector().add(new SelectorItemInfo("name"));
            evi.getSelector().add(new SelectorItemInfo("gradeMode.id"));
            evi.getSelector().add(new SelectorItemInfo("gradeMode.name"));
            evi.getSelector().add(new SelectorItemInfo("gradeMode.hrOrgUnit.id"));
            evi.getSelector().add(new SelectorItemInfo("gradeMode.isDefault"));
            evi.getSelector().add(new SelectorItemInfo("isDefault"));
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("gradeMode.id", set, CompareType.INCLUDE));
            evi.setFilter(filter);
            RankGroupCollection rankGroupColl = RankGroupFactory.getLocalInstance(ctx).getRankGroupCollection(evi);
            String gradeModeID = null;
            RankGroupCollection subColl = null;
            int n2 = rankGroupColl.size();
            for (int i = 0; i < n2; ++i) {
                gradeModeID = rankGroupColl.get(i).getGradeMode().getId().toString();
                if (ret.get(gradeModeID) == null) {
                    subColl = new RankGroupCollection();
                    subColl.add(rankGroupColl.get(i));
                    ret.put(gradeModeID, subColl);
                    continue;
                }
                subColl = (RankGroupCollection)((Object)ret.get(gradeModeID));
                subColl.add(rankGroupColl.get(i));
            }
        }
        return ret;
    }

    @Override
    protected void _patchEvaluObject(Context ctx, Map value) throws BOSException, EASBizException {
        SolutionPeriodInfo period = (SolutionPeriodInfo)value.get("period");
        Object obj = value.get("evaluObject");
        Object[] data = (Object[])obj;
        EvalWorkFlowInfo workFlow = (EvalWorkFlowInfo)value.get("workFlow");
        String groupID = (String)value.get("groupID");
        String cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String sql = "INSERT INTO T_PF_EvalWFObjects(FID,FSeq,FEvalWorkFlowID,FEvaluObjectID,FStatus) VALUES(?,?,?,?,?)";
        String sql2 = "INSERT INTO T_PF_EvaluGroupObject(FID, FControlUnitID,FEvaluGroupID,FEvaluObjectID) VALUES(?,?,?,?)";
        EvalWFObjectsInfo info = new EvalWFObjectsInfo();
        EvaluGroupObjectInfo groupObjectInfo = new EvaluGroupObjectInfo();
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)groupID));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("weight"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.thresholdValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.standardValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.challengeValue"));
        EvaluGroupTargetCollection groupTargetColl = EvaluGroupTargetFactory.getLocalInstance(ctx).getEvaluGroupTargetCollection(evi);
        Object groupTargetInfo = null;
        HashSet<String> evaluObjectIdSet = new HashSet<String>();
        try {
            BOSUuid id = null;
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt2 = conn.prepareStatement(sql2);
            String flowID = workFlow.getId().toString();
            for (int i = 0; i < data.length; ++i) {
                id = BOSUuid.create((BOSObjectType)info.getBOSType());
                pstmt.setString(1, id.toString());
                pstmt.setInt(2, 0);
                pstmt.setString(3, flowID);
                pstmt.setString(4, ((EvaluObjectInfo)data[i]).getId().toString());
                pstmt.setInt(5, 10);
                pstmt.addBatch();
                id = BOSUuid.create((BOSObjectType)groupObjectInfo.getBOSType());
                pstmt2.setString(1, id.toString());
                pstmt2.setString(2, cuID);
                pstmt2.setString(3, groupID);
                pstmt2.setString(4, ((EvaluObjectInfo)data[i]).getId().toString());
                pstmt2.addBatch();
                evaluObjectIdSet.add(((EvaluObjectInfo)data[i]).getId().toString());
            }
            pstmt.executeBatch();
            pstmt2.executeBatch();
            EvaluSolutionFacadeFactory.getLocalInstance(ctx).deliverGroupTarget(period.getId().toString(), groupID, evaluObjectIdSet);
            this.insertEvaluResult(ctx, period.getId().toString(), data);
        }
        catch (SQLException ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(pstmt2, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)pstmt2, (Connection)conn);
    }

    private void insertEvaluResult(Context ctx, String solutionPeriodId, Object[] data) throws BOSException, SQLDataException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement up = null;
        String sql = "INSERT INTO T_PF_EvaluResult (FID, FControlUnitID, FEvaluObjectID, FSolutionPeriodID, FHROrgUnitID,FIsModified,FIsReferenced,FIsApproved) VALUES (?,?,?,?,?,?,?,?)";
        StringBuffer sqlt = new StringBuffer("UPDATE T_PF_EvaluResult SET @ = (SELECT # FROM t_hr_personposition p inner join t_pf_evaluobject o on p.fpersonid = o.fobjectid where o.fid = T_PF_EvaluResult.fevaluobjectid) where T_PF_EvaluResult.FID IN (");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            StringBuffer sb = new StringBuffer();
            String id = null;
            EvaluResultInfo result = new EvaluResultInfo();
            BOSObjectType type = result.getBOSType();
            for (int i = 0; i < data.length; ++i) {
                id = BOSUuid.create((BOSObjectType)type).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)((EvaluObjectInfo)data[i]).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)solutionPeriodId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
                pstmt.setInt(6, 0);
                pstmt.setInt(7, 0);
                pstmt.setInt(8, 0);
                pstmt.addBatch();
                sb.append("'");
                sb.append(id);
                sb.append("',");
            }
            sb.deleteCharAt(sb.length() - 1);
            pstmt.executeBatch();
            sqlt.append(sb);
            sqlt.append(")");
            up = conn.prepareStatement(sqlt.toString().replaceAll("@", "FPositionID").replaceAll("#", "FPrimaryPositionID"));
            up.execute();
            SQLUtils.cleanup((Statement)up);
            up = conn.prepareStatement(sqlt.toString().replaceAll("@", "FAdminOrgUnitID").replaceAll("#", "FPersondep"));
            up.execute();
            SQLUtils.cleanup((Statement)up);
            up = conn.prepareStatement(sqlt.toString().replaceAll("@", "FJobGradeID").replaceAll("#", "FJobGrade"));
            up.execute();
            SQLUtils.cleanup((Statement)up);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected IObjectCollection _getEvaluRuleCollection(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("ruleMode"));
        evi.getSelector().add(new SelectorItemInfo("singleTableScoreDescr"));
        evi.getSelector().add(new SelectorItemInfo("evaluSumScoreDescr"));
        evi.getSelector().add(new SelectorItemInfo("description"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("id");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        EvaluRuleCollection evaluRuleCollection = EvaluRuleFactory.getLocalInstance(ctx).getEvaluRuleCollection(evi);
        return evaluRuleCollection;
    }
}

